#include "windows.h"
#include "commctrl.h"
#include "shared.h"
#include "unzip.h"
#include "main.h"
#include "resource.h"
#include "zip.h"

static char										FileToLoad[MAX_PATH];

LRESULT CALLBACK LoadZipProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	static char		*pArchive;
	static int		ValidFiles;

	switch (msg)
	{
	case WM_INITDIALOG:
		{
			pArchive = (char *)lParam;
			CenterWindowInParent(hwnd);
			ValidFiles = PopulateZipDialog(GetDlgItem(hwnd, IDC_FILE_LIST), pArchive);

			switch (ValidFiles)
			{
			case 0:
				MessageBox(hwnd, "Zip file contains no games.", "Error", MB_OK | MB_ICONWARNING);
				SendMessage(hwnd, WM_CLOSE, 0, 0);
				break;

			case 1:
				EndDialog(hwnd, 1);
				break;

			default:
				ShowWindow(hwnd, SW_SHOW);
				break;
			}
		}
		break;

	case WM_COMMAND:
		{
			switch (HIWORD(wParam))
			{
			case BN_CLICKED:
				switch (LOWORD(wParam))
				{
				case IDC_OK_BUTTON:
					EndDialog(hwnd, 1);
					break;
				}
				break;
			}
		}
		break;

	case WM_NOTIFY:
		{
			LPNMHDR	 pHeader = (LPNMHDR)lParam;

			switch (pHeader->idFrom)
			{
			case IDC_FILE_LIST:
				switch (pHeader->code)
				{
				case LVN_ITEMCHANGED:
					{
						LPNMLISTVIEW	pnmlv = (LPNMLISTVIEW)lParam;
						LVITEM			Item;

						Item.mask		= LVIF_TEXT;
						Item.iItem		= pnmlv->iItem;
						Item.iSubItem	= 0;
						Item.cchTextMax = MAX_PATH;
						Item.pszText	= FileToLoad;

						ListView_GetItem(pnmlv->hdr.hwndFrom, &Item);
					}
					break;

				case NM_DBLCLK:
					EndDialog(hwnd, 1);
					break;
				}
				break;
			}
		}
		break;

	case WM_CLOSE:
		EndDialog(hwnd, 0);
		break;

    default:
		return FALSE;
	}

	return TRUE;
}

int PopulateZipDialog(HWND	hList, char *pArchive)
{
	char			Name[MAX_PATH];
	unzFile			Handle;
	unz_file_info	FileInfo;
	int				Count = 0;
	int				Error;
	LVITEM			Item;

	ListView_DeleteAllItems(hList);

	Handle = unzOpen(pArchive);

	if (!Handle) return 0;

	Error = unzGoToFirstFile(Handle);

	if (Error != UNZ_OK)
	{
		unzClose(Handle);

		return 0;
	}

	while (Error == UNZ_OK)
	{
	    unzGetCurrentFileInfo(Handle, &FileInfo, Name, MAX_PATH, NULL, 0, NULL, 0);

		if (!stricmp(&Name[strlen(Name) - 2], "gg") ||
			!stricmp(&Name[strlen(Name) - 3], "sms"))
		{
			Item.mask		= LVIF_TEXT;
			Item.pszText	= Name;
			Item.cchTextMax = strlen(Item.pszText);
			Item.iItem		= Count++;
			Item.iSubItem	= 0;

			ListView_InsertItem(hList, &Item);
		}

		Error = unzGoToNextFile(Handle);
	}

	if (Count)
	{
		ListView_SetItemState(hList, 0, LVIS_SELECTED, LVIS_SELECTED);
	
		Item.iItem		= 0;
		Item.cchTextMax = MAX_PATH;
		Item.pszText	= FileToLoad;
	
		ListView_GetItem(hList, &Item);
	}

    unzClose(Handle);

	return Count;
}

BOOL LoadSelectedFileFromZip(char *pArchive)
{	
	unzFile			Handle;
	unz_file_info	FileInfo;
	char			Name[MAX_PATH];
	int				BytesRead;

	Handle = unzOpen(pArchive);

	if (!Handle) return FALSE;

	if (unzLocateFile(Handle, FileToLoad, 2) != UNZ_OK)
	{
		unzClose(Handle);

		return FALSE;
	}

    unzGetCurrentFileInfo(Handle, &FileInfo, Name, MAX_PATH, NULL, 0, NULL, 0);

	if (FileInfo.uncompressed_size < 0x8000)
	{
		unzClose(Handle);

		return FALSE;
	}

	if (cart.rom) free(cart.rom);
	cart.rom = (char *)malloc(FileInfo.uncompressed_size);

	if (!cart.rom)
	{
		unzClose(Handle);

		return FALSE;
	}

    if (unzOpenCurrentFile(Handle) != UNZ_OK)
	{
		unzClose(Handle);

		return FALSE;
	}
    
    BytesRead = unzReadCurrentFile(Handle, cart.rom, FileInfo.uncompressed_size);

	if (BytesRead != (int)FileInfo.uncompressed_size)
	{
		free(cart.rom);
		cart.rom = NULL;
		unzClose(Handle);

		return FALSE;
	}

	if ((FileInfo.uncompressed_size / 512) & 1)
	{
		FileInfo.uncompressed_size -= 512;
		memmove(cart.rom, cart.rom + 512, FileInfo.uncompressed_size);
	}

	if (!stricmp(&Name[strlen(Name) - 2], "gg"))
	{
		cart.type  = TYPE_GG;
	}
	else
	{
		cart.type  = TYPE_SMS;
	}

	cart.pages = (unsigned char)(FileInfo.uncompressed_size / 0x4000);

    unzCloseCurrentFile(Handle);
	unzClose(Handle);

	strcpy(pArchive, Name);

	return TRUE;
}

/*
unsigned char *loadzip(char *archive, char *filename, int *filesize)
{
    char name[0x100];
    unsigned char *buffer;

    int zerror = UNZ_OK;
    unzFile zhandle;
    unz_file_info zinfo;

    zhandle = unzOpen(archive);
    if(!zhandle) return (NULL);

    zerror = unzGoToFirstFile(zhandle);
    if(zerror != UNZ_OK)
    {
        unzClose(zhandle);
        return (NULL);
    }

    unzGetCurrentFileInfo(zhandle, &zinfo, &name[0], 0xff, NULL, 0, NULL, 0);
    *filesize = zinfo.uncompressed_size;

    if(*filesize <= 0)
    {
        unzClose(zhandle);
        return (NULL);
    }

    zerror = unzOpenCurrentFile(zhandle);
    if(zerror != UNZ_OK)
    {
        unzClose(zhandle);
        return (NULL);
    }

    buffer = malloc(*filesize);
    if(!buffer) return (NULL);
    zerror = unzReadCurrentFile(zhandle, buffer, *filesize);

    if(zerror < 0 || zerror != *filesize)
    {
        free(buffer);
        buffer = NULL;
        unzCloseCurrentFile(zhandle);
        unzClose(zhandle);
        return (NULL);
    }

    unzCloseCurrentFile(zhandle);
    unzClose(zhandle);

    memcpy(filename, name, 0x100);
    return (buffer);
}
*/