
#include "shared.h"
//#include "dinput.h"
#include "resource.h"
#include "main.h"
#include "input.h"
#include "registry.h"
#include <stdio.h>

void save_state(char *pFilename)
{
	FILE *outfile ;

	outfile = fopen( pFilename, "wb" ) ;

	if ( !outfile )
		return ;

	fwrite(&vdp, sizeof(t_vdp), 1, outfile ) ;
	fwrite(&sms, sizeof(t_sms), 1, outfile ) ;
	fwrite(Z80_Context, sizeof(Z80_Regs), 1, outfile ) ;
	fwrite(&after_EI, sizeof(int), 1, outfile ) ;
	fwrite(&ym2413[0].reg[0], 0x40, 1, outfile ) ;
	fwrite(&sn[0], sizeof(t_SN76496), 1, outfile ) ;

	fclose( outfile ) ;
}

void load_state(char *pFilename)
{
	int				BytesRead;
	int				i;
    byte			reg[0x40];
	FILE			*infile ;

	infile = fopen( pFilename, "rb" ) ;

	if ( !infile )
		return ;
	
    /* Reset the virtual console */
	cpu_reset();
    system_reset();

    /* Load VDP context */
    fread(&vdp, sizeof(t_vdp), 1, infile ) ;

    /* Load SMS context */
    fread(&sms, sizeof(t_sms), 1, infile ) ;

    /* Load Z80 context */
    fread(Z80_Context, sizeof(Z80_Regs), 1, infile ) ;
    fread(&after_EI, sizeof(int), 1, infile ) ;

    /* Load YM2413 registers */
    fread(&reg, 0x40, 1, infile ) ;

    /* Load SN76489 context */
	fread(&sn[0], sizeof(t_SN76496), 1, infile ) ;

	fclose(infile);
	
     /* Restore callbacks */
    z80_set_irq_callback(sms_irq_callback);

    cpu_readmap[0] = cart.rom + 0x0000; /* 0000-3FFF */
    cpu_readmap[1] = cart.rom + 0x2000;
    cpu_readmap[2] = cart.rom + 0x4000; /* 4000-7FFF */
    cpu_readmap[3] = cart.rom + 0x6000;
    cpu_readmap[4] = cart.rom + 0x0000; /* 0000-3FFF */
    cpu_readmap[5] = cart.rom + 0x2000;
    cpu_readmap[6] = sms.ram;
    cpu_readmap[7] = sms.ram;

    cpu_writemap[0] = sms.dummy;
    cpu_writemap[1] = sms.dummy;
    cpu_writemap[2] = sms.dummy;         
    cpu_writemap[3] = sms.dummy;
    cpu_writemap[4] = sms.dummy;         
    cpu_writemap[5] = sms.dummy;
    cpu_writemap[6] = sms.ram;           
    cpu_writemap[7] = sms.ram;

    sms_mapper_w(3, sms.fcr[3]);
    sms_mapper_w(2, sms.fcr[2]);
    sms_mapper_w(1, sms.fcr[1]);
    sms_mapper_w(0, sms.fcr[0]);

    /* Force full pattern cache update */
    is_vram_dirty = 1;
    memset(vram_dirty, 1, 0x200);

    /* Restore palette */
    for(i = 0; i < PALETTE_SIZE; i += 1)
        palette_sync(i);

    /* Restore sound state */
    if(snd.enabled)
    {
        /* Restore YM2413 emulation */
        OPLResetChip(ym3812);

        /* Clear YM2413 context */
        ym2413_reset(0);

        /* Restore rhythm enable first */
        ym2413_write(0, 0, 0x0E);
        ym2413_write(0, 1, reg[0x0E]);

        /* User instrument settings */
        for(i = 0x00; i <= 0x07; i += 1)
        {
            ym2413_write(0, 0, i);
            ym2413_write(0, 1, reg[i]);
        }

        /* Channel frequency */
        for(i = 0x10; i <= 0x18; i += 1)
        {
            ym2413_write(0, 0, i);
            ym2413_write(0, 1, reg[i]);
        }

        /* Channel frequency + ctrl. */
        for(i = 0x20; i <= 0x28; i += 1)
        {
            ym2413_write(0, 0, i);
            ym2413_write(0, 1, reg[i]);
        }

        /* Instrument and volume settings  */
        for(i = 0x30; i <= 0x38; i += 1)
        {
            ym2413_write(0, 0, i);
            ym2413_write(0, 1, reg[i]);
        }
    }
}
