#ifndef __REGISTRY_HEADER
#define __REGISTRY_HEADER

#define REGISTRY_KEY						"\\SMS Plus"

#define REGISTRY_DEFAULT_SCREEN_SCALE		1
#define REGISTRY_DEFAULT_UPDATE_FREQUENCY	FREQ_60HZ
#define REGISTRY_DEFAULT_FRAME_SKIP			0
#define REGISTRY_DEFAULT_BUTTON_MAP			{{DIK_LEFT, DIK_RIGHT, DIK_UP, DIK_DOWN, DIK_LCONTROL, DIK_LSHIFT, DIK_SPACE}, {0, 0, 0, 0, 0, 0, 0}}
#define REGISTRY_DEFAULT_ROM_PATH			"C:\\"
#define REGISTRY_DEFAULT_SCREENSHOT_PATH	"C:\\"
#define REGISTRY_DEFAULT_SAVESTATE_PATH		"C:\\"
#define REGISTRY_DEFAULT_SOUND_PATH			"C:\\"
#define REGISTRY_DEFAULT_SOUND_ENABLE		TRUE
#define REGISTRY_DEFAULT_SOUND_FREQUENCY	44100
#define REGISTRY_DEFAULT_DISABLE_KEYS		FALSE
#define REGISTRY_DEFAULT_RAPID_FIRE_RATE	5
#define REGISTRY_DEFAULT_REGION				TYPE_OVERSEAS
#define REGISTRY_DEFAULT_SINGLE_SAVESTATE	FALSE
#define REGISTRY_DEFAULT_GAMMA				1.0f
#define REGISTRY_DEFAULT_SCREEN_SMOOTHING	FALSE
#define REGISTRY_DEFAULT_FULL_SCREEN_MODE	0
#define REGISTRY_DEFAULT_FULL_SCREEN		FALSE
#define REGISTRY_DEFAULT_DIRECT_DRAW_ENABLE	FALSE
#define REGISTRY_DEFAULT_SCANLINES			FALSE
#define REGISTRY_DEFAULT_FM_VOLUME			1.0f

#define REGISTRY_SCREEN_SCALE				"Screen Scale"
#define REGISTRY_UPDATE_FREQUENCY			"Update Frequency"
#define REGISTRY_FRAME_SKIP					"Frame Skip"
#define REGISTRY_BUTTON_MAP					"Button Map"
#define REGISTRY_ROM_PATH					"ROM Path"
#define REGISTRY_SRAM_PATH					"SRAM Path"
#define REGISTRY_SCREENSHOT_PATH			"Screenshot Path"
#define REGISTRY_SAVESTATE_PATH				"Save State Path"
#define REGISTRY_SOUND_PATH					"Sound Record Path"
#define REGISTRY_JOYSTICK					"Joystick"
#define REGISTRY_JOYSTICK_MAP				"Joystick Map"
#define REGISTRY_SOUND_ENABLE				"Enable Sound"
#define REGISTRY_SOUND_FM_ENABLE			"Enable FM Sound"
#define REGISTRY_SOUND_FREQUENCY			"Sound Frequency"
#define REGISTRY_RAPID_FIRE					"Rapid Fire"
#define REGISTRY_RAPID_FIRE_RATE			"Rapid Fire Rate"
#define REGISTRY_DISABLE_KEYS				"Disable Keys"
#define REGISTRY_REGION						"Region"
#define REGISTRY_SINGLE_SAVESTATE			"Single Save State"
#define REGISTRY_GAMMA						"Gamma"
#define REGISTRY_SCREEN_SMOOTHING			"Screen Smoothing"
#define REGISTRY_FULL_SCREEN_MODE			"Full Screen Mode"
#define REGISTRY_FULL_SCREEN				"Full Screen"
#define REGISTRY_DIRECT_DRAW_ENABLE			"Enable Direct Draw"
#define REGISTRY_SCANLINES					"Enable ScanLines"
#define REGISTRY_FM_VOLUME					"FM Volume"

#ifndef MAX_PATH
#define MAX_PATH 1024
#endif 

typedef struct REGISTRY_INFO
{
	unsigned int							ScreenScale;
	unsigned int							UpdateFrequency;
	unsigned int							FrameSkip;
	unsigned char							ButtonMap[MAX_PLAYERS][NO_OF_BUTTONS];
	char									ROMPath[MAX_PATH];
	char									SRAMPath[MAX_PATH];
	char									ScreenshotPath[MAX_PATH];
	char									SaveStatePath[MAX_PATH];
	char									SoundRecordPath[MAX_PATH];
	char									Joystick[MAX_PLAYERS][MAX_PATH];
	unsigned char							JoystickMap[MAX_PLAYERS][3];
	char									EnableSound;
	char									EnableFMSound;
	int										SoundFrequency;
	unsigned char							RapidFire[MAX_PLAYERS][2];
	unsigned char							RapidFireRate[MAX_PLAYERS];
	unsigned char							DisableKeys[MAX_PLAYERS];
	int										Region;
	char									SingleSaveState;
	float									Gamma;
	char									ScreenSmoothing;
	int										FullScreenMode;
	char									FullScreen;
	char									EnableDirectDraw;
	char									EnableScanLines;
	float									FMVolume;
} REGISTRY_INFO;

extern REGISTRY_INFO						RegistryInfo;

void										InitRegistryEntries(void);
char										LoadRegistryEntries(void);
char										SaveRegistryEntries(void);
void										SetFileAssociations(void);

#endif