#include "shared.h"
//#include "commctrl.h"
#include "state.h"
//#include "dinput.h"
//#include "vfw.h"
#include "stdio.h"
#include "resource.h"
#include "file.h"
#include "audio.h"
#include "input.h"
#include "main.h"
#include "zip.h"
#include "registry.h"
#include "modes.h"

static BMP			Bmp;
static HWND			hwnd;
static HINSTANCE	hInstance;
static HMENU		hMenu;
static BOOL			RunEmulation = FALSE;
static BOOL			Paused = FALSE;
static HANDLE		Mutex = NULL;
static unsigned int	USER_MESSAGE = 0;
unsigned char		BitmapData[256 * 256 * 2];
static HBITMAP		hBitmap = NULL;

static char			GameName[MAX_PATH] = "";
static unsigned int	Frame		   = 0;
static unsigned int	LastTickCount  = 0;
static BOOL			RecordSound	   = FALSE;
static BOOL			RecordingSound = FALSE;
static BOOL			UseDirectDraw  = FALSE;
static BOOL			DirectDrawAvail= FALSE;

static unsigned int FrameTime[]		= {0, 0, 0};
static unsigned int	FrameTime60hz[] = {17, 17, 16};
static unsigned int	FrameTime50hz[] = {20, 20, 20};

extern short		pixel[];

int WINAPI OldWinMain(HINSTANCE hinstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	WNDCLASS    WindowClass;
	MSG			msg;
	int			QuitFlag = FALSE;

	if (CreateSingleInstance(szCmdLine))
	{
		// Clear the window class structure
		memset(&WindowClass, 0, sizeof(WindowClass));

		// Set up window class attributes
		WindowClass.style                   = CS_HREDRAW | CS_VREDRAW;				// Window styles
		WindowClass.lpfnWndProc				= MainWindowProc;						// Windows messaging function
		WindowClass.hInstance				= hInstance;							// Application instance
		WindowClass.hIcon                   = LoadIcon(hinstance, MAKEINTRESOURCE(IDI_ICON1));		// Icon to display on title bar
		WindowClass.hCursor                 = LoadCursor(NULL, IDC_ARROW);			// Cursor to use over window
		WindowClass.hbrBackground			= CreateSolidBrush(0);					// Colour to use for window background
		WindowClass.lpszMenuName			= NULL;									// Menu to use
		WindowClass.lpszClassName			= SMS_CLASS_NAME;						// Class name

		// Register window class
		if (!RegisterClass(&WindowClass))
		{
			// Return unsuccessful
			return FALSE;
		}

		InitRegistryEntries();
		LoadRegistryEntries();

		// Create the main window for our application
		hInstance = hinstance;
		hwnd = CreateWindowEx(0,									// Extended window style
							  SMS_CLASS_NAME,			            // Pointer to registered class name
							  "SMS Plus",							// Pointer to window name 
							  WS_POPUP | WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX | WS_CLIPCHILDREN | WS_CLIPSIBLINGS,	// Window style
							  0,                                    // X Pos
							  0,                                    // Y Pos
							  0,									// Width
							  0,							        // Height
							  NULL,                                 // Handle to parent or owner window
							  NULL,                                 // Handle to menu, or child window
							  hInstance,					        // Application instance
							  NULL);                                // Pointer to window creation data

		// Load the menu to use for the application and set it
		hMenu = LoadMenu(hInstance, MAKEINTRESOURCE(IDR_MENU));
		SetMenu(hwnd, hMenu);

		InitVRAM();
		InitAudio(hwnd, RegistryInfo.SoundFrequency, FREQ_60HZ);
		InitInput(hwnd, hInstance);

		DirectDrawAvail = InitModes();
		if (DirectDrawAvail && RegistryInfo.EnableDirectDraw) UseDirectDraw = ChangeMode(RegistryInfo.FullScreenMode, RegistryInfo.FullScreen);

		CheckMenuItem(hMenu, ID_MENU_CONFIG_SCREEN_SMOOTHING, RegistryInfo.ScreenSmoothing? MF_CHECKED : MF_UNCHECKED);
		CheckMenuItem(hMenu, ID_MENU_CONFIG_SOUND_ENABLE, RegistryInfo.EnableSound? MF_CHECKED : MF_UNCHECKED);
		EnableMenuItem(hMenu, ID_MENU_CONFIG_SCREEN_FULL, UseDirectDraw? MF_BYCOMMAND | MF_ENABLED : MF_BYCOMMAND | MF_GRAYED);
		EnableMenuItem(hMenu, ID_MENU_CONFIG_SCREEN_SMOOTHING, UseDirectDraw? MF_BYCOMMAND | MF_ENABLED : MF_BYCOMMAND | MF_GRAYED);
		EnableMenuItem(hMenu, ID_MENU_CONFIG_SOUND_RECORD, RegistryInfo.EnableSound? MF_BYCOMMAND | MF_ENABLED : MF_BYCOMMAND | MF_GRAYED);

		if ((!UseDirectDraw || !RegistryInfo.EnableDirectDraw) && (RegistryInfo.ScreenScale == 0))
		{
			RegistryInfo.ScreenScale = 1;
		}

		SetFrameTime(RegistryInfo.UpdateFrequency);
		SetScreenScale(RegistryInfo.ScreenScale);
		SetScreenSmoothing(RegistryInfo.ScreenSmoothing);
		SetUpdateFrequency(RegistryInfo.UpdateFrequency);
		SetFrameSkip(RegistryInfo.FrameSkip);
		SetSoundFrequency(RegistryInfo.SoundFrequency);
		SetRegion(RegistryInfo.Region);
		CenterWindowInParent(hwnd);
		ShowWindow(hwnd, SW_SHOW);

		if (strlen(szCmdLine))
		{
			if (!stricmp(&szCmdLine[strlen(szCmdLine) - 2], "gg") ||
				!stricmp(&szCmdLine[strlen(szCmdLine) - 3], "sms") ||
				!stricmp(&szCmdLine[strlen(szCmdLine) - 3], ".zip"))
			{
				OpenROM(szCmdLine);
			}
		}
	}
	else
	{
		QuitFlag = TRUE;
	}

	// Main program loop
    while (QuitFlag == FALSE)
    {
		unsigned int		TickCount;
		unsigned int		Skip = (Frame % (RegistryInfo.FrameSkip + 1))? 1 : 0;

		TickCount = GetTickCount();

		if (LastTickCount == 0) LastTickCount = TickCount;

		if (TickCount - LastTickCount >= FrameTime[Frame % 3])
		{
			// Auto frame skip
			if (RegistryInfo.FrameSkip == 0)
			{
				if (TickCount - LastTickCount >= (FrameTime[Frame % 3] * 2)) Skip = TRUE;
			}

			if (RunEmulation && !Paused)
			{
			    sms_frame(Skip);

				if (RegistryInfo.EnableSound) UpdateAudio(snd.buffer, snd.bufsize, Frame);

				if (!Skip)
				{
					UpdatePalette();
					UpdateKeyboard();
					UpdateSpecialKeys();
					UpdateJoysticks();
					UpdateRapidFire(Frame);
					SendMessage(hwnd, WM_PAINT, 0, 0);
				}
			}

			if ((TickCount - LastTickCount) >= (FrameTime[0] * (NO_OF_AUDIO_BUFFERS / 2)))
			{
				LastTickCount = 0;
				Frame		  = 0;
			}
			else
			{
				LastTickCount = TickCount - ((TickCount - LastTickCount) - FrameTime[Frame % 3]);
				Frame++;
			}
		}
		else
		{
			if (PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		    {
				if (GetMessage(&msg, NULL, 0, 0))
				{
					TranslateMessage(&msg);
					DispatchMessage(&msg);
			    }
				else
				{
					// GetMessage returning FALSE implies exit message
					QuitFlag = TRUE;
				}
			}
		}
    }
	
	SaveRegistryEntries();
	TidyModes();
	TidyInput();
	TidyAudio();
	system_shutdown();

	if (hMenu) DestroyMenu(hMenu);
	DestroySingleInstance();

	return msg.wParam;
}

LRESULT CALLBACK MainWindowProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch (msg)
	{
	case WM_CREATE:
		{
			HDC			hDC;

			memset(&Bmp, 0, sizeof(BMP));

			Bmp.BitmapInfoHeader.biSize			= sizeof(BITMAPINFOHEADER);
			Bmp.BitmapInfoHeader.biWidth		= 256;
			Bmp.BitmapInfoHeader.biHeight		= 192;
			Bmp.BitmapInfoHeader.biPlanes		= 1;
			Bmp.BitmapInfoHeader.biBitCount		= 8;
			Bmp.BitmapInfoHeader.biCompression	= BI_RGB;
			Bmp.BitmapInfoHeader.biClrUsed		= 256;
				
			hDC = GetDC(hwnd);
			hBitmap = CreateDIBitmap(hDC, &Bmp.BitmapInfoHeader, 0, &BitmapData[0], (BITMAPINFO *)&Bmp, DIB_PAL_COLORS);
			ReleaseDC(hwnd, hDC);
		}
		break;

	case WM_SETFOCUS:
		if (UseDirectDraw && RegistryInfo.EnableDirectDraw && FullScreenMode()) FlipToGDISurface(FALSE);
		break;

	case WM_KILLFOCUS:
		if (UseDirectDraw && RegistryInfo.EnableDirectDraw && FullScreenMode()) FlipToGDISurface(TRUE);
		break;

	case WM_ACTIVATEAPP:
		if (wParam)
		{
			Paused = FALSE;

			// Restore Sync (+ Restart Audio)
			Frame		  = 0;
			LastTickCount = 0;

			// Restore Input
			InitInput(hwnd, hInstance);
		}
		else
		{
			Paused = TRUE;
			StopAudio();
			TidyInput();
		}
		break;

	case WM_MOVE:
		if (UseDirectDraw && RegistryInfo.EnableDirectDraw && !FullScreenMode()) UpdateModeWindowCoords(hwnd);
		break;

	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
		case ID_MENU_FILE_OPEN:
		    SaveSRAM();
			OpenROM(NULL);
			break;

		case ID_MENU_FILE_EXIT:
			SendMessage(hwnd, WM_CLOSE, 0, 0);
			break;

		case ID_MENU_CPU_RESET:
			SaveSRAM();
			input.system = INPUT_HARD_RESET;
			if (RecordSound) RecordingSound = TRUE;
			break;

		case ID_MENU_CPU_LOAD_STATE:
			LoadState();
			break;
		
		case ID_MENU_CPU_SAVE_STATE:
			SaveState();
			break;

		case ID_MENU_CONFIG_SCREEN_FULL:
			SetScreenScale(RegistryInfo.ScreenScale = 0);
			break;

		case ID_MENU_CONFIG_SCREEN_X1:
			SetScreenScale(RegistryInfo.ScreenScale = 1);
			break;

		case ID_MENU_CONFIG_SCREEN_X2:
			SetScreenScale(RegistryInfo.ScreenScale = 2);
			break;

		case ID_MENU_CONFIG_SCREEN_X3:
			SetScreenScale(RegistryInfo.ScreenScale = 3);
			break;

		case ID_MENU_CONFIG_UPDATE_50HZ:
			SetUpdateFrequency(RegistryInfo.UpdateFrequency = FREQ_50HZ);
			break;

		case ID_MENU_CONFIG_UPDATE_60HZ:
			SetUpdateFrequency(RegistryInfo.UpdateFrequency = FREQ_60HZ);
			break;

		case ID_MENU_CONFIG_SKIP_AUTO:
			SetFrameSkip(RegistryInfo.FrameSkip = 0);
			break;

		case ID_MENU_CONFIG_SKIP_1:
			SetFrameSkip(RegistryInfo.FrameSkip = 1);
			break;

		case ID_MENU_CONFIG_SKIP_2:
			SetFrameSkip(RegistryInfo.FrameSkip = 2);
			break;

		case ID_MENU_CONFIG_SKIP_3:
			SetFrameSkip(RegistryInfo.FrameSkip = 3);
			break;

		case ID_MENU_CONFIG_SKIP_4:
			SetFrameSkip(RegistryInfo.FrameSkip = 4);
			break;

		case ID_MENU_CONFIG_SCREEN_SMOOTHING:
			if (GetMenuState(hMenu, ID_MENU_CONFIG_SCREEN_SMOOTHING, MF_BYCOMMAND) == MF_CHECKED)
			{
				CheckMenuItem(hMenu, ID_MENU_CONFIG_SCREEN_SMOOTHING, MF_UNCHECKED);
				SetScreenSmoothing(RegistryInfo.ScreenSmoothing = FALSE);
			}
			else
			{
				CheckMenuItem(hMenu, ID_MENU_CONFIG_SCREEN_SMOOTHING, MF_CHECKED);
				SetScreenSmoothing(RegistryInfo.ScreenSmoothing = TRUE);
			}
			break;

		case ID_MENU_CONFIG_SOUND_ENABLE:
			if (GetMenuState(hMenu, ID_MENU_CONFIG_SOUND_ENABLE, MF_BYCOMMAND) == MF_CHECKED)
			{
				RegistryInfo.EnableSound = FALSE;
				CheckMenuItem(hMenu, ID_MENU_CONFIG_SOUND_ENABLE, MF_UNCHECKED);
				EnableMenuItem(hMenu, ID_MENU_CONFIG_SOUND_RECORD, MF_BYCOMMAND | MF_GRAYED);
			}
			else
			{
				RegistryInfo.EnableSound = TRUE;
				CheckMenuItem(hMenu, ID_MENU_CONFIG_SOUND_ENABLE, MF_CHECKED);
				EnableMenuItem(hMenu, ID_MENU_CONFIG_SOUND_RECORD, MF_BYCOMMAND | MF_ENABLED);
			}
			break;

		case ID_MENU_CONFIG_SOUND_RECORD:
			if (GetMenuState(hMenu, ID_MENU_CONFIG_SOUND_RECORD, MF_BYCOMMAND) == MF_CHECKED)
			{
				RecordSound    = FALSE;
				RecordingSound = FALSE;
				CheckMenuItem(hMenu, ID_MENU_CONFIG_SOUND_RECORD, MF_UNCHECKED);
			}
			else
			{
				RecordSound = TRUE;
				MessageBox(hwnd, "Sound will begin recording when the\nnext game is loaded, or the CPU is reset.", "Record sound output", MB_OK | MB_ICONEXCLAMATION);
				CheckMenuItem(hMenu, ID_MENU_CONFIG_SOUND_RECORD, RecordSound? MF_CHECKED : MF_UNCHECKED);
			}
			break;

		case ID_MENU_CONFIG_SOUND_44100:
			SetSoundFrequency(RegistryInfo.SoundFrequency = 44100);
			break;

		case ID_MENU_CONFIG_SOUND_22050:
			// Pick nearest divisible by 50 & 60
			SetSoundFrequency(RegistryInfo.SoundFrequency = 22200);
			break;

		case ID_MENU_CONFIG_SOUND_11025:
			// Pick nearest divisible by 50 & 60
			SetSoundFrequency(RegistryInfo.SoundFrequency = 11100);
			break;

		case ID_MENU_CONFIG_REGION_JAPAN:
			SetRegion(RegistryInfo.Region = sms.country = TYPE_DOMESTIC);
			break;

		case ID_MENU_CONFIG_REGION_EUROPEUS:
			SetRegion(RegistryInfo.Region = sms.country = TYPE_OVERSEAS);
			break;

		case ID_MENU_CONFIG_CONTROLS:
			DialogBox(hInstance, MAKEINTRESOURCE(IDD_CONTROLS), hwnd, ConfigureControlsProc);
			TidyInput();
			InitInput(hwnd, hInstance);
			break;

		case ID_MENU_CONFIG_SETTINGS:
			DialogBox(hInstance, MAKEINTRESOURCE(IDD_SETTINGS), hwnd, SettingsProc);
			break;

		case ID_MENU_HELP_ABOUT:
			DialogBox(hInstance, MAKEINTRESOURCE(IDD_ABOUT), hwnd, AboutProc);
			break;

		default:
			return TRUE;
		}
		break;

	case WM_ENTERMENULOOP:
		{
			char			Filename[MAX_PATH];
			int				Found;
			int				AppendPos;

			wsprintf(Filename, "%s%s", RegistryInfo.SaveStatePath, GetGameName());
			Found = CountSaveStateFiles(Filename, &AppendPos);

			EnableMenuItem(hMenu, ID_MENU_CPU_LOAD_STATE, Found? (MF_BYCOMMAND | MF_ENABLED) : (MF_BYCOMMAND | MF_GRAYED));
			EnableMenuItem(hMenu, ID_MENU_CPU_SAVE_STATE, RunEmulation? (MF_BYCOMMAND | MF_ENABLED) : (MF_BYCOMMAND | MF_GRAYED));
		
			StopAudio();
			
			if (UseDirectDraw && RegistryInfo.EnableDirectDraw && FullScreenMode()) FlipToGDISurface(TRUE);
		}
		break;

	case WM_EXITMENULOOP:
		Frame		  = 0;
		LastTickCount = 0;

		if (UseDirectDraw && RegistryInfo.EnableDirectDraw && FullScreenMode()) FlipToGDISurface(FALSE);
		break;

	case WM_PAINT:
		if (UseDirectDraw && RegistryInfo.EnableDirectDraw)
		{
			PAINTSTRUCT			PaintStruct;

			BeginPaint(hwnd, &PaintStruct);
			EndPaint(hwnd, &PaintStruct);

			UpdateTexture();
			DrawTexture();
			FlipScreens();
		}
		else
		{
			HDC					hDC;
			HDRAWDIB			hDrawDib;
			PAINTSTRUCT			PaintStruct;
			int					Scale = RegistryInfo.ScreenScale;

			BeginPaint(hwnd, &PaintStruct);
			EndPaint(hwnd, &PaintStruct);

			hDC = GetDC(hwnd);
			hDrawDib = DrawDibOpen();
			if (cart.type == TYPE_GG)
			{
				DrawDibBegin(hDrawDib, hDC, Bmp.BitmapInfoHeader.biWidth - 96, Bmp.BitmapInfoHeader.biHeight - 48, &Bmp.BitmapInfoHeader, 
							 Bmp.BitmapInfoHeader.biWidth, Bmp.BitmapInfoHeader.biHeight, DDF_BACKGROUNDPAL);
				DrawDibDraw(hDrawDib, hDC, 0, 0, (Bmp.BitmapInfoHeader.biWidth - 96) * Scale, (Bmp.BitmapInfoHeader.biHeight - 48) * Scale,
							&Bmp.BitmapInfoHeader, &BitmapData[0], 48, 24, Bmp.BitmapInfoHeader.biWidth - 96, Bmp.BitmapInfoHeader.biHeight - 48, DDF_BACKGROUNDPAL);
			}
			else
			{
				DrawDibBegin(hDrawDib, hDC, Bmp.BitmapInfoHeader.biWidth, Bmp.BitmapInfoHeader.biHeight, &Bmp.BitmapInfoHeader, 
							 Bmp.BitmapInfoHeader.biWidth, Bmp.BitmapInfoHeader.biHeight, DDF_BACKGROUNDPAL);
				DrawDibDraw(hDrawDib, hDC, 0, 0, Bmp.BitmapInfoHeader.biWidth * Scale, Bmp.BitmapInfoHeader.biHeight * Scale,
							&Bmp.BitmapInfoHeader, &BitmapData[0], 0, 0, Bmp.BitmapInfoHeader.biWidth, Bmp.BitmapInfoHeader.biHeight, DDF_BACKGROUNDPAL);
			}
			DrawDibEnd(hDrawDib);
			DrawDibClose(hDrawDib);
			ReleaseDC(hwnd, hDC);
		}
		break;

	case WM_CLOSE:
		DeleteObject(hBitmap);
		DestroyWindow(hwnd);
		break;

	case WM_DESTROY:
	    SaveSRAM();
        PostQuitMessage(0);
		break;

	default:
		if (msg == USER_MESSAGE)
		{
		    SaveSRAM();
			OpenROM((char *)lParam);
			SendMessage(hwnd, WM_ACTIVATE, WA_CLICKACTIVE, (long)hwnd);
			SendMessage(hwnd, WM_NCACTIVATE, TRUE, 0);
			break;
		}
		else
		{
			return DefWindowProc(hwnd, msg, wParam, lParam);
		}
	}

	return FALSE;
}

void AdjustWindowSize(void)
{
	if (!FullScreenMode())
	{
		RECT		Rect;

		GetConsoleScreenRect(&Rect);

		Rect.right  = (Rect.right - Rect.left) * RegistryInfo.ScreenScale;
		Rect.bottom = (Rect.bottom - Rect.top) * RegistryInfo.ScreenScale;
		Rect.top	= 0;
		Rect.left	= 0;

		AdjustWindowRect(&Rect, GetWindowLong(hwnd, GWL_STYLE), GetMenu(hwnd)? TRUE : FALSE);
		SetWindowPos(hwnd, NULL, 0, 0, Rect.right - Rect.left, Rect.bottom - Rect.top, SWP_NOMOVE | SWP_NOZORDER | SWP_NOACTIVATE | SWP_FRAMECHANGED);
	}

	if (UseDirectDraw && RegistryInfo.EnableDirectDraw) UpdateModeWindowCoords(hwnd);
}

void InitVRAM(void)
{
     /* Initialize display bitmap */
    memset(&bitmap, 0, sizeof(t_bitmap));
    bitmap.width  = 256;
    bitmap.height = 192;
    bitmap.depth  = 8;
    bitmap.pitch  = (bitmap.width * (bitmap.depth >> 3));
    bitmap.data   = (unsigned char *)&BitmapData[0];
}

void UpdatePalette(void)
{
    unsigned char	r, g, b;
    int				index;

    if (bitmap.pal.update == 0) return;

    for (index = 0; index < 32; index++)
    {
        if(bitmap.pal.color[index])
        {
			if (UseDirectDraw && RegistryInfo.EnableDirectDraw)
			{
	            b = bitmap.pal.color[index][0];
				g = bitmap.pal.color[index][1];
				r = bitmap.pal.color[index][2];
			}
			else
			{
	            r = bitmap.pal.color[index][0];
				g = bitmap.pal.color[index][1];
				b = bitmap.pal.color[index][2];
			}

			r = (unsigned char)(255.0f * pow((float)r / 255.0f, 1.0f / RegistryInfo.Gamma) + 0.5f);
			g = (unsigned char)(255.0f * pow((float)g / 255.0f, 1.0f / RegistryInfo.Gamma) + 0.5f);
			b = (unsigned char)(255.0f * pow((float)b / 255.0f, 1.0f / RegistryInfo.Gamma) + 0.5f);

			pixel[index] = MAKE_PIXEL(b, g, r);

			Bmp.Palette[0x00 | index].rgbRed	  = r;
			Bmp.Palette[0x00 | index].rgbGreen	  = g;
			Bmp.Palette[0x00 | index].rgbBlue	  = b;
			Bmp.Palette[0x20 | index].rgbRed	  = r;
			Bmp.Palette[0x20 | index].rgbGreen	  = g;
			Bmp.Palette[0x20 | index].rgbBlue	  = b;
			Bmp.Palette[0x40 | index].rgbRed	  = r;
			Bmp.Palette[0x40 | index].rgbGreen	  = g;
			Bmp.Palette[0x40 | index].rgbBlue	  = b;
        }
    }

    bitmap.pal.update = 0;
    memset(bitmap.pal.dirty, 0, 32);
}

void OpenROM(char *pROM)
{
	HANDLE			FileHandle;
	char			Filename[MAX_PATH] = "";
	int				FileSize;
	int				BytesRead;
	int				i;

	if (RecordingSound)
	{
		CloseSoundRecording();
		RecordSound    = FALSE;
		RecordingSound = FALSE;
		CheckMenuItem(hMenu, ID_MENU_CONFIG_SOUND_RECORD, MF_UNCHECKED);
	}
	
	if (pROM)
	{
		strcpy(Filename, pROM);
	}
	else
	{
		// Initialise the file dialog
		InitFileDialog(hwnd, RegistryInfo.ROMPath, "Roms (*.gg, *.sms, *.zip)\0*.gg;*.sms;*.zip\0All Files (*.*)\0*.*\0", 0); 

		// Show the dialog, and return if it is cancelled
		if (!GetLoadFileFromDialog(hwnd, "Open", Filename)) return;
	}

	if (!stricmp(&Filename[strlen(Filename) - 3], "zip"))
	{
		if (!DialogBoxParam(hInstance, MAKEINTRESOURCE(IDD_ZIP), hwnd, LoadZipProc, (long)Filename)) return;
		if (!LoadSelectedFileFromZip(Filename)) return;
	}
	else
	{
		FileHandle = CreateFile(Filename, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, NULL);

		if (FileHandle == INVALID_HANDLE_VALUE) return;
		
		FileSize = GetFileSize(FileHandle, NULL);

		if (FileSize < 0x8000) 
		{
			CloseHandle(FileHandle);
			return;
		}

		if ((FileSize / 512) & 1)
		{
			SetFilePointer(FileHandle, 512, 0, FILE_CURRENT);
			FileSize -= 512;
		}

		if (!stricmp(&Filename[strlen(Filename) - 2], "gg"))
		{
			cart.type  = TYPE_GG;
		}
		else
		{
			cart.type  = TYPE_SMS;
		}

		cart.pages = (FileSize / 0x4000);
    
		if (cart.rom) free(cart.rom);
		cart.rom = malloc(FileSize);
    
		if (!cart.rom)
		{
			CloseHandle(FileHandle);
			return;
		}

		ReadFile(FileHandle, cart.rom, FileSize, &BytesRead, NULL); 

		CloseHandle(FileHandle);
	}

	system_init(RegistryInfo.SoundFrequency, RegistryInfo.UpdateFrequency);
	system_reset();
    sms.country  = RegistryInfo.Region;
    sms.use_fm   = RegistryInfo.EnableFMSound;
	snd.callback = UpdateSoundRecording;

	for (i = strlen(Filename) - 1 ; i >= 0 ; i--)
	{
		if (Filename[i] == '\\' || Filename[i] == '/') 
		{
			break;
		}
	}

    strcpy(GameName, &Filename[i + 1]);
    strcpy(strrchr(GameName, '.'), "");
    LoadSRAM();

	SetWindowText(hwnd, GameName);

	AdjustWindowSize();
	RunEmulation = TRUE;

	if (RecordSound) 
	{
		CreateSoundRecording();
		RecordingSound = TRUE;
	}
}

char *GetGameName(void)
{
	return GameName;
}

char *GetBitmapInfoHeader(void)
{
	return (char *)&Bmp;
}

char *GetBitmapData(void)
{
	return BitmapData;
}

void LoadSRAM(char *filename)
{
	HANDLE		FileHandle;
	int			BytesRead;
	char		Filename[MAX_PATH];

	wsprintf(Filename, "%s%s.sav", RegistryInfo.SRAMPath, GameName);

    FileHandle = CreateFile(Filename, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, NULL);

	if (FileHandle == INVALID_HANDLE_VALUE) return;

    ReadFile(FileHandle, sms.sram, 0x8000, &BytesRead, NULL); 

	CloseHandle(FileHandle);

	sms.save = 1;
}

void SaveSRAM(void)
{
    HANDLE		FileHandle;
    int			BytesWritten;
	char		Filename[MAX_PATH];

	wsprintf(Filename, "%s%s.sav", RegistryInfo.SRAMPath, GameName);

	if (sms.save && strlen(GameName))
	{
	    FileHandle = CreateFile(Filename, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_FLAG_SEQUENTIAL_SCAN, NULL);

	    if (FileHandle == INVALID_HANDLE_VALUE) return;

	    WriteFile(FileHandle, sms.sram, 0x8000, &BytesWritten, NULL); 

	    CloseHandle (FileHandle);
	}
}

LRESULT CALLBACK ConfigureControlsProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch (msg)
	{
	case WM_INITDIALOG:
		{
			int			i;

			CenterWindowInParent(hwnd);

			PopulateJoystickCombo(hwnd, PLAYER_1);
			PopulateJoystickCombo(hwnd, PLAYER_2);
			PopulateConfigureControls(hwnd);

			CheckDlgButton(hwnd, IDC_P1_BUTTON1_RAPIDFIRE_CHECK, RegistryInfo.RapidFire[PLAYER_1][PAD_BUTTON1 - PAD_BUTTON1]? BST_CHECKED : BST_UNCHECKED);
			CheckDlgButton(hwnd, IDC_P1_BUTTON2_RAPIDFIRE_CHECK, RegistryInfo.RapidFire[PLAYER_1][PAD_BUTTON2 - PAD_BUTTON1]? BST_CHECKED : BST_UNCHECKED);
			CheckDlgButton(hwnd, IDC_P2_BUTTON1_RAPIDFIRE_CHECK, RegistryInfo.RapidFire[PLAYER_2][PAD_BUTTON1 - PAD_BUTTON1]? BST_CHECKED : BST_UNCHECKED);
			CheckDlgButton(hwnd, IDC_P2_BUTTON2_RAPIDFIRE_CHECK, RegistryInfo.RapidFire[PLAYER_2][PAD_BUTTON2 - PAD_BUTTON1]? BST_CHECKED : BST_UNCHECKED);

			CheckDlgButton(hwnd, IDC_P1_DISABLE_KEYS_CHECK, RegistryInfo.DisableKeys[PLAYER_1]? BST_CHECKED : BST_UNCHECKED);
			CheckDlgButton(hwnd, IDC_P2_DISABLE_KEYS_CHECK, RegistryInfo.DisableKeys[PLAYER_2]? BST_CHECKED : BST_UNCHECKED);

			EnableWindow(GetDlgItem(hwnd, IDC_P1_DISABLE_KEYS_CHECK), GetSelectedJoystick(PLAYER_1)? TRUE : FALSE);
			EnableWindow(GetDlgItem(hwnd, IDC_P2_DISABLE_KEYS_CHECK), GetSelectedJoystick(PLAYER_2)? TRUE : FALSE);

			for (i = 0 ; i < MAX_PLAYERS ; i++)
			{
				HWND		hCombo = (i == PLAYER_1)? GetDlgItem(hwnd, IDC_P1_RAPIDFIRE_COMBO) : GetDlgItem(hwnd, IDC_P2_RAPIDFIRE_COMBO);
				int			j;

				SendMessage(hCombo, CB_RESETCONTENT, 0, 0);
				
				for (j = 2 ; j <= 10 ; j++)
				{
					char	String[32];
					char	PostFix[4];

					if (j == 2) strcpy(PostFix, "nd");
					else if (j == 3) strcpy(PostFix, "rd");
					else strcpy(PostFix, "th");

					wsprintf(String, "Every %d%s frame", j, PostFix);
					SendMessage(hCombo, CB_ADDSTRING, 0, (long)String);
				}

				SendMessage(hCombo, CB_SETCURSEL, RegistryInfo.RapidFireRate[i] - 2, 0);
			}

			ShowWindow(hwnd, SW_SHOW);
		}
		break;

	case WM_COMMAND:
		{
			switch (HIWORD(wParam))
			{
			case BN_CLICKED:
				switch (LOWORD (wParam))
				{
				case IDC_P1_LEFT_BUTTON:
					ConfigureButton(hwnd, PLAYER_1, PAD_LEFT, IDC_P1_LEFT, "'Player 1 Left'");
					break;

				case IDC_P1_RIGHT_BUTTON:
					ConfigureButton(hwnd, PLAYER_1, PAD_RIGHT, IDC_P1_RIGHT, "'Player 1 Right'");
					break;

				case IDC_P1_UP_BUTTON:
					ConfigureButton(hwnd, PLAYER_1, PAD_UP, IDC_P1_UP, "'Player 1 Up'");
					break;

				case IDC_P1_DOWN_BUTTON:
					ConfigureButton(hwnd, PLAYER_1, PAD_DOWN, IDC_P1_DOWN, "'Player 1 Down'");
					break;

				case IDC_P1_BUTTON1_BUTTON:
					ConfigureButton(hwnd, PLAYER_1, PAD_BUTTON1, IDC_P1_BUTTON1, "'Player 1 Button 1'");
					break;

				case IDC_P1_BUTTON2_BUTTON:
					ConfigureButton(hwnd, PLAYER_1, PAD_BUTTON2, IDC_P1_BUTTON2, "'Player 1 Button 2'");
					break;

				case IDC_P1_START_BUTTON:
					ConfigureButton(hwnd, PLAYER_1, PAD_START, IDC_P1_START, "'Player 1 Start / Pause'");
					break;

				case IDC_P2_LEFT_BUTTON:
					ConfigureButton(hwnd, PLAYER_2, PAD_LEFT, IDC_P2_LEFT, "'Player 2 Left'");
					break;

				case IDC_P2_RIGHT_BUTTON:
					ConfigureButton(hwnd, PLAYER_2, PAD_RIGHT, IDC_P2_RIGHT, "'Player 2 Right'");
					break;

				case IDC_P2_UP_BUTTON:
					ConfigureButton(hwnd, PLAYER_2, PAD_UP, IDC_P2_UP, "'Player 2 Up'");
					break;

				case IDC_P2_DOWN_BUTTON:
					ConfigureButton(hwnd, PLAYER_2, PAD_DOWN, IDC_P2_DOWN, "'Player 2 Down'");
					break;

				case IDC_P2_BUTTON1_BUTTON:
					ConfigureButton(hwnd, PLAYER_2, PAD_BUTTON1, IDC_P2_BUTTON1, "'Player 2 Button 1'");
					break;

				case IDC_P2_BUTTON2_BUTTON:
					ConfigureButton(hwnd, PLAYER_2, PAD_BUTTON2, IDC_P2_BUTTON2, "'Player 2 Button 2'");
					break;

				case IDC_P2_START_BUTTON:
					ConfigureButton(hwnd, PLAYER_2, PAD_START, IDC_P2_START, "'Player 2 Start / Pause'");
					break;

				case IDC_P1_BUTTON1_RAPIDFIRE_CHECK:
					RegistryInfo.RapidFire[PLAYER_1][PAD_BUTTON1 - PAD_BUTTON1] ^= 1;
					break;

				case IDC_P1_BUTTON2_RAPIDFIRE_CHECK:
					RegistryInfo.RapidFire[PLAYER_1][PAD_BUTTON2 - PAD_BUTTON1] ^= 1;
					break;
				
				case IDC_P2_BUTTON1_RAPIDFIRE_CHECK:
					RegistryInfo.RapidFire[PLAYER_2][PAD_BUTTON1 - PAD_BUTTON1] ^= 1;
					break;
				
				case IDC_P2_BUTTON2_RAPIDFIRE_CHECK:
					RegistryInfo.RapidFire[PLAYER_2][PAD_BUTTON2 - PAD_BUTTON1] ^= 1;
					break;

				case IDC_P1_DISABLE_KEYS_CHECK:
					RegistryInfo.DisableKeys[PLAYER_1] ^= 1;
					break;

				case IDC_P2_DISABLE_KEYS_CHECK:
					RegistryInfo.DisableKeys[PLAYER_2] ^= 1;
					break;
				}
				break;

			case CBN_SELCHANGE:
				{
					int		Index = SendMessage(GetDlgItem(hwnd, LOWORD(wParam)), CB_GETCURSEL, 0, 0);
	
					switch (LOWORD(wParam))
					{
					case IDC_P1_JOYSTICK_COMBO:
						SetSelectedJoystick(PLAYER_1, Index);
						PopulateConfigureControls(hwnd);
						EnableWindow(GetDlgItem(hwnd, IDC_P1_DISABLE_KEYS_CHECK), GetSelectedJoystick(PLAYER_1)? TRUE : FALSE);
						EnableWindow(GetDlgItem(hwnd, IDC_P2_DISABLE_KEYS_CHECK), GetSelectedJoystick(PLAYER_2)? TRUE : FALSE);
						break;

					case IDC_P2_JOYSTICK_COMBO:
						SetSelectedJoystick(PLAYER_2, Index);
						PopulateConfigureControls(hwnd);
						EnableWindow(GetDlgItem(hwnd, IDC_P1_DISABLE_KEYS_CHECK), GetSelectedJoystick(PLAYER_1)? TRUE : FALSE);
						EnableWindow(GetDlgItem(hwnd, IDC_P2_DISABLE_KEYS_CHECK), GetSelectedJoystick(PLAYER_2)? TRUE : FALSE);
						break;

					case IDC_P1_RAPIDFIRE_COMBO:
						RegistryInfo.RapidFireRate[PLAYER_1] = Index + 2;
						break;

					case IDC_P2_RAPIDFIRE_COMBO:
						RegistryInfo.RapidFireRate[PLAYER_2] = Index + 2;
						break;
					}
				}
				break;
			}
		}
		break;

	case WM_CLOSE:
		EndDialog(hwnd, 0);
		break;

    default:
		return FALSE;
	}

	return TRUE;
}

void PopulateConfigureControls(HWND hwnd)
{
	int		Joystick1 = GetSelectedJoystick(PLAYER_1);
	int		Joystick2 = GetSelectedJoystick(PLAYER_2);
	char	Text[32];

	if (Joystick1)
	{
		EnableWindow(GetDlgItem(hwnd, IDC_P1_LEFT_BUTTON), FALSE);
		EnableWindow(GetDlgItem(hwnd, IDC_P1_RIGHT_BUTTON), FALSE);
		EnableWindow(GetDlgItem(hwnd, IDC_P1_UP_BUTTON), FALSE);
		EnableWindow(GetDlgItem(hwnd, IDC_P1_DOWN_BUTTON), FALSE);

		SetDlgItemText(hwnd, IDC_P1_LEFT, 	 "Left");
		SetDlgItemText(hwnd, IDC_P1_RIGHT,	 "Right");
		SetDlgItemText(hwnd, IDC_P1_UP,		 "Up");
		SetDlgItemText(hwnd, IDC_P1_DOWN,	 "Down");

		wsprintf(Text, "Button %d", RegistryInfo.JoystickMap[PLAYER_1][PAD_BUTTON1 - PAD_BUTTON1]);
		SetDlgItemText(hwnd, IDC_P1_BUTTON1, Text);
		wsprintf(Text, "Button %d", RegistryInfo.JoystickMap[PLAYER_1][PAD_BUTTON2 - PAD_BUTTON1]);
		SetDlgItemText(hwnd, IDC_P1_BUTTON2, Text);
		wsprintf(Text, "Button %d", RegistryInfo.JoystickMap[PLAYER_1][PAD_START - PAD_BUTTON1]);
		SetDlgItemText(hwnd, IDC_P1_START, Text);
	}
	else
	{
		EnableWindow(GetDlgItem(hwnd, IDC_P1_LEFT_BUTTON), TRUE);
		EnableWindow(GetDlgItem(hwnd, IDC_P1_RIGHT_BUTTON), TRUE);
		EnableWindow(GetDlgItem(hwnd, IDC_P1_UP_BUTTON), TRUE);
		EnableWindow(GetDlgItem(hwnd, IDC_P1_DOWN_BUTTON), TRUE);

		SetDlgItemText(hwnd, IDC_P1_LEFT,	 ButtonToString(PLAYER_1, PAD_LEFT));
		SetDlgItemText(hwnd, IDC_P1_RIGHT,	 ButtonToString(PLAYER_1, PAD_RIGHT));
		SetDlgItemText(hwnd, IDC_P1_UP,		 ButtonToString(PLAYER_1, PAD_UP));
		SetDlgItemText(hwnd, IDC_P1_DOWN,	 ButtonToString(PLAYER_1, PAD_DOWN));
		SetDlgItemText(hwnd, IDC_P1_BUTTON1, ButtonToString(PLAYER_1, PAD_BUTTON1));
		SetDlgItemText(hwnd, IDC_P1_BUTTON2, ButtonToString(PLAYER_1, PAD_BUTTON2));
		SetDlgItemText(hwnd, IDC_P1_START,	 ButtonToString(PLAYER_1, PAD_START));
	}
	
	if (Joystick2)
	{
		EnableWindow(GetDlgItem(hwnd, IDC_P2_LEFT_BUTTON), FALSE);
		EnableWindow(GetDlgItem(hwnd, IDC_P2_RIGHT_BUTTON), FALSE);
		EnableWindow(GetDlgItem(hwnd, IDC_P2_UP_BUTTON), FALSE);
		EnableWindow(GetDlgItem(hwnd, IDC_P2_DOWN_BUTTON), FALSE);

		SetDlgItemText(hwnd, IDC_P2_LEFT, 	 "Left");
		SetDlgItemText(hwnd, IDC_P2_RIGHT,	 "Right");
		SetDlgItemText(hwnd, IDC_P2_UP,		 "Up");
		SetDlgItemText(hwnd, IDC_P2_DOWN,	 "Down");

		wsprintf(Text, "Button %d", RegistryInfo.JoystickMap[PLAYER_2][PAD_BUTTON1 - PAD_BUTTON1]);
		SetDlgItemText(hwnd, IDC_P2_BUTTON1, Text);
		wsprintf(Text, "Button %d", RegistryInfo.JoystickMap[PLAYER_2][PAD_BUTTON2 - PAD_BUTTON1]);
		SetDlgItemText(hwnd, IDC_P2_BUTTON2, Text);
		wsprintf(Text, "Button %d", RegistryInfo.JoystickMap[PLAYER_2][PAD_START - PAD_BUTTON1]);
		SetDlgItemText(hwnd, IDC_P2_START, Text);
	}
	else
	{
		EnableWindow(GetDlgItem(hwnd, IDC_P2_LEFT_BUTTON), TRUE);
		EnableWindow(GetDlgItem(hwnd, IDC_P2_RIGHT_BUTTON), TRUE);
		EnableWindow(GetDlgItem(hwnd, IDC_P2_UP_BUTTON), TRUE);
		EnableWindow(GetDlgItem(hwnd, IDC_P2_DOWN_BUTTON), TRUE);

		SetDlgItemText(hwnd, IDC_P2_LEFT,	 ButtonToString(PLAYER_2, PAD_LEFT));
		SetDlgItemText(hwnd, IDC_P2_RIGHT,	 ButtonToString(PLAYER_2, PAD_RIGHT));
		SetDlgItemText(hwnd, IDC_P2_UP,		 ButtonToString(PLAYER_2, PAD_UP));
		SetDlgItemText(hwnd, IDC_P2_DOWN,	 ButtonToString(PLAYER_2, PAD_DOWN));
		SetDlgItemText(hwnd, IDC_P2_BUTTON1, ButtonToString(PLAYER_2, PAD_BUTTON1));
		SetDlgItemText(hwnd, IDC_P2_BUTTON2, ButtonToString(PLAYER_2, PAD_BUTTON2));
		SetDlgItemText(hwnd, IDC_P2_START,	 ButtonToString(PLAYER_2, PAD_START));
	}
}

void PopulateJoystickCombo(HWND hwnd, int Player)
{
	int		i;

	if (Player == PLAYER_1)
	{
		hwnd = GetDlgItem(hwnd, IDC_P1_JOYSTICK_COMBO);
	}
	else
	{
		hwnd = GetDlgItem(hwnd, IDC_P2_JOYSTICK_COMBO);
	}

	SendMessage(hwnd, CB_RESETCONTENT, 0, 0);
	SendMessage(hwnd, CB_ADDSTRING, 0, (long)"None");

	for (i = 0 ; i < MAX_JOYSTICKS ; i++)
	{
		char	Name[MAX_PATH];

		if (GetJoystickName(i, Name))
		{
			SendMessage(hwnd, CB_ADDSTRING, 0, (long)Name);
		}
	}

	SendMessage(hwnd, CB_SETCURSEL, GetSelectedJoystick(Player), 0);
}

int ConfigureButton(HWND hwnd, int Player, int Button, int DialogItem, char *pString)
{
	int			AssignedKey;

	AssignedKey = DialogBoxParam(hInstance, MAKEINTRESOURCE(IDD_CONTROLS_KEY), hwnd, ConfigureControlsKeyProc, (long)pString);
	SetControlKey(Player, Button, AssignedKey);
	
	if (AssignedKey >= 256)
	{
		char		Text[32];

		wsprintf(Text, "Button %d", AssignedKey - 256);
		SetDlgItemText(hwnd, DialogItem, Text);
	}
	else
	{
		SetDlgItemText(hwnd, DialogItem, ButtonToString(Player, Button));
	}

	return AssignedKey;
}

LRESULT CALLBACK ConfigureControlsKeyProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	static	UINT_PTR	Timer = 0;

	switch (msg)
	{
	case WM_INITDIALOG:
		{
			char		String[MAX_PATH];
	
			CenterWindowInParent(hwnd);

			if (JoystickPresent())
			{
				wsprintf(String, "Press the new key or button for %s.", (char *)lParam);
			}
			else
			{
				wsprintf(String, "Press the new key for %s.", (char *)lParam);
			}
			SetDlgItemText(hwnd, IDC_TEXT, String);

			TidyInput();
			InitInput(hwnd, hInstance);
			Timer = SetTimer(hwnd, 0, 20, NULL);

			ShowWindow(hwnd, SW_SHOW);
		}
		break;

	case WM_TIMER:
		{
			int		Key = GetKeyPressed(TRUE);

			if (Key == -1 && JoystickPresent())
			{
				UpdateJoysticks();
				Key = GetJoystickButtonPressed();
			}

			if (Key != -1)
			{
				KillTimer(hwnd, Timer);
				EndDialog(hwnd, Key);
			}
		}
		break;

    default:
		return FALSE;
	}

	return TRUE;
}

void SetScreenScale(unsigned int Scale)
{
	if (UseDirectDraw && RegistryInfo.EnableDirectDraw)
	{
		if (!FullScreenMode() && !Scale)
		{
			UseDirectDraw = ChangeMode(RegistryInfo.FullScreenMode, RegistryInfo.FullScreen = TRUE);
		}
		else
		{
			if (Scale)
			{
				UseDirectDraw = ChangeMode(RegistryInfo.FullScreenMode, RegistryInfo.FullScreen = FALSE);
			}
		}
	}

	CheckMenuItem(hMenu, ID_MENU_CONFIG_SCREEN_FULL, (Scale == 0)? MF_CHECKED : MF_UNCHECKED);
	CheckMenuItem(hMenu, ID_MENU_CONFIG_SCREEN_X1,   (Scale == 1)? MF_CHECKED : MF_UNCHECKED);
	CheckMenuItem(hMenu, ID_MENU_CONFIG_SCREEN_X2,   (Scale == 2)? MF_CHECKED : MF_UNCHECKED);
	CheckMenuItem(hMenu, ID_MENU_CONFIG_SCREEN_X3,   (Scale == 3)? MF_CHECKED : MF_UNCHECKED);
	AdjustWindowSize();
}

void SetFrameTime(int Frequency)
{
	if (Frequency == FREQ_50HZ)
	{
		memcpy(FrameTime, FrameTime50hz, sizeof(FrameTime));
	}
	else
	{
		memcpy(FrameTime, FrameTime60hz, sizeof(FrameTime));
	}
}

void SetScreenSmoothing(BOOL UseSmoothing)
{
	CheckMenuItem(hMenu, ID_MENU_CONFIG_SCREEN_SMOOTHING, (UseSmoothing)? MF_CHECKED : MF_UNCHECKED);
	if (UseDirectDraw && RegistryInfo.EnableDirectDraw) SetModeSmoothing(UseSmoothing);
}

void SetUpdateFrequency(unsigned int Frequency)
{
	CheckMenuItem(hMenu, ID_MENU_CONFIG_UPDATE_50HZ, (Frequency == FREQ_50HZ)? MF_CHECKED : MF_UNCHECKED);
	CheckMenuItem(hMenu, ID_MENU_CONFIG_UPDATE_60HZ, (Frequency == FREQ_60HZ)? MF_CHECKED : MF_UNCHECKED);
	TidyAudio();
	audio_init(RegistryInfo.SoundFrequency, Frequency);
	InitAudio(hwnd, RegistryInfo.SoundFrequency, Frequency);
	SetFrameTime(Frequency);
}

void SetFrameSkip(unsigned int Skip)
{
	CheckMenuItem(hMenu, ID_MENU_CONFIG_SKIP_AUTO, (Skip == 0)? MF_CHECKED : MF_UNCHECKED);
	CheckMenuItem(hMenu, ID_MENU_CONFIG_SKIP_1, (Skip == 1)? MF_CHECKED : MF_UNCHECKED);
	CheckMenuItem(hMenu, ID_MENU_CONFIG_SKIP_2, (Skip == 2)? MF_CHECKED : MF_UNCHECKED);
	CheckMenuItem(hMenu, ID_MENU_CONFIG_SKIP_3, (Skip == 3)? MF_CHECKED : MF_UNCHECKED);
	CheckMenuItem(hMenu, ID_MENU_CONFIG_SKIP_4, (Skip == 4)? MF_CHECKED : MF_UNCHECKED);
}

void SetSoundFrequency(unsigned int Frequency)
{
	CheckMenuItem(hMenu, ID_MENU_CONFIG_SOUND_44100, (Frequency == 44100)? MF_CHECKED : MF_UNCHECKED);
	CheckMenuItem(hMenu, ID_MENU_CONFIG_SOUND_22050, (Frequency == 22200)? MF_CHECKED : MF_UNCHECKED);
	CheckMenuItem(hMenu, ID_MENU_CONFIG_SOUND_11025, (Frequency == 11100)? MF_CHECKED : MF_UNCHECKED);
	TidyAudio();
	audio_init(Frequency, RegistryInfo.UpdateFrequency);
	InitAudio(hwnd, Frequency, RegistryInfo.UpdateFrequency);
}

void SetRegion(int Region)
{
	CheckMenuItem(hMenu, ID_MENU_CONFIG_REGION_JAPAN, (Region == TYPE_DOMESTIC)? MF_CHECKED : MF_UNCHECKED);
	CheckMenuItem(hMenu, ID_MENU_CONFIG_REGION_EUROPEUS, (Region == TYPE_OVERSEAS)? MF_CHECKED : MF_UNCHECKED);
}

LRESULT CALLBACK SettingsProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	static int			SelectedFolder = 0;
	static char			*pFolderString = NULL;
	static char			GammaText[8];
	static char			FMVolumeText[8];
	static int			NewMode;
	static BOOL			NewDirectDrawEnable;

	switch (msg)
	{
	case WM_INITDIALOG:
		{
			HWND		hCombo = GetDlgItem(hwnd, IDC_FOLDERS_COMBO);

			CenterWindowInParent(hwnd);

			SelectedFolder = 0;
			pFolderString  = RegistryInfo.ROMPath;

			SendMessage(hCombo, CB_RESETCONTENT, 0, 0);
			SendMessage(hCombo, CB_ADDSTRING, 0, (long)"ROM Folder");
			SendMessage(hCombo, CB_ADDSTRING, 0, (long)"SRAM Folder");
			SendMessage(hCombo, CB_ADDSTRING, 0, (long)"Screenshot Folder");
			SendMessage(hCombo, CB_ADDSTRING, 0, (long)"Save State Folder");
			SendMessage(hCombo, CB_ADDSTRING, 0, (long)"Sound Record Folder");
			SendMessage(hCombo, CB_SETCURSEL, SelectedFolder, 0);
			
			SetDlgItemText(hwnd, IDC_FOLDERS_TEXT, RegistryInfo.ROMPath);

			CheckDlgButton(hwnd, IDC_SAVESTATE_CHECK, RegistryInfo.SingleSaveState? BST_CHECKED : BST_UNCHECKED);

			SendMessage(GetDlgItem(hwnd, IDC_GAMMA_SLIDER), TBM_SETTICFREQ, 5, 0);
			SendMessage(GetDlgItem(hwnd, IDC_GAMMA_SLIDER), TBM_SETRANGE, TRUE, MAKELPARAM(5, 100));
			SendMessage(GetDlgItem(hwnd, IDC_GAMMA_SLIDER), TBM_SETPOS, TRUE, (int)(RegistryInfo.Gamma * 20.0f));
			wsprintf(GammaText, "%d.%02d", (int)(RegistryInfo.Gamma * 20.0f) / 20, ((int)(RegistryInfo.Gamma * 20.0f) % 20) * 5);
			SetDlgItemText(hwnd, IDC_GAMMA_TEXT, GammaText);

			PopulateModesCombo(GetDlgItem(hwnd, IDC_DIRECT_DRAW_MODE_COMBO));
			NewMode = RegistryInfo.FullScreenMode;

			CheckDlgButton(hwnd, IDC_DIRECT_DRAW_ENABLE_CHECK, RegistryInfo.EnableDirectDraw? BST_CHECKED : BST_UNCHECKED);
			CheckDlgButton(hwnd, IDC_DIRECT_DRAW_ENABLE_SCANLINES_CHECK, RegistryInfo.EnableScanLines? BST_CHECKED : BST_UNCHECKED);
			EnableWindow(GetDlgItem(hwnd, IDC_DIRECT_DRAW_ENABLE_CHECK), DirectDrawAvail);
			EnableWindow(GetDlgItem(hwnd, IDC_DIRECT_DRAW_ENABLE_SCANLINES_CHECK), DirectDrawAvail && RegistryInfo.EnableDirectDraw);
			EnableWindow(GetDlgItem(hwnd, IDC_DIRECT_DRAW_MODE_COMBO), DirectDrawAvail);
			NewDirectDrawEnable = RegistryInfo.EnableDirectDraw;

			CheckDlgButton(hwnd, IDC_FM_ENABLE_CHECK, RegistryInfo.EnableFMSound? BST_CHECKED : BST_UNCHECKED);
			SendMessage(GetDlgItem(hwnd, IDC_FM_VOLUME_SLIDER), TBM_SETTICFREQ, 5, 0);
			SendMessage(GetDlgItem(hwnd, IDC_FM_VOLUME_SLIDER), TBM_SETRANGE, TRUE, MAKELPARAM(0, 100));
			SendMessage(GetDlgItem(hwnd, IDC_FM_VOLUME_SLIDER), TBM_SETPOS, TRUE, (int)(RegistryInfo.FMVolume * 100.0f));
			sprintf(FMVolumeText, "%.2f", RegistryInfo.FMVolume);
			SetDlgItemText(hwnd, IDC_FM_VOLUME_TEXT, FMVolumeText);

			ShowWindow(hwnd, SW_SHOW);
		}
		break;

	case WM_COMMAND:
		{
			switch (HIWORD(wParam))
			{
			case BN_CLICKED:
				switch (LOWORD(wParam))
				{
				case IDC_FOLDERS_BROWSE_BUTTON:
					if (BrowseForDirectory(hwnd, pFolderString, "Select folder"))
					{
						SetDlgItemText(hwnd, IDC_FOLDERS_TEXT, pFolderString);
					}
					break;
				
				case IDC_REGISTER_BUTTON:
					SetFileAssociations();
					MessageBox(hwnd, "File associations set.", "", MB_OK);
					break;

				case IDC_OK_BUTTON:
					SendMessage(hwnd, WM_CLOSE, 0, 0);
					break;

				case IDC_SAVESTATE_CHECK:
					RegistryInfo.SingleSaveState ^= 1;
					break;

				case IDC_DIRECT_DRAW_ENABLE_CHECK:
					NewDirectDrawEnable ^= 1;
					EnableWindow(GetDlgItem(hwnd, IDC_DIRECT_DRAW_ENABLE_SCANLINES_CHECK), DirectDrawAvail && NewDirectDrawEnable);
					break;

				case IDC_DIRECT_DRAW_ENABLE_SCANLINES_CHECK:
					RegistryInfo.EnableScanLines ^= 1;
					break;

				case IDC_FM_ENABLE_CHECK:
					RegistryInfo.EnableFMSound ^= 1;
					sms.use_fm ^= 1;
					break;
				}
				break;
	
			case CBN_SELCHANGE:
				{
					int Index = SendMessage(GetDlgItem(hwnd, LOWORD(wParam)), CB_GETCURSEL, 0, 0);

					switch (LOWORD(wParam))
					{
					case IDC_FOLDERS_COMBO:
						SelectedFolder = Index;

						switch (SelectedFolder)
						{
						case 0:
							pFolderString = RegistryInfo.ROMPath;
							break;

						case 1:
							pFolderString = RegistryInfo.SRAMPath;
							break;

						case 2:
							pFolderString = RegistryInfo.ScreenshotPath;
							break;

						case 3:
							pFolderString = RegistryInfo.SaveStatePath;
							break;

						case 4:
							pFolderString = RegistryInfo.SoundRecordPath;
							break;
						}

						if (pFolderString[strlen(pFolderString) - 1] != '\\')
						{
							strcat(pFolderString, "\\");
						}

						SetDlgItemText(hwnd, IDC_FOLDERS_TEXT, pFolderString);
						
						break;

					case IDC_DIRECT_DRAW_MODE_COMBO:
						NewMode = Index;
						break;
					}
				}
				break;
			}
		}
		break;

	case WM_HSCROLL:
		{
			if ((HWND)lParam == GetDlgItem(hwnd, IDC_GAMMA_SLIDER))
			{
				RegistryInfo.Gamma = (float)SendMessage(GetDlgItem(hwnd, IDC_GAMMA_SLIDER), TBM_GETPOS, 0, 0) / 20.0f;
				wsprintf(GammaText, "%d.%02d", (int)(RegistryInfo.Gamma * 20.0f) / 20, ((int)(RegistryInfo.Gamma * 20.0f) % 20) * 5);
				SetDlgItemText(hwnd, IDC_GAMMA_TEXT, GammaText);
				bitmap.pal.update = 1;
				UpdatePalette();
				for(vdp.line = 0; vdp.line < LINES_PER_FRAME; vdp.line += 1)
				{
					render_line(vdp.line);
				}
				SendMessage(GetParent(hwnd), WM_PAINT, 0, 0);
			}
			else if ((HWND)lParam == GetDlgItem(hwnd, IDC_FM_VOLUME_SLIDER))
			{
				RegistryInfo.FMVolume = (float)SendMessage(GetDlgItem(hwnd, IDC_FM_VOLUME_SLIDER), TBM_GETPOS, 0, 0) / 100.0f;
				sprintf(FMVolumeText, "%.2f", RegistryInfo.FMVolume);
				SetDlgItemText(hwnd, IDC_FM_VOLUME_TEXT, FMVolumeText);
			}
		}
		break;

	case WM_CLOSE:
		EndDialog(hwnd, 0);

		if ((NewMode != RegistryInfo.FullScreenMode) && FullScreenMode())
		{
			UseDirectDraw = ChangeMode(NewMode, TRUE);
			AdjustWindowSize();
		}

		RegistryInfo.FullScreenMode = NewMode;

		if (NewDirectDrawEnable != RegistryInfo.EnableDirectDraw)
		{
			if (NewDirectDrawEnable)
			{
				UseDirectDraw = ChangeMode(RegistryInfo.FullScreenMode, RegistryInfo.FullScreen);				
			}
			else
			{
				if (FullScreenMode())
				{
					SetScreenScale(RegistryInfo.ScreenScale = 1);
				}

				SwitchInternalRenderingFormat(8);
				UseDirectDraw = FALSE;
			}

		    bitmap.pal.update = 1;
			memset(bitmap.pal.dirty, 1, PALETTE_SIZE);

			AdjustWindowSize();
			EnableMenuItem(hMenu, ID_MENU_CONFIG_SCREEN_SMOOTHING, UseDirectDraw? MF_BYCOMMAND | MF_ENABLED : MF_BYCOMMAND | MF_GRAYED);
			EnableMenuItem(hMenu, ID_MENU_CONFIG_SCREEN_FULL, UseDirectDraw? MF_BYCOMMAND | MF_ENABLED : MF_BYCOMMAND | MF_GRAYED);
		}

		RegistryInfo.EnableDirectDraw = NewDirectDrawEnable;
		break;

    default:
		return FALSE;
	}

	return TRUE;
}

LRESULT CALLBACK AboutProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch (msg)
	{
	case WM_INITDIALOG:
		{
			CenterWindowInParent(hwnd);
			ShowWindow(hwnd, SW_SHOW);
		}
		break;

	case WM_CLOSE:
		EndDialog(hwnd, 0);
		break;

    default:
		return FALSE;
	}

	return TRUE;
}

BOOL CreateSingleInstance(char *pCommandLine)
{
	SECURITY_ATTRIBUTES			Security;

	USER_MESSAGE = RegisterWindowMessage(SMS_INSTANCE_LOAD_NAME);

	Security.nLength			  = sizeof(SECURITY_ATTRIBUTES);
	Security.lpSecurityDescriptor = NULL;
	Security.bInheritHandle		  = FALSE;

	Mutex = CreateMutex(&Security, TRUE, SMS_MUTEX_NAME);

	if (Mutex)
	{
		int			State = WaitForSingleObject(Mutex, 0);

		if (State != WAIT_TIMEOUT) return TRUE;
	}

	SendMessage(FindWindow(SMS_CLASS_NAME, NULL), USER_MESSAGE, 0, (long)pCommandLine);

	DestroySingleInstance();

	return FALSE;
}

void DestroySingleInstance(void)
{
	if (Mutex)
	{
		CloseHandle(Mutex);
		Mutex = NULL;
	}
}

void LoadState(void)
{
	char			Filename[MAX_PATH];
	int				Found;
	int				AppendPos;

	wsprintf(Filename, "%s%s", RegistryInfo.SaveStatePath, GetGameName());

	Found = CountSaveStateFiles(Filename, &AppendPos);

	switch (Found)
	{
	case 0:
		return;

	case 1:
		wsprintf(&Filename[AppendPos], "(%04d).sta", 0);
		break;

	default:
		{
			int		SaveState;

			SaveState = DialogBox(GetSMSInstance(), MAKEINTRESOURCE(IDD_SAVESTATE), GetSMShwnd(), SaveStateProc);

			if (SaveState == -1) return;

			wsprintf(&Filename[AppendPos], "(%04d).sta", SaveState);
		}
		break;
	}

	load_state(Filename);

	// Force audio to re-sync
	Frame		  = 0;
	LastTickCount = 0;
}

int	CountSaveStateFiles(char *pFilename, int *pAppendPos)
{
	int				i;
	int				Found = 0;
	HANDLE			FileHandle;

	*pAppendPos = strlen(pFilename);

	for (i = 0 ; i < MAX_SAVE_STATES ; i++)
	{
		// Add a numbered index and the extension .sta
		wsprintf(&pFilename[*pAppendPos], "(%04d).sta", i);

		// Attempt to open a new file
		FileHandle = CreateFile(pFilename, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, NULL);
	
		if (FileHandle != INVALID_HANDLE_VALUE)
		{
			Found++;

			// Close the file
			CloseHandle(FileHandle);
		}
	}

	if (RegistryInfo.SingleSaveState && Found)
	{
		Found = 1;
	}

	return Found;
}

void SaveState(void)
{
	char	Filename[MAX_PATH];
	int		AppendPos;
	int		i;
	HANDLE	FileHandle;

	wsprintf(Filename, "%s%s", RegistryInfo.SaveStatePath, GetGameName());

	AppendPos = strlen(Filename);

	for (i = 0 ; i < MAX_SAVE_STATES ; i++)
	{
		// Add a numbered index and the extension .sta
		wsprintf(&Filename[AppendPos], "(%04d).sta", i);

		if (RegistryInfo.SingleSaveState)
		{
		    FileHandle = CreateFile(Filename, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_FLAG_SEQUENTIAL_SCAN, NULL);
		}
		else
		{
			// Attempt to create a new file
		    FileHandle = CreateFile(Filename, GENERIC_WRITE, 0, NULL, CREATE_NEW, FILE_FLAG_SEQUENTIAL_SCAN, NULL);
		}

		// If we're successful, stop looking for a new name
		if (FileHandle != INVALID_HANDLE_VALUE) break;
	}

	save_state(Filename, FileHandle);
}

HWND GetSMShwnd(void)
{
	return hwnd;
}

HINSTANCE GetSMSInstance(void)
{
	return hInstance;
}


LRESULT CALLBACK SaveStateProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	static int		SelectedSaveState;

	switch (msg)
	{
	case WM_INITDIALOG:
		{
			char		Filename[MAX_PATH];
			HANDLE		FileHandle;
			int			i;
			int			InsertPos;
			int			AppendPos;

			CenterWindowInParent(hwnd);

			SendMessage(GetDlgItem(hwnd, IDC_SAVESTATE_COMBO), CB_RESETCONTENT, 0, 0);

			wsprintf(Filename, "%s%s", RegistryInfo.SaveStatePath, GetGameName());

			AppendPos = strlen(Filename);

			for (i = 0 ; i < MAX_SAVE_STATES ; i++)
			{
				// Add a numbered index and the extension .sta
				wsprintf(&Filename[AppendPos], "(%04d).sta", i);

				// Attempt to open a new file
				FileHandle = CreateFile(Filename, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, NULL);

				// If we're successful, stop looking for a new name
				if (FileHandle != INVALID_HANDLE_VALUE)
				{
					InsertPos = SendMessage(GetDlgItem(hwnd, IDC_SAVESTATE_COMBO), CB_ADDSTRING, 0, (long)&Filename[strlen(RegistryInfo.SaveStatePath)]);
					SendMessage(GetDlgItem(hwnd, IDC_SAVESTATE_COMBO), CB_SETITEMDATA, InsertPos, i);

					// Close the file
					CloseHandle(FileHandle);
				}
			}

			SelectedSaveState = InsertPos;

			SendMessage(GetDlgItem(hwnd, IDC_SAVESTATE_COMBO), CB_SETCURSEL, SelectedSaveState, 0);

			ShowWindow(hwnd, SW_SHOW);
		}
		break;

	case WM_COMMAND:
		{
			switch (HIWORD(wParam))
			{
			case BN_CLICKED:
				switch (LOWORD(wParam))
				{
				case IDC_OK:
					EndDialog(hwnd, SelectedSaveState);
					break;

				case IDC_CANCEL:
					EndDialog(hwnd, -1);
					break;
				}
				break;
	
			case CBN_SELCHANGE:
				{
					SelectedSaveState = SendMessage(GetDlgItem(hwnd, LOWORD(wParam)), CB_GETCURSEL, 0, 0);
				}
				break;
			}
		}
		break;

	case WM_CLOSE:
		EndDialog(hwnd, -1);
		break;

    default:
		return FALSE;
	}

	return TRUE;
}

void CenterWindowInParent(HWND hwnd)
{
	RECT		ParentRect;
	RECT		OurRect;
	HWND		hParent = GetParent(hwnd);
	POINT		Pos;

	if (!hParent) hParent = GetDesktopWindow();

	GetWindowRect(hParent, &ParentRect);
	GetWindowRect(hwnd, &OurRect);
	Pos.x = (((ParentRect.right - ParentRect.left) - (OurRect.right - OurRect.left)) / 2) + ParentRect.left;
	Pos.y = (((ParentRect.bottom - ParentRect.top) - (OurRect.bottom - OurRect.top)) / 2) + ParentRect.top;

	if (Pos.x < 0) Pos.x = 0;
	if (Pos.y < 0) Pos.y = 0;
	
	SetWindowPos(hwnd, HWND_TOP, Pos.x, Pos.y, 0, 0, SWP_NOSIZE);
}

void GetConsoleScreenRect(RECT *pRect)
{
	if (cart.type == TYPE_GG)
	{
		pRect->left		= 48;
		pRect->top		= 24;
		pRect->right	= 208;
		pRect->bottom	= 168;
	}
	else
	{
		pRect->left		= 0;
		pRect->top		= 0;
		pRect->right	= 256;
		pRect->bottom	= 192;
	}
}

BOOL GetRecordSoundStatus(void)
{
	return RecordingSound;
}

RGBQUAD *GetSMSPalette(void)
{
	return Bmp.Palette;
}

void SwitchInternalRenderingFormat(int BitDepth)
{
	HDC		hDC;

	bitmap.depth					= BitDepth;
    bitmap.pitch					= (bitmap.width * (bitmap.depth >> 3));
	Bmp.BitmapInfoHeader.biBitCount	= BitDepth;

	hDC = GetDC(hwnd);
	DeleteObject(hBitmap);
	hBitmap = CreateDIBitmap(hDC, &Bmp.BitmapInfoHeader, 0, &BitmapData[0], (BITMAPINFO *)&Bmp, DIB_PAL_COLORS);
	ReleaseDC(hwnd, hDC);
}

BOOL DirectDrawAvailable(void)
{
	return UseDirectDraw;
}
