#include "stdafx.h"
/*
-----------------------------------------------------------------------------
 Class: ScreenNetworkGame

 Desc: Area for testing.

 Copyright (c) 2001-2002 by the person(s) listed below.  All rights reserved.
	Brendan Walker
	Chris Danford
-----------------------------------------------------------------------------
*/


#include "ScreenNetworkGame.h"
#include "ScreenManager.h"
#include "RageMusic.h"
#include "GameConstantsAndTypes.h"
#include "PrefsManager.h"
#include "Quad.h"
#include "RageNetwork.h"


const int USERS_X = 30;
const int USERS_WIDTH = 100;
const int USERS_START_Y = 100;
const int USERS_SPACING_Y = 24;

const int SESSIONS_X = 180;
const int SESSIONS_WIDTH = 160;
const int SESSIONS_START_Y = 100;
const int SESSIONS_SPACING_Y = 24;

const int SESSION_DETAILS_X = 400;
const int SESSION_DETAILS_Y = 140;

const int CHAT_X = 180;
const int CHAT_WIDTH = 400;
const int CHAT_START_Y = 290;
const int CHAT_SPACING_Y = 18;


ScreenNetworkGame::ScreenNetworkGame()
{	
	int i;

	for( i=0; i<MAX_USER_LINES; i++ )
	{
		m_textUsers[i].LoadFromFont( THEME->GetPathTo("Fonts","normal") );
		m_textUsers[i].SetHorizAlign(Actor::align_left);
		m_textUsers[i].SetXY( USERS_X, USERS_START_Y+USERS_SPACING_Y*i );
		m_textUsers[i].SetText( ssprintf("Users line %d", i) );
		m_textUsers[i].SetZoom( 0.5f );
		this->AddChild( &m_textUsers[i] );
	}
	
	for( i=0; i<MAX_SESSION_LINES; i++ )
	{
		m_textSessions[i].LoadFromFont( THEME->GetPathTo("Fonts","normal") );
		m_textSessions[i].SetHorizAlign(Actor::align_left);
		m_textSessions[i].SetXY( SESSIONS_X, SESSIONS_START_Y+SESSIONS_SPACING_Y*i );
		m_textSessions[i].SetText( ssprintf("Sessions line %d", i) );
		m_textSessions[i].SetZoom( 0.5f );
		this->AddChild( &m_textSessions[i] );
	}
	
	m_textSessionDetails.SetXY( SESSIONS_X, SESSIONS_START_Y+SESSIONS_SPACING_Y*i );
	m_textSessionDetails.SetHorizAlign(Actor::align_left);
	m_textSessionDetails.LoadFromFont( THEME->GetPathTo("Fonts","normal") );
	m_textSessionDetails.SetXY( SESSION_DETAILS_X, SESSION_DETAILS_Y );
	m_textSessionDetails.SetZoom( 0.5f );
	m_textSessionDetails.SetText( ssprintf("Sessions details\njklsdf\nkjsdfsd\nkjsdfsd\njksdfsd\nsdfs") );
	this->AddChild( &m_textSessionDetails );

	for( i=0; i<MAX_CHAT_LINES; i++ )
	{
		m_textChat[i].LoadFromFont( THEME->GetPathTo("Fonts","normal") );
		m_textChat[i].SetHorizAlign(Actor::align_left);
		m_textChat[i].SetXY( CHAT_X, CHAT_START_Y+CHAT_SPACING_Y*i );
		m_textChat[i].SetText( ssprintf("Chat line %d", i) );
		m_textChat[i].SetZoom( 0.5f );
		this->AddChild( &m_textChat[i] );
	}

	this->AddChild( &m_Menu );
	m_Menu.Load( 
		THEME->GetPathTo("BGAnimations","edit menu"), 
		THEME->GetPathTo("Graphics","edit menu top edge"),
		"help text TBA", false, false, 99 
		);
	m_Menu.TweenOnScreenFromBlack( SM_None );

}


void ScreenNetworkGame::Update( float fDeltaTime )
{
	Screen::Update( fDeltaTime );
}

void ScreenNetworkGame::DrawPrimitives()
{
	m_Menu.DrawBottomLayer();
	Screen::DrawPrimitives();
	m_Menu.DrawTopLayer();
}
/*
void Connect( CString sAnswer )
{
	NETWORK->Connect( sAnswer, 1096 );
}

void SendMessage( CString sAnswer )
{
	Packet packet;
	packet.type = Packet::chat;
	packet.SetData( sAnswer.GetBuffer(999), sAnswer.GetLength()+1 );
	NETWORK->Send( &packet );
}
*/
void ScreenNetworkGame::Input( const DeviceInput& DeviceI, const InputEventType type, const GameInput &GameI, const MenuInput &MenuI, const StyleInput &StyleI )
{
	
	if( MenuI.IsValid()  &&  MenuI.button == MENU_BUTTON_BACK )
	{
//		NETWORK->Disconnect();
		SCREENMAN->SetNewScreen( "ScreenTitleMenu" );
		return;
	}

	if( MenuI.IsValid()  &&  MenuI.button == MENU_BUTTON_START )
	{
		SCREENMAN->SetNewScreen( "ScreenTitleMenu" );
		return;
	}

	/*
	if( type != IET_FIRST_PRESS )
		return;	// ignore

	switch( DeviceI.device)
	{
	case DEVICE_KEYBOARD:
		switch( DeviceI.button )
		{
		case DIK_LEFT:
			NETWORK->Init( true );
			m_text.SetText( "You are the server." );
			NETWORK->Listen( 1096 );
			break;
		case DIK_RIGHT:
			NETWORK->Init( false );
			m_text.SetText( "You are the client." );
			SCREENMAN->TextEntry( SM_None, "Type the IP to connect to", "", Connect, NULL );
			break;
		case DIK_T:
			SCREENMAN->TextEntry( SM_None, "Type a message", "", SendMessage, NULL );
			break;
		}
	}
	*/
//	m_sprBG.SetEffectCamelion( 5, D3DXCOLOR(1,0.8f,0.8f,1), D3DXCOLOR(1,0.2f,0.2f,1) );
}

void ScreenNetworkGame::HandleScreenMessage( const ScreenMessage SM )
{
	switch( SM )
	{
	case SM_DoneClosingWipingLeft:
		break;
	case SM_DoneClosingWipingRight:
		break;
	case SM_DoneOpeningWipingLeft:
		break;
	case SM_DoneOpeningWipingRight:
		break;
	}
}