/*
-----------------------------------------------------------------------------
 File: RandomStream.h

 Desc: Holds multiple sounds samples and can play a random sound easily.

 Copyright (c) 2001-2002 by the person(s) listed below.  All rights reserved.
-----------------------------------------------------------------------------
*/

#ifndef _RandomStream_H_
#define _RandomStream_H_


#include "RageSound.h"
#include "RageSoundStream.h"
#include "RageUtil.h"

class RandomStream
{
public:
	RandomStream();
	~RandomStream();

	virtual bool Load( CString sFilePath )
	{
		CString sDir, sFName, sExt;
		splitrelpath( sFilePath, sDir, sFName, sExt );

		sExt.MakeLower();

		if( sExt == "" )	return LoadSoundDir( sFilePath );
		else				return LoadSound( sFilePath );
	};

	void PlayRandom();


private:
	bool LoadSoundDir( CString sDir );
	bool LoadSound( CString sSoundFilePath );


	CStringArray m_arrayFilePaths;
	int m_iIndexLastPlayed;
};




#endif