#include "stdafx.h"
/*
-----------------------------------------------------------------------------
 Class: RageSoundSample

 Desc: See header.

 Copyright (c) 2001-2002 by the person(s) listed below.  All rights reserved.
	Chris Danford
-----------------------------------------------------------------------------
*/



#include "RageSoundSample.h"
#include "RageUtil.h"
#include "RageLog.h"
#include "RageException.h"

#if 0
RageSoundSample::RageSoundSample() { }
RageSoundSample::~RageSoundSample() { }
void RageSoundSample::Unload() { }
bool RageSoundSample::Load( CString sSoundFilePath, int iMaxChannels ) { return true; }
void RageSoundSample::Play() { }
void RageSoundSample::Pause() { }
void RageSoundSample::Stop() { }
float RageSoundSample::GetLengthSeconds() { return 0; }
float RageSoundSample::GetPositionSeconds() { return 0; }
bool RageSoundSample::SetPlaybackRate( float fScale ) { return true; }
float RageSoundSample::GetPlaybackRate(){ return 0;}
bool RageSoundSample::IsPlaying() { return true; }
#else


RageSoundSample::RageSoundSample()
{
	//return ;
	m_hSample = NULL;

	m_hLastChannelPlayed = NULL;

	m_fLastKnownPosition = 0;


	m_numPlayers = 0 ;

	m_mp3players = NULL ;
	m_lastPlayed = NULL ;

	//m_mp3player.dsound = g_dsound ;
	//m_mp3player.dsound_init() ;


}

RageSoundSample::~RageSoundSample()
{
	//return ;
	Unload();
}

void RageSoundSample::Unload()
{
	//return ;

	Stop();

	if ( m_mp3players )
	{
		for ( int i = 0 ; i < m_numPlayers ; i++ )
		{
			if ( m_mp3players[i] )
			{
				Remove_Mp3Player( m_mp3players[i] ) ;
				delete m_mp3players[i] ;
			}
		}

		free(m_mp3players) ;
	}

	m_mp3players = NULL ;
	m_numPlayers = 0 ;
	m_lastPlayed = NULL ;

	/*
	if( m_hSample )
	{
		BASS_SampleFree( m_hSample );
	}
	*/
}
	
bool RageSoundSample::Load( CString sSoundFilePath, int iMaxChannels )
{
	sprintfx("load sound sample %s %u\r\n", sSoundFilePath, iMaxChannels ) ;

	//return true ;
	Mp3Player *mp3player ;

	LOG->Trace( "RageSoundSample::Load( %s )", sSoundFilePath );

	Unload();

	if ( iMaxChannels == 0 )
		return true ;

	m_filename = sSoundFilePath ;

	m_numPlayers = iMaxChannels ;

	m_mp3players = (Mp3Player**)malloc( sizeof(mp3player)*m_numPlayers ) ;

	for ( int i = 0 ; i < m_numPlayers ; i++ )
		m_mp3players[i] = NULL ;


	mp3player = new Mp3Player ;

	mp3player->dsound = g_dsound ;
	mp3player->dsound_init() ;

	//sprintfx("load file %s position %u\r\n", sSoundFilePath, 0 ) ;

	mp3player->loadFile( (char*)(LPCTSTR)sSoundFilePath, 0, 0, 999999999) ;
	mp3player->pause(TRUE) ;


	m_mp3players[0] = mp3player ;


	Insert_Mp3Player( mp3player ) ;

	/*
	m_hSample = BASS_SampleLoad( FALSE, const_cast<char*>((const char *)sSoundFilePath), 0, 0, iMaxChannels, 0 );

	if( m_hSample == NULL )
		throw RageException( "RageSoundSample::Load: error loading %s (error code %d)", 
											   sSoundFilePath, BASS_ErrorGetCode() );
*/
	return true;
}

void RageSoundSample::Play()
{
	//return ;

	int numfree ;
	int availableSlot ;

	numfree = 0 ;


	for( int i = 0 ; i < m_numPlayers ; i++ )
	{
		if ( m_mp3players[i] )
		{
			if ( WaitForSingleObject( hSoundMutex,INFINITE) == WAIT_OBJECT_0 )
			{
				m_mp3players[i]->stop() ;
				m_mp3players[i]->m_bDone = 0 ;
				m_mp3players[i]->pause(FALSE) ;
				m_lastPlayed = m_mp3players[i] ;

				ReleaseMutex( hSoundMutex ) ;
			}
			return ;
			if ( ( m_mp3players[i]->m_bDone ) || ( m_mp3players[i]->m_bPaused ) )
			{
				m_mp3players[i]->m_bDone = 0 ;
				m_mp3players[i]->pause(FALSE) ;
				m_lastPlayed = m_mp3players[i] ;
				return ;
			}
		}
		else
		{
			numfree++ ;
			availableSlot = i ;
		}
	}


	if ( numfree )
	{
		writexbox("WE SHOULD NEVER GET HERE\r\n" ) ;
		writexbox("WE SHOULD NEVER GET HERE\r\n" ) ;
		writexbox("WE SHOULD NEVER GET HERE\r\n" ) ;
		writexbox("WE SHOULD NEVER GET HERE\r\n" ) ;

		Mp3Player *mp3player ;

		numfree = 0 ;
		availableSlot = 5/numfree ;

		mp3player = new Mp3Player ;

		mp3player->dsound = g_dsound ;
		mp3player->dsound_init() ;

		mp3player->loadFile( (char*)(LPCTSTR)m_filename, 0, 0, 999999999) ;
		mp3player->pause(FALSE) ;


		//sprintfx("load file %s position %u\r\n", m_filename, availableSlot ) ;
		m_mp3players[availableSlot] = mp3player ;

		Insert_Mp3Player( mp3player ) ;
		m_lastPlayed = mp3player ;
	}
/*
	if ( m_mp3player.m_bDone == 0 )
	{
		Stop() ;
		m_mp3player.m_bDone = 0 ;
		m_mp3player.pause(FALSE) ;
	}
	else
	{
		m_mp3player.m_bDone = 0 ;
	}
*/
	//m_hLastChannelPlayed = BASS_SamplePlay( m_hSample );
}

void RageSoundSample::Pause()
{
	//return ;

	if ( m_lastPlayed )
		m_lastPlayed->pause(TRUE) ;
	//BASS_ChannelPause( m_hLastChannelPlayed );
}

void RageSoundSample::Stop()
{
	//return ;
	//m_mp3player.stop() ;

	for ( int i = 0 ; i < m_numPlayers ; i++ )
	{
		if ( m_mp3players[i] )
		{
			if ( WaitForSingleObject( hSoundMutex,INFINITE) == WAIT_OBJECT_0 )
			{
				m_mp3players[i]->stop() ;
				ReleaseMutex(hSoundMutex) ;
			}
		}
	}

	m_fLastKnownPosition = 0;
	//BASS_SampleStop( m_hSample );
}

float RageSoundSample::GetLengthSeconds()
{
	//return 0 ;
	Mp3Player *mp3player ;

	//writexbox("getlengthseconds \r\n") ;

	mp3player = m_mp3players[0] ;

	if ( mp3player == NULL )
		return 0 ;

	//BASS_SAMPLE info;
	//BASS_SampleGetInfo( m_hSample, &info);

	//float fSeconds = info.length/(float)info.freq;
	//return fSeconds;

	
	float datasize = mp3player->m_mp3BufSize ;
	float samplesize = mp3player->m_framebytes ;

	if ( samplesize == 0 )
		return 0 ;

	return (datasize*13.0f)/(samplesize*500.0f) ;

	//return 0 ;
}

float RageSoundSample::GetPositionSeconds()
{
	//return 0 ;

	if( !IsPlaying() )
		return m_fLastKnownPosition;

	Mp3Player *mp3player ;

	mp3player = m_lastPlayed ;

	if ( mp3player == NULL )
		return 0 ;

	//writexbox("get position seconds\r\n") ;

	float posinfile = mp3player->m_mp3ReadDataPos - ( mp3player->m_pMp3BufferData + ( mp3player->m_framebytes * mp3player->m_nFrameOffset ) ) ;

	if ( posinfile <= 0 )
		return 0 ;

	float samplesize = mp3player->m_framebytes ;

	if ( samplesize == 0 )
		return 0 ;

	m_fLastKnownPosition = (posinfile*13.0f)/(samplesize*500.0f) ;
	return m_fLastKnownPosition ;


	//return 0 ;

	//QWORD qwPosition = BASS_ChannelGetPosition( m_hLastChannelPlayed );
	//float fSeconds = BASS_ChannelBytes2Seconds( m_hLastChannelPlayed, qwPosition );
	/*
	if( fSeconds == -1 )
		return 0;
	else		
	{
		m_fLastKnownPosition = fSeconds;	// save this so we can report it later when the song is paused
		return fSeconds;
	}
	*/
	//return 0 ;
}

bool RageSoundSample::SetPlaybackRate( float fScale )
{
	
	//writexbox( "set playback rate - change freq of stream\r\n") ;
	//BASS_SAMPLE info;
	//BASS_SampleGetInfo( m_hSample, &info);

	//return BASS_ChannelSetAttributes( m_hLastChannelPlayed, DWORD(info.freq * fScale), -1, -101 ) == 1;
	return TRUE ;
}

float RageSoundSample::GetPlaybackRate()
{
	/*
	DWORD freq;
	if( ! BASS_ChannelGetAttributes( m_hLastChannelPlayed, &freq, NULL, NULL ) )
		return 1;

	BASS_SAMPLE info;
	BASS_SampleGetInfo( m_hSample, &info);

	return freq / (float)info.freq;
	*/
	//writexbox("get ratio of orig sample rate vs specified rate\r\n") ;
	return 1 ;
}

bool RageSoundSample::IsPlaying()
{
	//writexbox("isplaying\r\n") ;
	//return BASS_ChannelIsActive(m_hLastChannelPlayed) ? true : false;

	//return false ;

	if ( m_lastPlayed )
		return !(m_lastPlayed->m_bPaused || m_lastPlayed->m_bDone) ;
	else
		return 0 ;
}

#endif