#include "stdafx.h"
/*
-----------------------------------------------------------------------------
 Class: Quad

 Desc: See header

 Copyright (c) 2001-2002 by the person(s) listed below.  All rights reserved.
	Chris Danford
-----------------------------------------------------------------------------
*/


#include "Quad.h"
#include "RageTextureManager.h"
#include "IniFile.h"
#include <math.h>


Quad::Quad()
{
	m_size.x = m_size.y = 1;
}


void Quad::DrawPrimitives()
{	
	// use m_temp_* variables to draw the object
	RectF quadVerticies;

	switch( m_HorizAlign )
	{
	case align_top:		quadVerticies.left = 0;				quadVerticies.right = m_size.x;		break;
	case align_middle:	quadVerticies.left = -m_size.x/2;	quadVerticies.right = m_size.x/2;	break;
	case align_bottom:	quadVerticies.left = -m_size.x;		quadVerticies.right = 0;			break;
	default:		ASSERT(0);
	}

	switch( m_VertAlign )
	{
	case align_bottom:	quadVerticies.top = 0;				quadVerticies.bottom = m_size.y;	break;
	case align_middle:	quadVerticies.top = -m_size.y/2;	quadVerticies.bottom = m_size.y/2;	break;
	case align_top:		quadVerticies.top = -m_size.y;		quadVerticies.bottom = 0;			break;
	default:		ASSERT(0);
	}


	static RAGEVERTEX v[4];

	v[0].p = D3DXVECTOR3( quadVerticies.left,	quadVerticies.bottom,	0 );	// bottom left
	v[1].p = D3DXVECTOR3( quadVerticies.left,	quadVerticies.top,		0 );	// top left
	v[2].p = D3DXVECTOR3( quadVerticies.right,	quadVerticies.bottom,	0 );	// bottom right
	v[3].p = D3DXVECTOR3( quadVerticies.right,	quadVerticies.top,		0 );	// top right



	DISPLAY->SetTexture( NULL );

	DISPLAY->SetColorTextureMultDiffuse();
	DISPLAY->SetAlphaTextureMultDiffuse();

	if( m_bBlendAdd )
		DISPLAY->SetBlendModeAdd();
	else
		DISPLAY->SetBlendModeNormal();




	if( m_temp.diffuse[0].a != 0 )
	{
		//////////////////////
		// render the shadow
		//////////////////////
		if( m_bShadow )
		{
			DISPLAY->PushMatrix();
			DISPLAY->TranslateLocal( m_fShadowLength, m_fShadowLength, 0 );	// shift by 5 units
			v[0].color = v[1].color = v[2].color = v[3].color = D3DXCOLOR(0,0,0,0.5f*m_temp.diffuse[0].a);	// semi-transparent black
			DISPLAY->AddQuad( v );
			DISPLAY->PopMatrix();
		}
	}

	//////////////////////
	// render the diffuse pass
	//
	// Do this pass even if a == 0 because we use Quads as a mask by writing only into the Z Buffer
	//////////////////////
	v[0].color = m_temp.diffuse[2];	// bottom left
	v[1].color = m_temp.diffuse[0];	// top left
	v[2].color = m_temp.diffuse[3];	// bottom right
	v[3].color = m_temp.diffuse[1];	// top right
	DISPLAY->AddQuad( v );

	//////////////////////
	// render the glow pass
	//////////////////////
	if( m_temp.glow.a != 0 )
	{
		DISPLAY->SetColorDiffuse();
		v[0].color = v[1].color = v[2].color = v[3].color = m_temp.glow;
		DISPLAY->AddQuad( v );
	}	
}



