#include "stdafx.h"
/*
-----------------------------------------------------------------------------
 Class: GroupInfoFrame

 Desc: See header.

 Copyright (c) 2001-2002 by the person(s) listed below.  All rights reserved.
	Chris Danford
-----------------------------------------------------------------------------
*/

#include "GroupInfoFrame.h"
#include "RageUtil.h"
#include "GameConstantsAndTypes.h"
#include "PrefsManager.h"
#include "RageLog.h"
#include "PrefsManager.h"


const float BANNER_X = 0;
const float BANNER_Y = -2;

const float NUM_SONGS_X = -65;
const float NUM_SONGS_Y =  64;

const D3DXCOLOR NUM_SONGS_COLOR = D3DCOLOR_XRGB(8,216,253);


GroupInfoFrame::GroupInfoFrame()
{
	// these guys get loaded SetSong and TweenToSong
	m_Banner[0].SetXY( BANNER_X, BANNER_Y );
	m_Banner[1].SetXY( BANNER_X, BANNER_Y );
	this->AddSubActor( &m_Banner[0] );
	this->AddSubActor( &m_Banner[1] );

	m_sprGroupInfoFrame.Load( THEME->GetPathTo("Graphics","select group info frame") );
	m_sprGroupInfoFrame.TurnShadowOff();
	this->AddSubActor( &m_sprGroupInfoFrame );

	m_textNum.LoadFromFont( THEME->GetPathTo("Fonts","header1") );
	m_textNum.SetXY( NUM_SONGS_X-2, NUM_SONGS_Y );
	m_textNum.SetDiffuseColor( NUM_SONGS_COLOR );
	m_textNum.SetHorizAlign( Actor::align_right );
	m_textNum.TurnShadowOff();
	m_textNum.SetZoom( 1.0f );
	this->AddSubActor( &m_textNum );

	m_textSongs.LoadFromFont( THEME->GetPathTo("Fonts","header1") );
	m_textSongs.SetXY( NUM_SONGS_X+2, NUM_SONGS_Y+3 );
	m_textSongs.SetDiffuseColor( NUM_SONGS_COLOR );
	m_textSongs.SetHorizAlign( Actor::align_left );
	m_textSongs.TurnShadowOff();
	m_textSongs.SetText( "songs" );
	m_textSongs.SetZoom( 0.6f );
	this->AddSubActor( &m_textSongs );
}

void GroupInfoFrame::Set( const CString sGroupBannerPath, const int iNumSongs )
{
	// move the back banner to the front in preparation for a cross fade
	const CString sOldBannerPath = m_Banner[0].GetTexturePath();
	if( sOldBannerPath != "" )
		m_Banner[1].Load( sOldBannerPath );

	m_Banner[1].SetDiffuseColor( D3DXCOLOR(1,1,1,1) );
	m_Banner[1].BeginTweening( 0.25f );		// fade out
	m_Banner[1].SetTweenDiffuseColor( D3DXCOLOR(1,1,1,0) );


	m_textNum.SetText( ssprintf("%d", iNumSongs) );
	m_Banner[0].Load( sGroupBannerPath );
}
