#define DEBUG_KEYBOARD

#include <XBApp.h>
#include <XBFont.h>
#include <XBHelp.h>
#include <xgraphics.h>
#include <assert.h>
#include <d3d8perf.h>
#include "SndXBOX.hxx"
#include <stdio.h>
#include <vector>
#include "zlib.h"
#include "unzip.h"
#include "debugclient.h"
#include "Mp3Player.h"
#include "keyboard_api.h"


#ifdef __cplusplus
extern "C" {
#endif

extern byte *RAMData;
extern int  RAMPages ;
extern byte KeyMap[16];
extern byte JoyStateA;
extern byte JoyStateB;
extern unsigned short *XBuf;
int fmsxmain( int msxtype, char *statefile, char *sramfile, char *cartafile, char* cartbfile, int romtype, char **disks, int numdisks );

int g_throttle ;
#ifdef __cplusplus
}
#endif



#define PLATFORM_SAV L"MSXSAV"
#define READING_ROMS_STRING L"Reading msxroms directory...please wait."
#define PLATFORM_INI "msx.ini"
#define PLATFORM_SPEC_INI "msxspec.ini"
#define PLATFORM_MEMORY_POINTER RAMData
#define THEMEMUSIC "D:\\MSXROMS\\FMSXTHEME.MP3"
#define PLATFORM_FILE_DIR "D:\\msxroms\\*"
#define CONSOLE_MEMORY_SIZE 4*(0x4000)
//#define CONSOLE_MEMORY_SIZE RAMPages*0x4000


byte keyboard_keystate[256] ;

struct { char *keyname ; int keynum ; } validKeys[71] = 
{
	{ "Space", 0 },
	{ "Single Quote", 1 },
	{ "[", 2 },
	{ "\\", 3 },
	{ "]", 4 },
	{ "Comma", 5 },
	{ "-", 6 },
	{ "Period", 7 },
	{ "/", 8 },
	{ "0", 9 },
	{ "1", 10 },
	{ "2", 11 },
	{ "3", 12 },
	{ "4", 13 },
	{ "5", 14 },
	{ "6", 15 },
	{ "7", 16 },
	{ "8", 17 },
	{ "9", 18 },
	{ ";", 19 },
	{ "=", 20 },
	{ "`", 21 },
	{ "A", 22 },
	{ "B", 23 },
	{ "C", 24 },
	{ "D", 25 },
	{ "E", 26 },
	{ "F", 27 },
	{ "G", 28 },
	{ "H", 29 },
	{ "I", 30 },
	{ "J", 31 },
	{ "K", 32 },
	{ "L", 33 },
	{ "M", 34 },
	{ "N", 35 },
	{ "O", 36 },
	{ "P", 37 },
	{ "Q", 38 },
	{ "R", 39 },
	{ "S", 40 },
	{ "T", 41 },
	{ "U", 42 },
	{ "V", 43 },
	{ "W", 44 },
	{ "X", 45 },
	{ "Y", 46 },
	{ "Z", 47 },
	{ "Backspace", 48 },
	{ "Tab", 49 },
	{ "Return", 50 },
	{ "Escape", 51 },
	{ "Left", 52 },
	{ "Up", 53 },
	{ "Right", 54 },
	{ "Down", 55 },
	{ "F1", 56 },
	{ "F2", 57 },
	{ "F3", 58 },
	{ "F4", 59 },
	{ "F5", 60 },
	{ "SHIFT", 61 },
	{ "CAPSLOCK", 62 },
	{ "CONTROL", 63 },
	{ "GRAPH", 65 },
	{ "DELETE", 67 },
	{ "INSERT", 68 },
	{ "COUNTRY", 69 },
	{ "STOP/BREAK", 70 },
	{ "HOME/CLS", 71 },
	{ "SELECT", 72 }
} ;


	
struct { short Code; byte Pos,Mask; } Keys[256] =
{
  {VK_SPACE,8,0x01},{VK_OEM_7,2,0x01},
  {VK_OEM_4,1,0x20},{VK_OEM_5,1,0x10},{VK_OEM_6,1,0x40},
  {VK_OEM_COMMA,2,0x04},{VK_OEM_MINUS,1,0x04},{VK_OEM_PERIOD,2,0x08},{VK_OEM_2,2,0x10},
  {'0',0,0x01},{'1',0,0x02},{'2',0,0x04},{'3',0,0x08},
  {'4',0,0x10},{'5',0,0x20},{'6',0,0x40},{'7',0,0x80},
  {'8',1,0x01},{'9',1,0x02},{VK_OEM_1,1,0x80},{VK_OEM_PLUS,1,0x08},
  {VK_OEM_3,2,0x02},{'A',2,0x40},{'B',2,0x80},{'C',3,0x01},
  {'D',3,0x02},{'E',3,0x04},{'F',3,0x08},{'G',3,0x10},
  {'H',3,0x20},{'I',3,0x40},{'J',3,0x80},{'K',4,0x01},
  {'L',4,0x02},{'M',4,0x04},{'N',4,0x08},{'O',4,0x10},
  {'P',4,0x20},{'Q',4,0x40},{'R',4,0x80},{'S',5,0x01},
  {'T',5,0x02},{'U',5,0x04},{'V',5,0x08},{'W',5,0x10},
  {'X',5,0x20},{'Y',5,0x40},{'Z',5,0x80},
  {VK_BACK,  7,0x20},
  {VK_TAB,        7,0x08},
  {VK_RETURN,     7,0x80},
  {VK_ESCAPE,     7,0x04},
  {VK_LEFT,       8,0x10},
  {VK_UP,         8,0x20},
  {VK_RIGHT,      8,0x80},
  {VK_DOWN,       8,0x40},
  {VK_F1,         6,0x20},
  {VK_F2,         6,0x40},
  {VK_F3,         6,0x80},
  {VK_F4,         7,0x01},
  {VK_F5,         7,0x02},
  {VK_LSHIFT,    6,0x01}, /* SHIFT      */
  {VK_RSHIFT,    6,0x08}, /* CAPSLOCK   */
  {VK_LCONTROL,  6,0x02}, /* CONTROL    */
  {VK_RCONTROL,  6,0x02}, /* CONTROL    */
  {VK_F5,        6,0x04}, /* GRAPH      */
  {VK_F5,        6,0x04}, /* GRAPH      */
  {VK_DELETE,     8,0x08}, /* DELETE     */
  {VK_INSERT,     8,0x04}, /* INSERT     */
  {VK_PRIOR,  6,0x10}, /* COUNTRY    */
  {VK_NEXT,    7,0x10}, /* STOP/BREAK */
  {VK_HOME,       8,0x02}, /* HOME/CLS   */
  {VK_END,        7,0x40}, /* SELECT     */
  {0,0,0x00}               /** The End. **/
};

//-----------------------------------------------------------------------------
// Name: class CXBoxSample
// Desc: Main class to run this application. Most functionality is inherited
//       from the CXBApplication base class.
//-----------------------------------------------------------------------------
class CXBoxSample : public CXBApplication
{
public:
    CXBoxSample();

    virtual HRESULT Initialize();
    virtual HRESULT InitializeWithScreen();
    virtual HRESULT Render();
    virtual HRESULT FrameMove();
	virtual void MoveCursor() ;
	virtual void    initConsole( UINT32 idx, int forceUS, int whichCard ) ;
	virtual void    cleanupConsole( ) ;
	virtual int     handleEvents() ;
	virtual int     init_texture() ;
	virtual int		init_white_texture();
	virtual int		render_to_texture( char *msg) ;
	virtual void	FindAvailRoms() ;
	virtual void    doStartSearchMenu() ;
	virtual void    doCodeListMenu() ;
	virtual void    doAddFoundCodes() ;
	virtual void    doContinueSearchMenu() ;
	virtual void    doCheatMenu() ;
	virtual void    doFontSize() ;
	virtual void    doSaveConfig() ;
	virtual void    doScreenSize() ;
	virtual void    doTextOffset() ;
	virtual void    doConfiguration() ;
	virtual void    updateCheats() ;
	virtual void    processEmu( BOOL render ) ;
	virtual void    cht_load() ;
	virtual void    cht_save() ;
	virtual void    deleteSaveFiles( int which ) ;
	virtual void    doEditCode( int which ) ;
	virtual BOOL    hasFiles( int which ) ;
	virtual int     rom_load_zip( char *hugozipfile ) ;
	virtual void    QuickSort( int start, int end ) ;
	void			MenuBar( int xpos, int ypos, int xlen, int ylen ) ;
	        int     doMouse( int port ) ;
	void			doEmulatorOptions() ;
	

	float fGameSelect;
	float fCursorPos;
	float m_fFrameTime ;
	float fMaxCount;
	int   iGameSelect;
	int   iCursorPos;
	UINT32 m_numFrames ;
	int   keyTime ;
	unsigned int   m_bMappingB ;
	unsigned int   m_bMappingSTART ;
	unsigned int   m_bMappingBLACK ;
	unsigned int   m_bMappingWHITE ;


	UINT32 topIdx  ;
	UINT32 curr  ;
	CDebugClient m_debugClient ;
	D3DPalette			*m_pd3dPalette ;

    CXBFont     m_Font;             // Font object
    CXBFont     m_FontSmall;             // Font object
    CXBHelp     m_Help;             // Help object
    BOOL        m_bDrawHelp;        // TRUE to draw help screen

    LPDIRECTSOUND8      m_pDSound;      // DirectSound object
    DWORD               m_dwCurrent;    // Current surface

	byte *m_memBuf1, *m_memBuf2, *m_consoleMemory, *m_memMatches ;
	UINT32 m_currentMemMatches ;

	typedef struct _filenamestruct {
		WCHAR name[200] ;
		unsigned char filename[200] ;
		char flagged ;
	} FILENAME ;

	FILENAME *files ;
	unsigned long numfiles ;
	UINT32   m_iMaxWindowList;
	UINT32   m_iWindowMiddle ;
	UINT32   m_steps ;
	DWORD    m_dwStartPause ;
	int		m_nbytes ;
	int		m_nXOffset, m_nFontHeight ;
	int		m_namesPerPage ;
	int		m_throttle ;
	int     m_mouseX, m_mouseY ;

	LPDIRECT3DTEXTURE8	Texture;
	LPDIRECT3DTEXTURE8	WhiteTexture;
	LPD3DXSPRITE			Sprite;
	LPD3DXSPRITE			MenuSprite;
	byte*				g_pBlitBuff ;
	byte*				g_pAlignBuff ;
	int					m_droppedFrames ;	
	
	UINT32				m_state ;
    WCHAR      m_strMessage[80];
	UINT32              m_msgDelay ;


	SoundXBOX			m_sound;
	Mp3Player			m_mp3player;
	char				g_savePath[500] ;
	char				g_saveprefix[500] ;
	char				g_sramfile[500] ;
	char				g_cuefile[500] ;
	char				g_rtcfile[500] ;
	char				g_chtfile[500] ;
	char				g_statefile[500] ;
	FILE                *m_logfile ;

// Indicates the width and height of the screen
	UINT32 theWidth;
	UINT32 theHeight;
    RECT SrcRect;
    RECT DestRect;

	int					m_nScreenX, m_nScreenY, m_nScreenMaxX, m_nScreenMaxY ;

	typedef struct _cheat_code {
		char code[20] ;
		UINT32 adr ;
		UINT32 val ;
		byte   enabled ;
	} CHEAT_CODE;

	CHEAT_CODE *m_cheatCodes;

	UINT32 m_numCheats ;


};


#include "..\common\commonfuncs.cpp"




int CXBoxSample::init_texture()
{
	// Release any previous texture
	if (Texture) 
	{ 
		Texture->Release();
		Texture = NULL;
	}
	
	theWidth = 320 ;
	theHeight = 240 ;

	// Create the texture
	D3DXCreateTexture(m_pd3dDevice, theWidth, theHeight, 0, 0, D3DFMT_X1R5G5B5, D3DPOOL_DEFAULT, &Texture);
	
	D3DSURFACE_DESC desc;
    Texture->GetLevelDesc(0, &desc);

	if (g_pBlitBuff != NULL)
	{
		delete [] g_pBlitBuff;
		g_pBlitBuff = NULL;
	}
	
	// Allocate a buffer to blit our frames to
	g_pBlitBuff = new byte[desc.Size];


	if (g_pAlignBuff != NULL)
	{
		delete [] g_pAlignBuff;
		g_pAlignBuff = NULL;
	}
	
	// Allocate a buffer to blit our frames to
	g_pAlignBuff = new byte[desc.Size];


	D3DCOLOR			*color_palette;
	

/*
	RECT rectSource;
	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = theHeight-1 ;
	rectSource.right  = theWidth-1 ;

	D3DLOCKED_RECT d3dlr;
	Texture->LockRect(0, &d3dlr, &rectSource, 0);

	// Unlock our texture
	Texture->UnlockRect(0);
*/
	//m_pd3dDevice->CreatePalette( D3DPALETTE_256 , &m_pd3dPalette ) ;
	//m_pd3dPalette->Lock( &color_palette, 0 ) ;

/*
  osd_gfx_set_color (255, 0x3f, 0x3f, 0x3f);

  for (i = 0; i < 255; i++)
    {
      osd_gfx_set_color (i,
			 (i & 0x1C) << 1, (i & 0xe0) >> 2, (i & 0x03) << 4);
    }
*/
/*
	color_palette[255] = 0xFFFFFFFF ;


	int r, g, b;
	for (int i = 0; i < 255; i++)
	{
		r = (i & 0x1C) << 1 ;
		g = (i & 0xe0) >> 2 ;
		b = (i & 0x03) << 4 ;

		r = r << 2 ;
		g = g << 2 ;
		b = b << 2 ;

		//r = (256*r) / 56 ;
		//g = (256*g) / 56 ;
		//b = (256*b) / 48 ;
		color_palette[i] = 	( 0xFF << 24 ) | ( (r) << 16 ) | ( (g) << 8 ) | (b)  ;
	}

	m_pd3dPalette->Unlock() ;

	m_pd3dDevice->SetPalette( 0, m_pd3dPalette ) ;
*/
	return 0;
}











void CXBoxSample::doCheatMenu()
{

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		m_Font.Begin();
		m_Font.DrawText( (float)m_nXOffset+  32, 16*2, 0xffffffff, L"OPTIONS MENU" );
		m_Font.DrawText( (float)m_nXOffset+  32, 16*4, 0xffffffff, L"B - Return to Game" );
		m_Font.DrawText( (float)m_nXOffset+  32, 16*5, 0xffffffff, L"START+BACK - Quit Game" );
		m_Font.DrawText( (float)m_nXOffset+  32, 16*6, 0xffffffff, L"BLACK - Start Search for Cheat Code" );
		m_Font.DrawText( (float)m_nXOffset+  32, 16*7, 0xffffffff, L"A - Continue Cheat Search" );
		m_Font.DrawText( (float)m_nXOffset+  32, 16*8, 0xffffffff, L"RS+LS - Cheat Code List" );
		m_Font.DrawText( (float)m_nXOffset+  32, 16*9, 0xffffffff, L"LTHUMB - Configuration screen" );


		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sound.pause( FALSE ) ;
			m_mp3player.pause( FALSE ) ;
			m_state = IN_GAME ;
			break ;
		}
		else if ( ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_START )  &&
			      ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_BACK )  )
		{
			m_sound.cleanup() ;
			m_mp3player.cleanup() ;
			cleanupConsole() ;
			m_state = MAIN_MENU ;
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			doContinueSearchMenu() ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK])
		{
			doStartSearchMenu() ;
		}
		else if ( (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) )
		{
			doCodeListMenu() ;
		}
		else if( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_LEFT_THUMB )
		{
			doConfiguration() ;
		}


	}

}

void CXBoxSample::doEmulatorOptions()
{

	int menuChoice = 0 ;
	WCHAR str[200] ;
	FILE *inifile ;
	char tmpfilename[MAX_PATH] ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		MenuBar( 32, 16*(6+menuChoice)+3, 600, 19 ) ;

		m_Font.Begin();
		m_Font.DrawText( (float)(m_nXOffset+  32), (float)(16*4), 0xffffffff, L"Emulator Configuration Options" );

		swprintf( str, L"Use DPAD to change mapping of B button : %S", validKeys[m_bMappingB].keyname ) ;
		m_Font.DrawText( (float)m_nXOffset+  32, 16*6, menuChoice==0 ? 0xff000000 : 0xffffffff, str );

		swprintf( str, L"Use DPAD to change mapping of START button : %S", validKeys[m_bMappingSTART].keyname ) ;
		m_Font.DrawText( (float)m_nXOffset+  32, 16*7, menuChoice==1 ? 0xff000000 : 0xffffffff, str );

		swprintf( str, L"Use DPAD to change mapping of BLACK button : %S", validKeys[m_bMappingBLACK].keyname ) ;
		m_Font.DrawText( (float)m_nXOffset+  32, 16*8, menuChoice==2 ? 0xff000000 : 0xffffffff, str );

		swprintf( str, L"Use DPAD to change mapping of WHITE button : %S", validKeys[m_bMappingWHITE].keyname ) ;
		m_Font.DrawText( (float)m_nXOffset+  32, 16*9, menuChoice==3 ? 0xff000000 : 0xffffffff, str );

		m_Font.DrawText( (float)m_nXOffset+  32, 16*11, 0xffffffff, L"Press B to go back" );
		m_Font.End();

		
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			strcpy( tmpfilename, g_savePath ) ;
			strcat( tmpfilename, PLATFORM_SPEC_INI ) ;
			inifile = fopen( tmpfilename, "wb" ) ;
			if ( inifile )
			{
				fwrite( &m_bMappingB, sizeof(m_bMappingB), 1, inifile ) ;
				fwrite( &m_bMappingBLACK, sizeof(m_bMappingBLACK), 1, inifile ) ;
				fwrite( &m_bMappingWHITE, sizeof(m_bMappingWHITE), 1, inifile ) ;
				fwrite( &m_bMappingSTART, sizeof(m_bMappingSTART), 1, inifile ) ;
				fclose( inifile ) ;
			}
	        XBInput_GetInput();
			break ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN )
		{
			menuChoice = (menuChoice+1)%4 ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP )
		{
			if ( menuChoice == 0 )
				menuChoice = 3 ;
			else
				menuChoice = (menuChoice-1)%4 ;
		}
		else if ( (g_Gamepads[0].hDevice ) && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT )
		{
			switch ( menuChoice )
			{
				case 0 : m_bMappingB = (m_bMappingB+1)%71; break ;
				case 1 : m_bMappingSTART = (m_bMappingSTART+1)%71; break ;
				case 2 : m_bMappingBLACK = (m_bMappingBLACK+1)%71; break ;
				case 3 : m_bMappingWHITE = (m_bMappingWHITE+1)%71; break ;
				default : break ;
			}
		}
		else if ( (g_Gamepads[0].hDevice ) && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT )
		{
			switch ( menuChoice )
			{
				case 0 : if ( m_bMappingB == 0 ) m_bMappingB = 70 ; else m_bMappingB = (m_bMappingB-1)%71; break ;
				case 1 : if ( m_bMappingSTART == 0 ) m_bMappingSTART = 70 ; else m_bMappingSTART = (m_bMappingSTART-1)%71; break ;
				case 2 : if ( m_bMappingBLACK == 0 ) m_bMappingBLACK = 70 ; else m_bMappingBLACK = (m_bMappingBLACK-1)%71; break ;
				case 3 : if ( m_bMappingWHITE == 0 ) m_bMappingWHITE = 70 ; else m_bMappingWHITE = (m_bMappingWHITE-1)%71; break ;
				default : break ;
			}
		}


	}

}

//-----------------------------------------------------------------------------
// Name: FrameMove
// Desc: Performs per-frame updates
//-----------------------------------------------------------------------------
HRESULT CXBoxSample::FrameMove()
{

	m_bPaused =  ( m_state != IN_GAME ) ;


	if ( m_state == IN_GAME )
	{
		if ( m_dwStartPause > 0 )
		{
			g_dwTimePaused += ( GetTickCount() - m_dwStartPause ) ;
			m_dwStartPause = 0;
		}

		if(m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_sound.pause( TRUE ) ;
			m_mp3player.pause( TRUE ) ;
			m_state = IN_GAME_PAUSED ;
			m_dwStartPause = GetTickCount();
			return S_OK ;
		}
	}
	else if ( m_state == MAIN_MENU )
	{
		m_mp3player.process() ;

		if(m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_Y])
		{
		}
		else if ( ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_START )  &&
			      ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_BACK )  &&
				  ( g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) &&
				  ( g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) )
		{
			LD_LAUNCH_DASHBOARD LaunchData = { XLD_LAUNCH_DASHBOARD_MAIN_MENU };
			XLaunchNewImage( NULL, (LAUNCH_DATA*)&LaunchData );
		}
		else if ( (m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_X]) && (m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_B]) )
		{
			m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
								 0x00000000, 1.0f, 0L );
			RenderGradientBackground( 0xFF000000, 0xFF000000 );
			m_Font.Begin();
			m_Font.DrawText( (float)m_nXOffset+  32, 16*2, 0xffffffff, L"Reloading game list..." ) ;
			m_Font.End();
			m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

			if ( numfiles > 0 )
			{
				delete [] files;
				files = NULL;
			}

			numfiles = 0 ;
			FindAvailRoms() ;
		}
		else
		{
			// check for cursor select movement and move
			MoveCursor();

			// check for selection of game and do something (anything!)
			if(m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_A])
			{
				m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
									 0x00000000, 1.0f, 0L );
				RenderGradientBackground( 0xFF000000, 0xFF000000 );
				m_Font.Begin();
				m_Font.DrawText( (float)m_nXOffset+  32, 16*2, 0xffffffff, L"Loading game...please wait." ) ;
				m_Font.End();
				m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
				m_state = IN_GAME ;
				initConsole(curr, 2, 0) ;
				return S_OK ;
			}
			else if(m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_B])
			{
				m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
									 0x00000000, 1.0f, 0L );
				RenderGradientBackground( 0xFF000000, 0xFF000000 );
				m_Font.Begin();
				m_Font.DrawText( (float)m_nXOffset+  32, 16*2, 0xffffffff, L"Loading game...please wait." ) ;
				m_Font.End();
				m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
				m_state = IN_GAME ;
				initConsole(curr,2, 1) ;
				return S_OK ;
			}
			else if(m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_X])
			{
				m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
									 0x00000000, 1.0f, 0L );
				RenderGradientBackground( 0xFF000000, 0xFF000000 );
				m_Font.Begin();
				m_Font.DrawText( (float)m_nXOffset+  32, 16*2, 0xffffffff, L"Loading game...please wait." ) ;
				m_Font.End();
				m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
				m_state = IN_GAME ;
				initConsole(curr,0, 1) ;
				return S_OK ;
			}
			else if(m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK])
			{
				files[curr].flagged = ! files[curr].flagged ;

				return S_OK ;
			}
			else if(m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_WHITE])
			{
				m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
									 0x00000000, 1.0f, 0L );
				RenderGradientBackground( 0xFF000000, 0xFF000000 );
				m_Font.Begin();
				m_Font.DrawText( (float)m_nXOffset+  32, 16*2, 0xffffffff, L"Loading game...please wait." ) ;
				m_Font.End();
				m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
				m_state = IN_GAME ;
				initConsole(curr,2,1) ;
				return S_OK ;
			}
			else if(m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_BACK)
			{
				m_mp3player.stop() ;
				return S_OK ;
			}
			else if(m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_LEFT_THUMB )
			{
				doConfiguration() ;
				return S_OK ;
			}
		}
	}
	else if ( m_state == IN_GAME_PAUSED )
	{
		m_sound.pause( TRUE ) ;
		m_mp3player.pause( TRUE ) ;
		m_bPaused =  TRUE ;
		doCheatMenu() ;

		if ( m_state == MAIN_MENU )
		{
		}

		return S_OK ;
	}
	else
	{
	}

    return S_OK;
}


int CXBoxSample::render_to_texture( char *msg)
{

	//DOXXX
	RECT src, dst;
	byte *curr1, *curr2 ;
	WCHAR scrmsg[2000] ;
	
	//writexbox("render1\r\n" ) ;

	// Get a description of our level 0 texture so we can figure
	// out the pitch of the texture
	D3DSURFACE_DESC desc;
    Texture->GetLevelDesc(0, &desc);
	
	
	// Allocate a buffer to blit our frames to

	// Figure out how big of a rect to lock in our texture
	RECT rectSource;
	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = theHeight - 1 ;
	rectSource.right  = theWidth  - 1;

	// Lock the rect in our texture
	D3DLOCKED_RECT d3dlr;
	Texture->LockRect(0, &d3dlr, &rectSource, 0);

	//sprintf(xmsg, "h=%u,w=%u\r\n", io.screen_h, io.screen_w) ;
	//writexbox( xmsg) ;

	curr1 = g_pBlitBuff ;
	//DOXXX
	//curr2 = XBuf ;

	for ( unsigned int y = 0 ; y < theHeight ; y++ )
	{
		curr1 = ((byte*)g_pBlitBuff) + ( y*d3dlr.Pitch ) ;
		curr2 = ((byte*)XBuf) + ( y*(theWidth)*2 )   ;
		memcpy( curr1, curr2, theWidth*2 ) ;
	}
	
	// Swizzle the blittled surface back to the texture
	XGSwizzleRect(g_pBlitBuff, 0, NULL, d3dlr.pBits, desc.Width, desc.Height, NULL, 2);


	// Swizzle the blittled surface back to the texture
//	XGSwizzleRect(osd_gfx_buffer2, 0, NULL, d3dlr.pBits, desc.Width, desc.Height, NULL, 2);

	// Unlock our texture
	Texture->UnlockRect(0);

	//delete [] g_pBlitBuff;
	//g_pBlitBuff = NULL;



	src.left   = 0;
	src.top    = 0;
	src.right  = theWidth  + 0;
	src.bottom = theHeight + 1;

	UINT iWidth  = theWidth;
	UINT iHeight = theHeight;
	
	// win_start_maximized the rect, constraining to the aspect ratio
	dst.left   = dst.top = 0;
	dst.right  = iWidth;
	dst.bottom = iHeight;
	
	// center
	//dst.left   += ((iWidth - (dst.right - dst.left)) / 2)  + ((640-iWidth)/2);
	//dst.top    += ((iHeight - (dst.bottom - dst.top)) / 2) + ((480-iHeight)/2);
	//dst.right  += dst.left;
	//dst.bottom += dst.top;
	
    // Clear the viewport
//	if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_A ] ) || ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_X ] ) )  
	    g_pd3dDevice->Clear(0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0,0,0), 1.0f, 0L);
	
	// Begin the Scene
	g_pd3dDevice->BeginScene();

	// Compute the source and dest image sizes
	const float dw = (float)dst.right-dst.left;
	const float dh = (float)dst.bottom-dst.top;
	const float sw = (float)src.right-src.left;
	const float sh = (float)src.bottom-src.top;
	float mx, my ;



	mx = (float)m_nScreenMaxX / (float)theWidth ;
	my = (float)m_nScreenMaxY / (float)theHeight;

	// Compute the scale and transform vectors
	//D3DXVECTOR2 vecScale(dw/sw, dh/sh);
	D3DXVECTOR2 vecScale(mx, my);
	D3DXVECTOR2 vecTranslate((float)m_nScreenX, (float)m_nScreenY );


	//mx = 640.0f / io.screen_w ;
	//my = 480.0f / io.screen_h ;
	//mx = 580.0f / io.screen_w ;
	//my = 400.0f / io.screen_h ;



	// Compute the scale and transform vectors
	//D3DXVECTOR2 vecScale(dw/sw, dh/sh);
	//D3DXVECTOR2 vecScale( mx,my ) ;
	//D3DXVECTOR2 vecScale( min(mx,my), min(mx,my) ) ;
	//D3DXVECTOR2 vecScale( (io.screen_w <= 320) ? 2 : 1 , (io.screen_w <= 320) ? 2 : 1);
	//D3DXVECTOR2 vecTranslate( 10, 20 ) ;
	//D3DXVECTOR2 vecTranslate( ( 640.0f - ( (float)io.screen_w * ( min(mx,my) ) ) )/2,
		                      //( 480.0f - ( (float)io.screen_h * ( min(mx,my) ) ) )/2 );
	//D3DXVECTOR2 vecTranslate( ( 640.0f - ( (float)io.screen_w * ( mx ) ) )/2,
		                      //( 480.0f - ( (float)io.screen_h * ( my ) ) )/2 );
	//D3DXVECTOR2 vecTranslate( (io.screen_w <= 320) ? 320 - io.screen_w : 320 - ( io.screen_w/2), 
	//	                      (io.screen_w <= 320) ? 240 - io.screen_h : 240 - ( io.screen_h/2)  );
	//D3DXVECTOR2 vecTranslate(dst.left, dst.top);
	
	D3DXCOLOR d3color(1.0, 1.0, 1.0, 1.0);
	
	// Draw the sprite
	//if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_A ] ) || ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_Y ] ) )  
		Sprite->Draw(Texture, &rectSource, &vecScale, NULL, 0, &vecTranslate, d3color);
	
	// End the scene.
	g_pd3dDevice->EndScene();
	
	if ( msg )
	{
		//writexbox(msg) ;
		swprintf( scrmsg, L"%S", msg );

		m_Font.Begin();
		m_Font.DrawText( (float)g_app->m_nXOffset+  32, 16*2, 0xffffffff, scrmsg );
		m_Font.End();
	}

	// Present the scene
	//if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_A ] ) || ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_BLACK ] ) )  
		g_pd3dDevice->Present(NULL, NULL, NULL, NULL);


	return 1;
}



//-----------------------------------------------------------------------------
// Name: Render
// Desc: Renders the scene
//-----------------------------------------------------------------------------
HRESULT CXBoxSample::Render()
{
	m_bPaused =  ( m_state != IN_GAME ) ;


	if ( m_state == IN_GAME )
	{
		if ( m_dwStartPause > 0 )
		{
			g_dwTimePaused += ( GetTickCount() - m_dwStartPause ) ;
			m_dwStartPause = 0;
		}

		// Clear the zbuffer
		//m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 //0x00000000, 1.0f, 0L );

		// Draw a gradient filled background
		//RenderGradientBackground( 0xff404040, 0xff404080 );

		if ( global_error_message[0] != 0 )
		{

			m_Font.Begin();
			//swprintf( str, L"%S", global_error_message );
			//m_Font.DrawText( 32, 48, 0x40ffffff, str );
			m_Font.DrawText( (float)m_nXOffset+ 32, 48, 0xffffffff, L"ERROR" );
			m_Font.End();
		}
		else
		{

			processEmu( TRUE ) ;

			if ( m_msgDelay > 0 )
			{
				m_msgDelay-- ;
				m_Font.Begin();
				m_Font.DrawText( (float)m_nXOffset+  32, 32, 0xffffff00, m_strMessage );
				m_Font.End();
			}
			else
			{
				//float elapsedTime ;
				//m_Font.Begin();
				//WCHAR str[2000];
				//swprintf( str, L"width = %u, height = %u", io.screen_w, io.screen_h ) ;
				//elapsedTime = ( (float)GetTickCount() - (float)g_dwStartTime - (float)g_dwTimePaused ) / 1000.0f ;
				//swprintf( str, L"numbytes apptime %5.5f, sndbytes %u, avg %6.5f, fps %5.5f cfps %5.5f", elapsedTime, m_sound.m_totalBytesWritten, 
					//((float)m_sound.m_totalBytesWritten) / elapsedTime, m_fFPS, ((float)m_numFrames) / m_fAppTime );
				//m_Font.DrawText( 30, 320, 0xFFffffff, str );
				//m_Font.End();
			}
		}
		
		// Present the scene
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
	}
	else if ( m_state == IN_GAME_PAUSED )
	{
	}
	else if ( m_state == MAIN_MENU )
	{
		// Clear the zbuffer
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );

		if(m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_Font.Begin(); 
			m_Font.DrawText( (float)m_nXOffset+32, 16*3,  0xffffffff, L"FMSXBOX");
			m_Font.DrawText( (float)m_nXOffset+32, 16*5,  0xffffffff, L"Main Menu Controls");
			m_Font.DrawText( (float)m_nXOffset+32, 16*6,  0xffffffff, L"A/B - Play Selected Game");
			m_Font.DrawText( (float)m_nXOffset+32, 16*7,  0xffffffff, L"  A=Normal, B=cycle through ROM mappers");
			m_Font.DrawText( (float)m_nXOffset+32, 16*8,  0xffffffff, L"Y - Show This Help Screen");
			m_Font.DrawText( (float)m_nXOffset+32, 16*9,  0xffffffff, L"UP/DOWN - Select Game");
			m_Font.DrawText( (float)m_nXOffset+32, 16*10,  0xffffffff, L"RIGHT/LEFT - Next/Prev Page");
			m_Font.DrawText( (float)m_nXOffset+32, 16*11,  0xffffffff, L"LS/RS - Next/Prev Letter");
			m_Font.DrawText( (float)m_nXOffset+32, 16*12,  0xffffffff, L"START+BACK+LS+RS - Exit to dashboard");
			m_Font.DrawText( (float)m_nXOffset+32, 16*13,  0xffffffff, L"X+B - Reload list");
			m_Font.DrawText( (float)m_nXOffset+32, 16*14,  0xff00ff00, L"Lines colored like this have save files on the HD.");

			m_Font.DrawText( (float)m_nXOffset+32, 16*16, 0xffffffff, L"In-Game Controls");
			m_Font.DrawText( (float)m_nXOffset+32, 16*17, 0xffffffff, L"A - Joystick button 1");
			m_Font.DrawText( (float)m_nXOffset+32, 16*18, 0xffffffff, L"X - Joystick button 2");
			m_Font.DrawText( (float)m_nXOffset+32, 16*19, 0xffffffff, L"DPAD - Joystick Movement");
			m_Font.DrawText( (float)m_nXOffset+32, 16*20, 0xffffffff, L"Y - Options Menu");
			m_Font.DrawText( (float)m_nXOffset+32, 16*21, 0xffffffff, L"RANALOG U/D/L/R - Adjust MP3/SFX volume");
			m_Font.DrawText( (float)m_nXOffset+32, 16*22, 0xffffffff, L"LS+BLACK - Save state");
			m_Font.DrawText( (float)m_nXOffset+32, 16*23, 0xffffffff, L"LS+WHITE - Load state");
			m_Font.End();
		}
		else if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_BLACK ] ) &&
				  ( m_DefaultGamepad.wButtons & XINPUT_GAMEPAD_LEFT_THUMB ) &&
				  ( m_DefaultGamepad.wButtons & XINPUT_GAMEPAD_RIGHT_THUMB ) )
		{
			m_Font.Begin(); 
			m_Font.DrawText( (float)m_nXOffset+48, 32, 0xffffffff, L"FMSXBOX - made by me");
			m_Font.End();
		}
		else if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_BLACK ] ) &&
				  ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_WHITE ] ) )
		{
			deleteSaveFiles( curr ) ;
		}
		else
		{
			WCHAR str[2000];
			swprintf( str, L"FMSXBOX  Y-Help Screen  Found %u games", numfiles);

			m_Font.Begin(); 
			m_FontSmall.Begin(); 
			m_Font.DrawText( (float)m_nXOffset+ 48, 32, 0xffffffff, str );
			//m_Font.DrawText(48, 32, 0x40ffffff, L"Gnuboy for XBOX  Y-Help Screen");


			
			
			float fWinX = 32, fWinY = 64;

			MenuBar( m_nXOffset+(int)fWinX, (int)fWinY+ (( m_nFontHeight+2)*(curr-topIdx)) + 3, 600, m_nFontHeight+3 ) ;

			for ( unsigned int idx = topIdx ; ( idx < numfiles ) && ( idx < topIdx+m_namesPerPage) ; idx++ )
			{
		        swprintf( str, L"*%S", files[idx].filename );

				if ( curr == idx )
				{
					if ( hasFiles( idx ) )
						m_FontSmall.DrawText( (float)m_nXOffset+fWinX  , fWinY, 0xffff00ff, files[idx].flagged ? str : files[idx].name );
					else
						m_FontSmall.DrawText( (float)m_nXOffset+fWinX , fWinY, 0xff000000, files[idx].flagged ? str : files[idx].name );
				}
				else
				{
					if ( hasFiles( idx ) )
						m_FontSmall.DrawText( (float)m_nXOffset+fWinX, fWinY, 0xff00ff00, files[idx].flagged ? str : files[idx].name );
					else
						m_FontSmall.DrawText( (float)m_nXOffset+fWinX, fWinY, 0xffffffff, files[idx].flagged ? str : files[idx].name );
				}
				fWinY += (m_nFontHeight + 2);
			}
			

			// end font drawing
			m_Font.End();
			m_FontSmall.End();


		}

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
	}
	else if ( m_state == INIT_SYSTEM )
	{
		char tmpfilename[MAX_PATH] ;
		FILE *inifile ;

		InitializeWithScreen() ;
		m_bMappingB = m_bMappingSTART = m_bMappingBLACK = m_bMappingWHITE = 0 ;

		strcpy( tmpfilename, g_savePath ) ;
		strcat( tmpfilename, PLATFORM_SPEC_INI ) ;
		inifile = fopen( tmpfilename, "rb" ) ;
		if ( inifile )
		{
			fread( &m_bMappingB, sizeof(m_bMappingB), 1, inifile ) ;
			fread( &m_bMappingBLACK, sizeof(m_bMappingBLACK), 1, inifile ) ;
			fread( &m_bMappingWHITE, sizeof(m_bMappingWHITE), 1, inifile ) ;
			fread( &m_bMappingSTART, sizeof(m_bMappingSTART), 1, inifile ) ;
			fclose( inifile ) ;
		}

	}
	else if ( m_state == INIT_SYSTEM_SHOW_SCREEN )
	{
	}
	else
	{
	}



    return S_OK;
}

/**
  This routine should be called regularly to handle events
*/

int CXBoxSample::doMouse( int port)
{
	//xbinput_getinput already called


	writexbox("readingmouse" ) ;

	if ( m_mouseX < 0 )
		m_mouseX = 0 ;
	if ( m_mouseY < 0 )
		m_mouseY = 0 ;
	if ( m_mouseX > 255 )
		m_mouseX = 255 ;
	if ( m_mouseY > 211 )
		m_mouseY = 211 ;

	return (m_mouseY<<8) |  m_mouseX ;
	
}

int CXBoxSample::handleEvents()
{
	char xmsg[100] ;

	static int whichbit = 0 ;
	static int whichbyte = 0 ;

	XINPUT_DEBUG_KEYSTROKE   keystroke ;

	updateCheats() ;

	int retval ;
	byte *whichjoy ;


	retval = 0 ;

	XBInput_GetInput();

	for ( int i = 0 ; i < 2 ; i++ )
	{
		if ( i == 0 )
			whichjoy = &JoyStateA ;
		else
			whichjoy = &JoyStateB ;

		if(g_Gamepads[i].hDevice)
		{
			if ( g_Gamepads[i].fX1 )
			{
				m_mouseX += ( g_Gamepads[i].fX1 * 25.0 ) ;
			}
			if ( g_Gamepads[i].fY1 )
			{
				m_mouseY += ( g_Gamepads[i].fY1 * 25.0 ) ;
			}

			if ( g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_Y]) 
			{
				m_state = IN_GAME_PAUSED ;
				m_sound.pause( TRUE ) ;
				m_mp3player.pause( TRUE ) ;
				m_dwStartPause = GetTickCount();
				doCheatMenu() ;

				if ( m_state == MAIN_MENU )
				{
					retval = 1 ;
				}
			}

			if ( g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_B]) 
			{
				//KeyMap[whichbyte] |= ( 1 << whichbit ) ;
				//sprintf(xmsg, "down mp=%u, vk[mb].keynum=%u, keys[vk[mb]].pos=%u, mask=%u\r\n", m_bMappingB,
					//validKeys[m_bMappingB].keynum, Keys[validKeys[m_bMappingB].keynum].Pos, Keys[validKeys[m_bMappingB].keynum].Mask ) ;
				//writexbox(xmsg) ;
				KeyMap[Keys[validKeys[m_bMappingB].keynum].Pos] &= ~(Keys[validKeys[m_bMappingB].keynum].Mask);
			}
			else
			{
				//sprintf(xmsg, "up mp=%u, vk[mb].keynum=%u, keys[vk[mb]].pos=%u, mask=%u\r\n", m_bMappingB,
					//validKeys[m_bMappingB].keynum, Keys[validKeys[m_bMappingB].keynum].Pos, Keys[validKeys[m_bMappingB].keynum].Mask ) ;
				//writexbox(xmsg) ;
				KeyMap[Keys[validKeys[m_bMappingB].keynum].Pos]|=Keys[validKeys[m_bMappingB].keynum].Mask;

			}

			if ( (g_Gamepads[i].hDevice && g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_WHITE]) )
			{
				KeyMap[Keys[validKeys[m_bMappingWHITE].keynum].Pos]&=~Keys[validKeys[m_bMappingWHITE].keynum].Mask;
			}
			else
			{
				KeyMap[Keys[validKeys[m_bMappingWHITE].keynum].Pos]|=Keys[validKeys[m_bMappingWHITE].keynum].Mask;
			}

			if ( (g_Gamepads[i].hDevice && g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_BLACK]) )
			{
				KeyMap[Keys[validKeys[m_bMappingBLACK].keynum].Pos]&=~Keys[validKeys[m_bMappingBLACK].keynum].Mask;
			}
			else
			{
				KeyMap[Keys[validKeys[m_bMappingBLACK].keynum].Pos]|=Keys[validKeys[m_bMappingBLACK].keynum].Mask;
			}

			if ( g_Gamepads[i].wButtons & XINPUT_GAMEPAD_START )  
			{
				KeyMap[Keys[validKeys[m_bMappingSTART].keynum].Pos]&=~Keys[validKeys[m_bMappingSTART].keynum].Mask;
			}
			else
			{
				KeyMap[Keys[validKeys[m_bMappingSTART].keynum].Pos]|=Keys[validKeys[m_bMappingSTART].keynum].Mask;
			}
			
			if ( ( g_Gamepads[i].hDevice && g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && 
				 (g_Gamepads[i].hDevice && g_Gamepads[i].bPressedAnalogButtons[XINPUT_GAMEPAD_WHITE]) )
			{
				retval = 3 ;
			}
			else if ( ( g_Gamepads[i].hDevice && g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && 
				 (g_Gamepads[i].hDevice && g_Gamepads[i].bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK]) )
			{
				retval = 2 ;
			}
	
			if ( g_Gamepads[i].bAnalogButtons[ XINPUT_GAMEPAD_A ] ) 
				*whichjoy |= 0x10 ;
			else
				*whichjoy &= 0xEF ;

			if ( g_Gamepads[i].bAnalogButtons[ XINPUT_GAMEPAD_X ] ) 
				*whichjoy |= 0x20 ;
			else
				*whichjoy &= 0xDF ;

			if ( g_Gamepads[i].wButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
				*whichjoy |= 0x04 ;
			else
				*whichjoy &= 0xFB ;

			if ( g_Gamepads[i].wButtons & XINPUT_GAMEPAD_DPAD_UP ) 
				*whichjoy |= 0x01 ;
			else
				*whichjoy &= 0xFE ;

			if ( g_Gamepads[i].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
				*whichjoy |= 0x08 ;
			else
				*whichjoy &= 0xF7 ;

			if ( g_Gamepads[i].wButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
				*whichjoy |= 0x02 ;
			else
				*whichjoy &= 0xFD ;

			if ( g_Gamepads[i].wPressedButtons & XINPUT_GAMEPAD_BACK )  
				retval = 4 ;

			if ( g_Gamepads[i].fX2 )
			{
				m_sound.adjust_volume( (int) ( g_Gamepads[i].fX2 * 25.0 ) ) ;
			}
			if ( g_Gamepads[i].fY2 )
			{
				m_mp3player.adjust_volume( (int) ( g_Gamepads[i].fY2 * 25.0 ) ) ;
			}
		
		}
	}

	if ( ( g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) ||
		 ( g_Gamepads[1].hDevice && g_Gamepads[1].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) )
	{
		g_throttle = 1 ;

	}
	else
	{
		g_throttle = 0 ;
	}


	while( ERROR_SUCCESS == XInputDebugGetKeystroke( &keystroke ) )
	{
		if ( keystroke.Flags & XINPUT_DEBUG_KEYSTROKE_FLAG_KEYUP )
		{
			for(int I=0;Keys[I].Code;I++)
			{
				if(Keys[I].Code==keystroke.VirtualKey) 
				{
					KeyMap[Keys[I].Pos]|=Keys[I].Mask;
					keyboard_keystate[keystroke.VirtualKey] = 0 ;
					break ;
				}
			}
		}
		else
		{
			if ( keystroke.Flags & XINPUT_DEBUG_KEYSTROKE_FLAG_REPEAT )
			{
				if ( keyboard_keystate[keystroke.VirtualKey] == 1 )
				{
					for(int I=0;Keys[I].Code;I++)
					{
						if(Keys[I].Code==keystroke.VirtualKey) 
						{
							KeyMap[Keys[I].Pos]&=~Keys[I].Mask;
							keyboard_keystate[keystroke.VirtualKey] = 1 ;
							break ;
						}
					}
				}
			}
			else
			{
				for(int I=0;Keys[I].Code;I++)
				{
					if(Keys[I].Code==keystroke.VirtualKey) 
					{
						KeyMap[Keys[I].Pos]&=~Keys[I].Mask;
						keyboard_keystate[keystroke.VirtualKey] = 1 ;
						break ;
					}
				}
			}
		}


	}

	return retval ;
}

/*
int ReadJoypad( int port )
{

	int value ;
	char xmsg[100] ;


	value = 0 ;
#define	JOY_A		0x01
#define	JOY_B		0x02
#define	JOY_SELECT	0x04
#define	JOY_START	0x08
#define	JOY_UP		0x10
#define	JOY_RIGHT	0x20
#define	JOY_DOWN	0x40
#define	JOY_LEFT	0x80
#define JOY_AUTOI	0x100
#define JOY_AUTOII	0x200

	updateCheats() ;

	XBInput_GetInput();

	if ( g_Gamepads[port].hDevice )
	{

		if ( g_Gamepads[port].bAnalogButtons[ XINPUT_GAMEPAD_A ] ) 
			value |= JOY_A ;
		if ( g_Gamepads[port].bAnalogButtons[ XINPUT_GAMEPAD_X ] ) 
			value |= JOY_B ;
		if ( g_Gamepads[port].wButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
			value |= JOY_LEFT ;
		if ( g_Gamepads[port].wButtons & XINPUT_GAMEPAD_DPAD_UP ) 
			value |= JOY_UP ;
		if ( g_Gamepads[port].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
			value |= JOY_RIGHT ;
		if ( g_Gamepads[port].wButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
			value |= JOY_DOWN ;
		if ( g_Gamepads[port].wButtons & XINPUT_GAMEPAD_START )  
			value |= JOY_START ;
		if ( g_Gamepads[port].wButtons & XINPUT_GAMEPAD_BACK )  
			value |= JOY_SELECT ;

		if ( g_Gamepads[port].bPressedAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER])
		{
			//bkgHalt = bkgHalt ^ 1 ;
		}

		if ( ( g_Gamepads[port].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && 
			 (g_Gamepads[port].bPressedAnalogButtons[XINPUT_GAMEPAD_WHITE]) )
		{
			loadgame() ;
		}
		else if ( ( g_Gamepads[port].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && 
			 (g_Gamepads[port].bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK]) )
		{
			savegame() ;
		}

		//sprintf( xmsg, "x=%d,y=%d,x=%d,y=%d\r\n", g_Gamepads[port].sThumbRX, g_Gamepads[port].sThumbRX, g_Gamepads[port].fX2, g_Gamepads[port].fY2 ) ;

		if ( g_Gamepads[port].fX2 )
		{
			m_sound.adjust_volume( (int) ( g_Gamepads[port].fX2 * 25.0 ) ) ;
		}
		if ( g_Gamepads[port].fY2 )
		{
			m_mp3player.adjust_volume( (int) ( g_Gamepads[port].fY2 * 25.0 ) ) ;
		}
	
	}

	return value ;
}

*/




void CXBoxSample::initConsole( UINT32 idx, int msxsystem, int rotate  )
{
	char                filename[500] ;
	char systemcard[200] ;
	char *disks[32] ;
	int  numdisks ;

	Keyboard_Init( 32, 400, 150 )  ;
	memset(keyboard_keystate, 0, 256 ) ;

	global_error_message[0] = 0 ;

	m_numFrames = 0 ;
	m_droppedFrames = 0 ;
//	soundChannels = 0xFF ;
//	bkgHalt = 0 ;

	m_mouseX = m_mouseY = 0 ;

	memset( m_memMatches, 1, CONSOLE_MEMORY_SIZE ) ;
	m_currentMemMatches = CONSOLE_MEMORY_SIZE ;
	m_numCheats = 0 ;
	g_throttle = 0 ;

	//writexbox( "init1" ) ;



	strcpy((char*)filename, "D:\\msxroms\\" ) ;
	//wcsrtombs( (char*)gfilename, (const wchar_t**)(&(files[idx].name)), 100, NULL ) ;
	strcat( (char*)filename, (const char*)files[idx].filename ) ;


	strcpy( g_cuefile, "" ) ;

	if (strstr (strupr(filename), ".MP3"))
	{
		if ( m_mp3player.loadFile( filename, 1, 0, 70*60*75 ) )
		{
			//writexbox( "nonomp3\r\n") ;
		}
		else
		{
			m_mp3player.insertSilence( 22050 ) ;
			m_mp3player.pause( FALSE ) ;
			m_state = MAIN_MENU ;
			return  ;
		}
	}

	char *p;

	numdisks = 0 ;

	for ( int i = 0 ; i < numfiles ; i++ )
	{
		if ( files[i].flagged )
		{
			disks[numdisks] = (char*)malloc( MAX_PATH ) ;
			strcpy((char*)disks[numdisks], "D:\\msxroms\\" ) ;
			strcat( (char*)disks[numdisks], (const char*)files[i].filename ) ;
			numdisks++ ;
			if ( numdisks > 31 )
				break ;
		}
	}

	//writexbox( "init1" ) ;

	strcpy( g_saveprefix, g_savePath ) ;
	strcat( g_saveprefix, "\\" ) ;
	strcat( g_saveprefix, strrchr( filename, '\\' )+1 ) ;
	//sprintf(saveprefix, "%s\\%s", savedir, (const char*)files[idx].filename);
	p = strchr(g_saveprefix, '.');
	if (p) *p = 0;

	strcpy(g_sramfile, g_saveprefix);
	strcat(g_sramfile, ".sav");

	strcpy(g_chtfile, g_saveprefix);
	strcat(g_chtfile, ".cht");

	sprintf( g_statefile, "%s.sta", g_saveprefix ) ;

//	nonoise = 0 ;
	
	//writexbox( "init1" ) ;

	m_sound.init() ;
	//m_mp3player.init() ;

	//writexbox( "init1" ) ;
	cht_load() ;
	//writexbox( "init1" ) ;

	// Create our texture
	init_texture();

	//writexbox( "init1" ) ;

	// Create our sprite driver
	if ( Sprite == NULL )
		D3DXCreateSprite(m_pd3dDevice, &Sprite);
	
	//writexbox( "init1" ) ;





	m_fAppTime = 0.0f ;

	g_dwStartTime = GetTickCount() ;
	g_dwTimePaused = 0 ;
	m_dwStartPause = 0 ;


	//writexbox( "init4" ) ;
	//Then start it up

	//m_sound.insertSilence( 22050 ) ;
	m_sound.pause( FALSE ) ;
	//m_mp3player.insertSilence( 22050 ) ;
	//m_mp3player.pause( FALSE ) ;

	if ( numdisks )
	{
		if (strstr (strupr(filename), ".DSK"))
		{
			strcpy( filename, disks[0] ) ;

			strcpy( g_saveprefix, g_savePath ) ;
			strcat( g_saveprefix, "\\" ) ;
			strcat( g_saveprefix, strrchr( filename, '\\' )+1 ) ;
			//sprintf(saveprefix, "%s\\%s", savedir, (const char*)files[idx].filename);
			p = strchr(g_saveprefix, '.');
			if (p) *p = 0;

			strcpy(g_sramfile, g_saveprefix);
			strcat(g_sramfile, ".sav");

			strcpy(g_chtfile, g_saveprefix);
			strcat(g_chtfile, ".cht");

			sprintf( g_statefile, "%s.sta", g_saveprefix ) ;
		}
		else if (!strstr (strupr(filename), ".ROM"))
		{
			strcpy( filename, "D:\\MSXROMS\\CARTA.ROM" ) ;
		}
	}

	//writexbox( "init5" ) ;
	//fmsxmain( msxsystem, g_statefile, g_sramfile, filename, NULL, (m_steps++)%8, disks, numdisks ) ;

	if ( rotate )
		fmsxmain( msxsystem, g_statefile, g_sramfile, filename, NULL, (m_steps++)%8, disks, numdisks ) ;
	else
		fmsxmain( msxsystem, g_statefile, g_sramfile, filename, NULL, 0, disks, numdisks ) ;

	for ( int i = 0 ; i < numdisks ; i++ )
	{
		free( disks[i] ) ;
	}

	//writexbox( "initout" ) ;
	m_state=MAIN_MENU ;

	//put 3 frames of data in the audio buffer
	//processEmu(FALSE) ;
	//processEmu(FALSE) ;
	//processEmu(FALSE) ;


}

void CXBoxSample::cleanupConsole( )
{
	//sram_save();
	//rtc_save();
	cht_save() ;


	if (m_cheatCodes != NULL)
	{
		free(m_cheatCodes);
		m_cheatCodes = NULL;
	}


}



#ifdef __cplusplus
extern "C" {
#endif

void xbox_set_memory( byte *ptr ) 
{
	g_app->m_consoleMemory = ptr ;
}


int xbox_mouse( int port ) 
{
	return g_app->doMouse( port ) ;
}

int xbox_getThrottle() 
{
	return g_throttle ;
}

void xbox_put_message( char *message ) 
{
	WCHAR msg[2000] ;

	//swprintf( msg, L"%S", message );

		//g_app->m_Font.Begin();
		//g_app->m_Font.DrawText( (float)g_app->m_nXOffset+  32, 16*2, 0xffffffff, msg );
		//g_app->m_Font.End();
}

int xbox_read_input(int port) 
{
	//writexbox( "before readinput") ;
	//return g_app->ReadJoypad( port ) ;
	//writexbox( "after readinput") ;
	return 0 ;
}

int xbox_check_events()
{
	//writexbox( "before events") ;
	g_mp3player->process() ;
	return g_app->handleEvents() ;
	//writexbox( "after events") ;
	return 0 ;
}

void xbox_put_image( char* msg)
{
	//writexbox( "before render") ;
	g_sound->process() ;
	g_mp3player->process() ;
	//g_mp3player->process() ;
	g_app->render_to_texture(msg) ;
	//writexbox( "after render") ;
}
unsigned int xbox_GetTicks() 
{
	return GetTickCount() ;
}

void xbox_open_zip( char *hugozipfile )
{
	//writexbox( "before zip") ;
	//g_app->rom_load_zip( hugozipfile ) ;
	//writexbox( "after zip") ;
}

#ifdef __cplusplus
}
#endif

void CXBoxSample::processEmu( BOOL render )
{
			
			handleEvents();
			updateCheats() ;


//			doneFrame = 0 ;

			//m_nbytes = update_sound_main() ;



			if ( render )
			{
				render_to_texture( NULL );
				m_numFrames++ ;
			}


//			m_droppedFrames += m_sound.process( (byte**)sbuf, m_nbytes, soundChannels ) ;

			while ( m_sound.m_bDanger )
			{
				handleEvents();
				updateCheats() ;
//				doneFrame = 0 ;
				//m_nbytes = update_sound_main() ;


				//m_droppedFrames += m_sound.process( (byte**)sbuf, m_nbytes, soundChannels ) ;
			}



}


int CXBoxSample::rom_load_zip( char *hugozipfile )
{
	byte *data ;
	int len = 0;

	//writexbox( "ttt\r\n" ) ;
    unzFile file = unzOpen(hugozipfile);

    if(file == NULL)
		return 0 ;

	//writexbox( "ttt\r\n" ) ;

    char filename[132];
    int filesize = 0;
    int port = unzGoToFirstFile(file);
    unz_file_info info;

	//writexbox( "ttt\r\n" ) ;
    while(port == UNZ_OK)
    {
		char name[132];
		unzGetCurrentFileInfo(file, &info, name,128, NULL,0, NULL,0);

		if ((int) info.uncompressed_size > filesize)
		{
			strcpy(filename,name);
			filesize = info.uncompressed_size;
		}
		port = unzGoToNextFile(file);
    }

	//writexbox( "ttt\r\n" ) ;
    if( !(port == UNZ_END_OF_LIST_OF_FILE || port == UNZ_OK) || filesize == 0)
    {
		unzClose(file) ;
		return 0 ;
    }
	//writexbox( "ttt\r\n" ) ;

    unzLocateFile(file,filename,1);
    unzGetCurrentFileInfo(file, &info, filename,128, NULL,0, NULL,0);
    
	//writexbox( "ttt\r\n" ) ;
    if( unzOpenCurrentFile(file) != UNZ_OK )
    {
		unzClose(file);
		return 0 ;
    }

	//writexbox( "ttt\r\n" ) ;

	data = (byte*)malloc( info.uncompressed_size ) ;

	//writexbox( "ttt\r\n" ) ;

	int l = unzReadCurrentFile(file,data,info.uncompressed_size);
	if(unzCloseCurrentFile(file) == UNZ_CRCERROR)
	{
		free(data) ;
	    unzClose(file);
		return 0 ;
	}

	//writexbox( "ttt\r\n" ) ;
    unzClose(file);

/*
	fsize = ftell (fp);

	fseek (fp, fsize & 0x1fff, SEEK_SET);
	fsize &= ~0x1fff;

	ROM = (UChar *) malloc (fsize);
	ROM_size = fsize / 0x2000;
	fread (ROM, 1, fsize, fp);
*/

	filesize = info.uncompressed_size ;
	filesize &= ~0x1fff;  //524288  524800

	//writexbox( "ttt\r\n" ) ;

	//ROM = (UChar *) malloc (filesize);
	//ROM_size = filesize / 0x2000;
	//memcpy(ROM, data + (info.uncompressed_size & 0x1fff), filesize ) ;

	free(data) ;

	//writexbox( "ttt\r\n" ) ;

	return 1;
}

