
#include "app.h"
#include <crtdbg.h>

HWND FrameWnd=NULL;

int MainWidth=640,MainHeight=480;

char AppName[]="ZsnexBox";

// ------------------------------------ XBox Main ------------------------------------------
#ifdef _XBOX

int MainCode()
{
  int ret=0;

  ret=LoopInit(); if (ret) { LoopExit(); return 1; }

  LoopQuit=0; LoopCode();
  LoopExit();

  return 0;
}

int __cdecl main()
{
  LD_LAUNCH_DASHBOARD launch;

  MainCode();

  // Go back to dashboard:
  memset(&launch,0,sizeof(launch));
  launch.dwReason=XLD_LAUNCH_DASHBOARD_MAIN_MENU;
  XLaunchNewImage(NULL,(LAUNCH_DATA *)&launch);
}
#endif

// ----------------------------------- Windows Main ----------------------------------------
#ifndef _XBOX
// Window proc for the frame window:
static LRESULT CALLBACK WndProc(HWND hwnd,UINT msg,WPARAM wparam,LPARAM lparam)
{
  if (msg==WM_CLOSE) { PostQuitMessage(0); return 0; }
  if (msg==WM_DESTROY) FrameWnd=NULL; // Blank handle

  return DefWindowProc(hwnd,msg,wparam,lparam);
}

static int FrameInit()
{
  WNDCLASS wc;
  RECT rect={0,0,0,0};
  int style=0;
  int left=0,top=0,width=0,height=0;

  memset(&wc,0,sizeof(wc));

  // Register the window class:
  wc.lpfnWndProc=WndProc;
  wc.hInstance=GetModuleHandle(NULL);
  wc.hCursor=LoadCursor(NULL,IDC_ARROW);
  wc.hbrBackground=CreateSolidBrush(0);
  wc.lpszClassName="MainFrame";
  RegisterClass(&wc);

  rect.right =MainWidth;
  rect.bottom=MainHeight;

  // Adjust size of windows based on borders:
  style=WS_OVERLAPPEDWINDOW;
  AdjustWindowRect(&rect,style,0);
  width =rect.right-rect.left;
  height=rect.bottom-rect.top;

  // Place window in the centre of the screen:
  SystemParametersInfo(SPI_GETWORKAREA,0,&rect,0);
  left=rect.left+rect.right;
  top=rect.top+rect.bottom;

  left-=width; left>>=1;
  top-=height; top>>=1;

  // Create the window:
  FrameWnd=CreateWindow(wc.lpszClassName,AppName,style|WS_VISIBLE,
    left,top,width,height,NULL,NULL,NULL,NULL);

  return 0;
}

// --------------------

static DWORD WINAPI ThreadCode(void *)
{
  LoopCode();
  ExitThread(0);
  return 0;
}

int WINAPI WinMain(HINSTANCE,HINSTANCE,LPSTR,int)
{
  MSG msg;
  int ret=0;
  DWORD tid=0;
  HANDLE thread=NULL;

  memset(&msg,0,sizeof(msg));

  FrameInit();
  ret=LoopInit(); if (ret) { LoopExit(); return 1; }

  // Make another thread to run LoopCode():
  LoopQuit=0;
  thread=CreateThread(NULL,0,ThreadCode,NULL,0,&tid);

  // Main window loop:
  for (;;)
  {
    GetMessage(&msg,NULL,0,0);
    if (msg.message==WM_QUIT) break;

    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }

  // Signal thread to quit and wait for it to exit:
  LoopQuit=1; WaitForSingleObject(thread,1000);
  CloseHandle(thread); thread=NULL;

  LoopExit();
  DestroyWindow(FrameWnd);

  _CrtDumpMemoryLeaks();
  return 0;
}
#endif

