#include "MusicManager.h"
#include "dsstdfx.h"

extern float BGVol;
extern bool getPlaying();
extern int inGame;

extern bool videoRender;
LPDIRECTSOUND8  m_pDSound = NULL;          // DirectSound object
static CMusicManager*  m_pMusicManager;    // Music Manager

void pauseMusic() {
	if(m_pMusicManager)
		m_pMusicManager->Pause();	
}

void resumeMusic() {
	if(videoRender)
		return;
	if(m_pMusicManager)
		m_pMusicManager->Play();
}

void switchSongs() {
	if(m_pMusicManager)
		m_pMusicManager->changeTrack(false);
}

float getVolume() {
	return m_pMusicManager->GetVolume();
}
void setVolume() {
	if(videoRender)
		return;
	if(BGVol > 0) BGVol = 0;
	if(BGVol < -5000) BGVol = -5000;
	if(m_pMusicManager)
		m_pMusicManager->SetVolume(BGVol); 
}

void resetThemeSong() {
	if(m_pMusicManager)
		m_pMusicManager->changeTrack(true);
	//m_pMusicManager->Initialize();
}

int initMusic() {

	m_pMusicManager = NULL;

	if( FAILED( DirectSoundCreate( NULL, &m_pDSound, NULL ) ) )
		return E_FAIL;

	// download the standard DirectSound effects image
	DSEFFECTIMAGELOC EffectLoc;
	EffectLoc.dwI3DL2ReverbIndex = GraphI3DL2_I3DL2Reverb;
	EffectLoc.dwCrosstalkIndex   = GraphXTalk_XTalk;
	if( FAILED( XAudioDownloadEffectsImage( "d:\\media\\dsstdfx.bin", 
		&EffectLoc, 
		XAUDIO_DOWNLOADFX_EXTERNFILE, 
		NULL ) ) )
		return E_FAIL;

	// Create MusicManager
	m_pMusicManager = new CMusicManager();
	if( !m_pMusicManager ) {
		return E_OUTOFMEMORY;
	}

	// Initialize MusicManager
	if( FAILED( m_pMusicManager->Initialize() ) ) {
		

		return E_FAIL;
	}

	m_pMusicManager->SetVolume( BGVol );
	//m_pMusicManager->Play();

	//m_pMusicManager->m_dwStream.SetMixBins(&dsmb); 
	return S_OK;
}

//-----------------------------------------------------------------------------
// Name: FrameMove()
// Desc: Performs per-frame updates
//-----------------------------------------------------------------------------

void updateSound()
{
	if(videoRender || inGame == 1)
		return;
	FLOAT fVolume = m_pMusicManager->GetVolume();
	//fVolume += 2000 * m_DefaultGamepad.fY1 * m_fElapsedTime;
	if( fVolume < DSBVOLUME_MIN )
		fVolume = DSBVOLUME_MIN;
	if( fVolume > DSBVOLUME_MAX )
		fVolume = DSBVOLUME_MAX;
	m_pMusicManager->SetVolume( fVolume );


	DirectSoundDoWork();
	m_pMusicManager->Process();
}