
#include "app.h"


// ----------------------------------------------------------------------------------
#ifdef _XBOX

#define XFONT_TRUETYPE 

#include <xfont.h>

class CTitleFontRenderer
{
public:
	CTitleFontRenderer() { m_pXFont = NULL;  };
    ~CTitleFontRenderer() { if( m_pXFont ) { m_pXFont->Release(); } };
    STDMETHODIMP_(ULONG)Release() { delete this; return 0; };
    STDMETHODIMP OpenFont( LPCWSTR pszFont ) {
        return XFONT_OpenTrueTypeFont( pszFont, 0x10000, &m_pXFont );
    };
    STDMETHODIMP DrawText( LPCWSTR pText, DWORD X, DWORD Y, DWORD MaxWidth ) {
        if( MaxWidth > 0 ) {
            D3DRECT r = { X, Y, X + MaxWidth, Y + 200 };
            m_pXFont->SetClippingRectangle( &r );
        }
        return m_pXFont->TextOut( DirectBack, pText, -1, X, Y );
    };
    STDMETHODIMP GetTextSize( LPCWSTR pText, DWORD *pWidth, DWORD *pHeight ) {
        *pHeight = m_pXFont->GetTextHeight();
        return m_pXFont->GetTextExtent( pText, -1, (UINT *)pWidth );
    };
    STDMETHODIMP SetColor( D3DCOLOR Color ) {
        m_pXFont->SetTextColor( Color );
        return S_OK;
    };
    STDMETHODIMP SetHeight( DWORD Height ) {
        return m_pXFont->SetTextHeight( Height );
    };

private:
    XFONT *m_pXFont;
};


CTitleFontRenderer ctfr;





XFONT *Font=NULL;

int FontInit()
{
  ctfr.OpenFont( L"d:\\media\\FRADM.TTF" );

  XFONT_OpenDefaultFont(&Font); if (Font==NULL) return 1;

  return 0;
}

void FontExit()
{
}

int FontSetColour(unsigned int colour)
{
  ctfr.SetColor(colour); 
  //Font->SetTextColor(colour);
  return 0;
}

int FontText(WCHAR *text,int dx,int dy, int maxWidth)
{
  if (Font==NULL || DirectBack==NULL) return 1;

  ctfr.DrawText(text, dx, dy, maxWidth); 
  //Font->TextOut(DirectBack,text,~0U,dx,dy);
  return 0;
}

#endif


// ----------------------------------------------------------------------------------
#ifndef _XBOX

ID3DXFont *Font=NULL;
unsigned int FontColour=0;

int FontInit()
{
  LOGFONT lf;

  memset(&lf,0,sizeof(lf));
  strcpy(lf.lfFaceName,"Arial");
  lf.lfHeight=16;
  D3DXCreateFontIndirect(Device,&lf,&Font);

  return 0;
}

void FontExit()
{
  RELEASE(Font);
}

int FontSetColour(unsigned int colour)
{
  FontColour=0xff000000|colour;
  return 0;
}

int FontText(WCHAR *text,int dx,int dy)
{
  RECT rect={0,0,0,0};

  if (Font==NULL || DirectBack==NULL) return 1;

  Font->Begin();
  rect.left=dx;
  rect.top=dy;
  rect.right=MainWidth;
  rect.bottom=MainHeight;

  Font->DrawTextW(text,-1,&rect,DT_LEFT,FontColour);
  Font->End();

  return 0;
}

#endif
