bool useNoRom = true;
#include "app.h"

IDirect3D8 *Direct3D=NULL;
IDirect3DDevice8 *Device=NULL;
IDirect3DSurface8 *DirectBack=NULL; // Back Buffer

  float nudgex=0.0f,nudgey=0.0f;
IDirect3DVertexBuffer8 *VertexBuffer=NULL;
IDirect3DVertexBuffer8 *VertexBufferPreview=NULL;
IDirect3DVertexBuffer8 *VertexBufferLinear=NULL;
IDirect3DVertexBuffer8 *VertexBufferResize=NULL;

float leftX = 0;
float rightX = 0;
float topY = 0;
float bottomY = 0;
int nFilter = 0;


#define D3DFVF_CUSTOMVERTEX (D3DFVF_XYZ|D3DFVF_DIFFUSE|D3DFVF_TEX1)

CustomVertex VertexList[4];
CustomVertex VertexListPreview[4];
CustomVertex VertexListLinear[4];
CustomVertex VertexListResize[4];
extern int screenResize;
void DirectExit()
{
  FontExit();
  TexScreenExit();

  RELEASE(VertexBuffer)
	  RELEASE(VertexBufferPreview)
	  RELEASE(VertexBufferLinear)
	  RELEASE(VertexBufferResize)
  RELEASE(DirectBack)
  RELEASE(Device)
  RELEASE(Direct3D)
}


extern float zTop;
extern float zLeft;
extern float zRight;
extern float zBottom;
void makeVertexListResize() {
  rightX = -0.3f;//-2.7999999f;
  leftX = 0.5f;//2.999999f;
  topY = -1.3f;//-4.0f;
  bottomY = 1.3f;//4.0f;
  scaleZ = -0.9f;
	
	struct CustomVertex *vert=NULL,*pv=NULL;
  float dist=0.0f;
  float scalex=0.0f,scaley=0.0f;
  unsigned int colour=0xffffff;
  float right=0.0f,bottom=0.0f;


  //if (LoopMode!=8) colour=0x102040;

  dist=10.0; scalex=dist*1.3333f; scaley=dist;

  //scalex*=640.0f/(float)640;
  //scaley*=480.0f/(float)480;


  dist += scaleZ;
  
  vert=VertexListResize;

  // Put the vertices for the corners of the screen:
  
  
  
  pv=vert;
  pv->z=dist;
  pv->x=-scalex + leftX + zLeft; pv->y=scaley + topY + zTop;
  pv->colour=colour; pv++;

  *pv=vert[0]; pv->x= scalex + rightX + zRight; pv->y= scaley + topY + zTop; pv++;
  *pv=vert[0]; pv->x=-scalex + leftX + zLeft; pv->y=-scaley + bottomY + zBottom; pv++;
  *pv=vert[0]; pv->x= scalex + rightX + zRight; pv->y=-scaley + bottomY + zBottom; pv++;

  // Find where the screen images ends on the texture
  right = 1.0f;//(float)EmuWidth /(float)TexWidth;
  bottom= 1.0f;//(float)EmuHeight/(float)TexHeight;

  // Write texture coordinates:
  pv=vert;
  pv->u=0.0f;  pv->v=0.00f;  pv++;
  pv->u=right; pv->v=0.00f;  pv++;
  pv->u=0.0f;  pv->v=bottom; pv++;
  pv->u=right; pv->v=bottom; pv++;

}

void makeVertexListLinear() {
  rightX = -0.3f;//-2.7999999f;
  leftX = 0.5f;//2.999999f;
  topY = -1.3f;//-4.0f;
  bottomY = 1.3f;//4.0f;
  scaleZ = -0.9f;
	
	struct CustomVertex *vert=NULL,*pv=NULL;
  float dist=0.0f;
  float scalex=0.0f,scaley=0.0f;
  unsigned int colour=0xffffff;
  float right=0.0f,bottom=0.0f;


  //if (LoopMode!=8) colour=0x102040;

  dist=10.0; scalex=dist*1.3333f; scaley=dist;

  //scalex*=640.0f/(float)640;
  //scaley*=480.0f/(float)480;


  dist += scaleZ;
  
  vert=VertexListLinear;

  // Put the vertices for the corners of the screen:
  
  
  
  pv=vert;
  pv->z=dist;
  pv->x=-scalex + leftX + zLeft; pv->y=scaley + topY + zTop;
  pv->colour=colour; pv++;

  *pv=vert[0]; pv->x= scalex + rightX + zRight; pv->y= scaley + topY + zTop; pv++;
  *pv=vert[0]; pv->x=-scalex + leftX + zLeft; pv->y=-scaley + bottomY + zBottom; pv++;
  *pv=vert[0]; pv->x= scalex + rightX + zRight; pv->y=-scaley + bottomY + zBottom; pv++;

  // Find where the screen images ends on the texture
  right = 640.0f;//(float)EmuWidth /(float)TexWidth;
  bottom= 480.0f;//(float)EmuHeight/(float)TexHeight;

  // Write texture coordinates:
  pv=vert;
  pv->u=0.0f;  pv->v=0.00f;  pv++;
  pv->u=right; pv->v=0.00f;  pv++;
  pv->u=0.0f;  pv->v=bottom; pv++;
  pv->u=right; pv->v=bottom; pv++;

}



int MakeVertexList()
{
  rightX = -2.7999999f;
  leftX = 2.999999f;
  topY = -2.0f;
  bottomY = 2.0f;
  scaleZ = -0.9f;

  struct CustomVertex *vert=NULL,*pv=NULL;
  float dist=0.0f;
  float scalex=0.0f,scaley=0.0f;
  unsigned int colour=0xffffff;
  float right=0.0f,bottom=0.0f;

  //if (LoopMode!=8) colour=0x102040;

  dist=10.0; scalex=dist*1.3333f; scaley=dist;

  //scalex*=640.0f/(float)640;
  //scaley*=480.0f/(float)480;


  dist += scaleZ;
  
  vert=VertexList;

  // Put the vertices for the corners of the screen:
  
  
  
  pv=vert;
  pv->z=dist;
  pv->x=-scalex + leftX; pv->y=scaley + topY;
  pv->colour=colour; pv++;

  *pv=vert[0]; pv->x= scalex + rightX; pv->y= scaley + topY; pv++;
  *pv=vert[0]; pv->x=-scalex + leftX; pv->y=-scaley + bottomY; pv++;
  *pv=vert[0]; pv->x= scalex + rightX; pv->y=-scaley + bottomY; pv++;

  // Find where the screen images ends on the texture
  right = 1;//(float)EmuWidth /(float)TexWidth;
  bottom= 1;//(float)EmuHeight/(float)TexHeight;

  // Write texture coordinates:
  pv=vert;
  pv->u=0.0f;  pv->v=0.00f;  pv++;
  pv->u=right; pv->v=0.00f;  pv++;
  pv->u=0.0f;  pv->v=bottom; pv++;
  pv->u=right; pv->v=bottom; pv++;
 


  

  //PREVIEW-----------------------------------------------------------
  dist=10.0f; scalex=dist*1.3333f; scaley=dist;
  vert=VertexListPreview;

  dist += 1.5;//scaleZ2;
  //dist += scaleZ;
  // Put the vertices for the corners of the screen:
  pv=vert;
  
  pv->z=dist;
  pv->x= -0.1f + 0.2f; 
  pv->y=5.4f;// + topY;
  pv->colour=colour; 
  pv++;

  *pv=vert[0]; 
  pv->x= 12.1f;// + rightX; 
  pv->y= 5.4f ;//+ topY; 
  pv++;

  *pv=vert[0];
  pv->x=-0.1f + 0.2f; 
  pv->y=-4.0;// + bottomY; 
  pv++;

  *pv=vert[0]; 
  pv->x= 12.1f;// + rightX; 
  pv->y=-4.0;// + bottomY; 
  pv++;

  // Find where the screen images ends on the texture
  right = 1;//(float)EmuWidth /(float)TexWidth;
  bottom= 1;//(float)EmuHeight/(float)TexHeight;

  // Write texture coordinates:
  pv=vert;
  pv->u=0.0f;  pv->v=0.00f;  pv++;
  pv->u=right; pv->v=0.00f;  pv++;
  pv->u=0.0f;  pv->v=bottom; pv++;
  pv->u=right; pv->v=bottom; pv++;
 




  makeVertexListLinear();
  makeVertexListResize();
  return 0;
}

int DirectClear(unsigned int colour)
{
  Device->Clear(0,NULL,D3DCLEAR_TARGET,0x0,1.0f,0);
  return 0;
}

int DirectPresent()
{
  Device->Present(NULL,NULL,NULL,NULL);
#ifdef _XBOX  
  Device->SetFlickerFilter(0);
#endif
  return 0;
}

int SetupMatrices()
{
	D3DXVECTOR3 eye ( 0.0f, 0.0f, 0.0f );
  D3DXVECTOR3 look( 0.0f, 0.0f, 0.0f );
  D3DXVECTOR3 up  ( 0.0f, 1.0f, 0.0f );
  D3DXMATRIX mat;
  memset(&mat,0,sizeof(mat));
 mat.m[0][0]=mat.m[1][1]=mat.m[2][2]=mat.m[3][3]=1.0f;
  
  Device->SetTransform(D3DTS_WORLD,&mat);

  look.x=0;//(float)Inp.axis[2]/2457.6f;
  look.y=0;//(float)Inp.axis[3]/2457.6f;
  look.z=10.0f;

  // Nudge pixels to the centre of each screen pixel:
  nudgex=13.3333f/(float)(MainWidth <<1);
  nudgey=10.0000f/(float)(MainHeight<<1);
  eye.x +=nudgex; eye.y +=nudgey;
  look.x+=nudgex; look.y+=nudgey;

  D3DXMatrixLookAtLH(&mat,&eye,&look,&up);
  Device->SetTransform(D3DTS_VIEW,&mat);

  D3DXMatrixPerspectiveFovLH(&mat, 0.5f*PI, 1.3333f, 0.2f, 1000.0f);
  Device->SetTransform(D3DTS_PROJECTION,&mat);
  return 0;
}


void setTextureMode() {
	
	Device->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
	Device->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
	Device->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
	Device->SetTextureStageState( 0, D3DTSS_ALPHAOP,   D3DTOP_MODULATE );
	Device->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
	Device->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
	Device->SetTextureStageState( 1, D3DTSS_COLOROP,   D3DTOP_DISABLE );
	Device->SetTextureStageState( 1, D3DTSS_ALPHAOP,   D3DTOP_DISABLE );
	Device->SetTextureStageState( 0, D3DTSS_ADDRESSU,  D3DTADDRESS_CLAMP );
	Device->SetTextureStageState( 0, D3DTSS_ADDRESSV,  D3DTADDRESS_CLAMP );
	


	//nFilter = 1;
	

}


extern void resumeMusic();
struct CustomVertex *vertResize=NULL;
struct CustomVertex *vertScreen=NULL;
int DirectScreen()
{
  
      SetupMatrices();
	  if(screenResize == 1) {
		  unsigned char *lock=NULL;
	     setTextureMode();

		 makeVertexListResize();
		 VertexBufferResize->Lock(0,sizeof(VertexList),&lock,0); if (lock==NULL) return 1;
         memcpy(lock,VertexListResize,sizeof(VertexList));
         VertexBufferResize->Unlock();
		 
		 makeVertexListLinear();
		 VertexBufferLinear->Lock(0,sizeof(VertexList),&lock,0); if (lock==NULL) return 1;
         memcpy(lock,VertexListLinear,sizeof(VertexList));
         VertexBufferLinear->Unlock();
		 
		 Device->SetTexture(0,TexResize);
	     Device->SetStreamSource(0,VertexBufferResize,sizeof(CustomVertex));
	     Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
		 Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);


		
		    WCHAR text234567__[280]={0};
			wsprintfW(text234567__,L"Use the left and right analog sticks to resize/move the screen. "); //to get a non stretched aspect ratio");
			FontSetColour(0xffffff);
			FontText(text234567__,100,75, 600);	


			WCHAR text234567[280]={0};
			wsprintfW(text234567,L"Align the RED border with the edges of the screen "); //to get a non stretched aspect ratio");
			FontSetColour(0xffffff);
			FontText(text234567,150,175, 600);	

			WCHAR text234567_[280]={0};
			wsprintfW(text234567_,L"to get a non stretched display."); //to get a non stretched aspect ratio");
			FontSetColour(0xffffff);
			FontText(text234567_,150,200, 600);	


			WCHAR text23456[280]={0};
			wsprintfW(text23456,L"Align the BLUE border with the edges of the screen ");//to get a stretched aspect ratio");
			FontSetColour(0xffffff);
			FontText(text23456,150,250, 600);	

			WCHAR text23456_[280]={0};
			wsprintfW(text23456_,L"to get a stretched display.");//to get a stretched aspect ratio");
			FontSetColour(0xffffff);
			FontText(text23456_,150,275, 600);	


			WCHAR text2345[280]={0};
			wsprintfW(text2345,L"Press \"A\" to return to the rom browser.");
			FontSetColour(0xffff00);
			FontText(text2345,175,375, 600);	
         
		 return 0;
	  
	  }

	  





	  Device->SetTexture(0,TexMenu);
	  setTextureMode();

	  Device->SetStreamSource(0,VertexBuffer,sizeof(CustomVertex));
      Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
      Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);

	  if(useNoRom == false)
		  Device->SetTexture(0,TexPreview);
	  else
          Device->SetTexture(0,TexPreview2);

	  setTextureMode();
//D3DFVF_XYZRHW|D3DFVF_TEX1
	  Device->SetStreamSource(0,VertexBufferPreview,sizeof(CustomVertex));
	  Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
      Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
  return 0;
}

int DirectInit()
{
  D3DPRESENT_PARAMETERS d3dpp; 
  D3DDISPLAYMODE mode;
  int i=0,ret=0;

  memset(&d3dpp,0,sizeof(d3dpp));
  memset(&mode,0,sizeof(mode));

  Direct3D=Direct3DCreate8(D3D_SDK_VERSION); if (Direct3D==NULL) return 1;

  // Set up the structure used to create the D3D device:
  d3dpp.BackBufferWidth =640;
  d3dpp.BackBufferHeight=480;
  d3dpp.BackBufferCount =1;
  d3dpp.SwapEffect=D3DSWAPEFFECT_COPY;
  d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_ONE;

#ifdef _XBOX
  d3dpp.BackBufferFormat=D3DFMT_X8R8G8B8;
  d3dpp.FullScreen_RefreshRateInHz=60;
#else
  Direct3D->GetAdapterDisplayMode(D3DADAPTER_DEFAULT,&mode);
  d3dpp.BackBufferFormat=mode.Format;
  d3dpp.Windowed=1;
#endif

  // Try to create a device with hardware vertex processing:
  for (i=0;i<4;i++)
  {
    int behave=D3DCREATE_HARDWARE_VERTEXPROCESSING;

#ifdef _XBOX
    if (i==1)
    {
      // If 60Hz didn't work, try PAL 50Hz instead:
      d3dpp.FullScreen_RefreshRateInHz=0;
      d3dpp.BackBufferHeight=MainHeight=576;
    }
#endif

    // Try software vertex processing:
    if (i==2) behave=D3DCREATE_MIXED_VERTEXPROCESSING;
    if (i==3) behave=D3DCREATE_SOFTWARE_VERTEXPROCESSING;

    Direct3D->CreateDevice(D3DADAPTER_DEFAULT,D3DDEVTYPE_HAL,FrameWnd,behave,&d3dpp,&Device);
    if (Device) break;
  }

  if (Device==NULL) return 1;

  Device->GetBackBuffer(0,D3DBACKBUFFER_TYPE_MONO,&DirectBack);
  if (DirectBack==NULL) return 1;

  Device->CreateVertexBuffer(sizeof(VertexList),0,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBuffer);
  if (VertexBuffer==NULL) return 1;

  Device->CreateVertexBuffer(sizeof(VertexListPreview),0,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferPreview);
  if (VertexBufferPreview==NULL) return 1;

  Device->CreateVertexBuffer(sizeof(VertexListLinear),0,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferLinear);
  if (VertexBufferLinear==NULL) return 1;

  Device->CreateVertexBuffer(sizeof(VertexListResize),0,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferResize);
  if (VertexBufferResize==NULL) return 1;

  ret=TexScreenInit(); if (ret) return 1;

  FontInit();

  Device->SetRenderState(D3DRS_LIGHTING,0); // Turn off lighting

  // Set up texture modes:
  Device->SetTextureStageState(0,D3DTSS_ADDRESSU,D3DTADDRESS_CLAMP);
  Device->SetTextureStageState(0,D3DTSS_ADDRESSV,D3DTADDRESS_CLAMP);

  MakeVertexList();

  unsigned char *lock=NULL;
  VertexBufferPreview->Lock(0,sizeof(VertexList),&lock,0); if (lock==NULL) return 1;
  memcpy(lock,VertexListPreview,sizeof(VertexList));
  VertexBufferPreview->Unlock();

  VertexBuffer->Lock(0,sizeof(VertexList),&lock,0); if (lock==NULL) return 1;
  memcpy(lock,VertexList,sizeof(VertexList));
  VertexBuffer->Unlock();

  
  VertexBufferLinear->Lock(0,sizeof(VertexList),&lock,0); if (lock==NULL) return 1;
  memcpy(lock,VertexListLinear,sizeof(VertexList));
  VertexBufferLinear->Unlock();

  VertexBufferResize->Lock(0,sizeof(VertexList),&lock,0); if (lock==NULL) return 1;
  memcpy(lock,VertexListResize,sizeof(VertexList));
  VertexBufferResize->Unlock();
  
  return 0;
}
