#include <iostream>
#include <string>
#include <vector>
#include <fstream>
#include <stdlib.h>

using namespace std;

vector<string> synopsis;
extern vector<string> guide;

void LoadSynopsis() {
	ifstream f("D:\\info\\synopsis.txt");
	if(!f) {
        return;
	}
	while(!f.eof()) {
		char line[20480];
		f.getline(line, 20480);
		string t = line;
		synopsis.push_back(t);
	}
	f.close();
}

int FindInfo(char* crc) {
    for(int i = 0; i < synopsis.size(); i++) {
        string temp = synopsis[i];
        for(int n = 0; n < temp.size(); n++)
            temp[n] = towlower(temp[n]);
		if(temp.find(crc, 0) != string::npos)
            return i;
    }
    return -1;
}

void LoadGameInfo(unsigned int crc) {
    char buf[512];
    itoa(crc, buf, 16);
    LoadSynopsis();
    int location = FindInfo(buf);
    if(location != -1) {
        guide.clear();
        int asterickCount = 0;
        int i = location + 1;
        while(true) {
            if(asterickCount == 2)
                break;
            if(synopsis[i][0] == '*') {
                asterickCount++;
            }
            else { 
                if(strcmp("_________________________", synopsis[i].c_str()) == 0) {
                    guide.push_back(synopsis[i]);
                    guide.push_back("");
                }
                else {
                    guide.push_back(synopsis[i]);
                }
            }
            i++;
        }
    }
    else {
        guide.push_back("No info found");
    }
    synopsis.clear();
}

unsigned int GetCRC() {
    return 0x5ea8ccd3;
}
