#include "GlobalExtern.h"

void UpdateTurboButtons() {
	UpdateTurboDescriptions();	
}

void DrawOptionControllerTurboItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(OptionControllerTurboSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawOptionControllerTurboMenu() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();

	for(int i = 0; i < OptionControllerTurboItems.size(); i++) {
		DrawOptionControllerTurboItem(i, (char*)OptionControllerTurboItems[i].c_str(), MenuDetailPosX, MenuDetailPosY + (i * vSpace));
		DrawOptionControllerTurboItem(i, (char*)OptionControllerTurboValueItems[i].c_str(), MenuDetailPosX + MenuSpacing, MenuDetailPosY + (i * vSpace));
	}
	Present();
}

std::string GetButtonName(int q) {
	if(q == -1) return "Not Assigned";
	if(q == 0) return "Xbox A";
	if(q == 1) return "Xbox B";
	if(q == 2) return "Xbox X";
	if(q == 3) return "Xbox Y";
	if(q == 4) return "Xbox Black";
	if(q == 5) return "Xbox White";
	if(q == 6) return "Xbox Left Trigger";
	if(q == 7) return "Xbox Right Trigger";
	if(q == 8) return "Xbox Back";
	if(q == 9) return "Xbox Start";
	return "";
}

void UpdateButtonDescriptions() {
	for(int q = 0; q < 4; q++) {
		OptionControllerButtonValueItems[q][0] = GetButtonName(NESControllers[q].A);
		OptionControllerButtonValueItems[q][1] = GetButtonName(NESControllers[q].B);
		OptionControllerButtonValueItems[q][2] = GetButtonName(NESControllers[q].Select);
		OptionControllerButtonValueItems[q][3] = GetButtonName(NESControllers[q].Start);
	}
}

void SaveControllerIni() {
	FILE* f;
	char fileName[2048];
	sprintf(fileName,"%s%s%s%s", IniPath.c_str(), "\\controller\\", globalGameName.c_str(), ".ini");
	f = fopen(fileName , "w+");
	if(!f) {
		LD_LAUNCH_DASHBOARD launch;
		memset(&launch,0,sizeof(launch));
		launch.dwReason=XLD_LAUNCH_DASHBOARD_MAIN_MENU;
		XLaunchNewImage(NULL,(LAUNCH_DATA *)&launch);
	}
	for(int q = 0; q < 4; q++) {
		fprintf(f, "Controller %d Button A=%d\n", q + 1, NESControllers[q].A);
		fprintf(f, "Controller %d Button A=%d\n", q + 1, NESControllers[q].B);
		fprintf(f, "Controller %d Button A=%d\n", q + 1, NESControllers[q].Select);
		fprintf(f, "Controller %d Button A=%d\n", q + 1, NESControllers[q].Start);
	}
	for(int q = 0; q < 4; q++) {
		fprintf(f, "Controller %d Button A Turbo=%d\n", q + 1, tButtons[q].turboA);
		fprintf(f, "Controller %d Button B Turbo=%d\n", q + 1, tButtons[q].turboB);
		fprintf(f, "Controller %d Button Select Turbo=%d\n", q + 1, tButtons[q].turboSelect);
		fprintf(f, "Controller %d Button Start Turbo=%d\n", q + 1, tButtons[q].turboStart);
	}
	fprintf(f, "Turbo=%d\n", turboSpeed);
	fprintf(f, "Controller1Type=%d\n", Controller1Type);
	fprintf(f, "Controller2Type=%d\n", Controller2Type);
	fprintf(f, "Controller3Type=%d\n", Controller3Type);
	fprintf(f, "Controller4Type=%d\n", Controller4Type);
	fprintf(f, "FastForward=%d\n", FastForward);
	fprintf(f, "Rewind=%d\n", Rewind);
	fprintf(f, "VSCoin1=%d\n", VSCoin1);
	fprintf(f, "VSCoin2=%d\n", VSCoin2);
	fprintf(f, "CursorColor=%d\n", CursorColor);
	fprintf(f, "CursorSpeed=%d\n", CursorSpeed);
	fprintf(f, "CursorEnabled=%d\n", CursorEnabled);
	fprintf(f, "XBINPUT_DEADZONE=%f\n", XBINPUT_DEADZONE);
	fclose(f);
}

void ButtonUpdate(int q, int button) {

}

void SetupControllers() {
	for(int i = 0; i < 4; i++) {
		NESControllers[i].A = 0;
		NESControllers[i].B = 2;
		NESControllers[i].Select = 8;
		NESControllers[i].Start = 9;
		tButtons[i].turboA = 0;
		tButtons[i].turboB = 0;
		tButtons[i].turboSelect = 0;
		tButtons[i].turboStart = 0;
	}
	turboSpeed = 3;
	turboControllerSelected = 0;
	UpdateButtonDescriptions();
	UpdateTurboDescriptions();
	Controller1Type = 1;
	Controller2Type = 1;
	Controller3Type = 0;
	Controller4Type = 0;
}

void UpdateTurboDescriptions() {
	OptionControllerTurboValueItems[1] = "Off";
	OptionControllerTurboValueItems[2] = "Off";
	OptionControllerTurboValueItems[3] = "Off";
	OptionControllerTurboValueItems[4] = "Off";
	if(turboControllerSelected == 0)
		OptionControllerTurboValueItems[0] = "1";
	if(turboControllerSelected == 1)
		OptionControllerTurboValueItems[0] = "2";
	if(turboControllerSelected == 2)
		OptionControllerTurboValueItems[0] = "3";
	if(turboControllerSelected == 3)
		OptionControllerTurboValueItems[0] = "4";
	if(tButtons[turboControllerSelected].turboA == 1)
		OptionControllerTurboValueItems[1] = "On";
	if(tButtons[turboControllerSelected].turboB == 1)
		OptionControllerTurboValueItems[2] = "On";
	if(tButtons[turboControllerSelected].turboSelect == 1)
		OptionControllerTurboValueItems[3] = "On";
	if(tButtons[turboControllerSelected].turboStart == 1)
		OptionControllerTurboValueItems[4] = "On";
	OptionControllerTurboValueItems[5] = ConvertIntToString(turboSpeed);
}

void LoadControllerIni() {
	FILE* f;
	char fileName[2048];
	SetupControllers();
	sprintf(fileName,"%s%s%s%s", IniPath.c_str(), "\\controller\\", globalGameName.c_str(), ".ini");
	f = fopen(fileName , "r");
	if(f) {
		for(int q = 0; q < 4; q++) {
			NESControllers[q].A = GetFileInteger(f);
			NESControllers[q].B = GetFileInteger(f);
			NESControllers[q].Select = GetFileInteger(f);
			NESControllers[q].Start = GetFileInteger(f);
		}

		UpdateButtonDescriptions();
		for(int e = 0; e < 4; e++) {
			tButtons[e].turboA = GetFileInteger(f);
			tButtons[e].turboB = GetFileInteger(f);
			tButtons[e].turboSelect = GetFileInteger(f);
			tButtons[e].turboStart = GetFileInteger(f);
		}

		turboSpeed = GetFileInteger(f);
		Controller1Type = GetFileInteger(f);
		Controller2Type = GetFileInteger(f);
		Controller3Type = GetFileInteger(f);
		Controller4Type = GetFileInteger(f);
		FastForward = GetFileInteger(f);
		Rewind = GetFileInteger(f);
		VSCoin1 = GetFileInteger(f);
		VSCoin2 = GetFileInteger(f);
		CursorColor = GetFileInteger(f);
		CursorSpeed = GetFileInteger(f);
		CursorEnabled = GetFileInteger(f);
		XBINPUT_DEADZONE = GetFileFloat(f);
		OptionControllerTurboValueItems[0] = "1";
		OptionControllerTurboValueItems[1] = "Off";
		OptionControllerTurboValueItems[2] = "Off";
		OptionControllerTurboValueItems[3] = "Off";
		OptionControllerTurboValueItems[4] = "Off";
		OptionControllerTurboValueItems[5] = "7";

		if(turboControllerSelected == 0)
			OptionControllerTurboValueItems[0] = "1";
		if(turboControllerSelected == 1)
			OptionControllerTurboValueItems[0] = "2";
		if(turboControllerSelected == 2)
			OptionControllerTurboValueItems[0] = "3";
		if(turboControllerSelected == 3)
			OptionControllerTurboValueItems[0] = "4";

		if(tButtons[turboControllerSelected].turboA == 1)
			OptionControllerTurboValueItems[1] = "On";
		if(tButtons[turboControllerSelected].turboB == 1)
			OptionControllerTurboValueItems[2] = "On";
		if(tButtons[turboControllerSelected].turboSelect == 1)
			OptionControllerTurboValueItems[3] = "On";
		if(tButtons[turboControllerSelected].turboStart == 1)
			OptionControllerTurboValueItems[4] = "On";

		SetDefaultControllerValues();

		fclose(f);
	}
	else {
		SaveControllerIni();
	}
}

bool OptionControllerInput() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveControllerIni();
		return false;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
		ClickSound();
		OptionControllerSelected++;
		if(OptionControllerSelected > OptionControllerItems.size() - 1)
			OptionControllerSelected = 0;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
		ClickSound();
		OptionControllerSelected--;
		if(OptionControllerSelected < 0)
			OptionControllerSelected = OptionControllerItems.size() - 1;
	}  

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		ConfirmSound();
		OptionControllerButtonSelected = 0;
		while(1) {
			updateEffect();
			if(!OptionControllerButtonInput())
				break;
			DrawOptionControllerButtonMenu();
		}
	}
	return true;
}

void DrawOptionControllerItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(OptionControllerSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontCenteredText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawOptionControllerMenu() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	for(int i = 0; i < OptionControllerItems.size(); i++) {
		DrawOptionControllerItem(i, (char*)OptionControllerItems[i].c_str(), MenuPosX, MenuPosY + (i * vSpace));
	}
	Present();
}

bool OptionControllerButtonInput() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		return false;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  { 
		ClickSound();
		OptionControllerButtonSelected++;
		if(OptionControllerButtonSelected > OptionControllerButtonItems[OptionControllerSelected].size() - 1)
			OptionControllerButtonSelected = 0;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
		ClickSound();
		OptionControllerButtonSelected--;
		if(OptionControllerButtonSelected < 0)
			OptionControllerButtonSelected = OptionControllerButtonItems[OptionControllerSelected].size() - 1;
	}  

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		ConfirmSound();
		if(OptionControllerButtonSelected == 0) {
			NESControllers[OptionControllerSelected].A++;
			if(NESControllers[OptionControllerSelected].A > 9)
				NESControllers[OptionControllerSelected].A = 0;
		}
		if(OptionControllerButtonSelected == 1) {
			NESControllers[OptionControllerSelected].B++;
			if(NESControllers[OptionControllerSelected].B > 9)
				NESControllers[OptionControllerSelected].B = 0;
		}
		if(OptionControllerButtonSelected == 2) {
			NESControllers[OptionControllerSelected].Select++;
			if(NESControllers[OptionControllerSelected].Select > 9)
				NESControllers[OptionControllerSelected].Select = 0;
		}
		if(OptionControllerButtonSelected == 3) {
			NESControllers[OptionControllerSelected].Start++;
			if(NESControllers[OptionControllerSelected].Start > 9)
				NESControllers[OptionControllerSelected].Start = 0;
		}
		UpdateButtonDescriptions();
	}
	return true;
}
void DrawOptionControllerButtonItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(OptionControllerButtonSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawOptionControllerButtonMenu() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	for(int i = 0; i < OptionControllerButtonItems[OptionControllerSelected].size(); i++) {
		DrawOptionControllerButtonItem(i, (char*)(OptionControllerButtonItems[OptionControllerSelected])[i].c_str(), MenuDetailPosX, MenuDetailPosY + (i * vSpace));
		DrawOptionControllerButtonItem(i, (char*)(OptionControllerButtonValueItems[OptionControllerSelected])[i].c_str(), MenuDetailPosX + MenuSpacing, MenuDetailPosY + (i * vSpace));
	}
	Present();
}

void SetDefaultControllerValues() {
	if(Controller1Type == 0)
		OptionControllerGeneralValueItems[0] = "Disconnected";
	if(Controller1Type == 1)
		OptionControllerGeneralValueItems[0] = "Gamepad";
	if(Controller1Type == 2)
		OptionControllerGeneralValueItems[0] = "Lightgun";

	if(Controller2Type == 0)
		OptionControllerGeneralValueItems[1] = "Disconnected";
	if(Controller2Type == 1)
		OptionControllerGeneralValueItems[1] = "Gamepad";
	if(Controller2Type == 2)
		OptionControllerGeneralValueItems[1] = "Lightgun";

	if(Controller3Type == 0)
		OptionControllerGeneralValueItems[2] = "Disconnected";
	if(Controller3Type == 1)
		OptionControllerGeneralValueItems[2] = "Gamepad";

	if(Controller4Type == 0)
		OptionControllerGeneralValueItems[3] = "Disconnected";
	if(Controller4Type == 1)
		OptionControllerGeneralValueItems[3] = "Gamepad";

	if(FastForward == -1) OptionControllerGeneralValueItems[4] = "Not Assigned";
	if(FastForward == 0) OptionControllerGeneralValueItems[4] = "Xbox A";
	if(FastForward == 1) OptionControllerGeneralValueItems[4] = "Xbox B";
	if(FastForward == 2) OptionControllerGeneralValueItems[4] = "Xbox X";
	if(FastForward == 3) OptionControllerGeneralValueItems[4] = "Xbox Y";
	if(FastForward == 4) OptionControllerGeneralValueItems[4] = "Xbox Black";
	if(FastForward == 5) OptionControllerGeneralValueItems[4] = "Xbox White";
	if(FastForward == 6) OptionControllerGeneralValueItems[4] = "Xbox Left Trigger";
	if(FastForward == 7) OptionControllerGeneralValueItems[4] = "Xbox Right Trigger";

	if(Rewind == -1) OptionControllerGeneralValueItems[5] = "Not Assigned";
	if(Rewind == 0) OptionControllerGeneralValueItems[5] = "Xbox A";
	if(Rewind == 1) OptionControllerGeneralValueItems[5] = "Xbox B";
	if(Rewind == 2) OptionControllerGeneralValueItems[5] = "Xbox X";
	if(Rewind == 3) OptionControllerGeneralValueItems[5] = "Xbox Y";
	if(Rewind == 4) OptionControllerGeneralValueItems[5] = "Xbox Black";
	if(Rewind == 5) OptionControllerGeneralValueItems[5] = "Xbox White";
	if(Rewind == 6) OptionControllerGeneralValueItems[5] = "Xbox Left Trigger";
	if(Rewind == 7) OptionControllerGeneralValueItems[5] = "Xbox Right Trigger";

	if(VSCoin1 == -1) OptionControllerGeneralValueItems[6] = "Not Assigned";
	if(VSCoin1 == 0) OptionControllerGeneralValueItems[6] = "Xbox A";
	if(VSCoin1 == 1) OptionControllerGeneralValueItems[6] = "Xbox B";
	if(VSCoin1 == 2) OptionControllerGeneralValueItems[6] = "Xbox X";
	if(VSCoin1 == 3) OptionControllerGeneralValueItems[6] = "Xbox Y";
	if(VSCoin1 == 4) OptionControllerGeneralValueItems[6] = "Xbox Black";
	if(VSCoin1 == 5) OptionControllerGeneralValueItems[6] = "Xbox White";
	if(VSCoin1 == 6) OptionControllerGeneralValueItems[6] = "Xbox Left Trigger";
	if(VSCoin1 == 7) OptionControllerGeneralValueItems[6] = "Xbox Right Trigger";

	if(VSCoin2 == -1) OptionControllerGeneralValueItems[7] = "Not Assigned";
	if(VSCoin2 == 0) OptionControllerGeneralValueItems[7] = "Xbox A";
	if(VSCoin2 == 1) OptionControllerGeneralValueItems[7] = "Xbox B";
	if(VSCoin2 == 2) OptionControllerGeneralValueItems[7] = "Xbox X";
	if(VSCoin2 == 3) OptionControllerGeneralValueItems[7] = "Xbox Y";
	if(VSCoin2 == 4) OptionControllerGeneralValueItems[7] = "Xbox Black";
	if(VSCoin2 == 5) OptionControllerGeneralValueItems[7] = "Xbox White";
	if(VSCoin2 == 6) OptionControllerGeneralValueItems[7] = "Xbox Left Trigger";
	if(VSCoin2 == 7) OptionControllerGeneralValueItems[7] = "Xbox Right Trigger";

	if(CursorColor == 0) OptionControllerGeneralValueItems[8] = "Yellow";
	if(CursorColor == 1) OptionControllerGeneralValueItems[8] = "Blue";
	if(CursorColor == 2) OptionControllerGeneralValueItems[8] = "Green";
	if(CursorColor == 3) OptionControllerGeneralValueItems[8] = "Red";
	if(CursorColor == 4) OptionControllerGeneralValueItems[8] = "Black";
	if(CursorColor == 5) OptionControllerGeneralValueItems[8] = "White";

	std::ostringstream q0;
	q0 << CursorSpeed;
	std::string w0 = q0.str();
	OptionControllerGeneralValueItems[9] = (char*)w0.c_str();

	if(CursorEnabled == 0)
		OptionControllerGeneralValueItems[10] = "False";
	if(CursorEnabled == 1)
		OptionControllerGeneralValueItems[10] = "True";

	std::ostringstream temp;
	temp << XBINPUT_DEADZONE;
	std::string temp2 = temp.str();
	OptionControllerGeneralValueItems[11] = (char*)temp2.c_str();
}

void OptionControllerGeneralInput() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		if(Emulation) {
			ControllerEdit = false;
			SaveControllerIni();
		}
		else {
			SaveIni();
			GUIState = 3;
		}		
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  { 
		ClickSound();
		OptionControllerGeneralSelected++;
		if(OptionControllerGeneralSelected > OptionControllerGeneralItems.size() - 1)
			OptionControllerGeneralSelected = 0;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {  
		ClickSound();
		OptionControllerGeneralSelected--;
		if(OptionControllerGeneralSelected < 0)
			OptionControllerGeneralSelected = OptionControllerGeneralItems.size() - 1;
	}  

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_X) {
		ConfirmSound();
		if(OptionControllerGeneralSelected == 9) {
			CursorSpeed--;
			if(CursorSpeed < 1) 
				CursorSpeed = 1;
		    std::ostringstream q0;
			q0 << CursorSpeed;
			std::string w0 = q0.str();
			OptionControllerGeneralValueItems[9] = (char*)w0.c_str();
			return;
		}

		if(OptionControllerGeneralSelected == 11) {
			XBINPUT_DEADZONE-=0.01;
			std::ostringstream temp;
			temp << XBINPUT_DEADZONE;
			std::string temp2 = temp.str();
			OptionControllerGeneralValueItems[11] = (char*)temp2.c_str();
			return;
		}
	}

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		ConfirmSound();
		if(OptionControllerGeneralSelected == 0) {
			Controller1Type++;
			if(Controller1Type > 2)
				Controller1Type = 0;
			if(Controller1Type == 0)
				OptionControllerGeneralValueItems[0] = "Disconnected";
			if(Controller1Type == 1)
				OptionControllerGeneralValueItems[0] = "Gamepad";
			if(Controller1Type == 2)
				OptionControllerGeneralValueItems[0] = "Lightgun";
			if(Emulation)
				SetupInput();
			return;
		}
		if(OptionControllerGeneralSelected == 1) {
			Controller2Type++;
			if(Controller2Type > 2)
				Controller2Type = 0;
			if(Controller2Type == 0)
				OptionControllerGeneralValueItems[1] = "Disconnected";
			if(Controller2Type == 1)
				OptionControllerGeneralValueItems[1] = "Gamepad";
			if(Controller2Type == 2)
				OptionControllerGeneralValueItems[1] = "Lightgun";
			if(Emulation)
				SetupInput();
			return;
		}
		if(OptionControllerGeneralSelected == 2) {
			Controller3Type++;
			if(Controller3Type > 1)
				Controller3Type = 0;
			if(Controller3Type == 0)
				OptionControllerGeneralValueItems[2] = "Disconnected";
			if(Controller3Type == 1)
				OptionControllerGeneralValueItems[2] = "Gamepad";
			if(Emulation)
				SetupInput();
			return;
		}
		if(OptionControllerGeneralSelected == 3) {
			Controller4Type++;
			if(Controller4Type > 1)
				Controller4Type = 0;
			if(Controller4Type == 0)
				OptionControllerGeneralValueItems[3] = "Disconnected";
			if(Controller4Type == 1)
				OptionControllerGeneralValueItems[3] = "Gamepad";
			if(Emulation)
				SetupInput();
			return;
		}
		if(OptionControllerGeneralSelected == 4) {
			FastForward++;
			if(FastForward > 7)
				FastForward = -1;
			if(FastForward == -1) OptionControllerGeneralValueItems[4] = "Not Assigned";
			if(FastForward == 0) OptionControllerGeneralValueItems[4] = "Xbox A";
			if(FastForward == 1) OptionControllerGeneralValueItems[4] = "Xbox B";
			if(FastForward == 2) OptionControllerGeneralValueItems[4] = "Xbox X";
			if(FastForward == 3) OptionControllerGeneralValueItems[4] = "Xbox Y";
			if(FastForward == 4) OptionControllerGeneralValueItems[4] = "Xbox Black";
			if(FastForward == 5) OptionControllerGeneralValueItems[4] = "Xbox White";
			if(FastForward == 6) OptionControllerGeneralValueItems[4] = "Xbox Left Trigger";
			if(FastForward == 7) OptionControllerGeneralValueItems[4] = "Xbox Right Trigger";
			return;
		}
		if(OptionControllerGeneralSelected == 5) {
			Rewind++;
			if(Rewind > 7)
				Rewind = -1;
			if(Rewind == -1) OptionControllerGeneralValueItems[5] = "Not Assigned";
			if(Rewind == 0) OptionControllerGeneralValueItems[5] = "Xbox A";
			if(Rewind == 1) OptionControllerGeneralValueItems[5] = "Xbox B";
			if(Rewind == 2) OptionControllerGeneralValueItems[5] = "Xbox X";
			if(Rewind == 3) OptionControllerGeneralValueItems[5] = "Xbox Y";
			if(Rewind == 4) OptionControllerGeneralValueItems[5] = "Xbox Black";
			if(Rewind == 5) OptionControllerGeneralValueItems[5] = "Xbox White";
			if(Rewind == 6) OptionControllerGeneralValueItems[5] = "Xbox Left Trigger";
			if(Rewind == 7) OptionControllerGeneralValueItems[5] = "Xbox Right Trigger";
			return;
		}
		if(OptionControllerGeneralSelected == 6) {
			VSCoin1++;
			if(VSCoin1 > 7)
				VSCoin1 = -1;
			if(VSCoin1 == -1) OptionControllerGeneralValueItems[6] = "Not Assigned";
			if(VSCoin1 == 0) OptionControllerGeneralValueItems[6] = "Xbox A";
			if(VSCoin1 == 1) OptionControllerGeneralValueItems[6] = "Xbox B";
			if(VSCoin1 == 2) OptionControllerGeneralValueItems[6] = "Xbox X";
			if(VSCoin1 == 3) OptionControllerGeneralValueItems[6] = "Xbox Y";
			if(VSCoin1 == 4) OptionControllerGeneralValueItems[6] = "Xbox Black";
			if(VSCoin1 == 5) OptionControllerGeneralValueItems[6] = "Xbox White";
			if(VSCoin1 == 6) OptionControllerGeneralValueItems[6] = "Xbox Left Trigger";
			if(VSCoin1 == 7) OptionControllerGeneralValueItems[6] = "Xbox Right Trigger";
			return;
		}
		if(OptionControllerGeneralSelected == 7) {
			VSCoin2++;
			if(VSCoin2 > 7)
				VSCoin2 = -1;
			if(VSCoin2 == -1) OptionControllerGeneralValueItems[7] = "Not Assigned";
			if(VSCoin2 == 0) OptionControllerGeneralValueItems[7] = "Xbox A";
			if(VSCoin2 == 1) OptionControllerGeneralValueItems[7] = "Xbox B";
			if(VSCoin2 == 2) OptionControllerGeneralValueItems[7] = "Xbox X";
			if(VSCoin2 == 3) OptionControllerGeneralValueItems[7] = "Xbox Y";
			if(VSCoin2 == 4) OptionControllerGeneralValueItems[7] = "Xbox Black";
			if(VSCoin2 == 5) OptionControllerGeneralValueItems[7] = "Xbox White";
			if(VSCoin2 == 6) OptionControllerGeneralValueItems[7] = "Xbox Left Trigger";
			if(VSCoin2 == 7) OptionControllerGeneralValueItems[7] = "Xbox Right Trigger";
			return;
		}
		if(OptionControllerGeneralSelected == 8) {
			CursorColor++;
			if(CursorColor > 5)
				CursorColor = 0;
			if(CursorColor == 0) OptionControllerGeneralValueItems[8] = "Yellow";
			if(CursorColor == 1) OptionControllerGeneralValueItems[8] = "Blue";
			if(CursorColor == 2) OptionControllerGeneralValueItems[8] = "Green";
			if(CursorColor == 3) OptionControllerGeneralValueItems[8] = "Red";
			if(CursorColor == 4) OptionControllerGeneralValueItems[8] = "Black";
			if(CursorColor == 5) OptionControllerGeneralValueItems[8] = "White";
			return;
		}
		if(OptionControllerGeneralSelected == 9) {
			CursorSpeed++;
		    std::ostringstream q0;
			q0 << CursorSpeed;
			std::string w0 = q0.str();
			OptionControllerGeneralValueItems[9] = (char*)w0.c_str();
			return;
		}
		if(OptionControllerGeneralSelected == 10) {
			CursorEnabled++;
			if(CursorEnabled > 1)
				CursorEnabled = 0;
			if(CursorEnabled == 0)
				OptionControllerGeneralValueItems[10] = "False";
			if(CursorEnabled == 1)
				OptionControllerGeneralValueItems[10] = "True";
			return;
		}
		if(OptionControllerGeneralSelected == 11) {
			XBINPUT_DEADZONE+=0.01;
			std::ostringstream temp;
			temp << XBINPUT_DEADZONE;
			std::string temp2 = temp.str();
			OptionControllerGeneralValueItems[11] = (char*)temp2.c_str();
			return;
		}
	}
}

void DrawOptionControllerGeneralItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(OptionControllerGeneralSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawOptionControllerGeneralMenu() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	for(int i = 0; i < OptionControllerGeneralItems.size(); i++) {
		DrawOptionControllerGeneralItem(i, (char*)OptionControllerGeneralItems[i].c_str(), MenuDetailPosX, MenuDetailPosY + (i * vSpace));
		DrawOptionControllerGeneralItem(i, (char*)OptionControllerGeneralValueItems[i].c_str(), MenuDetailPosX + MenuSpacing, MenuDetailPosY + (i * vSpace));
	}
	Present();
}
void OptionControllerGeneralMenu() {
	OptionControllerGeneralInput();
	DrawOptionControllerGeneralMenu();
}