#include "GlobalExtern.h"

void OptionSoundInput() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		GUIState = 3;
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  { 
		ClickSound();
		OptionSoundSelected++;
		if(OptionSoundSelected > OptionSoundItems.size() - 1)
			OptionSoundSelected = 0;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  { 
		ClickSound();
		OptionSoundSelected--;
		if(OptionSoundSelected < 0)
			OptionSoundSelected = OptionSoundItems.size() - 1;
	}  

	if (g_Gamepads[DefaultController].fY2 > 0)  {
		if(OptionSoundSelected == 1) {
			BackgroundMusicVolume+=10;
			m_mp3player.adjust_volume(BackgroundMusicVolume);
			std::ostringstream temp;
			temp << BackgroundMusicVolume;
			std::string temp2 = temp.str();
			OptionSoundValueItems[1] = temp2.c_str();
			return;
		}
	}  
	
	if (g_Gamepads[DefaultController].fY2 < 0)  {
		if(OptionSoundSelected == 1) {
			BackgroundMusicVolume-=10;
			m_mp3player.adjust_volume(BackgroundMusicVolume);
			std::ostringstream temp;
			temp << BackgroundMusicVolume;
			std::string temp2 = temp.str();
			OptionSoundValueItems[1] = temp2.c_str();
			return;
		}
	}  

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_X) {
		ConfirmSound();
		if(OptionSoundSelected == 1) {
			BackgroundMusicVolume--;
			m_mp3player.adjust_volume(BackgroundMusicVolume);
			std::ostringstream temp;
			temp << BackgroundMusicVolume;
			std::string temp2 = temp.str();
			OptionSoundValueItems[1] = temp2.c_str();
			return;
		}
	}

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		ConfirmSound();
	
		if(OptionSoundSelected == 0) {
			disableMenuSounds++;
			if(disableMenuSounds > 1)
				disableMenuSounds = 0;
			if(disableMenuSounds == 0)
				OptionSoundValueItems[0] = "False";
			else
				OptionSoundValueItems[0] = "True";
			return;
		}
		if(OptionSoundSelected == 1) {
			BackgroundMusicVolume++;
			m_mp3player.adjust_volume(BackgroundMusicVolume);
			std::ostringstream temp;
			temp << BackgroundMusicVolume;
			std::string temp2 = temp.str();
			OptionSoundValueItems[1] = temp2.c_str();
			return;
		}
		if(OptionSoundSelected == 2) {
			SurroundSound++;
			if(SurroundSound > 1)
				SurroundSound = 0;
			if(SurroundSound == 1)
				OptionSoundValueItems[2] = "True";
			else
				OptionSoundValueItems[2] = "False";
			return;
		}
	}
}

void DrawOptionSoundItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(OptionSoundSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawOptionSoundMenu() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	for(int i = 0; i < OptionSoundItems.size(); i++) {
		DrawOptionSoundItem(i, (char*)OptionSoundItems[i].c_str(), MenuDetailPosX, MenuDetailPosY + (i * vSpace));
		DrawOptionSoundItem(i, (char*)OptionSoundValueItems[i].c_str(), MenuDetailPosX + MenuSpacing, MenuDetailPosY + (i * vSpace));
	}
	Present();
}

void OptionEmulationSoundInput() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		GUIState = 1;
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
		ClickSound();
		OptionEmulationSoundSelected++;
		if(OptionEmulationSoundSelected > OptionEmulationSoundItems.size() - 1)
			OptionEmulationSoundSelected = 0;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
		ClickSound();
		OptionEmulationSoundSelected--;
		if(OptionEmulationSoundSelected < 0)
			OptionEmulationSoundSelected = OptionEmulationSoundItems.size() - 1;
	}  

    if (g_Gamepads[DefaultController].fY2 > 0)  {
		if(OptionEmulationSoundSelected == 1) {
			nDSoundVol+=10;
			DxSoundSetVolume();
			std::ostringstream temp;
			temp << nDSoundVol;
			std::string temp2 = temp.str();
			OptionEmulationSoundValueItems[1] = temp2.c_str();
			return;
		}
	}  
	
	if (g_Gamepads[DefaultController].fY2 < 0)  {
		if(OptionEmulationSoundSelected == 1) {
			nDSoundVol-=10;
			DxSoundSetVolume();
			std::ostringstream temp;
			temp << nDSoundVol;
			std::string temp2 = temp.str();
			OptionEmulationSoundValueItems[1] = temp2.c_str();
			return;
		}
	}  

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_X) {
		ConfirmSound();
		if(OptionEmulationSoundSelected == 1) {
			nDSoundVol-=1;
			DxSoundSetVolume();
			std::ostringstream temp;
			temp << nDSoundVol;
			std::string temp2 = temp.str();
			OptionEmulationSoundValueItems[1] = temp2.c_str();
			return;
		}
	}

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		ConfirmSound();
		if(OptionEmulationSoundSelected == 0) {
			disableMenuSounds++;
			if(disableMenuSounds > 1)
				disableMenuSounds = 0;
			if(disableMenuSounds == 0)
				OptionEmulationSoundValueItems[0] = "False";
			else
				OptionEmulationSoundValueItems[0] = "True";
		}
        if(OptionEmulationSoundSelected == 1) {
			nDSoundVol+=1;
			DxSoundSetVolume();
			std::ostringstream temp;
			temp << nDSoundVol;
			std::string temp2 = temp.str();
			OptionEmulationSoundValueItems[1] = temp2.c_str();
			return;
		}
		if(OptionEmulationSoundSelected == 2) {
			RewindSound++;
			if(RewindSound > 1)
				RewindSound = 0;
			if(RewindSound == 1)
				OptionEmulationSoundValueItems[2] = "Enabled";
			else
				OptionEmulationSoundValueItems[2] = "Disabled";
			SetRewindSound();
		}
	}
}

void DrawOptionEmulationSoundItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(OptionEmulationSoundSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawOptionEmulationSoundMenu() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	for(int i = 0; i < OptionEmulationSoundItems.size(); i++) {
		DrawOptionEmulationSoundItem(i, (char*)OptionEmulationSoundItems[i].c_str(), MenuDetailPosX, MenuDetailPosY + (i * vSpace));
		DrawOptionEmulationSoundItem(i, (char*)OptionEmulationSoundValueItems[i].c_str(), MenuDetailPosX + MenuSpacing, MenuDetailPosY + (i * vSpace));
	}
	Present();
}

void OptionSoundMenu() {
	if(Emulation) {
		OptionEmulationSoundInput();
		DrawOptionEmulationSoundMenu();
	}
	else {
		OptionSoundInput();
		DrawOptionSoundMenu();
	}
}
