#include "GlobalExtern.h"

void  RemoveFromFavorites() {
    if(FavoritesDatabase.size() == 1 && GameFavoriteSelected == 0) {
        FavoritesDatabase.clear();
        ImageDBEntry e;
        e.path = "";
        e.name = "No Favorites Found";
        FavoritesDatabase.push_back(e);
        UpdatePreview(FavoritesDatabase[GameFavoriteSelected].name);
        return;
    }
    if(FavoritesDatabase.size() > 1) {
        FavoritesDatabase.erase(FavoritesDatabase.begin()+GameFavoriteSelected);
    }
    if(GameFavoriteSelected > 0) GameFavoriteSelected--;
    UpdatePreview(FavoritesDatabase[GameFavoriteSelected].name);
}

bool BuildFavorites() {
    FavoritesDatabase.clear();
    char fileName[2048];
    sprintf(fileName,"%s%s", IniPath.c_str(), "\\favorites.ini");
    ifstream f(fileName);
    if(!f){
        ImageDBEntry game;
        game.path = "";
        game.name = "No Favorites Found";
        FavoritesDatabase.push_back(game);
        return false;
    }
    char line[2048];
    for(int i = 0; i < 2048; i++) line[i] = '\0';
    f.getline(line, 2048);
    int e = atoi(line);
    if(e == 0) {
        ImageDBEntry game;
        game.path = "";
        game.name = "No Favorites Found";
        FavoritesDatabase.push_back(game);
        f.close();
        return true;
    }

    for(int i = 0; i < e; i++) {
        ImageDBEntry game;
        for(int i = 0; i < 2048; i++) line[i] = '\0';
        f.getline(line, 2048);
        game.name = line;
        for(int i = 0; i < 2048; i++) line[i] = '\0';
        f.getline(line, 2048);
        game.path = line;
        FavoritesDatabase.push_back(game);
    }

    f.close();
    return true;
}

void SaveFavorites() {
    FILE* f;
    char fileName[2048];
    sprintf(fileName,"%s%s", IniPath.c_str(), "\\favorites.ini");
    f = fopen(fileName, "w+");
    if(!f) {
        LD_LAUNCH_DASHBOARD launch;
        memset(&launch,0,sizeof(launch));
        launch.dwReason=XLD_LAUNCH_DASHBOARD_MAIN_MENU;
        XLaunchNewImage(NULL,(LAUNCH_DATA *)&launch);
    }

    if(FavoritesDatabase.size() > 0) {
        std::string e = "No Favorites Found";
        if (_tcscmp(FavoritesDatabase[0].name.c_str(), e.c_str()) == 0) {	
            fprintf(f, "%d\n", 0);
            fclose(f);
            return;
        }

        fprintf(f, "%d\n", FavoritesDatabase.size());
        for(int i = 0; i < FavoritesDatabase.size(); i++) {
            fprintf(f, "%s\n", FavoritesDatabase[i].name.c_str());
            fprintf(f, "%s\n", FavoritesDatabase[i].path.c_str());
        }
    }

    fclose(f);
}


void FavoriteSelectInput() {
    ReadInput();

    if(analogScroll && !g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER] && 
        !g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) {
            analogScroll = false;
            UpdatePreview(FavoritesDatabase[GameFavoriteSelected].name);
            return;
    }

    if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
        CancelSound();
        stopMovie();
        GUIState = MAIN_MENU;
        fadeOption = 0;
        fadeColor = 255;
        SaveIni();
        MenuSelected = 1;
        MenuBackground();
        m_mp3player.pause(FALSE);
        return;
    }

    if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
        if(GameFavoriteSelected == FavoritesDatabase.size() - 1)
            return;
        ClickSound();
        GameFavoriteSelected++; 
        if(GameFavoriteSelected >= FavoritesDatabase.size()) 
            GameFavoriteSelected = FavoritesDatabase.size() - 1;
        UpdatePreview(FavoritesDatabase[GameFavoriteSelected].name);
        return;
    }

    if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
        if(GameFavoriteSelected == 0)
            return;
        ClickSound();
        GameFavoriteSelected--; 
        if(GameFavoriteSelected < 0) 
            GameFavoriteSelected = 0;
        UpdatePreview(FavoritesDatabase[GameFavoriteSelected].name);
        return;
    }  

    if (g_Gamepads[DefaultController].fY2 < 0)  {
        ScrollSpeedCount++;
        if((ScrollSpeedCount % ScrollSpeed) == 0) {
            ScrollSpeedCount = 0;
            GameInfoDetailSelected += 1;
        }
        if(GameInfoDetailSelected >= GameInfoDetail.size()) 
            GameInfoDetailSelected = GameInfoDetail.size() - 1;
        return;
    }

    if (g_Gamepads[DefaultController].fY2 > 0)  {
        ScrollSpeedCount++;
        if((ScrollSpeedCount % ScrollSpeed) == 0) {
            ScrollSpeedCount = 0;
            GameInfoDetailSelected -= 1;
        }
        if(GameInfoDetailSelected < (GameInfoDetailNumLines / 2)) 
            GameInfoDetailSelected = (GameInfoDetailNumLines / 2);
        return;
    }  

    if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_LEFT  && g_Gamepads[DefaultController].fX2 == 0 && 
        !(g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) && 
        !(g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])) {  
            char c = FavoritesDatabase[GameFavoriteSelected].name[0];	  
            c = tolower(c);
            for(int i = GameFavoriteSelected; i > 0; i--) {
                char n = FavoritesDatabase[i].name[0];
                n = tolower(n);
                if(n <  c) {
                    GameFavoriteSelected = i;
                    UpdatePreview(FavoritesDatabase[GameFavoriteSelected].name);
                    break;	
                }
            }
            return;
    } 

    if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_RIGHT && g_Gamepads[DefaultController].fX2 == 0 && 
        !(g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) && 
        !(g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])) { 
            char c = FavoritesDatabase[GameFavoriteSelected].name[0];	  
            c = tolower(c);
            for(int i = GameFavoriteSelected; i < FavoritesDatabase.size(); i++) {
                char n = FavoritesDatabase[i].name[0];
                n = tolower(n);
                if(n > c) {
                    GameFavoriteSelected = i;
                    UpdatePreview(FavoritesDatabase[GameFavoriteSelected].name);
                    break;
                }
            }
            return;
    } 		

    if (g_Gamepads[DefaultController].fX2 < 0)  {
        if(!PreviewSwitchValid())
            return;
        CyclePreview(-1);
        PreviewSwitch = true;
        UpdatePreview(FavoritesDatabase[GameFavoriteSelected].name);
        if(!TexPreview) {
            for(int i = 0; i < 7; i++) {
                CyclePreview(-1);
                PreviewSwitch = true;
                UpdatePreview(FavoritesDatabase[GameFavoriteSelected].name);
                if(TexPreview)
                    break;
            }
        }
        return;
    }

    if (g_Gamepads[DefaultController].fX2 > 0)  {
        if(!PreviewSwitchValid())
            return;
        CyclePreview(1);
        PreviewSwitch = true;
        UpdatePreview(FavoritesDatabase[GameFavoriteSelected].name);
        if(!TexPreview) {
            for(int i = 0; i < 7; i++) {
                CyclePreview(1);
                PreviewSwitch = true;
                UpdatePreview(FavoritesDatabase[GameFavoriteSelected].name);
                if(TexPreview)
                    break;
            }
        }
        return;
    }

    if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
        if(_tcscmp("No Favorites Found", FavoritesDatabase[0].name.c_str()) == 0) {
            return;
        }
        m_mp3player.pause(true);
        stopMovie();
        SaveIni();
        std::string e = FavoritesDatabase[GameFavoriteSelected].name;
        globalGameName = e.substr(0, e.size() - 4);
        CreateDirectories(globalGameName);
        oldGUIState = GUIState;
        GameDelay();
        StartGame((char*)FavoritesDatabase[GameFavoriteSelected].path.c_str());
        m_mp3player.pause(false);
        GUIState = oldGUIState;
        SetDelay();
        g_Gamepads[DefaultController].Event = XBGAMEPAD_NONE;
        return;
    }

    if(g_Gamepads[DefaultController].Event == XBGAMEPAD_WHITE) {
        if(((_tcscmp(FavoritesDatabase[0].name.c_str(), "No Favorites Found") == 0))) 
            return;
        RemoveFromFavorites();
        SaveFavorites();
        return;
    }

    if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) {
        if(GameFavoriteSelected == FavoritesDatabase.size() - 1)
            return;
        stopMovie();
        GameInfoDetail.clear();
        if(analogSpeed >= 1) { 
            analogSpeed = 0; 
        } 
        if(rightAnalog == 255)
            analogSpeed = scrollSpeed;
        else
            analogSpeed += ((float)rightAnalog/255.0f);
        GameFavoriteSelected+=((int)analogSpeed); 
        if(GameFavoriteSelected >= FavoritesDatabase.size()) 
            GameFavoriteSelected = FavoritesDatabase.size() - 1;
        analogScroll = true;
        if(TexPreview) {
            TexPreview->Release();
            TexPreview = NULL;
        }
        return;
    }

    if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) {
        if(GameFavoriteSelected == 0)
            return;
        stopMovie();
        GameInfoDetail.clear();
        if(analogSpeed >= 1)  { 
            analogSpeed = 0;
        }
        if(leftAnalog == 255)
            analogSpeed = scrollSpeed;
        else
            analogSpeed += ((float)leftAnalog/255.0f);
        GameFavoriteSelected-=((int)analogSpeed); if(GameFavoriteSelected < 0) GameFavoriteSelected = 0;
        analogScroll = true;
        if(TexPreview) {
            TexPreview->Release();
            TexPreview = NULL;
        }
        return;
    }

    if(g_Gamepads[DefaultController].Event == XBGAMEPAD_Y) {
        GameFavoriteSelected = 0;
        UpdatePreview(FavoritesDatabase[GameFavoriteSelected].name);
        return;
    }

    if(g_Gamepads[DefaultController].Event == XBGAMEPAD_X) {
        ConfirmSound();
        m_mp3player.pause(FALSE);
        stopMovie();
        ImageSelectedMenu((char*)FavoritesDatabase[GameFavoriteSelected].name.c_str());
        UpdatePreview(FavoritesDatabase[GameFavoriteSelected].name);
    }
}

void DrawGameFavoriteList() {
    if(_tcscmp("No Favorites Found", FavoritesDatabase[0].name.c_str()) == 0) {
        FontSetColour(0xffff00);
        FontText(ConvertCharStringToWCHAR("No Favorites Found"),GameListX, GameListY, GameListWidth);
        FontCenteredText(ConvertCharStringToWCHAR("No Favorites Found"),320, ROMPosY, 640);
        return;
    }
    FontSetColour(0xffff00);
    string temp = FavoritesDatabase[GameFavoriteSelected].name;
    if(temp[0] != '<')
        temp = temp.substr(0, temp.size() - 4);
    if(EditName) {
        for(int i = 0; i < temp.size(); i++) {
            if((temp[i] == '(')) {
                temp[i] = '\0';
                break;
            }
        }
    }

    FontCenteredText(ConvertCharStringToWCHAR((char*)temp.c_str()),320, ROMPosY, 640);
    int y = GameListY;
    DWORD color;
    int start = 0;

    if(GameFavoriteSelected > (GameListCount / 2) && (FavoritesDatabase.size() > GameListCount)) {
        start += (GameFavoriteSelected  - (GameListCount / 2));
    }

    if((GameFavoriteSelected > ((FavoritesDatabase.size()-1) - (GameListCount / 2))) && (FavoritesDatabase.size() > GameListCount)) {
        start = (FavoritesDatabase.size() - GameListCount);
    }

    for(int i = start; i <  start + GameListCount; i++) {
        if(i == FavoritesDatabase.size()) return;
        if(i ==GameFavoriteSelected) {
            color = 0xffff00; 
        }
        else {
            color = 0xffffff;
        }

        WCHAR msg[1024]={0};

        std::string t = FavoritesDatabase[i].name;
        if(t[0] != '<')
            t = t.substr(0, t.size() - 4);

        if(EditName) {
            for(int n = 0; n < t.size(); n++) {
                if((t[n] == '(')) {
                    t[n] = '\0';
                    break;
                }
            }
        }
        for(int r = 0; r < 1024; r++) {
            if((t.c_str())[r] == '\0') {
                msg[r] = '\0';
                break;
            }
            msg[r] = (t.c_str())[r];
        }
        FontSetColour(color);
        FontText(msg,GameListX, y, GameListWidth);
        y+=vSpace;
    }
}

void DrawFavoriteSelectMenu() {
    DrawROMList(1);
}

void FavoriteSelectMenu() {
    DrawFavoriteSelectMenu();
    FavoriteSelectInput();
}
