#include "MusicManager.h"
#include "dsstdfx.h"

extern float BackgroundMusicVolume;
extern bool videoRender;
extern int GUIMode;
static CMusicManager*  m_pMusicManager;    // Music Manager

void PauseMusic() {
	if(m_pMusicManager)
		m_pMusicManager->Pause();	
}

void ResumeMusic() {
	if(videoRender)
		return;
	if(m_pMusicManager)
		m_pMusicManager->Play();
}

void switchSongs() {
	if(m_pMusicManager)
		m_pMusicManager->changeTrack(false);
}

float getVolume() {
	return m_pMusicManager->GetVolume();
}

void StopMusic() {
	if(m_pMusicManager)
		m_pMusicManager->Stop();	
}

void SetVolume() {
	if(BackgroundMusicVolume > 0) BackgroundMusicVolume = 0;
	if(BackgroundMusicVolume < -5000) BackgroundMusicVolume = -5000;
	if(m_pMusicManager)
		m_pMusicManager->SetVolume(BackgroundMusicVolume); 
}

void resetThemeSong() {
	if(m_pMusicManager)
		m_pMusicManager->changeTrack(true);
}

int InitBackgroundMusic() {
	m_pMusicManager = NULL;

	// download the standard DirectSound effects image
	DSEFFECTIMAGELOC EffectLoc;
	EffectLoc.dwI3DL2ReverbIndex = GraphI3DL2_I3DL2Reverb;
	EffectLoc.dwCrosstalkIndex   = GraphXTalk_XTalk;
	if( FAILED( XAudioDownloadEffectsImage( "d:\\media\\dsstdfx.bin", 
		&EffectLoc, 
		XAUDIO_DOWNLOADFX_EXTERNFILE, 
		NULL ) ) )
		return E_FAIL;

	// Create MusicManager
	m_pMusicManager = new CMusicManager();
	if( !m_pMusicManager ) {
		return E_OUTOFMEMORY;
	}

	// Initialize MusicManager
	if( FAILED( m_pMusicManager->Initialize() ) ) {
		return E_FAIL;
	}

	m_pMusicManager->SetVolume( BackgroundMusicVolume );
	return S_OK;
}

//-----------------------------------------------------------------------------
// Name: FrameMove()
// Desc: Performs per-frame updates
//"D:\\skins\\arcade\\backgroundmusic.wma"; 
//-----------------------------------------------------------------------------
void UpdateSound()
{
	//if(videoRender && GUIMode != 0)
	//	return;
	FLOAT fVolume = m_pMusicManager->GetVolume();
	if( fVolume < DSBVOLUME_MIN )
		fVolume = DSBVOLUME_MIN;
	if( fVolume > DSBVOLUME_MAX )
		fVolume = DSBVOLUME_MAX;
	m_pMusicManager->SetVolume( fVolume );
	DirectSoundDoWork();
	m_pMusicManager->Process();
}