#include "GlobalExtern.h"

extern int NestopiaMain(char* game);
extern int nst_quit;

void FreeImages() {
    if(TexPreviewBorder) {TexPreviewBorder->Release();TexPreviewBorder = NULL;}
    if(TexAnimatedLogo) {TexAnimatedLogo->Release();TexAnimatedLogo = NULL;}
    if(TexVideoBorder) {TexVideoBorder->Release();TexVideoBorder = NULL;}
    if(TexROMBorder) {TexROMBorder->Release();TexROMBorder = NULL;}
    if(TexSelectedBorder) {TexSelectedBorder->Release();TexSelectedBorder = NULL;}
    if(TexROMBrowser) {TexROMBrowser->Release();TexROMBrowser = NULL;}
    if(TexMainMenuOverlay) {TexMainMenuOverlay->Release();TexMainMenuOverlay = NULL;}
}

void ResetImages() {
    char fileName[2048];

    if(TexScreen) {TexScreen->Release();TexScreen = NULL;}

    sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\logo.png");
    D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
        D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
        D3DX_DEFAULT,0,NULL,NULL,&TexAnimatedLogo);

    sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\selectedborder.png");
    D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
        D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
        D3DX_DEFAULT,0,NULL,NULL,&TexSelectedBorder);

    sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\rombrowser.png");
    D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
        D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
        D3DX_DEFAULT,0,NULL,NULL,&TexROMBrowser);

    sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\previewborder.png");
    D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
        D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
        D3DX_DEFAULT,0,NULL,NULL,&TexPreviewBorder);

    sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\videoborder.png");
    D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
        D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
        D3DX_DEFAULT,0,NULL,NULL,&TexVideoBorder);

    sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\romborder.png");
    D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
        D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
        D3DX_DEFAULT,0,NULL,NULL,&TexROMBorder);

    sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\overlay.png");
    D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
        D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
        D3DX_DEFAULT,0,NULL,NULL,&TexMainMenuOverlay);
}

void BeforeGame() {
    Disk = 0;
    GeneralOptionsValueSettings[1] = "Disk 1, Side A";
    FreeImages();
    LoadControllerIni();
    LoadGameIni(globalGameName);
    Emulation = true;
    setDisplay = true;
    nst_quit = 1;
    ResizeTexture();
    SetupMatricesEmulation();
    MakeVertexList();
    Device->SetTexture(0,TexScreen);
    Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
    Present();
    setDisplay = false;
    Device->SetFlickerFilter(FlickerFilter);
    Device->SetSoftDisplayFilter(Soften);
    BuildCheatGameList("D:\\cheats\\");
    GlobalCRC = 0;
}

void EndGame() {
    DeleteCheats();
    LoadIni();
    SetDefaultControllerValues();
    Emulation = false;
    Region = 0;
    UnlimitedSprites = 0;
    char fileName2[2048];
    sprintf(fileName2,"%s%s", globalGameName.c_str(), ".zip");
    globalGameName = fileName2;
    ResetImages();
    UpdatePreview(globalGameName);
    GlobalCRC = 0;
    FPS = false;
    OptionEmulationVideoValueItems[9] = "False";
    ResetType = 1;
    GeneralOptionsValueSettings[4] = "Soft";
    RewindSound = 1;
    OptionEmulationSoundValueItems[2] = "Enabled";
    if(PaletteSelected == -1) {
        OptionVideoValueItems[10] = "None";
    }
    else {
        if(PaletteList.size() > 0) {
            if(PaletteSelected <= (PaletteList.size() - 1)) {
                OptionVideoValueItems[10] = PaletteList[PaletteSelected].c_str();
            }
            else {
                OptionVideoValueItems[10] = "None";
                PaletteSelected = -1;
                if(ColorMode == 2)
                    ColorMode = 0;
            }
        }
        else {
            OptionVideoValueItems[10] = "None";
            PaletteSelected = -1;
            if(ColorMode == 2)
                ColorMode = 0;
        }
    }

    if(ColorMode == 0)
        OptionVideoValueItems[9] = "Auto - YUV";
    if(ColorMode == 1)
        OptionVideoValueItems[9] = "Auto - RGB";
    if(ColorMode == 2)
        OptionVideoValueItems[9] = "Custom";

    std::ostringstream NTSC;
    NTSC << NTSCResolution;
    std::string tempNTSC = NTSC.str();
    OptionVideoValueItems2[0] = (char*)tempNTSC.c_str();

    std::ostringstream NTSC2;
    NTSC2 << NTSCSharpness;
    std::string tempNTSC2 = NTSC2.str();
    OptionVideoValueItems2[1] = (char*)tempNTSC2.c_str();

    std::ostringstream NTSC3;
    NTSC3 << NTSCColorBleed;
    std::string tempNTSC3 = NTSC3.str();
    OptionVideoValueItems2[2] = (char*)tempNTSC3.c_str();

    std::ostringstream NTSC4;
    NTSC4 << NTSCArtifacts;
    std::string tempNTSC4 = NTSC4.str();
    OptionVideoValueItems2[3] = (char*)tempNTSC4.c_str();

    std::ostringstream NTSC5;
    NTSC5 << NTSCFringing;
    std::string tempNTSC5 = NTSC5.str();
    OptionVideoValueItems2[4] = (char*)tempNTSC5.c_str();
}

void StartGame(char* game) {
    BeforeGame();
    NestopiaMain(game);
    EndGame();
}

void OptionScreen() {
    char fileName[2048];
    if(!TexOption) {
        sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\option.png");
        D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
            D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
            D3DX_DEFAULT,0,NULL,NULL,&TexOption);
    }
}

void Init() {
    Unmount("C:");
    Unmount("E:");
    Unmount("F:");
    Unmount("G:");
    Unmount("R:");
    Unmount("X:");
    Unmount("Y:");
    Unmount("Z:");
    Mount("C:", "Harddisk0\\Partition2");
    Mount("E:", "Harddisk0\\Partition1");
    Mount("F:", "Harddisk0\\Partition6");
    Mount("G:", "Harddisk0\\Partition7");
    Mount("X:", "Harddisk0\\Partition3");
    Mount("Y:", "Harddisk0\\Partition4");
    Mount("Z:", "Harddisk0\\Partition5");
    Mount("R:","Cdrom0");	
    SetupPath();	
    LoadIni();
    DirectInit();
    Device->CreateVertexBuffer(sizeof(VertexListMenu),0,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferMenu);
    Device->CreateVertexBuffer(sizeof(VertexListMenu),0,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferMainMenuOverlay1);
    Device->CreateVertexBuffer(sizeof(VertexListMenu),0,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferMainMenuOverlay2);
    Device->CreateVertexBuffer(sizeof(VertexListMenu),0,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferMainMenuOverlay3);
    Device->CreateVertexBuffer(sizeof(VertexListMenu),0,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferMainMenuOverlay4);
    Device->CreateVertexBuffer(sizeof(VertexListMenu),0,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferMainMenuOverlay5);
    Device->CreateVertexBuffer(sizeof(VertexListMenu),0,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferMainMenuOverlay6);
    FontInit(1);
    SetFontHeight(FontSize);
    InputInit(); 
    DirectSoundInit();
    effectInit();
    GameOptionItems.push_back("Return to Game");
    GameOptionItems.push_back("Reset Game");
    GameOptionItems.push_back("Save State");
    GameOptionItems.push_back("Load State");
    GameOptionItems.push_back("Take Screenshot");
    GameOptionItems.push_back("Video Options");
    GameOptionItems.push_back("Sound Options");
    GameOptionItems.push_back("Controller Options");
    GameOptionItems.push_back("General Options");
    GameOptionItems.push_back("Cheat Codes");
    GameOptionItems.push_back("Game Info");
    GameOptionItems.push_back("Load Game Guide");
    GameOptionItems.push_back("Load Image");
    GameOptionItems.push_back("Exit Game");
    OptionEmulationVideoItems.push_back("Hardware Filter:"); OptionEmulationVideoValueItems.push_back("Point");
    OptionEmulationVideoItems.push_back("Software Filter:"); OptionEmulationVideoValueItems.push_back("No Filter");
    OptionEmulationVideoItems.push_back("Flicker Filter:"); OptionEmulationVideoValueItems.push_back("0");
    OptionEmulationVideoItems.push_back("Soften:"); OptionEmulationVideoValueItems.push_back("Off");
    OptionEmulationVideoItems.push_back("Adjust Screen"); OptionEmulationVideoValueItems.push_back("");
    OptionEmulationVideoItems.push_back("Vsync:"); OptionEmulationVideoValueItems.push_back("On");
    OptionEmulationVideoItems.push_back("Dim Resize Screen:"); OptionEmulationVideoValueItems.push_back("On");
    OptionEmulationVideoItems.push_back("10x11 Pixel Ratio:"); OptionEmulationVideoValueItems.push_back("Off");
    OptionEmulationVideoItems.push_back("Screenshot Save Slot:"); OptionEmulationVideoValueItems.push_back("1");
    OptionEmulationVideoItems.push_back("FPS Enabled:"); OptionEmulationVideoValueItems.push_back("False");
    OptionEmulationVideoItems.push_back("Color:"); OptionEmulationVideoValueItems.push_back("Auto - YUV");
    OptionEmulationVideoItems.push_back("Custom Palette:"); OptionEmulationVideoValueItems.push_back("None");
    OptionEmulationVideoItems.push_back("NTSC Custom Filter Settings"); OptionEmulationVideoValueItems.push_back("");

    OptionEmulationVideoItems2.push_back("Resolution:"); OptionEmulationVideoValueItems2.push_back("1");
    OptionEmulationVideoItems2.push_back("Sharpness:"); OptionEmulationVideoValueItems2.push_back("1");
    OptionEmulationVideoItems2.push_back("Color Bleed:"); OptionEmulationVideoValueItems2.push_back("1");
    OptionEmulationVideoItems2.push_back("Artifacts:"); OptionEmulationVideoValueItems2.push_back("1");
    OptionEmulationVideoItems2.push_back("Fringing:"); OptionEmulationVideoValueItems2.push_back("1");

    OptionEmulationSoundItems.push_back("Disable GUI Sound Effects:"); OptionEmulationSoundValueItems.push_back("False");
    OptionEmulationSoundItems.push_back("Emulation Music Volume:"); OptionEmulationSoundValueItems.push_back("100");
    OptionEmulationSoundItems.push_back("Rewind Sound:"); OptionEmulationSoundValueItems.push_back("Enabled");

    GeneralOptionsSettings.push_back("Flip FDS Disk"); GeneralOptionsValueSettings.push_back("");
    GeneralOptionsSettings.push_back("Set FDS Disk:"); GeneralOptionsValueSettings.push_back("Disk 1, Side A");
    GeneralOptionsSettings.push_back("Region:"); GeneralOptionsValueSettings.push_back("Auto");
    GeneralOptionsSettings.push_back("Unlimited Sprites:"); GeneralOptionsValueSettings.push_back("Enabled");
    GeneralOptionsSettings.push_back("Reset Type:"); GeneralOptionsValueSettings.push_back("Hard");
    GeneralOptionsSettings.push_back("Stop Movie"); GeneralOptionsValueSettings.push_back("");
    GeneralOptionsSettings.push_back("Play Movie"); GeneralOptionsValueSettings.push_back("");

    SaveStateItems.push_back("Slot 1");
    SaveStateItems.push_back("Slot 2");
    SaveStateItems.push_back("Slot 3");
    SaveStateItems.push_back("Slot 4");
    SaveStateItems.push_back("Slot 5");
    SaveStateItems.push_back("Slot 6");
    SaveStateItems.push_back("Slot 7");
    SaveStateItems.push_back("Slot 8");
    SaveStateItems.push_back("Slot 9");
    SaveStateItems.push_back("Slot 10");
    LoadStateItems.push_back("Slot 1");
    LoadStateItems.push_back("Slot 2");
    LoadStateItems.push_back("Slot 3");
    LoadStateItems.push_back("Slot 4");
    LoadStateItems.push_back("Slot 5");
    LoadStateItems.push_back("Slot 6");
    LoadStateItems.push_back("Slot 7");
    LoadStateItems.push_back("Slot 8");
    LoadStateItems.push_back("Slot 9");
    LoadStateItems.push_back("Slot 10");

    OptionScreen();
    Device->CreateVertexBuffer(sizeof(VertexList),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBuffer);
    Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferExitGame);	
    SetRenderStates();
    SetHardwareFilter();
    QueryPerformanceFrequency(&ticksPerSecondDelay);
    QueryPerformanceCounter(&tickDelay);
    lastTimeDelay = (FLOAT)tickDelay.QuadPart;
    ResetScreenSaver();
    setDisplay = true;
    BuildSkins();
    char fileName[2048];
    sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\previewborder.png");
    D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
        D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
        D3DX_DEFAULT,0,NULL,NULL,&TexPreviewBorder);

    sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\logo.png");
    D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
        D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
        D3DX_DEFAULT,0,NULL,NULL,&TexAnimatedLogo);

    sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\videoborder.png");
    D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
        D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
        D3DX_DEFAULT,0,NULL,NULL,&TexVideoBorder);

    sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\romborder.png");
    D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
        D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
        D3DX_DEFAULT,0,NULL,NULL,&TexROMBorder);

    sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\selectedborder.png");
    D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
        D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
        D3DX_DEFAULT,0,NULL,NULL,&TexSelectedBorder);

    sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\rombrowser.png");
    D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
        D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
        D3DX_DEFAULT,0,NULL,NULL,&TexROMBrowser);

    sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\overlay.png");
    D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
        D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
        D3DX_DEFAULT,0,NULL,NULL,&TexMainMenuOverlay);

    sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\mainmenu.png");
    D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
        D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
        D3DX_DEFAULT,0,NULL,NULL,&TexMainMenu);

    QueryPerformanceFrequency(&ticksPerSecondPreviewSwitch);
    QueryPerformanceCounter(&tickPreviewSwitch);
    lastTimePreviewSwitch = (FLOAT)tickPreviewSwitch.QuadPart;
    Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferPreview);
    Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferPreviewBorder);
    Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferPreviewVertical);
    Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferPreviewBorderVertical);
    Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferInfoBorder);
    Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferInfoBorderSimple);
    Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferVideoBorder);
    Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferDualVideoBorder);
    Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferROMBorder);
    Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferSelectBorder);
    Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferAlternatePreview);
    Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferAlternatePreviewBorder);
    Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferAlternatePreviewVertical);
    Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferAlternatePreviewBorderVertical);
    Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferAnimatedLogo);
    Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferAnimatedLogoMainMenu);
    Device->CreateVertexBuffer(sizeof(VertexListImage),0,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferImage);

    BuildFavorites();
    if(GameFavoriteSelected > FavoritesDatabase.size() - 1)
        GameFavoriteSelected = 0;

    MainMenuItems.push_back("Select Game");
    MainMenuItems.push_back("Favorite Games");
    MainMenuItems.push_back("Options");
    MainMenuItems.push_back("Utilities");
    MainMenuItems.push_back("Help");
    MainMenuItems.push_back("Exit");
    OptionItems.push_back("Video Options");
    OptionItems.push_back("Sound Options");
    OptionItems.push_back("Controller Options");
    OptionItems.push_back("GUI Options");
    OptionItems.push_back("Select GUI Skin");

    OptionVideoItems.push_back("Hardware Filter:"); OptionVideoValueItems.push_back("Point");
    OptionVideoItems.push_back("Software Filter:"); OptionVideoValueItems.push_back("No Filter");
    OptionVideoItems.push_back("Resolution:"); OptionVideoValueItems.push_back("1080i");
    OptionVideoItems.push_back("Flicker Filter:"); OptionVideoValueItems.push_back("0");
    OptionVideoItems.push_back("Soften:"); OptionVideoValueItems.push_back("Off");
    OptionVideoItems.push_back("Vsync:"); OptionVideoValueItems.push_back("On");
    OptionVideoItems.push_back("Dim Resize Screen:"); OptionVideoValueItems.push_back("On");
    OptionVideoItems.push_back("10x11 Pixel Ratio:"); OptionVideoValueItems.push_back("Off");
    OptionVideoItems.push_back("Adjust Default Screen Size"); OptionVideoValueItems.push_back("");
    OptionVideoItems.push_back("Color:"); OptionVideoValueItems.push_back("Auto - YUV");
    OptionVideoItems.push_back("Custom Palette:"); OptionVideoValueItems.push_back("None");
    OptionVideoItems.push_back("NTSC Custom Filter Settings"); OptionVideoValueItems.push_back("");

    OptionVideoItems2.push_back("Resolution:"); OptionVideoValueItems2.push_back("1");
    OptionVideoItems2.push_back("Sharpness:"); OptionVideoValueItems2.push_back("1");
    OptionVideoItems2.push_back("Color Bleed:"); OptionVideoValueItems2.push_back("1");
    OptionVideoItems2.push_back("Artifacts:"); OptionVideoValueItems2.push_back("1");
    OptionVideoItems2.push_back("Fringing:"); OptionVideoValueItems2.push_back("1");

    if(HardwareFilter == 0)
        OptionVideoValueItems[0] = "Point";
    if(HardwareFilter == 1)
        OptionVideoValueItems[0] = "Bilinear";
    if(HardwareFilter == 2)
        OptionVideoValueItems[0] = "Trilinear";
    if(HardwareFilter == 3)
        OptionVideoValueItems[0] = "Anisotropic";
    if(HardwareFilter == 4)
        OptionVideoValueItems[0] = "Quincunx";
    if(HardwareFilter == 5)
        OptionVideoValueItems[0] = "Gaussian Cubic";
    if(SoftwareFilter == 0)
        OptionVideoValueItems[1] = "No Filter";
    if(SoftwareFilter == 1)
        OptionVideoValueItems[1] = "Scale2X";
    if(SoftwareFilter == 2)
        OptionVideoValueItems[1] = "Scale3X";
    if(SoftwareFilter == 3)
        OptionVideoValueItems[1] = "HQ2X";
    if(SoftwareFilter == 4)
        OptionVideoValueItems[1] = "NTSC (Simulate Composite)";
    if(SoftwareFilter == 5)
        OptionVideoValueItems[1] = "NTSC (Simulate S-Video)";
    if(SoftwareFilter == 6)
        OptionVideoValueItems[1] = "NTSC (Simulate RGB)";
    if(SoftwareFilter == 7)
        OptionVideoValueItems[1] = "NTSC (Custom)";
    if(SoftwareFilter == 8)
        OptionVideoValueItems[1] = "Scanlines";
    if(SoftwareFilter == 9)
        OptionVideoValueItems[1] = "Super Eagle";
    if(SoftwareFilter == 10)
        OptionVideoValueItems[1] = "2XSAI";
    if(SoftwareFilter == 11)
        OptionVideoValueItems[1] = "Super 2XSAI";
    if(SoftwareFilter == 12)
        OptionVideoValueItems[1] = "AdvancedMAME";
    if(SoftwareFilter == 13)
        OptionVideoValueItems[1] = "Simple 2X";
    if(SoftwareFilter == 14)
        OptionVideoValueItems[1] = "SuperScale";
    if(SoftwareFilter == 15)
        OptionVideoValueItems[1] = "SuperScale75";
    if(HDMode == 0) 
        OptionVideoValueItems[2] = "480i/480p";
    if(HDMode == 1) 
        OptionVideoValueItems[2] = "720p";
    if(HDMode == 2) 
        OptionVideoValueItems[2] = "1080i";
    if(FlickerFilter == 0)
        OptionVideoValueItems[3] = "0";
    if(FlickerFilter == 1)
        OptionVideoValueItems[3] = "1";
    if(FlickerFilter == 2)
        OptionVideoValueItems[3] = "2";
    if(FlickerFilter == 3)
        OptionVideoValueItems[3] = "3";
    if(FlickerFilter == 4)
        OptionVideoValueItems[3] = "4";
    if(FlickerFilter == 5)
        OptionVideoValueItems[3] = "5";
    if(Soften == 0)
        OptionVideoValueItems[4] = "Off";
    if(Soften == 1)
        OptionVideoValueItems[4] = "On";
    if(vsyncEnabled == 0)
        OptionVideoValueItems[5] = "Off";
    if(vsyncEnabled == 1)
        OptionVideoValueItems[5] = "On";
    if(dimColor == 1) 
        OptionVideoValueItems[6] = "On";
    if(dimColor == 0)
        OptionVideoValueItems[6] = "Off";
    if(pixelRatio == 1) 
        OptionVideoValueItems[7] = "On";
    if(pixelRatio == 0)
        OptionVideoValueItems[7] = "Off";

    BuildPaletteList();
    if(PaletteSelected == -1) {
        OptionVideoValueItems[10] = "None";
    }
    else {
        if(PaletteList.size() > 0) {
            if(PaletteSelected <= (PaletteList.size() - 1)) {
                OptionVideoValueItems[10] = PaletteList[PaletteSelected].c_str();
            }
            else {
                OptionVideoValueItems[10] = "None";
                PaletteSelected = -1;
                if(ColorMode == 2)
                    ColorMode = 0;
            }
        }
        else {
            OptionVideoValueItems[10] = "None";
            PaletteSelected = -1;
            if(ColorMode == 2)
                ColorMode = 0;
        }
    }
    if(ColorMode == 0)
        OptionVideoValueItems[9] = "Auto - YUV";
    if(ColorMode == 1)
        OptionVideoValueItems[9] = "Auto - RGB";
    if(ColorMode == 2)
        OptionVideoValueItems[9] = "Custom";

    std::ostringstream NTSC;
    NTSC << NTSCResolution;
    std::string tempNTSC = NTSC.str();
    OptionVideoValueItems2[0] = (char*)tempNTSC.c_str();

    std::ostringstream NTSC2;
    NTSC2 << NTSCSharpness;
    std::string tempNTSC2 = NTSC2.str();
    OptionVideoValueItems2[1] = (char*)tempNTSC2.c_str();

    std::ostringstream NTSC3;
    NTSC3 << NTSCColorBleed;
    std::string tempNTSC3 = NTSC3.str();
    OptionVideoValueItems2[2] = (char*)tempNTSC3.c_str();

    std::ostringstream NTSC4;
    NTSC4 << NTSCArtifacts;
    std::string tempNTSC4 = NTSC4.str();
    OptionVideoValueItems2[3] = (char*)tempNTSC4.c_str();

    std::ostringstream NTSC5;
    NTSC5 << NTSCFringing;
    std::string tempNTSC5 = NTSC5.str();
    OptionVideoValueItems2[4] = (char*)tempNTSC5.c_str();

    OptionSoundItems.push_back("Disable GUI Sound Effects:"); OptionSoundValueItems.push_back("False");
    OptionSoundItems.push_back("GUI Background Music Volume:"); OptionSoundValueItems.push_back("0");
    OptionSoundItems.push_back("Surround Sound:"); OptionSoundValueItems.push_back("True");

    if(disableMenuSounds == 0)
        OptionSoundValueItems[0] = "False";
    else
        OptionSoundValueItems[0] = "True";
    std::ostringstream tempn;
    tempn << BackgroundMusicVolume;
    std::string temp2n = tempn.str();
    OptionSoundValueItems[1] = (char*)temp2n.c_str();


    if(SurroundSound == 1)
        OptionSoundValueItems[2] = "True";
    else
        OptionSoundValueItems[2] = "False";

    OptionControllerGeneralItems.push_back("Controller 1 Type:"); OptionControllerGeneralValueItems.push_back("Gamepad");
    OptionControllerGeneralItems.push_back("Controller 2 Type:"); OptionControllerGeneralValueItems.push_back("Gamepad");
    OptionControllerGeneralItems.push_back("Controller 3 Type:"); OptionControllerGeneralValueItems.push_back("Disconnected");
    OptionControllerGeneralItems.push_back("Controller 4 Type:"); OptionControllerGeneralValueItems.push_back("Disconnected");
    OptionControllerGeneralItems.push_back("Fast Forward:"); OptionControllerGeneralValueItems.push_back("Not Assigned");
    OptionControllerGeneralItems.push_back("Rewind:"); OptionControllerGeneralValueItems.push_back("Not Assigned");
    OptionControllerGeneralItems.push_back("VS Coin 1"); OptionControllerGeneralValueItems.push_back("Not Assigned");
    OptionControllerGeneralItems.push_back("VS Coin 2"); OptionControllerGeneralValueItems.push_back("Not Assigned");
    OptionControllerGeneralItems.push_back("Lightgun Cursor Color:"); OptionControllerGeneralValueItems.push_back("Yellow");
    OptionControllerGeneralItems.push_back("Lightgun Cursor Speed:"); OptionControllerGeneralValueItems.push_back("3");
    OptionControllerGeneralItems.push_back("Lightgun Cursor Enabled:"); OptionControllerGeneralValueItems.push_back("True");
    OptionControllerGeneralItems.push_back("Analog Dead Zone:"); OptionControllerGeneralValueItems.push_back("0.54");

    SetDefaultControllerValues();

    OptionGUIItems.push_back("Image Options");
    OptionGUIItems.push_back("Text Options");
    OptionGUITextItems.push_back("Game List Width:"); OptionGUITextValueItems.push_back(ConvertIntToString(GameListWidth));
    OptionGUITextItems.push_back("Game List Scroll Speed:"); OptionGUITextValueItems.push_back(ConvertIntToString(scrollSpeed));
    OptionGUITextItems.push_back("Game List Count:");  OptionGUITextValueItems.push_back(ConvertIntToString(GameListCount));
    OptionGUITextItems.push_back("Text Vertical Space:"); OptionGUITextValueItems.push_back(ConvertIntToString(vSpace));
    OptionGUITextItems.push_back("Font Size:"); OptionGUITextValueItems.push_back(ConvertFloatToString(FontSize));
    OptionGUITextItems.push_back("Menu Spacing:"); OptionGUITextValueItems.push_back(ConvertIntToString(MenuSpacing));
    OptionGUITextItems.push_back("Game List Adjust"); OptionGUITextValueItems.push_back("");
    OptionGUITextItems.push_back("Main Menu Adjust"); OptionGUITextValueItems.push_back("");
    OptionGUITextItems.push_back("Menu Details Adjust"); OptionGUITextValueItems.push_back("");
    OptionGUITextItems.push_back("Emulation Option Menu Adjust"); OptionGUITextValueItems.push_back("");
    OptionGUITextItems.push_back("Option Menu Adjust"); OptionGUITextValueItems.push_back("");
    OptionGUITextItems.push_back("Selected Game Text Adjust"); OptionGUITextValueItems.push_back("");
    OptionGUITextItems.push_back("Next Page"); OptionGUITextValueItems.push_back("");

    OptionGUITextPage2Items.push_back("Game Guide Line Count:"); OptionGUITextPage2ValueItems.push_back(ConvertIntToString(GameGuideLines));
    OptionGUITextPage2Items.push_back("Game Guide Color:"); 
    if(GameGuideColor == 0) 
        OptionGUITextPage2ValueItems.push_back("Green");
    else
        OptionGUITextPage2ValueItems.push_back("White");
    OptionGUITextPage2Items.push_back("Game Guide Font Size:"); OptionGUITextPage2ValueItems.push_back(ConvertFloatToString(GameGuideFontSize));
    OptionGUITextPage2Items.push_back("Game Guide Width:"); OptionGUITextPage2ValueItems.push_back(ConvertIntToString(GameGuideWidth));
    OptionGUITextPage2Items.push_back("Game Guide Vertical Space:"); OptionGUITextPage2ValueItems.push_back(ConvertIntToString(GameGuideVSpace));
    OptionGUITextPage2Items.push_back("Main Menu Font Size:"); OptionGUITextPage2ValueItems.push_back(ConvertFloatToString(MainMenuFontSize));
    OptionGUITextPage2Items.push_back("Main Menu Vertical Space:"); OptionGUITextPage2ValueItems.push_back(ConvertIntToString(MainMenuVSpace));
    OptionGUITextPage2Items.push_back("Main Menu Centered:");
    if(MainMenuCentered == 0)
        OptionGUITextPage2ValueItems.push_back("False");
    else
        OptionGUITextPage2ValueItems.push_back("True");

    OptionGUITextPage2Items.push_back("Basic ROM Names:");
    if(EditName == 0)
        OptionGUITextPage2ValueItems.push_back("False");
    else
        OptionGUITextPage2ValueItems.push_back("True");

    OptionGUIImageItems.push_back("GUI Adjust"); OptionGUIImageValueItems.push_back("");
    OptionGUIImageItems.push_back("Dual Preview Adjust"); OptionGUIImageValueItems.push_back("");
    OptionGUIImageItems.push_back("Exit Game Image Adjust"); OptionGUIImageValueItems.push_back("");
    OptionGUIImageItems.push_back("Exit Game Zoom Speed:"); OptionGUIImageValueItems.push_back(ConvertIntToString(zoomSpeed));
    OptionGUIImageItems.push_back("Image Fade Speed:"); OptionGUIImageValueItems.push_back(ConvertIntToString(fadeSpeed));
    OptionGUIImageItems.push_back("Video Preview Adjust"); OptionGUIImageValueItems.push_back("");
    OptionGUIImageItems.push_back("Main Menu Video Preview Adjust"); OptionGUIImageValueItems.push_back("");
    OptionGUIImageItems.push_back("Dual Preview Border Adjust"); OptionGUIImageValueItems.push_back("");
    OptionGUIImageItems.push_back("Video Preview Border Adjust"); OptionGUIImageValueItems.push_back("");
    OptionGUIImageItems.push_back("ROM List Background Adjust"); OptionGUIImageValueItems.push_back("");
    OptionGUIImageItems.push_back("Selected Game Background Adjust"); OptionGUIImageValueItems.push_back("");
    OptionGUIImageItems.push_back("Preview Adjust"); OptionGUIImageValueItems.push_back("");
    OptionGUIImageItems.push_back("Preview Border Adjust"); OptionGUIImageValueItems.push_back("");
    OptionGUIImageItems.push_back("ROM Browser Animated Logo Adjust"); OptionGUIImageValueItems.push_back("");
    OptionGUIImageItems.push_back("Next Page"); OptionGUIImageValueItems.push_back("");

    OptionGUIImageItemsPage2.push_back("ROM Browser Animated Logo Speed:"); 
    std::ostringstream q0;
    q0 << speedROMBrowserLogo;
    std::string w0 = q0.str();
    OptionGUIImageValueItemsPage2.push_back((char*)w0.c_str());

    OptionGUIImageItemsPage2.push_back("ROM Browser Animated Logo Distance:"); 
    std::ostringstream q1;
    q1 << distanceROMBrowserLogo;
    std::string w1 = q1.str();
    OptionGUIImageValueItemsPage2.push_back((char*)w1.c_str());

    OptionGUIImageItemsPage2.push_back("Main Menu Animated Logo Adjust"); OptionGUIImageValueItemsPage2.push_back("");
    OptionGUIImageItemsPage2.push_back("Main Menu Animated Logo Speed:"); 
    std::ostringstream e0;
    e0 << speedLogoMainMenu;
    w0 = e0.str();
    OptionGUIImageValueItemsPage2.push_back((char*)w0.c_str());

    OptionGUIImageItemsPage2.push_back("Main Menu Animated Logo Distance:"); 
    std::ostringstream e1;
    e1 << distanceLogoMainMenu;
    w1 = e1.str();
    OptionGUIImageValueItemsPage2.push_back((char*)w1.c_str());
    OptionGUIImageItemsPage2.push_back("Vertical Preview Adjust"); OptionGUIImageValueItemsPage2.push_back("");
    OptionGUIImageItemsPage2.push_back("Vertical Preview Border Adjust"); OptionGUIImageValueItemsPage2.push_back("");
    OptionGUIImageItemsPage2.push_back("Dual Vertical Preview Adjust"); OptionGUIImageValueItemsPage2.push_back("");
    OptionGUIImageItemsPage2.push_back("Dual Vertical Preview Border Adjust"); OptionGUIImageValueItemsPage2.push_back("");
    OptionGUIImageItemsPage2.push_back("Next Page"); OptionGUIImageValueItemsPage2.push_back("");
    OptionGUIImageItemsPage3.push_back("Main Menu Icon 1 Adjust"); OptionGUIImageValueItemsPage3.push_back("");
    OptionGUIImageItemsPage3.push_back("Main Menu Icon 2 Adjust"); OptionGUIImageValueItemsPage3.push_back("");
    OptionGUIImageItemsPage3.push_back("Main Menu Icon 3 Adjust"); OptionGUIImageValueItemsPage3.push_back("");
    OptionGUIImageItemsPage3.push_back("Main Menu Icon 4 Adjust"); OptionGUIImageValueItemsPage3.push_back("");
    OptionGUIImageItemsPage3.push_back("Main Menu Icon 5 Adjust"); OptionGUIImageValueItemsPage3.push_back("");
    OptionGUIImageItemsPage3.push_back("Main Menu Icon 6 Adjust"); OptionGUIImageValueItemsPage3.push_back("");
    OptionGUIImageItemsPage3.push_back("Dual Video Preview Adjust"); OptionGUIImageValueItemsPage3.push_back("");
    OptionGUIImageItemsPage3.push_back("Dual Video Preview Border Adjust"); OptionGUIImageValueItemsPage3.push_back("");
    OptionGUIImageItemsPage3.push_back("Video Previews:"); OptionGUIImageValueItemsPage3.push_back("Enabled");
    OptionGUIImageItemsPage3.push_back("Exit Game Controls:"); OptionGUIImageValueItemsPage3.push_back("Left Trigger + Right Trigger");
    OptionGUIImageItemsPage3.push_back("Main Menu Video Preview Change:"); OptionGUIImageValueItemsPage3.push_back("Enabled");
    OptionGUIImageItemsPage3.push_back("Video Preview Audio:"); OptionGUIImageValueItemsPage3.push_back("Enabled");

    if(PauseGame == 0)
        OptionGUIImageValueItemsPage3[9] = "Right Analog Click";
    if(PauseGame == 1)
        OptionGUIImageValueItemsPage3[9] = "Left Trigger + Right Trigger";
    if(PauseGame == 2)
        OptionGUIImageValueItemsPage3[9] = "Back + Start";
    if(PauseGame == 3)
        OptionGUIImageValueItemsPage3[9] = "Left Trigger + Back";
    if(PauseGame == 4)
        OptionGUIImageValueItemsPage3[9] = "Right Trigger + Back";

    if(MovieEnabled) {
        OptionGUIImageValueItemsPage3[8] = "Enabled";
    }
    else {
        OptionGUIImageValueItemsPage3[8] = "Disabled";
    }

    if(MainMenuMovieSwitchEnabled) {
        OptionGUIImageValueItemsPage3[10] = "Enabled";
    }
    else {
        OptionGUIImageValueItemsPage3[10] = "Disabled";
    }

    if(EnableVideoAudio) {
        OptionGUIImageValueItemsPage3[11] = "Enabled";
    }
    else {
        OptionGUIImageValueItemsPage3[11] = "Disabled";
    }
    ResetAnimatedLogo();
    ResetAnimatedLogoMainMenu();
    GUIState = 0;
    MenuBackground();
    setDisplay = true;

    QueryPerformanceFrequency(&ticksPerSecondROMBrowserLogo);
    QueryPerformanceFrequency(&ticksPerSecondLogoMainMenu);

    QueryPerformanceFrequency((union _LARGE_INTEGER *) m_performanceFreq);
    m_mp3player.dsound_init() ;
    m_mp3player.m_fps = 60;
    sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\backgroundmusic.mp3");
    m_mp3player.loadFile(fileName, 1, 0, 70*60*75 );
    m_mp3player.pause( FALSE );
    m_mp3player.adjust_volume(BackgroundMusicVolume);
    memset( m_mp3player.m_pSoundBufferData, 0, m_mp3player.stream_buffer_size);

    SetDelay();
    GameSelected = 0;
    GameFavoriteSelected = 0;
    setDisplay = false;
    Device->Clear(0,NULL,D3DCLEAR_TARGET,0x0,1.0f,0);
    Device->Present( NULL, NULL, NULL, NULL );
    Device->SetFlickerFilter(FlickerFilter);
    Device->SetSoftDisplayFilter(Soften);
    GUIState = MAIN_MENU;
    Init_2xSaIMMX(565);
    _2xSaiBuffer = (unsigned char*)osd_malloc(256 * 240 * 4);
    ZeroMemory(_2xSaiBuffer, 256 * 240 * 4);
    OptionGUIControllerItems.push_back("Configure Buttons");
    OptionGUIControllerItems.push_back("Turbo Options");
    OptionGUIControllerItems.push_back("General Settings");

    NESController n;
    n.A = 0;
    n.B = 2;
    n.Select = 8;
    n.Start = 9;
    NESControllers.push_back(n);
    NESControllers.push_back(n);
    NESControllers.push_back(n);
    NESControllers.push_back(n);

    for(int i = 0; i < 4; i++) {
        OptionControllerButtonItems[i].push_back("NES Button A:");
        OptionControllerButtonValueItems[i].push_back(GetButtonName(NESControllers[i].A));
        OptionControllerButtonItems[i].push_back("NES Button B:");
        OptionControllerButtonValueItems[i].push_back(GetButtonName(NESControllers[i].B));
        OptionControllerButtonItems[i].push_back("NES Button Select:");
        OptionControllerButtonValueItems[i].push_back(GetButtonName(NESControllers[i].Select));
        OptionControllerButtonItems[i].push_back("NES Button Start:");
        OptionControllerButtonValueItems[i].push_back(GetButtonName(NESControllers[i].Start));
    }

    OptionControllerTurboItems.push_back("Controller:");
    OptionControllerTurboItems.push_back("NES Button A:");
    OptionControllerTurboItems.push_back("NES Button B:");
    OptionControllerTurboItems.push_back("NES Button Select:");
    OptionControllerTurboItems.push_back("NES Button Start:");
    OptionControllerTurboItems.push_back("Turbo Speed:");
    OptionControllerTurboValueItems.push_back("1");
    OptionControllerTurboValueItems.push_back("Off");
    OptionControllerTurboValueItems.push_back("Off");
    OptionControllerTurboValueItems.push_back("Off");
    OptionControllerTurboValueItems.push_back("Off");
    OptionControllerTurboValueItems.push_back("7");

    SetupControllers();

    CommandLineLaunch = 0;
    XGetCustomLaunchData();
    if(g_autoLaunchGame == 1) {
        CommandLineLaunch = 1;
        string e = g_launchData.szFilename;
        globalGameName = e.substr(0, e.size() - 4);
        CreateDirectories(globalGameName);
        char game[2048];
        sprintf(game, "%s\\%s", RomPath1.c_str(), e.c_str());
        GUIState = 1;
        StartGame(game);
    }

    SplashScreen();
    g_hSoundThread = CreateThread( 
        NULL,                        // (this parameter is ignored)
        0,                           // use default stack size  
        Mp3player_ThreadFunc,                  // thread function 
        NULL,                // argument to thread function 
        0,                           // use default creation flags 
        &g_dwSoundThreadId); 
}

void UpdateGUI() {
    updateEffect();
    if(GUIState == MAIN_MENU) {
        MainMenu();
        return;
    }
    if(GUIState == ROM_SELECT) {
        ROMSelectMenu();
        return;
    }
    if(GUIState == FAVORITE_SELECT) {
        FavoriteSelectMenu();
        return;
    }
    if(GUIState == 3) {
        OptionMenu();
        return;
    }
    if(GUIState == 4) {
        OptionVideoMenu();
        return;
    }
    if(GUIState == 5) {
        OptionSoundMenu();
        return;
    }

    if(GUIState == 100) {
        OptionControllerGeneralMenu();
        return;
    }

    if(GUIState == 6) {
        OptionDefaultScreen();
        return;
    }

    if(GUIState == 7) {
        OptionGUIMenu();
        return;
    }

    if(GUIState == 8) {
        OptionVideoScaleMenu();
        return;
    }

    if(GUIState == 9) {
        OptionGUITextItemsMenu();
        return;
    }

    if(GUIState == 10) {
        OptionGUIImageItemsMenu();
        return;
    }

    if(GUIState == 11) {
        GuideListMenu();
        return;
    }

    if(GUIState == 17) {
        OptionGUITextItemsMenuPage2();
        return;
    }

    if(GUIState == 18) {
        OptionGUIImageItemsMenuPage2();
        return;
    }

    if(GUIState == 19) {
        GameListAdjust();
        return;
    }

    if(GUIState == 20) {
        MainMenuAdjust();
        return;
    }

    if(GUIState == 21) {
        MenuDetailAdjust();
        return;
    }

    if(GUIState == 22) {
        GameOptionAdjust();
        return;
    }

    if(GUIState == 23) {
        MenuAdjust();
        return;
    }

    if(GUIState == 24) {
        ROMAdjust();
        return;
    }

    if(GUIState == 27) { BackgroundAdjust(); return; }
    if(GUIState == 28) { PreviewAdjust(); return; }
    if(GUIState == 29) { ExitGameAdjust(); return; }
    if(GUIState == 30) { MovieAdjust(); return; }
    if(GUIState == 31) { MainMenuMovieAdjust(); return; }
    if(GUIState == 32) { PreviewBorderAdjust(); return; }
    if(GUIState == 34) { VideoBorderAdjust(); return; }
    if(GUIState == 35) { ROMBorderAdjust(); return; }
    if(GUIState == 36) { SelectBorderAdjust(); return; }
    if(GUIState == 37) { AlternatePreviewAdjust(); return; }
    if(GUIState == 38) { AlternatePreviewBorderAdjust(); return; }
    if(GUIState == 39) { AnimatedLogoAdjust(); return; }
    if(GUIState == 40) { AnimatedLogoMainMenuAdjust(); return; }
    if(GUIState == 42) { AlternatePreviewVerticalAdjust(); return; }
    if(GUIState == 43) { AlternatePreviewBorderVerticalAdjust(); return; }
    if(GUIState == 44) { PreviewVerticalAdjust(); return; }
    if(GUIState == 45) { PreviewBorderVerticalAdjust(); return; }
    if(GUIState == 46) { ExitGameAdjust90(); return; }
    if(GUIState == 47) { ExitGameAdjust180(); return; }
    if(GUIState == 48) { ExitGameAdjust270(); return; }
    if(GUIState == 49) {
        OptionGUIImageItemsMenuPage3();
        return;
    }
    if(GUIState == 50) { MainMenuOverlay1Adjust(); return; }
    if(GUIState == 51) { MainMenuOverlay2Adjust(); return; }
    if(GUIState == 52) { MainMenuOverlay3Adjust(); return; }
    if(GUIState == 53) { MainMenuOverlay4Adjust(); return; }
    if(GUIState == 54) { MainMenuOverlay5Adjust(); return; }
    if(GUIState == 55) { MainMenuOverlay6Adjust(); return; }
    if(GUIState == 56) { DualMovieAdjust(); return; }
    if(GUIState == 57) { DualVideoBorderAdjust(); return; }
    if(GUIState == 58) { UtilityMenu(); return; }
    if(GUIState == 59) { OptionVideoMenu2(); return; }
    return;
}

void RunGUI() {
    while(true) {
        UpdateGUI();
        Sleep(1);
    }
}

LONG CALLBACK ExceptionFilter(_EXCEPTION_POINTERS* pExceptionInfo)
{
    DxSoundStop();
    NestopiaXCrashed();
    return 0;

}

void __cdecl main()
{
    srand(time(NULL));
    SetUnhandledExceptionFilter(ExceptionFilter);
    Init();
    RunGUI();
}