#include "GlobalExtern.h"

void GameInfoDetailAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		ExitROMSelectEditMenu();
		GameInfoDetailResize = false;
		GUIState = 17;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) GameInfoDetailPosY-=1; // Up
	if (g_Gamepads[DefaultController].fY1 < 0) GameInfoDetailPosY+=1;  // Down
	if (g_Gamepads[DefaultController].fX1 < 0) GameInfoDetailPosX-=1; // Up
	if (g_Gamepads[DefaultController].fX1 > 0) GameInfoDetailPosX+=1;  // Down

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	DrawROMSelectEditMenu();
	DisplayInstructions("Use the left analog stick to adjust the text.");
	Present();	
}

void OptionGUITextItemsPage2Input() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		
		GUIState = 9;
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  { 
		ClickSound();
		OptionGUITextPage2Selected++;
		if(OptionGUITextPage2Selected > OptionGUITextPage2Items.size() - 1)
			OptionGUITextPage2Selected = 0;
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  { 
		ClickSound();
		OptionGUITextPage2Selected--;
		if(OptionGUITextPage2Selected < 0)
			OptionGUITextPage2Selected = OptionGUITextPage2Items.size() - 1;
		return;
	}  

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_X) {
		ConfirmSound();
		if(OptionGUITextPage2Selected == 0) {
			GameGuideLines-=1;
			if(GameGuideLines < 1)
				GameGuideLines = 1; 
			OptionGUITextPage2ValueItems[0] = ConvertIntToString(GameGuideLines);
			return;
		}
		if(OptionGUITextPage2Selected == 1) {
			GameGuideColor-=1;
			if(GameGuideColor < 0)
				GameGuideColor = 1;
			if(GameGuideColor == 0) 
				OptionGUITextPage2ValueItems[1] = "Green";
			else
				OptionGUITextPage2ValueItems[1] = "White";
			return;
		}
		if(OptionGUITextPage2Selected == 2) {
			GameGuideFontSize-=0.1;
			if(GameGuideFontSize < 0.1)
				GameGuideFontSize = 10;
			OptionGUITextPage2ValueItems[2] = ConvertFloatToString(GameGuideFontSize);
			return;
		}
		if(OptionGUITextPage2Selected == 3) {
			GameGuideWidth-=1;
			if(GameGuideWidth < 1)
				GameGuideWidth = sWidth;
			OptionGUITextPage2ValueItems[3] = ConvertIntToString(GameGuideWidth);
			return;
		}
		if(OptionGUITextPage2Selected == 4) {
			GameGuideVSpace-=1;
			if(GameGuideVSpace < 1)
				GameGuideVSpace = 100;
			OptionGUITextPage2ValueItems[4] = ConvertIntToString(GameGuideVSpace);
			return;
		}
		if(OptionGUITextPage2Selected == 5) {
			MainMenuFontSize-=0.1;
			if(MainMenuFontSize < 0.1)
				MainMenuFontSize = 10;
			OptionGUITextPage2ValueItems[5] = ConvertFloatToString(MainMenuFontSize);
			return;
		}
		if(OptionGUITextPage2Selected == 6) {
			MainMenuVSpace-=1;
			if(MainMenuVSpace < 1)
				MainMenuVSpace = 100;
			OptionGUITextPage2ValueItems[6] = ConvertIntToString(MainMenuVSpace);
			return;
		}
	}

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		ConfirmSound();
		if(OptionGUITextPage2Selected == 0) {
			GameGuideLines+=1;
			if(GameGuideLines > 100)
				GameGuideLines = 1;
			OptionGUITextPage2ValueItems[0] = ConvertIntToString(GameGuideLines);
			return;
		}
		if(OptionGUITextPage2Selected == 1) {
			GameGuideColor+=1;
			if(GameGuideColor > 1)
				GameGuideColor = 0;
			if(GameGuideColor == 0) 
				OptionGUITextPage2ValueItems[1] = "Green";
			else
				OptionGUITextPage2ValueItems[1] = "White";
			return;
		}
		if(OptionGUITextPage2Selected == 2) {
			GameGuideFontSize+=0.1;
			if(GameGuideFontSize > 10)
				GameGuideFontSize = 0.1;
			OptionGUITextPage2ValueItems[2] = ConvertFloatToString(GameGuideFontSize);
			return;
		}
		if(OptionGUITextPage2Selected == 3) {
			GameGuideWidth+=1;
			if(GameGuideWidth > sWidth)
				GameGuideWidth = 1;
			OptionGUITextPage2ValueItems[3] = ConvertIntToString(GameGuideWidth);
			return;
		}
		if(OptionGUITextPage2Selected == 4) {
			GameGuideVSpace+=1;
			if(GameGuideVSpace > 100)
				GameGuideVSpace = 1; 
			OptionGUITextPage2ValueItems[4] = ConvertIntToString(GameGuideVSpace);
			return;
		}
		
		if(OptionGUITextPage2Selected == 5) {
			MainMenuFontSize+=0.1;
			if(MainMenuFontSize > 10)
				MainMenuFontSize = 0.1;
			OptionGUITextPage2ValueItems[5] = ConvertFloatToString(MainMenuFontSize);
			return;
		}

		if(OptionGUITextPage2Selected == 6) {
			MainMenuVSpace+=1;
			if(MainMenuVSpace > 100)
				MainMenuVSpace = 1;
			OptionGUITextPage2ValueItems[6] = ConvertIntToString(MainMenuVSpace);
			return;
		}

		if(OptionGUITextPage2Selected == 7) {
			MainMenuCentered+=1;
			if(MainMenuCentered > 1)
				MainMenuCentered = 0;
			if(MainMenuCentered == 0)
				OptionGUITextPage2ValueItems[7] = "False";
			else
				OptionGUITextPage2ValueItems[7] = "True";
			return;
		}

		if(OptionGUITextPage2Selected == 8) {
			EditName+=1;
			if(EditName > 1)
				EditName = 0;
			if(EditName == 0)
				OptionGUITextPage2ValueItems[8] = "False";
			else
				OptionGUITextPage2ValueItems[8] = "True";
			return;
		}


	}
	return;
}

void GameListAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		ExitROMSelectEditMenu();
		GUIState = 9;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) GameListY-=1; // Up
	if (g_Gamepads[DefaultController].fY1 < 0) GameListY+=1;  // Down
	if (g_Gamepads[DefaultController].fX1 < 0) GameListX-=1;  // Left
	if (g_Gamepads[DefaultController].fX1 > 0) GameListX+=1; // Right

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	DrawROMSelectEditMenu();
	DisplayInstructions("Use the left analog stick to adjust the text."); 
	Present();
}

void MainMenuAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		GUIState = 9;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) MainMenuPosY-=1; // Up
	if (g_Gamepads[DefaultController].fY1 < 0) MainMenuPosY+=1;  // Down
	if (g_Gamepads[DefaultController].fX1 < 0) MainMenuPosX-=1; // Up
	if (g_Gamepads[DefaultController].fX1 > 0) MainMenuPosX+=1;  // Down

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexMainMenu);
	DrawBackground();
	for(int i = 0; i < MainMenuItems.size(); i++) {
		DrawMainMenuItem(i, (char*)MainMenuItems[i].c_str(), MainMenuPosX, MainMenuPosY + (i * MainMenuVSpace));
	}
	DisplayInstructions("Use the left analog stick to adjust the text.");
	Present();
}

void MenuDetailAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		GUIState = 9;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) MenuDetailPosY-=1; // Up
	if (g_Gamepads[DefaultController].fY1 < 0) MenuDetailPosY+=1;  // Down
	if (g_Gamepads[DefaultController].fX1 < 0) MenuDetailPosX-=1;  // Left
	if (g_Gamepads[DefaultController].fX1 > 0) MenuDetailPosX+=1; // Right

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	for(int i = 0; i < OptionSoundItems.size(); i++) {
		DrawOptionVideoItem(i, (char*)OptionSoundItems[i].c_str(), MenuDetailPosX, MenuDetailPosY + (i * vSpace));
		DrawOptionVideoItem(i, (char*)OptionSoundValueItems[i].c_str(), MenuDetailPosX + MenuSpacing, MenuDetailPosY + (i * vSpace));
	}
	DisplayInstructions("Use the left analog stick to adjust the text."); 
	Present();	
}

void GameOptionAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		GUIState = 9;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) GameOptionPosY-=1; // Up
	if (g_Gamepads[DefaultController].fY1 < 0) GameOptionPosY+=1;  // Down
	if (g_Gamepads[DefaultController].fX1 < 0) GameOptionPosX-=1;  // Left
	if (g_Gamepads[DefaultController].fX1 > 0) GameOptionPosX+=1; // Right

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	for(int i = 0; i < GameOptionItems.size(); i++) {
		DrawGameOptionItem(i, (char*)GameOptionItems[i].c_str(), GameOptionPosX, GameOptionPosY + (i * vSpace));
	}
	DisplayInstructions("Use the left analog stick to adjust the text."); 
	Present();		
}

void MenuAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		GUIState = 9;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) MenuPosY-=1; // Up
	if (g_Gamepads[DefaultController].fY1 < 0) MenuPosY+=1;  // Down
	if (g_Gamepads[DefaultController].fX1 < 0) MenuPosX-=1; // Up
	if (g_Gamepads[DefaultController].fX1 > 0) MenuPosX+=1;  // Down

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexMainMenu);
	DrawBackground();
	for(int i = 0; i < OptionItems.size(); i++) {
		DrawOptionItem(i, (char*)OptionItems[i].c_str(), MenuPosX, MenuPosY + (i * vSpace));
	}
	DisplayInstructions("Use the left analog stick to adjust the text.");
	Present();	
}

void ROMAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		ExitROMSelectEditMenu();
		GUIState = 9;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) ROMPosY-=1; // Up
	if (g_Gamepads[DefaultController].fY1 < 0) ROMPosY+=1;  // Down

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	DrawROMSelectEditMenu();
	DisplayInstructions("Use the left analog stick to adjust the text.");
	Present();		
}

void GameInfoAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		ExitROMSelectEditMenu();
		GameInfoResize = false;
		GUIState = 9;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) GameInfoPosY-=1; // Up
	if (g_Gamepads[DefaultController].fY1 < 0) GameInfoPosY+=1;  // Down
	if (g_Gamepads[DefaultController].fX1 < 0) GameInfoPosX-=1; // Up
	if (g_Gamepads[DefaultController].fX1 > 0) GameInfoPosX+=1;  // Down

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	DrawROMSelectEditMenu();
	DisplayInstructions("Use the left analog stick to adjust the text.");
	Present();	
}

void OptionGUITextItemsInput() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		GUIState = 7;
		
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  { 
		ClickSound();
		OptionGUITextSelected++;
		if(OptionGUITextSelected > OptionGUITextItems.size() - 1)
			OptionGUITextSelected = 0;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
		ClickSound();
		OptionGUITextSelected--;
		if(OptionGUITextSelected < 0)
			OptionGUITextSelected = OptionGUITextItems.size() - 1;
	}  

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_X) {
		ConfirmSound();
		if(OptionGUITextSelected == 0) {
			GameListWidth--;
			if(GameListWidth < 0)
				GameListWidth = sWidth;
			OptionGUITextValueItems[0] = ConvertIntToString(GameListWidth);
			return;
		}
		if(OptionGUITextSelected == 1) {
			scrollSpeed--;
			if(scrollSpeed < 0)
				scrollSpeed = 100;
			OptionGUITextValueItems[1] = ConvertIntToString(scrollSpeed);
			return;
		}
		if(OptionGUITextSelected == 2) {
			GameListCount--;
			if(GameListCount < 0)
				GameListCount =100;
			OptionGUITextValueItems[2] = ConvertIntToString(GameListCount);
			return;
		}
		if(OptionGUITextSelected == 3) {
			vSpace--;
			if(vSpace < 1)
				vSpace = 100;
			OptionGUITextValueItems[3] = ConvertIntToString(vSpace);
			return;
		}
		if(OptionGUITextSelected == 4) {
			FontSize-=0.1;
			if(FontSize < 0.1)
				FontSize = 10;
			OptionGUITextValueItems[4] = ConvertFloatToString(FontSize);
			SetFontHeight(FontSize);
			return;
		}
		if(OptionGUITextSelected == 5) {
			MenuSpacing--;
			if(MenuSpacing < 0)
				MenuSpacing = sWidth;
			OptionGUITextValueItems[5] = ConvertIntToString(MenuSpacing);
			return;
		}
	}

	if (g_Gamepads[DefaultController].fY2 > 0) {
		if(OptionGUITextSelected == 0) {
			GameListWidth+=1;
			if(GameListWidth > sWidth)
				GameListWidth = 0;
			OptionGUITextValueItems[0] = ConvertIntToString(GameListWidth);
			return;
		}
	}

	if (g_Gamepads[DefaultController].fY2 < 0) {
		if(OptionGUITextSelected == 0) {
			GameListWidth-=1;
			if(GameListWidth < 0)
				GameListWidth = sWidth;
			OptionGUITextValueItems[0] = ConvertIntToString(GameListWidth);
			return;
		}
	}

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		ConfirmSound();
		if(OptionGUITextSelected == 0) {
			GameListWidth++;
			if(GameListWidth > sWidth)
				GameListWidth = 0;
			OptionGUITextValueItems[0] = ConvertIntToString(GameListWidth);
			return;
		}
		if(OptionGUITextSelected == 1) {
			scrollSpeed++;
			if(scrollSpeed > 100)
				scrollSpeed = 0;
			OptionGUITextValueItems[1] = ConvertIntToString(scrollSpeed);
			return;
		}
		if(OptionGUITextSelected == 2) {
			GameListCount++;
			if(GameListCount > 100)
				GameListCount = 0;
			OptionGUITextValueItems[2] = ConvertIntToString(GameListCount);
			return;
		}
		if(OptionGUITextSelected == 3) {
			vSpace++;
			if(vSpace > 100)
				vSpace = 1;
			OptionGUITextValueItems[3] = ConvertIntToString(vSpace);
			return;
		}
		if(OptionGUITextSelected == 4) {
			FontSize+=0.1;
			if(FontSize > 10)
				FontSize = 0.1;
			OptionGUITextValueItems[4] = ConvertFloatToString(FontSize);
			SetFontHeight(FontSize);
			return;
		}
		if(OptionGUITextSelected == 5) {
			MenuSpacing++;
			if(MenuSpacing > sWidth)
				MenuSpacing = 0;
			OptionGUITextValueItems[5] = ConvertIntToString(MenuSpacing);
			return;
		}

		if(OptionGUITextSelected == 6) {
			InitROMSelectEditMenu();
			GUIState = 19;
		}

		if(OptionGUITextSelected == 7) {
			GUIState = 20;
		}

		if(OptionGUITextSelected == 8) {
			GUIState = 21;
		}

		if(OptionGUITextSelected == 9) {
			GUIState = 22;
		}

		if(OptionGUITextSelected == 10) {
			GUIState = 23;
		}

		if(OptionGUITextSelected == 11) {
			InitROMSelectEditMenu();
			GUIState = 24;
		}

		if(OptionGUITextSelected == 12) {
			GUIState = 17;
			return;
		}
	}
}

void OptionGUITextItemsMenuPage2() {
	OptionGUITextItemsPage2Input();
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	for(int i = 0; i < OptionGUITextPage2Items.size(); i++) {
		DrawOptionGUITextPage2Item(i, (char*)OptionGUITextPage2Items[i].c_str(), MenuDetailPosX, MenuDetailPosY + (i * vSpace));
		DrawOptionGUITextPage2Item(i, (char*)OptionGUITextPage2ValueItems[i].c_str(), MenuDetailPosX + MenuSpacing, MenuDetailPosY + (i * vSpace));
	}
	Present();	
}

void DrawOptionGUITextItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(OptionGUITextSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawOptionGUITextPage2Item(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(OptionGUITextPage2Selected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawOptionGUITextItemsMenu() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	for(int i = 0; i < OptionGUITextItems.size(); i++) {
		DrawOptionGUITextItem(i, (char*)OptionGUITextItems[i].c_str(), MenuDetailPosX, MenuDetailPosY + (i * vSpace));
		DrawOptionGUITextItem(i, (char*)OptionGUITextValueItems[i].c_str(), MenuDetailPosX + MenuSpacing, MenuDetailPosY + (i * vSpace));
	}
	Present();
}

void OptionGUITextItemsMenu() {
	OptionGUITextItemsInput();
	DrawOptionGUITextItemsMenu();
}

