// Burner Input Set dialog module
#include "burner.h"

unsigned int nInpsInput = 0;				// The input number we are redefining
static struct BurnInputInfo bii;			// Info about the input
static int nDlgState = 0;
static int nInputCode = -1;					// If in state 3, code N was nInputCode
static int nCounter = 0;					// Counter of frames since the dialog was made
static struct GameInp* pgi = NULL;			// Current GameInp
static struct GameInp OldInp;				// Old GameInp
static int bOldPush = 0;					// 1 if the push button was pressed last time
static bool bGrabMouse = false;
static bool bOldLeftAltkeyMapped;

static int InpsInit()
{
	TCHAR szTitle[128];
	memset(&OldInp, 0, sizeof(OldInp));

	pgi = NULL;
	if (nInpsInput >= nGameInpCount + nMacroCount) {		// input out of range
		return 1;
	}
	pgi = GameInp + nInpsInput;

	memset(&bii,0,sizeof(bii));
	BurnDrvGetInputInfo(&bii, nInpsInput);

	if (bii.nType & BIT_GROUP_CONSTANT) {					// This dialog doesn't handle constants
		return 1;
	}

	OldInp = *pgi;
	bOldPush = 0;

	bGrabMouse = false;

	bOldLeftAltkeyMapped = bLeftAltkeyMapped;
	bLeftAltkeyMapped = true;

	// Set the dialog title
	if (nInpsInput >= nGameInpCount) {
		// Macro
//		_stprintf(szTitle, FBALoadStringEx(hAppInst, IDS_INPSET_MOVENAME, true), pgi->Macro.szName);
	} else {
		// Normal input
		if (bii.szName == NULL || bii.szName[0] == _T('\0')) {
//			_stprintf(szTitle, FBALoadStringEx(hAppInst, IDS_INPSET_MOVE, true));
		} else {
//			_stprintf(szTitle, FBALoadStringEx(hAppInst, IDS_INPSET_MOVENAME, true), bii.szName);
		}
	}

	InputFind(2);

	nDlgState = 4;
	nInputCode = -1;
	nCounter = 0;

	return 0;
}

static int InpsExit()
{
	bOldPush = 0;
	if (pgi != NULL) {
		*pgi=OldInp;
	}
	memset(&OldInp, 0, sizeof(OldInp));

	bLeftAltkeyMapped = bOldLeftAltkeyMapped;

	nDlgState = 0;

	return 0;
}

static int SetInput(int nCode)
{
	if ((pgi->nInput & GIT_GROUP_MACRO) == 0) {

		if (bii.nType & BIT_GROUP_CONSTANT) {							// Don't change dip switches!
			return 0;
		}

		if ((bii.nType & BIT_GROUP_ANALOG) && (nCode & 0xFF) < 0x10) {	// Analog controls
			if (strcmp(bii.szInfo + 4, "-axis-neg") == 0 || strcmp(bii.szInfo + 4, "-axis-pos") == 0) {
				if ((nCode & 0xF000) == 0x4000) {
					if (nCode & 1) {
						pgi->nInput = GIT_JOYAXIS_POS;
					} else {
						pgi->nInput = GIT_JOYAXIS_NEG;
					}
					pgi->Input.JoyAxis.nJoy = (nCode & 0x0F00) >> 8;
					pgi->Input.JoyAxis.nAxis = (nCode & 0x0F) >> 1;
				}
			} else {													// Map entire axis
				if ((nCode & 0xF000) == 0x4000) {
					pgi->nInput = GIT_JOYAXIS_FULL;
					pgi->Input.JoyAxis.nJoy = (nCode & 0x0F00) >> 8;
					pgi->Input.JoyAxis.nAxis = (nCode & 0x0F) >> 1;
				} else {
					pgi->nInput = GIT_MOUSEAXIS;
					pgi->Input.MouseAxis.nMouse = (nCode & 0x0F00) >> 8;
					pgi->Input.MouseAxis.nAxis = (nCode & 0x0F) >> 1;
				}
			}
		} else {
			pgi->nInput = GIT_SWITCH;
			pgi->Input.Switch.nCode = (unsigned short)nCode;
		}
	} else {
		pgi->Macro.nMode = 0x01;										// Mark macro as in use
		pgi->Macro.Switch.nCode = (unsigned short)nCode;				// Assign switch
	}

	OldInp = *pgi;

	return 0;
}

static int InpsPushUpdate()
{
	return 0;
}

static void InpsUpdateControl(int nCode)
{
	TCHAR szString[260] = _T("");
	TCHAR szDevice[260] = _T("");
	TCHAR szControl[260] = _T("");

	_stprintf(szString, _T("%s"), InputCodeDesc(nCode));
//	SetWindowText(GetDlgItem(hInpsDlg, IDC_INPS_CONTROL), szString);

	InputGetControlName(nCode, szDevice, szControl);
	_sntprintf(szString, 260, _T("%s %s"), szDevice, szControl);
//	SetWindowText(GetDlgItem(hInpsDlg, IDC_INPS_CONTROL_NAME), szString);
}

int InpsUpdate()
{
	return 0;
}

int InpsCreate()
{
	return 0;
}
