#include "GlobalExtern.h"

int xS = 320;
int yS = 240;
float xMove = 1;
float yMove = 1;
vector <Category> gameTypelist;
extern float GetFontHeight();
extern void SortGameList();
extern void SortFavoritesList();

void InitROMSelectEditMenu() {
    if(TexPreview) {
        TexPreview->Release();
        TexPreview = NULL;
    }
    if(GUIState >= 42 && GUIState <= 45)
        D3DXCreateTextureFromFileEx(Device, "D:\\media\\previewbox.png", D3DX_DEFAULT,
        D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
        D3DX_DEFAULT,0,NULL,NULL,&TexPreview);
    else
        D3DXCreateTextureFromFileEx(Device, "D:\\media\\preview.png", D3DX_DEFAULT,
        D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
        D3DX_DEFAULT,0,NULL,NULL,&TexPreview);
    initMovie("D:\\media\\videopreview.xmv");
}

void BuildPaletteList() {
    PaletteList.clear();
    HANDLE find=NULL;
    WIN32_FIND_DATA wfd;
    memset(&wfd,0,sizeof(wfd));
    find=FindFirstFile("D:\\palettes\\*",&wfd);

    if (find ==INVALID_HANDLE_VALUE){ //Empty directory
        return;
    }

    do {
        if(!(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)) {
            //Not a folder		 
            std::string fileFound(wfd.cFileName);
            if((fileFound.find(".pal", 0) != string::npos) || 
                (fileFound.find(".PAL", 0) != string::npos)) {
                    fileFound = fileFound.substr(0, fileFound.size() - 4);
                    PaletteList.push_back(fileFound);	
            }
        }
    } while (FindNextFile(find,&wfd) !=0);
    sort(PaletteList.begin(), PaletteList.end());
}


void ExitROMSelectEditMenu() {
    if(TexPreview) {
        TexPreview->Release();
        TexPreview = NULL;
    }
    GameInfoDetail.clear();
    stopMovie();
}

void DrawROMSelectEditMenu() {
    Device->SetTexture(0,TexROMBrowser);
    DrawBackground();

    if(PreviewResize || PreviewBorderResize) {
        Device->SetTexture(0,TexPreview);
        MakeVertexListPreview();
        Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
        Device->SetTexture(0,TexPreviewBorder);
        MakeVertexListPreviewBorder();
        Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
        Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
        Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
    }

    if(PreviewVerticalResize || PreviewBorderVerticalResize) {
        Device->SetTexture(0,TexPreview);
        MakeVertexListPreviewVertical();
        Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
        Device->SetTexture(0,TexPreviewBorder);
        MakeVertexListPreviewBorderVertical();
        Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
        Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
        Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
    }

    if(AlternatePreviewResize || AlternatePreviewBorderResize) {
        Device->SetTexture(0,TexPreview);
        MakeVertexListAlternatePreview();
        Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
        Device->SetTexture(0,TexPreviewBorder);
        MakeVertexListAlternatePreviewBorder();
        Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
        Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
        Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
    }

    if(AlternatePreviewVerticalResize || AlternatePreviewBorderVerticalResize) {
        Device->SetTexture(0,TexPreview);
        MakeVertexListAlternatePreviewVertical();
        Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
        Device->SetTexture(0,TexPreviewBorder);
        MakeVertexListAlternatePreviewBorderVertical();
        Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
        Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
        Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
    }

    if(VideoResize || GUIState == 34) {
        Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
        drawMovie();
        Device->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
        Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
        Device->SetTexture(0,TexVideoBorder);
        MakeVertexListVideoBorder();
        Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
    }

    if(DualVideoResize || DualVideoBorderResize || GUIState == 28 ||
        GUIState == 32 || GUIState == 44 || GUIState == 45) {
            Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
            drawMovie();
            Device->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
            Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
            Device->SetTexture(0,TexVideoBorder);
            MakeVertexListDualVideoBorder();
            Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
    }

    Device->SetTexture(0,TexROMBorder);
    MakeVertexListROMBorder();
    Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
    Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
    FontSetColour(0xFFFFFF00);
    for(int i = 0; i <  GameListCount; i++) {
        FontText(ConvertCharStringToWCHAR("Mike Tyson's Punch-Out!! (U) (PRG0) [!]"),
            GameListX, GameListY + (i * vSpace), GameListWidth);
        FontSetColour(0xFFFFFFFF);
    }

    Device->SetTexture(0,TexSelectedBorder);
    MakeVertexListSelectedBorder();
    Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
    FontGUI(ConvertCharStringToWCHAR("Mike Tyson's Punch-Out!! (U) (PRG0) [!]"), MenuPosX, ROMPosY, 640);
    Device->SetTexture(0,TexAnimatedLogo);
    MakeVertexListAnimatedLogo(false);
    Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
    Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
    Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
}

void ResetAnimatedLogo() {
    zLeftAnimatedLogoTemp = zLeftAnimatedLogo;
    zRightAnimatedLogoTemp = zRightAnimatedLogo;
    zTopAnimatedLogoTemp = zTopAnimatedLogo;
    zBottomAnimatedLogoTemp = zBottomAnimatedLogo;
    lMoveROMBrowserLogo = -1 * distanceROMBrowserLogo;
    rMoveROMBrowserLogo = distanceROMBrowserLogo;
    tMoveROMBrowserLogo = distanceROMBrowserLogo;
    bMoveROMBrowserLogo = -1 * distanceROMBrowserLogo;
    cMoveROMBrowserLogo = 0;
    lastTimeROMBrowserLogo = 0;
}

void ClickSound() {
    if(!disableMenuSounds) {
        playEffect(1);
    }
}

void CancelSound() {
    if(!disableMenuSounds) {
        playEffect(0);
    }
}

void ConfirmSound() {
    if(!disableMenuSounds) {
        playEffect(2);
    }
}

void CyclePreview(int e) {
    CurrentArtwork += e;
    if(CurrentArtwork > 8) CurrentArtwork = 1;
    if(CurrentArtwork < 1) CurrentArtwork = 8;
    if(CurrentArtwork == 1) 
        OptionEmulationVideoValueItems[8] = "1";
    if(CurrentArtwork == 2) 
        OptionEmulationVideoValueItems[8] = "2";
    if(CurrentArtwork == 3) 
        OptionEmulationVideoValueItems[8] = "3";
    if(CurrentArtwork == 4) 
        OptionEmulationVideoValueItems[8] = "4";
    if(CurrentArtwork == 5) 
        OptionEmulationVideoValueItems[8] = "5";
    if(CurrentArtwork == 6) 
        OptionEmulationVideoValueItems[8] = "6";
    if(CurrentArtwork == 7) 
        OptionEmulationVideoValueItems[8] = "7";
    if(CurrentArtwork == 8) 
        OptionEmulationVideoValueItems[8] = "8";
}

void ResetFiles(){
    char fileName[2048];
    for(int i = 0; i < 2048; i++) fileName[i] = '\0';
    sprintf(fileName,"%s%s", IniPath.c_str(), "\\controller\\*");

    HANDLE find=NULL;
    WIN32_FIND_DATA wfd;
    memset(&wfd,0,sizeof(wfd));
    find=FindFirstFile(fileName,&wfd);

    if (find ==INVALID_HANDLE_VALUE){ //Empty directory
        return;
    }
    do {
        if(!(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)) {
            std::string fileFound(wfd.cFileName);
            if(fileFound.find(".ini", 0) != string::npos) {
                SaveGameIni(fileFound.substr(0, fileFound.size() - 4));
                globalGameName = fileFound.substr(0, fileFound.size() - 4);
                SaveControllerIni();
                globalGameName = "";
            }
        }
    } while (FindNextFile(find,&wfd) !=0);
}

DWORD WINAPI Mp3player_ThreadFunc( LPVOID lpParam ) { 
    float FPS ;
    unsigned int perfCurr[2] ;
    unsigned int perfPrev[2] ;
    QueryPerformanceCounter((union _LARGE_INTEGER *) perfPrev);

    while (1) {
        do {
            if(Emulation == 1) {
                m_mp3player.pause(TRUE);
            }
            else {
                if(MovieEnabled && videoRender && EnableVideoAudio && (GUIState == 1 || GUIState == 2)) {
                    m_mp3player.pause(TRUE);
                }
            }

            QueryPerformanceCounter((union _LARGE_INTEGER *) perfCurr);

            if (perfCurr[0] != perfPrev[0]) {					
                FPS = (float) (m_performanceFreq[0])  / (float) (perfCurr[0] - perfPrev[0]);
            } 
            else {
                FPS = 200.0f ;
            }
            Sleep(1) ;
        } while ( FPS > 120 ) ;

        perfPrev[0] = perfCurr[0];

        m_mp3player.processReal() ;

    }
    return 0; 
}

DWORD WINAPI Mp3player_ThreadFuncSplash( LPVOID lpParam ) { 
    float FPS ;
    unsigned int perfCurr[2] ;
    unsigned int perfPrev[2] ;
    QueryPerformanceCounter((union _LARGE_INTEGER *) perfPrev);

    while (1) {
        if(SplashFinshed) return 0;
        do {
            if(SplashFinshed) return 0;
            QueryPerformanceCounter((union _LARGE_INTEGER *) perfCurr);

            if (perfCurr[0] != perfPrev[0]) {					
                FPS = (float) (m_performanceFreqSplash[0])  / (float) (perfCurr[0] - perfPrev[0]);
            } 
            else {
                FPS = 200.0f ;
            }
            Sleep(1) ;
        } while ( FPS > 120 ) ;

        perfPrev[0] = perfCurr[0];

        m_mp3playerSplash.processReal() ;

    }
    return 0; 
}

string ConvertIntToString(int n) {
    char q[133];
    std::string e;
    for(int i = 0; i < 133; i++) 
        q[i] = '\0'; 
    itoa(n, q, 10); 
    e = q; 
    return e;
}

string ConvertFloatToString(float n) {
    std::ostringstream temp;
    temp << n;
    return temp.str();;
}

WCHAR* ConvertCharStringToWCHAR(char* q) {
    std::string t = q;
    for(int r = 0; r < 1024; r++) {
        if((t.c_str())[r] == '\0') {
            msg[r] = '\0';
            break;
        }
        msg[r] = (WCHAR)(t.c_str())[r];
    }
    return msg;
}

std::string GetFileString(FILE* f) {
    std::string e = "";
	char line[260];
	for(int i = 0; i < 260; i++) line[i] = '\0';
	fgets(line,260, f);
	for(int i = 0; i < 260; i++) {
		if(line[i] == '\n' || line[i] == '\0') {
			e += '\0';
			break;
		}
		e += line[i];
	}
	int temp = e.find("=", 0);
	if(temp != -1) {
		if(temp == (e.size() - 1))
			e = "";
		else
			e = e.substr(temp + 1, e.size() - temp);
	}
	return e;
}

int GetFileInteger(FILE * f) {
    char line[100];
    fgets(line,100, f);
    for(int i = 0; i < 100; i++) {
        if(line[i] == '=') {
            return (int) atof(&line[i+1]);
        }
    }
    return -1;
}

float GetFileFloat(FILE * f) {
    char line[100];
    fgets(line,100, f);
    for(int i = 0; i < 100; i++) {
        if(line[i] == '=') {
            return atof(&line[i+1]);
        }
    }
    return -1;
}

void DisplayMessage(char* q) {
    Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
    Device->SetTexture(0,TexOption);
    DrawBackground();
    FontSetColour(0xffffff);
    FontCenteredText(ConvertCharStringToWCHAR(q), 320, 240, 640);
    Present();
}

void DisplayCenteredMsg(char* q, int y) {
    FontSetColour(0xffff00);
    FontCenteredText(ConvertCharStringToWCHAR(q),320,240, sWidth);
}

void DrawMsg(char* text, int x, int y) {
    FontSetColour(0xffffff);
    FontText(ConvertCharStringToWCHAR(text), x, y, sWidth);
}

void DrawGameInfoItem(char* text, int x, int y) {
    FontSetColour(0xffffff);
    FontText(ConvertCharStringToWCHAR(text), x, y, gameInfoListWidth);
}

void ResetScreenSaver() {
    QueryPerformanceCounter(&ScreenSaverDelay);
    ScreenSaverLastTimeDelay = (FLOAT)ScreenSaverDelay.QuadPart;
}

bool StartScreenSaver() {
    QueryPerformanceCounter(&ScreenSaverDelay);
    if((((FLOAT)ScreenSaverDelay.QuadPart) - ScreenSaverLastTimeDelay) >=
        (((FLOAT)ticksPerSecondDelay.QuadPart) * (screenSaverTime * 60))) {
            return true;
    }
    else {
        return false;
    }
}

bool ButtonPressed() {
    if((g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN) ||
        (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP) ||
        (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_LEFT) ||
        (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_RIGHT) ||
        (g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) ||
        (g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) ||
        (g_Gamepads[DefaultController].wButtons & XINPUT_GAMEPAD_BACK) ||
        (g_Gamepads[DefaultController].wButtons & XINPUT_GAMEPAD_START) ||
        (g_Gamepads[DefaultController].Event == XBGAMEPAD_A) ||
        (g_Gamepads[DefaultController].Event == XBGAMEPAD_B) ||
        (g_Gamepads[DefaultController].Event == XBGAMEPAD_X) ||
        (g_Gamepads[DefaultController].Event == XBGAMEPAD_Y) ||
        (g_Gamepads[DefaultController].fX1 > 0) ||
        (g_Gamepads[DefaultController].fX1 < 0) ||
        (g_Gamepads[DefaultController].fY1 > 0) ||
        (g_Gamepads[DefaultController].fY1 < 0) ||
        (g_Gamepads[DefaultController].fX2 > 0) ||
        (g_Gamepads[DefaultController].fX2 < 0) ||
        (g_Gamepads[DefaultController].fY2 > 0) ||
        (g_Gamepads[DefaultController].fY2 < 0) ||
        (g_Gamepads[DefaultController].wButtons & XINPUT_GAMEPAD_LEFT_THUMB) ||
        (g_Gamepads[DefaultController].wButtons & XINPUT_GAMEPAD_RIGHT_THUMB)) {
            return true;
    }
    else {
        return false;
    }	
}

void ScreenSaver() {
    xS += xMove;
    yS += yMove;

    if(xS > 488) {
        xMove *= -1;
    }
    if(yS > 421) {
        yMove *= -1;
    }
    if(xS < 147) {
        xMove *= -1;
    }
    if(yS < 7) {
        yMove *= -1;
    }

    Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
    if(sWidth == 640)
        SetFontHeight(1.33);
    if(sWidth == 1280)
        SetFontHeight(2.66);
    if(sWidth == 1920)
        SetFontHeight(4);
    FontSetColour(0x4B4B4B);
    FontGUI(ConvertCharStringToWCHAR("NestopiaX Emulator"), xS, yS, 640);
    Device->Present(NULL,NULL,NULL,NULL);
}

void Present() {
    if(!ButtonPressed()) {
        if(StartScreenSaver()) {
            float oldFont = GetFontHeight();
            while(true) {
                ReadInput();
                if(ButtonPressed()) {
                    SetFontHeight(oldFont);
                    ResetScreenSaver();
                    break;
                }
                ScreenSaver();
            }
        }
        else {
            Device->Present(NULL,NULL,NULL,NULL);
        }
    }
    else {
        ResetScreenSaver();
        Device->Present(NULL,NULL,NULL,NULL);
    }
}

void DrawGameInformationDetail() {
    if(GameInfoDetail.size() == 0) return;
    SetFontHeight(GameInfoDetailFontSize);
    int start = 0;
    if(GameInfoDetailSelected > (GameInfoDetailNumLines / 2) && (GameInfoDetail.size() > GameInfoDetailNumLines)) {
        start += (GameInfoDetailSelected  - (GameInfoDetailNumLines / 2));
    }
    if((GameInfoDetailSelected > ((GameInfoDetail.size()-1) - (GameInfoDetailNumLines / 2))) && (GameInfoDetail.size() > GameInfoDetailNumLines)) {
        start = (GameInfoDetail.size() - GameInfoDetailNumLines);
    }
    int e = 0;
    for(int i = start; i <  start + GameInfoDetailNumLines; i++) {
        if(i == GameInfoDetail.size()) return;
        FontSetColour(0xffffff);
        FontText(ConvertCharStringToWCHAR((char*)GameInfoDetail[i].c_str()),
            GameInfoDetailPosX, GameInfoDetailPosY + (e * GameInfoDetailVSpace), GameInfoDetailWidth);
        e++;
    }
    SetFontHeight(FontSize);
}

void DrawGameInformation() {	

}

void DrawGameFavoriteInformation() {	

}

void SaveGameIni(string e) {
    FILE* f;
    char fileName[2048];
    for(int i = 0; i < 2048; i++) fileName[i] = '\0';
    sprintf(fileName,"%s%s%s%s", IniPath.c_str(), "\\emulation\\", e.c_str(), ".ini");
    f = fopen(fileName, "w+");
    if(!f) {
        LD_LAUNCH_DASHBOARD launch;
        memset(&launch,0,sizeof(launch));
        launch.dwReason=XLD_LAUNCH_DASHBOARD_MAIN_MENU;
        XLaunchNewImage(NULL,(LAUNCH_DATA *)&launch);
    }

    fprintf(f, "zLeft=%f\n", zLeft);
    fprintf(f, "zRight=%f\n", zRight);
    fprintf(f, "zTop=%f\n", zTop);
    fprintf(f, "zBottom=%f\n", zBottom);
    fprintf(f, "SoftwareFilter=%d\n", SoftwareFilter);
    fprintf(f, "HardwareFilter=%d\n", HardwareFilter);
    fprintf(f, "vsyncEnabled=%d\n", vsyncEnabled);
    fprintf(f, "pixelRatio=%d\n", pixelRatio);
    fprintf(f, "FlickerFilter=%d\n", FlickerFilter);
    fprintf(f, "Soften=%d\n", Soften);
    fprintf(f, "disableMenuSounds=%d\n", disableMenuSounds);
    fprintf(f, "Region=%d\n", Region);
    fprintf(f, "UnlimitedSprites=%d\n", UnlimitedSprites);
    fprintf(f, "EmulationMusicVolume=%d\n", nDSoundVol);
    fprintf(f, "ResetType=%d\n", ResetType);
    fprintf(f, "RewindSound=%d\n", RewindSound);
    fprintf(f, "ColorMode=%d\n", ColorMode);
    fprintf(f, "PaletteSelected=%d\n", PaletteSelected);
    fprintf(f, "NTSCResolution=%d\n", NTSCResolution);
    fprintf(f, "NTSCSharpness=%d\n", NTSCSharpness);
    fprintf(f, "NTSCColorBleed=%d\n", NTSCColorBleed);
    fprintf(f, "NTSCArtifacts=%d\n", NTSCArtifacts);
    fprintf(f, "NTSCFringing=%d\n", NTSCFringing);
    fclose(f);
}

void LoadGameIni(string e) {
    FILE* f;
    char fileName[2048];
    for(int i = 0; i < 2048; i++) fileName[i] = '\0';
    sprintf(fileName,"%s%s%s%s", IniPath.c_str(), "\\emulation\\", e.c_str(), ".ini");
    f = fopen(fileName , "r");
    if(f) {
        zLeft = GetFileFloat(f);
        zRight = GetFileFloat(f);
        zTop = GetFileFloat(f);
        zBottom = GetFileFloat(f);
        SoftwareFilter = GetFileInteger(f);
        HardwareFilter = GetFileInteger(f);
        vsyncEnabled = GetFileInteger(f);
        pixelRatio = GetFileInteger(f);
        FlickerFilter = GetFileInteger(f);
        Soften = GetFileInteger(f);
        disableMenuSounds = GetFileInteger(f);
        Region = GetFileInteger(f);
        UnlimitedSprites = GetFileInteger(f);
        nDSoundVol = (long)GetFileInteger(f);
        ResetType = GetFileInteger(f);
        RewindSound = GetFileInteger(f);
        ColorMode = GetFileInteger(f);
        PaletteSelected = GetFileInteger(f);
        NTSCResolution = GetFileInteger(f);
        NTSCSharpness = GetFileInteger(f);
        NTSCColorBleed = GetFileInteger(f);
        NTSCArtifacts = GetFileInteger(f);
        NTSCFringing = GetFileInteger(f);

        if(HardwareFilter == 0)
            OptionEmulationVideoValueItems[0] = "Point";
        if(HardwareFilter == 1)
            OptionEmulationVideoValueItems[0] = "Bilinear";
        if(HardwareFilter == 2)
            OptionEmulationVideoValueItems[0] = "Trilinear";
        if(HardwareFilter == 3)
            OptionEmulationVideoValueItems[0] = "Anisotropic";
        if(HardwareFilter == 4)
            OptionEmulationVideoValueItems[0] = "Quincunx";
        if(HardwareFilter == 5)
            OptionEmulationVideoValueItems[0] = "Gaussian Cubic";
        if(SoftwareFilter == 0)
            OptionEmulationVideoValueItems[1] = "No Filter";
        if(SoftwareFilter == 1)
            OptionEmulationVideoValueItems[1] = "Scale2X";
        if(SoftwareFilter == 2)
            OptionEmulationVideoValueItems[1] = "Scale3X";
        if(SoftwareFilter == 3)
            OptionEmulationVideoValueItems[1] = "HQ2X";
        if(SoftwareFilter == 4)
            OptionEmulationVideoValueItems[1] = "NTSC (Simulate Composite)";
        if(SoftwareFilter == 5)
            OptionEmulationVideoValueItems[1] = "NTSC (Simulate S-Video)";
        if(SoftwareFilter == 6)
            OptionEmulationVideoValueItems[1] = "NTSC (Simulate RGB)";
        if(SoftwareFilter == 7)
            OptionEmulationVideoValueItems[1] = "NTSC (Custom)";
        if(SoftwareFilter == 8)
            OptionEmulationVideoValueItems[1] = "Scanlines";
        if(SoftwareFilter == 9)
            OptionEmulationVideoValueItems[1] = "Super Eagle";
        if(SoftwareFilter == 10)
            OptionEmulationVideoValueItems[1] = "2XSAI";
        if(SoftwareFilter == 11)
            OptionEmulationVideoValueItems[1] = "Super 2XSAI";
        if(SoftwareFilter == 12)
            OptionEmulationVideoValueItems[1] = "AdvancedMAME";
        if(SoftwareFilter == 13)
            OptionEmulationVideoValueItems[1] = "Simple 2X";
        if(SoftwareFilter == 14)
            OptionEmulationVideoValueItems[1] = "SuperScale";
        if(SoftwareFilter == 15)
            OptionEmulationVideoValueItems[1] = "SuperScale75";
        if(FlickerFilter == 0)
            OptionEmulationVideoValueItems[2] = "0";
        if(FlickerFilter == 1)
            OptionEmulationVideoValueItems[2] = "1";
        if(FlickerFilter == 2)
            OptionEmulationVideoValueItems[2] = "2";
        if(FlickerFilter == 3)
            OptionEmulationVideoValueItems[2] = "3";
        if(FlickerFilter == 4)
            OptionEmulationVideoValueItems[2] = "4";
        if(FlickerFilter == 5)
            OptionEmulationVideoValueItems[2] = "5";

        if(Soften == 0)
            OptionEmulationVideoValueItems[3] = "Off";
        if(Soften == 1)
            OptionEmulationVideoValueItems[3] = "On";
        if(vsyncEnabled == 0)
            OptionEmulationVideoValueItems[5] = "Off";
        if(vsyncEnabled == 1)
            OptionEmulationVideoValueItems[5] = "On";
        if(dimColor == 1) 
            OptionEmulationVideoValueItems[6] = "On";
        if(dimColor == 0)
            OptionEmulationVideoValueItems[6] = "Off";
        if(pixelRatio == 1) 
            OptionEmulationVideoValueItems[7] = "On";
        if(pixelRatio == 0)
            OptionEmulationVideoValueItems[7] = "Off";
        if(disableMenuSounds == 0)
            OptionEmulationSoundValueItems[0] = "False";
        else
            OptionEmulationSoundValueItems[0] = "True";

        if(Region == 0)
            GeneralOptionsValueSettings[2] = "Auto";
        if(Region == 1)
            GeneralOptionsValueSettings[2] = "NTSC";
        if(Region == 2)
            GeneralOptionsValueSettings[2] = "PAL";
        if(Region == 3)
            GeneralOptionsValueSettings[2] = "Famicom";
        if(Region == 4)
            GeneralOptionsValueSettings[2] = "Dendy";

        if(UnlimitedSprites == 1)
            GeneralOptionsValueSettings[3] = "Enabled";
        else
            GeneralOptionsValueSettings[3] = "Disabled";

        std::ostringstream temp;
        temp << nDSoundVol;
        std::string temp2 = temp.str();
        OptionEmulationSoundValueItems[1] = temp2.c_str();

        if(ResetType == 1)
            GeneralOptionsValueSettings[4] = "Soft";
        else
            GeneralOptionsValueSettings[4] = "Hard";

        if(RewindSound == 1)
            OptionEmulationSoundValueItems[2] = "Enabled";
        else
            OptionEmulationSoundValueItems[2] = "Disabled";

        if(PaletteSelected == -1) {
            OptionEmulationVideoValueItems[11] = "None";
        }
        else {
            if(PaletteList.size() > 0) {
                if(PaletteSelected <= (PaletteList.size() - 1)) {
                    OptionEmulationVideoValueItems[11] = PaletteList[PaletteSelected].c_str();
                }
                else {
                    OptionEmulationVideoValueItems[11] = "None";
                    PaletteSelected = -1;
                    if(ColorMode == 2)
                        ColorMode = 0;
                }
            }
            else {
                OptionEmulationVideoValueItems[11] = "None";
                PaletteSelected = -1;
                if(ColorMode == 2)
                    ColorMode = 0;
            }
        }

        if(ColorMode == 0)
            OptionEmulationVideoValueItems[10] = "Auto - YUV";
        if(ColorMode == 1)
            OptionEmulationVideoValueItems[10] = "Auto - RGB";
        if(ColorMode == 2)
            OptionEmulationVideoValueItems[10] = "Custom";
        fclose(f);

        std::ostringstream NTSC;
        NTSC << NTSCResolution;
        std::string tempNTSC = NTSC.str();
        OptionEmulationVideoValueItems2[0] = (char*)tempNTSC.c_str();

        std::ostringstream NTSC2;
        NTSC2 << NTSCSharpness;
        std::string tempNTSC2 = NTSC2.str();
        OptionEmulationVideoValueItems2[1] = (char*)tempNTSC2.c_str();

        std::ostringstream NTSC3;
        NTSC3 << NTSCColorBleed;
        std::string tempNTSC3 = NTSC3.str();
        OptionEmulationVideoValueItems2[2] = (char*)tempNTSC3.c_str();

        std::ostringstream NTSC4;
        NTSC4 << NTSCArtifacts;
        std::string tempNTSC4 = NTSC4.str();
        OptionEmulationVideoValueItems2[3] = (char*)tempNTSC4.c_str();

        std::ostringstream NTSC5;
        NTSC5 << NTSCFringing;
        std::string tempNTSC5 = NTSC5.str();
        OptionEmulationVideoValueItems2[4] = (char*)tempNTSC5.c_str();
    }
    else {
        SaveGameIni(e);
        LoadGameIni(e);
    }
}

void SaveIni() {
    FILE* f;
    char fileName[2048];
    sprintf(fileName,"%s%s", IniPath.c_str(), "\\NestopiaX.ini");
    f = fopen(fileName, "w+");
    if(!f) {
        LD_LAUNCH_DASHBOARD launch;
        memset(&launch,0,sizeof(launch));
        launch.dwReason=XLD_LAUNCH_DASHBOARD_MAIN_MENU;
        XLaunchNewImage(NULL,(LAUNCH_DATA *)&launch);
    }
    fprintf(f, "GameListWidth=%d\n", GameListWidth);
    fprintf(f, "GameListX=%d\n", GameListX);
    fprintf(f, "GameListY=%d\n", GameListY);
    fprintf(f, "HDMode=%d\n", HDMode);
    fprintf(f, "vSpace=%d\n", vSpace);
    fprintf(f, "SoftwareFilter=%d\n", SoftwareFilter);
    fprintf(f, "HardwareFilter=%d\n", HardwareFilter);
    fprintf(f, "vsyncEnabled=%d\n", vsyncEnabled);
    fprintf(f, "dimColor=%d\n", dimColor);
    fprintf(f, "pixelRatio=%d\n", pixelRatio);
    fprintf(f, "FlickerFilter=%d\n", FlickerFilter);
    fprintf(f, "Soften=%d\n", Soften);
    fprintf(f, "scrollSpeed=%d\n", scrollSpeed);
    fprintf(f, "GameSelected=%d\n", GameSelected);
    fprintf(f, "GameFavoriteSelected=%d\n", GameFavoriteSelected);
    fprintf(f, "GameOptionPosX=%d\n", GameOptionPosX);
    fprintf(f, "GameOptionPosY=%d\n", GameOptionPosY);
    fprintf(f, "FontSize=%f\n", FontSize);
    fprintf(f, "GameListCount=%d\n", GameListCount);
    fprintf(f, "DefaultController=%d\n", DefaultController);
    fprintf(f, "MenuSpacing=%d\n", MenuSpacing);
    fprintf(f, "MainMenuPosY=%d\n", MainMenuPosY);
    fprintf(f, "MainMenuPosX=%d\n", MainMenuPosX);
    fprintf(f, "MainMenuVSpace=%d\n", MainMenuVSpace);
    fprintf(f, "MainMenuFontSize=%f\n", MainMenuFontSize);
    fprintf(f, "MainMenuCentered=%d\n", MainMenuCentered);
    fprintf(f, "MenuPosY=%d\n", MenuPosY);
    fprintf(f, "MenuPosX=%d\n", MenuPosX);
    fprintf(f, "MenuDetailPosX=%d\n", MenuDetailPosX);
    fprintf(f, "MenuDetailPosY=%d\n", MenuDetailPosY);
    fprintf(f, "ROMPosY=%d\n", ROMPosY);
    fprintf(f, "zLeftMenu=%f\n", zLeftMenu);
    fprintf(f, "zRightMenu=%f\n", zRightMenu);
    fprintf(f, "zTopMenu=%f\n", zTopMenu);
    fprintf(f, "zBottomMenu=%f\n", zBottomMenu);
    fprintf(f, "zLeftPreview=%f\n", zLeftPreview);
    fprintf(f, "zRightPreview=%f\n", zRightPreview);
    fprintf(f, "zTopPreview=%f\n", zTopPreview);
    fprintf(f, "zBottomPreview=%f\n", zBottomPreview);
    fprintf(f, "GameInfoPosX=%d\n", GameInfoPosX);
    fprintf(f, "GameInfoPosY=%d\n", GameInfoPosY);
    fprintf(f, "GameInfoFontSize=%f\n", GameInfoFontSize);
    fprintf(f, "GameInfoVSpace=%d\n", GameInfoVSpace);
    fprintf(f, "GameInfoDetailNumLines=%d\n", GameInfoDetailNumLines);
    fprintf(f, "GameInfoDetailPosX=%d\n", GameInfoDetailPosX);
    fprintf(f, "GameInfoDetailPosY=%d\n", GameInfoDetailPosY);
    fprintf(f, "GameInfoDetailFontSize=%f\n", GameInfoDetailFontSize);
    fprintf(f, "GameInfoDetailWidth=%d\n", GameInfoDetailWidth);
    fprintf(f, "GameInfoDetailVSpace=%d\n", GameInfoDetailVSpace);
    fprintf(f, "zoomSpeed=%d\n", zoomSpeed);
    fprintf(f, "gameInfoListWidth=%d\n", gameInfoListWidth);
    fprintf(f, "GameGuideLines=%d\n", GameGuideLines);
    fprintf(f, "GameGuideColor=%d\n", GameGuideColor);
    fprintf(f, "GameGuideFontSize=%f\n", GameGuideFontSize);
    fprintf(f, "guideLeft=%d\n", guideLeft);
    if(GUIState != ROM_SELECT && GUIState != FAVORITE_SELECT) 
        GUIState = MAIN_MENU;
    fprintf(f, "GUIState=%d\n", GUIState);
    fprintf(f, "fadeSpeed=%d\n", fadeSpeed);
    fprintf(f, "GameGuideWidth=%d\n", GameGuideWidth);
    fprintf(f, "GameGuideVSpace=%d\n", GameGuideVSpace);
    fprintf(f, "disableMenuSounds=%d\n", disableMenuSounds);
    fprintf(f, "fLeft=%f\n", fLeft);
    fprintf(f, "fRight=%f\n", fRight);
    fprintf(f, "fTop=%f\n", fTop);
    fprintf(f, "fBottom=%f\n", fBottom);
    fprintf(f, "fLeftMenu=%f\n", fLeftMenu);
    fprintf(f, "fRightMenu=%f\n", fRightMenu);
    fprintf(f, "fTopMenu=%f\n", fTopMenu);
    fprintf(f, "fBottomMenu=%f\n", fBottomMenu);
    fprintf(f, "zLeftPreviewBorder=%f\n", zLeftPreviewBorder);
    fprintf(f, "zRightPreviewBorder=%f\n", zRightPreviewBorder);
    fprintf(f, "zTopPreviewBorder=%f\n", zTopPreviewBorder);
    fprintf(f, "zBottomPreviewBorder=%f\n", zBottomPreviewBorder);
    fprintf(f, "zLeftInfoBorder=%f\n", zLeftInfoBorder);
    fprintf(f, "zRightInfoBorder=%f\n", zRightInfoBorder);
    fprintf(f, "zTopInfoBorder=%f\n", zTopInfoBorder);
    fprintf(f, "zBottomInfoBorder=%f\n", zBottomInfoBorder);
    fprintf(f, "zLeftVideoBorder=%f\n", zLeftVideoBorder);
    fprintf(f, "zRightVideoBorder=%f\n", zRightVideoBorder);
    fprintf(f, "zTopVideoBorder=%f\n", zTopVideoBorder);
    fprintf(f, "zBottomVideoBorder=%f\n", zBottomVideoBorder);
    fprintf(f, "zLeftROMBorder=%f\n", zLeftROMBorder);
    fprintf(f, "zRightROMBorder=%f\n", zRightROMBorder);
    fprintf(f, "zTopROMBorder=%f\n", zTopROMBorder);
    fprintf(f, "zBottomROMBorder=%f\n", zBottomROMBorder);
    fprintf(f, "zLeftSelectBorder=%f\n", zLeftSelectBorder);
    fprintf(f, "zRightSelectBorder=%f\n", zRightSelectBorder);
    fprintf(f, "zTopSelectBorder=%f\n", zTopSelectBorder);
    fprintf(f, "zBottomSelectBorder=%f\n", zBottomSelectBorder);
    fprintf(f, "zLeftAlternatePreview=%f\n", zLeftAlternatePreview);
    fprintf(f, "zRightAlternatePreview=%f\n", zRightAlternatePreview);
    fprintf(f, "zTopAlternatePreview=%f\n", zTopAlternatePreview);
    fprintf(f, "zBottomAlternatePreview=%f\n", zBottomAlternatePreview);
    fprintf(f, "zLeftAlternatePreviewBorder=%f\n", zLeftAlternatePreviewBorder);
    fprintf(f, "zRightAlternatePreviewBorder=%f\n", zRightAlternatePreviewBorder);
    fprintf(f, "zTopAlternatePreviewBorder=%f\n", zTopAlternatePreviewBorder);
    fprintf(f, "zBottomAlternatePreviewBorder=%f\n", zBottomAlternatePreviewBorder);
    fprintf(f, "zLeftAnimatedLogo=%f\n", zLeftAnimatedLogo);
    fprintf(f, "zRightAnimatedLogo=%f\n", zRightAnimatedLogo);
    fprintf(f, "zTopAnimatedLogo=%f\n", zTopAnimatedLogo);
    fprintf(f, "zBottomAnimatedLogo=%f\n", zBottomAnimatedLogo);
    fprintf(f, "speedROMBrowserLogo=%f\n", speedROMBrowserLogo);
    fprintf(f, "distanceROMBrowserLogo=%f\n", distanceROMBrowserLogo);
    fprintf(f, "zLeftAnimatedLogoMainMenu=%f\n", zLeftAnimatedLogoMainMenu);
    fprintf(f, "zRightAnimatedLogoMainMenu=%f\n", zRightAnimatedLogoMainMenu);
    fprintf(f, "zTopAnimatedLogoMainMenu=%f\n", zTopAnimatedLogoMainMenu);
    fprintf(f, "zBottomAnimatedLogoMainMenu=%f\n", zBottomAnimatedLogoMainMenu);
    fprintf(f, "speedLogoMainMenu=%f\n", speedLogoMainMenu);
    fprintf(f, "distanceLogoMainMenu=%f\n", distanceLogoMainMenu);
    fprintf(f, "zLeftInfoBorderSimple=%f\n", zLeftInfoBorderSimple);
    fprintf(f, "zRightInfoBorderSimple=%f\n", zRightInfoBorderSimple);
    fprintf(f, "zTopInfoBorderSimple=%f\n", zTopInfoBorderSimple);
    fprintf(f, "zBottomInfoBorderSimple=%f\n", zBottomInfoBorderSimple);
    fprintf(f, "BackgroundMusicVolume=%d\n", BackgroundMusicVolume);
    fprintf(f, "%s\n", SkinPath.c_str());
    fprintf(f, "zLeftPreviewVertical=%f\n", zLeftPreviewVertical);
    fprintf(f, "zRightPreviewVertical=%f\n", zRightPreviewVertical);
    fprintf(f, "zTopPreviewVertical=%f\n", zTopPreviewVertical);
    fprintf(f, "zBottomPreviewVertical=%f\n", zBottomPreviewVertical);
    fprintf(f, "zLeftPreviewBorderVertical=%f\n", zLeftPreviewBorderVertical);
    fprintf(f, "zRightPreviewBorderVertical=%f\n", zRightPreviewBorderVertical);
    fprintf(f, "zTopPreviewBorderVertical=%f\n", zTopPreviewBorderVertical);
    fprintf(f, "zBottomPreviewBorderVertical=%f\n", zBottomPreviewBorderVertical);
    fprintf(f, "zLeftAlternatePreviewVertical=%f\n", zLeftAlternatePreviewVertical);
    fprintf(f, "zRightAlternatePreviewVertical=%f\n", zRightAlternatePreviewVertical);
    fprintf(f, "zTopAlternatePreviewVertical=%f\n", zTopAlternatePreviewVertical);
    fprintf(f, "zBottomAlternatePreviewVertical=%f\n", zBottomAlternatePreviewVertical);
    fprintf(f, "zLeftAlternatePreviewBorderVertical=%f\n", zLeftAlternatePreviewBorderVertical);
    fprintf(f, "zRightAlternatePreviewBorderVertical=%f\n", zRightAlternatePreviewBorderVertical);
    fprintf(f, "zTopAlternatePreviewBorderVertical=%f\n", zTopAlternatePreviewBorderVertical);
    fprintf(f, "zBottomAlternatePreviewBorderVertical=%f\n", zBottomAlternatePreviewBorderVertical);
    fprintf(f, "ScrollSpeed=%d\n", ScrollSpeed);
    fprintf(f, "zLeft0=%f\n", zLeft0);
    fprintf(f, "zRight0=%f\n", zRight0);
    fprintf(f, "zTop0=%f\n", zTop0); 
    fprintf(f, "zBottom0=%f\n", zBottom0);
    fprintf(f, "zLeft90=%f\n", zLeft90);
    fprintf(f, "zRight90=%f\n", zRight90);
    fprintf(f, "zTop90=%f\n", zTop90);
    fprintf(f, "zBottom90=%f\n", zBottom90);
    fprintf(f, "zLeft180=%f\n", zLeft180);
    fprintf(f, "zRight180=%f\n", zRight180);
    fprintf(f, "zTop180=%f\n", zTop180);
    fprintf(f, "zBottom180=%f\n", zBottom180);
    fprintf(f, "zLeft270=%f\n", zLeft270);
    fprintf(f, "zRight270=%f\n", zRight270);
    fprintf(f, "zTop270=%f\n", zTop270);
    fprintf(f, "zBottom270=%f\n", zBottom270);
    fprintf(f, "zLeftMainMenuOverlay1=%f\n", zLeftMainMenuOverlay1);
    fprintf(f, "zRightMainMenuOverlay1=%f\n", zRightMainMenuOverlay1);
    fprintf(f, "zTopMainMenuOverlay1=%f\n", zTopMainMenuOverlay1);
    fprintf(f, "zBottomMainMenuOverlay1=%f\n", zBottomMainMenuOverlay1);
    fprintf(f, "zLeftMainMenuOverlay2=%f\n", zLeftMainMenuOverlay2);
    fprintf(f, "zRightMainMenuOverlay2=%f\n", zRightMainMenuOverlay2);
    fprintf(f, "zTopMainMenuOverlay2=%f\n", zTopMainMenuOverlay2);
    fprintf(f, "zBottomMainMenuOverlay2=%f\n", zBottomMainMenuOverlay2);
    fprintf(f, "zLeftMainMenuOverlay3=%f\n", zLeftMainMenuOverlay3);
    fprintf(f, "zRightMainMenuOverlay3=%f\n", zRightMainMenuOverlay3);
    fprintf(f, "zTopMainMenuOverlay3=%f\n", zTopMainMenuOverlay3);
    fprintf(f, "zBottomMainMenuOverlay3=%f\n", zBottomMainMenuOverlay3);
    fprintf(f, "zLeftMainMenuOverlay4=%f\n", zLeftMainMenuOverlay4);
    fprintf(f, "zRightMainMenuOverlay4=%f\n", zRightMainMenuOverlay4);
    fprintf(f, "zTopMainMenuOverlay4=%f\n", zTopMainMenuOverlay4);
    fprintf(f, "zBottomMainMenuOverlay4=%f\n", zBottomMainMenuOverlay4);
    fprintf(f, "zLeftMainMenuOverlay5=%f\n", zLeftMainMenuOverlay5);
    fprintf(f, "zRightMainMenuOverlay5=%f\n", zRightMainMenuOverlay5);
    fprintf(f, "zTopMainMenuOverlay5=%f\n", zTopMainMenuOverlay5);
    fprintf(f, "zBottomMainMenuOverlay5=%f\n", zBottomMainMenuOverlay5);
    fprintf(f, "zLeftMainMenuOverlay6=%f\n", zLeftMainMenuOverlay6);
    fprintf(f, "zRightMainMenuOverlay6=%f\n", zRightMainMenuOverlay6);
    fprintf(f, "zTopMainMenuOverlay6=%f\n", zTopMainMenuOverlay6);
    fprintf(f, "zBottomMainMenuOverlay6=%f\n", zBottomMainMenuOverlay6);
    fprintf(f, "fDualLeft=%f\n", fDualLeft);
    fprintf(f, "fDualRight=%f\n", fDualRight);
    fprintf(f, "fDualTop=%f\n", fDualTop);
    fprintf(f, "fDualBottom=%f\n", fDualBottom);
    fprintf(f, "zLeftDualVideoBorder=%f\n", zLeftDualVideoBorder);
    fprintf(f, "zRightDualVideoBorder=%f\n", zRightDualVideoBorder);
    fprintf(f, "zTopDualVideoBorder=%f\n", zTopDualVideoBorder);
    fprintf(f, "zBottomDualVideoBorder=%f\n", zBottomDualVideoBorder);
    fprintf(f, "screenSaverTime=%d\n", screenSaverTime);
    fprintf(f, "MovieEnabled=%d\n", MovieEnabled);
    fprintf(f, "PauseGame=%d\n", PauseGame);
    fprintf(f, "MainMenuMovieSwitchEnabled=%d\n", MainMenuMovieSwitchEnabled);
    fprintf(f, "MainMenuVideoPath0=%s\n", (char*)MainMenuVideoPath0.c_str());
    fprintf(f, "MainMenuVideoPath1=%s\n", (char*)MainMenuVideoPath1.c_str());
    fprintf(f, "MainMenuVideoPath2=%s\n", (char*)MainMenuVideoPath2.c_str());
    fprintf(f, "MainMenuVideoPath3=%s\n", (char*)MainMenuVideoPath3.c_str());
    fprintf(f, "MainMenuVideoPath4=%s\n", (char*)MainMenuVideoPath4.c_str());
    fprintf(f, "MainMenuVideoPath5=%s\n", (char*)MainMenuVideoPath5.c_str());
    fprintf(f, "zLeft=%f\n", zLeft);
    fprintf(f, "zRight=%f\n", zRight);
    fprintf(f, "zTop=%f\n", zTop);
    fprintf(f, "zBottom=%f\n", zBottom);
    fprintf(f, "SurroundSound=%d\n", SurroundSound);
    fprintf(f, "EditName=%d\n", EditName);
    fprintf(f, "Controller1Type=%d\n", Controller1Type);
    fprintf(f, "Controller2Type=%d\n", Controller2Type);
    fprintf(f, "Controller3Type=%d\n", Controller3Type);
    fprintf(f, "Controller4Type=%d\n", Controller4Type);
    fprintf(f, "FastForward=%d\n", FastForward);
    fprintf(f, "Rewind=%d\n", Rewind);
    fprintf(f, "VSCoin1=%d\n", VSCoin1);
    fprintf(f, "VSCoin2=%d\n", VSCoin2);
    fprintf(f, "CursorColor=%d\n", CursorColor);
    fprintf(f, "CursorSpeed=%d\n", CursorSpeed);
    fprintf(f, "CursorEnabled=%d\n", CursorEnabled);
    fprintf(f, "XBINPUT_DEADZONE=%f\n", XBINPUT_DEADZONE);
    fprintf(f, "ColorMode=%d\n", ColorMode);
    fprintf(f, "PaletteSelected=%d\n", PaletteSelected);
    fprintf(f, "EnableVideoAudio=%d\n", EnableVideoAudio);
    fprintf(f, "NTSCResolution=%d\n", NTSCResolution);
    fprintf(f, "NTSCSharpness=%d\n", NTSCSharpness);
    fprintf(f, "NTSCColorBleed=%d\n", NTSCColorBleed);
    fprintf(f, "NTSCArtifacts=%d\n", NTSCArtifacts);
    fprintf(f, "NTSCFringing=%d\n", NTSCFringing);
    fclose(f);
}

void SetParameters(FILE* f) {
    GameListWidth = GetFileInteger(f);
    GameListX = GetFileInteger(f);
    GameListY = GetFileInteger(f);
    HDMode = GetFileInteger(f);
    vSpace = GetFileInteger(f);
    SoftwareFilter = GetFileInteger(f);
    HardwareFilter = GetFileInteger(f);
    vsyncEnabled = GetFileInteger(f);
    dimColor = GetFileInteger(f);
    pixelRatio = GetFileInteger(f);
    FlickerFilter = GetFileInteger(f);
    Soften = GetFileInteger(f);
    scrollSpeed = GetFileInteger(f);
    GameSelected = GetFileInteger(f);
    GameFavoriteSelected = GetFileInteger(f);
    GameOptionPosX = GetFileInteger(f);
    GameOptionPosY = GetFileInteger(f);
    FontSize = GetFileFloat(f);
    GameListCount = GetFileInteger(f);
    DefaultController = GetFileInteger(f);
    MenuSpacing = GetFileInteger(f);
    MainMenuPosY = GetFileInteger(f);
    MainMenuPosX = GetFileInteger(f);
    MainMenuVSpace = GetFileInteger(f);
    MainMenuFontSize = GetFileFloat(f);
    MainMenuCentered = GetFileInteger(f);
    MenuPosY = GetFileInteger(f);
    MenuPosX = GetFileInteger(f);
    MenuDetailPosX = GetFileInteger(f);
    MenuDetailPosY = GetFileInteger(f);
    ROMPosY = GetFileInteger(f);
    zLeftMenu = GetFileFloat(f);
    zRightMenu = GetFileFloat(f);
    zTopMenu = GetFileFloat(f);
    zBottomMenu = GetFileFloat(f);
    zLeftPreview = GetFileFloat(f);
    zRightPreview = GetFileFloat(f);
    zTopPreview = GetFileFloat(f);
    zBottomPreview = GetFileFloat(f);
    GameInfoPosX = GetFileInteger(f);
    GameInfoPosY = GetFileInteger(f);
    GameInfoFontSize = GetFileFloat(f);
    GameInfoVSpace = GetFileInteger(f);
    GameInfoDetailNumLines = GetFileInteger(f);
    GameInfoDetailPosX = GetFileInteger(f);
    GameInfoDetailPosY = GetFileInteger(f);
    GameInfoDetailFontSize = GetFileFloat(f);
    GameInfoDetailWidth = GetFileInteger(f);
    GameInfoDetailVSpace = GetFileInteger(f);
    zoomSpeed = GetFileInteger(f);
    gameInfoListWidth = GetFileInteger(f);
    GameGuideLines = GetFileInteger(f);
    if(GameGuideLines > 21)
        GameGuideLines = 21;
    GameGuideColor = GetFileInteger(f);
    GameGuideFontSize = GetFileFloat(f);
    guideLeft = GetFileInteger(f);
    GUIState = GetFileInteger(f);
    fadeSpeed = GetFileInteger(f);
    GameGuideWidth = GetFileInteger(f);
    GameGuideVSpace = GetFileInteger(f);
    disableMenuSounds = GetFileInteger(f);
    fLeft = GetFileFloat(f);
    fRight = GetFileFloat(f);
    fTop = GetFileFloat(f);
    fBottom = GetFileFloat(f);
    fLeftMenu = GetFileFloat(f);
    fRightMenu = GetFileFloat(f);
    fTopMenu = GetFileFloat(f);
    fBottomMenu = GetFileFloat(f);
    zLeftPreviewBorder = GetFileFloat(f);
    zRightPreviewBorder = GetFileFloat(f);
    zTopPreviewBorder = GetFileFloat(f);
    zBottomPreviewBorder = GetFileFloat(f);
    zLeftInfoBorder = GetFileFloat(f);
    zRightInfoBorder = GetFileFloat(f);
    zTopInfoBorder = GetFileFloat(f);
    zBottomInfoBorder = GetFileFloat(f);
    zLeftVideoBorder = GetFileFloat(f);
    zRightVideoBorder = GetFileFloat(f);
    zTopVideoBorder = GetFileFloat(f);
    zBottomVideoBorder = GetFileFloat(f);
    zLeftROMBorder = GetFileFloat(f);
    zRightROMBorder = GetFileFloat(f);
    zTopROMBorder = GetFileFloat(f);
    zBottomROMBorder = GetFileFloat(f);
    zLeftSelectBorder = GetFileFloat(f);
    zRightSelectBorder = GetFileFloat(f);
    zTopSelectBorder = GetFileFloat(f);
    zBottomSelectBorder = GetFileFloat(f);
    zLeftAlternatePreview = GetFileFloat(f);
    zRightAlternatePreview = GetFileFloat(f);
    zTopAlternatePreview = GetFileFloat(f);
    zBottomAlternatePreview = GetFileFloat(f);
    zLeftAlternatePreviewBorder = GetFileFloat(f);
    zRightAlternatePreviewBorder = GetFileFloat(f);
    zTopAlternatePreviewBorder = GetFileFloat(f);
    zBottomAlternatePreviewBorder = GetFileFloat(f);
    zLeftAnimatedLogo = GetFileFloat(f);
    zRightAnimatedLogo = GetFileFloat(f);
    zTopAnimatedLogo = GetFileFloat(f);
    zBottomAnimatedLogo = GetFileFloat(f);
    speedROMBrowserLogo = GetFileFloat(f);
    distanceROMBrowserLogo = GetFileFloat(f);
    zLeftAnimatedLogoMainMenu = GetFileFloat(f);
    zRightAnimatedLogoMainMenu = GetFileFloat(f);
    zTopAnimatedLogoMainMenu = GetFileFloat(f);
    zBottomAnimatedLogoMainMenu = GetFileFloat(f);
    speedLogoMainMenu = GetFileFloat(f);
    distanceLogoMainMenu = GetFileFloat(f);
    zLeftInfoBorderSimple = GetFileFloat(f);
    zRightInfoBorderSimple = GetFileFloat(f);
    zTopInfoBorderSimple = GetFileFloat(f);
    zBottomInfoBorderSimple = GetFileFloat(f);
    BackgroundMusicVolume = GetFileInteger(f);
    SkinPath = GetFileString(f);
    zLeftPreviewVertical = GetFileFloat(f);
    zRightPreviewVertical = GetFileFloat(f);
    zTopPreviewVertical = GetFileFloat(f);
    zBottomPreviewVertical = GetFileFloat(f);
    zLeftPreviewBorderVertical = GetFileFloat(f);
    zRightPreviewBorderVertical = GetFileFloat(f);
    zTopPreviewBorderVertical = GetFileFloat(f);
    zBottomPreviewBorderVertical = GetFileFloat(f);
    zLeftAlternatePreviewVertical = GetFileFloat(f);
    zRightAlternatePreviewVertical = GetFileFloat(f);
    zTopAlternatePreviewVertical = GetFileFloat(f);
    zBottomAlternatePreviewVertical = GetFileFloat(f);
    zLeftAlternatePreviewBorderVertical = GetFileFloat(f);
    zRightAlternatePreviewBorderVertical = GetFileFloat(f);
    zTopAlternatePreviewBorderVertical = GetFileFloat(f);
    zBottomAlternatePreviewBorderVertical = GetFileFloat(f);
    ScrollSpeed = GetFileInteger(f);
    zLeft0 = GetFileFloat(f);
    zRight0 = GetFileFloat(f);
    zTop0 = GetFileFloat(f);
    zBottom0 = GetFileFloat(f);
    zLeft90 = GetFileFloat(f);
    zRight90 = GetFileFloat(f);
    zTop90 = GetFileFloat(f);
    zBottom90 = GetFileFloat(f);
    zLeft180 = GetFileFloat(f);
    zRight180 = GetFileFloat(f);
    zTop180 = GetFileFloat(f);
    zBottom180 = GetFileFloat(f);
    zLeft270 = GetFileFloat(f);
    zRight270 = GetFileFloat(f);
    zTop270 = GetFileFloat(f);
    zBottom270 = GetFileFloat(f);
    zLeftMainMenuOverlay1 = GetFileFloat(f);
    zRightMainMenuOverlay1 = GetFileFloat(f);
    zTopMainMenuOverlay1 = GetFileFloat(f);
    zBottomMainMenuOverlay1 = GetFileFloat(f);
    zLeftMainMenuOverlay2 = GetFileFloat(f);
    zRightMainMenuOverlay2 = GetFileFloat(f);
    zTopMainMenuOverlay2 = GetFileFloat(f);
    zBottomMainMenuOverlay2 = GetFileFloat(f);
    zLeftMainMenuOverlay3 = GetFileFloat(f);
    zRightMainMenuOverlay3 = GetFileFloat(f);
    zTopMainMenuOverlay3 = GetFileFloat(f);
    zBottomMainMenuOverlay3 = GetFileFloat(f);
    zLeftMainMenuOverlay4 = GetFileFloat(f);
    zRightMainMenuOverlay4 = GetFileFloat(f);
    zTopMainMenuOverlay4 = GetFileFloat(f);
    zBottomMainMenuOverlay4 = GetFileFloat(f);
    zLeftMainMenuOverlay5 = GetFileFloat(f);
    zRightMainMenuOverlay5 = GetFileFloat(f);
    zTopMainMenuOverlay5 = GetFileFloat(f);
    zBottomMainMenuOverlay5 = GetFileFloat(f);
    zLeftMainMenuOverlay6 = GetFileFloat(f);
    zRightMainMenuOverlay6 = GetFileFloat(f);
    zTopMainMenuOverlay6 = GetFileFloat(f);
    zBottomMainMenuOverlay6 = GetFileFloat(f);
    fDualLeft = GetFileFloat(f);
    fDualRight = GetFileFloat(f);
    fDualTop = GetFileFloat(f);
    fDualBottom = GetFileFloat(f);
    zLeftDualVideoBorder = GetFileFloat(f);
    zRightDualVideoBorder = GetFileFloat(f);
    zTopDualVideoBorder = GetFileFloat(f);
    zBottomDualVideoBorder = GetFileFloat(f);
    screenSaverTime = GetFileInteger(f);
    MovieEnabled = GetFileInteger(f);
    PauseGame = GetFileInteger(f);
    MainMenuMovieSwitchEnabled = GetFileInteger(f);
    MainMenuVideoPath0 = GetFileString(f);
    MainMenuVideoPath1 = GetFileString(f);
    MainMenuVideoPath2 = GetFileString(f);
    MainMenuVideoPath3 = GetFileString(f);
    MainMenuVideoPath4 = GetFileString(f);
    MainMenuVideoPath5 = GetFileString(f);
    zLeft = GetFileFloat(f);
    zRight = GetFileFloat(f);
    zTop = GetFileFloat(f);
    zBottom = GetFileFloat(f);
    SurroundSound = GetFileInteger(f);
    EditName = GetFileInteger(f);
    Controller1Type = GetFileInteger(f);
    Controller2Type = GetFileInteger(f);
    Controller3Type = GetFileInteger(f);
    Controller4Type = GetFileInteger(f);
    FastForward = GetFileInteger(f);
    Rewind = GetFileInteger(f);
    VSCoin1 = GetFileInteger(f);
    VSCoin2 = GetFileInteger(f);
    CursorColor = GetFileInteger(f);
    CursorSpeed = GetFileInteger(f);
    CursorEnabled = GetFileInteger(f);
    XBINPUT_DEADZONE = GetFileFloat(f);
    ColorMode = GetFileInteger(f);
    PaletteSelected = GetFileInteger(f);
    EnableVideoAudio = GetFileInteger(f);
    NTSCResolution = GetFileInteger(f);
    NTSCSharpness = GetFileInteger(f);
    NTSCColorBleed = GetFileInteger(f);
    NTSCArtifacts = GetFileInteger(f);
    NTSCFringing = GetFileInteger(f);

    if(PauseGame < 0 || PauseGame > 4)
        PauseGame = 0;
}

void LoadSkinIni(std::string skin) {
    FILE* f;
    char fileName[2048];
    sprintf(fileName,"%s%s%s%s%s", "D:\\skins\\", skin.c_str(), "\\", skin.c_str(), ".ini");
    f = fopen(fileName, "r");
    if(!f) {
        LD_LAUNCH_DASHBOARD launch;
        memset(&launch,0,sizeof(launch));
        launch.dwReason=XLD_LAUNCH_DASHBOARD_MAIN_MENU;
        XLaunchNewImage(NULL,(LAUNCH_DATA *)&launch);
    }
    SetParameters(f);
    GameSelected = 0;
    GameFavoriteSelected = 0;
    CustomSelected = 0;
    CompanySelected = 0;
    YearSelected = 0;
    GenreSelected = 0;
    GUIState = 0;
    MenuSelected = 0;
    fclose(f);
}

void LoadIni() {
    FILE* f;
    char fileName[2048];
    sprintf(fileName,"%s%s", IniPath.c_str(), "\\NestopiaX.ini");
    f = fopen(fileName, "r");
    if(!f) {
        string e = "Default - 480";
        LoadSkinIni(e);
        SaveIni();
        return;
    }
    SetParameters(f);
    fclose(f);
}

extern void NstStopPlaying();
void ReturnToGUI() {
    if(CommandLineLaunch == 1) {
        LD_LAUNCH_DASHBOARD launch;
        memset(&launch,0,sizeof(launch));
        launch.dwReason=XLD_LAUNCH_DASHBOARD_MAIN_MENU;
        XLaunchNewImage(NULL,(LAUNCH_DATA *)&launch);
    }
}

void ROMError(char* msg) {
    OptionScreen();
    while(1) {
        updateEffect();
        ReadInput();
        if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
            ReturnToGUI();
        }
        FontSetColour(0xffff00);
        Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
        Device->SetTexture(0,TexOption);
        DrawBackground();
        FontGUI(ConvertCharStringToWCHAR(msg), 320, 240, 640);
        FontGUI(ConvertCharStringToWCHAR("Press \"A\" to exit"), 320, 240 + vSpace, 640);
        Present();
    }
}

void NestopiaXCrashed() {
    while(1) {
        ReadInput();
        if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
            PLAUNCH_DATA ldata ;
            memset( &ldata, 0, sizeof(PLAUNCH_DATA) ) ;
            XLaunchNewImage( "D:\\default.xbe", ldata ) ;
        }
        FontSetColour(0xffff00);
        Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
        Device->SetTexture(0,TexOption);
        SetupMatrices();
        MakeVertexListMenu();
        Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
        FontGUI(ConvertCharStringToWCHAR((char*)"NestopiaX encountered a problem"), 320, 240, 640);
        FontGUI(ConvertCharStringToWCHAR((char*)"Press \"A\" to restart"), 320, 240 + vSpace, 640);
        Present();
    }
}

void InvalidFile(char* msg) {
    while(1) {
        updateEffect();
        ReadInput();
        if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
            return;
        }
        FontSetColour(0xffff00);
        Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
        Device->SetTexture(0,TexOption);
        DrawBackground();
        FontGUI(ConvertCharStringToWCHAR(msg), 320, 240, 640);
        FontGUI(ConvertCharStringToWCHAR((char*)"Press \"A\" to exit"), 320, 240 + vSpace, 640);
        Present();
    }
}

void OutOfMemory() {
    while(1) {
        updateEffect();
        ReadInput();
        if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
            ReturnToGUI();
        }
        FontSetColour(0xffff00);
        Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
        Device->SetTexture(0,TexOption);
        DrawBackground();
        FontGUI(ConvertCharStringToWCHAR((char*)"Out of Memory."), 320, 240, 640);
        FontGUI(ConvertCharStringToWCHAR((char*)"Press \"A\" to exit"), 320, 240 + vSpace, 640);
        Present();
    }
}

float freeMemory() {
    MEMORYSTATUS stat;
    GlobalMemoryStatus( &stat );
    return (((float)stat.dwAvailPhys) / 1024000);
}

void PrintFreeMemory(char* n) {

}

void* osd_malloc(int n) {
    float q = n;
    q = q / 1024000.0f;
    float memory = freeMemory();
    if(q > memory || (memory < ((1024 * 1024 * 1) / 1024000))) {
        SaveIni();
        OutOfMemory();
    }
    else {
        return malloc(n);
    }
}

int PreviewSwitchValid() {
    QueryPerformanceCounter(&tickPreviewSwitch);
    if((((FLOAT)tickPreviewSwitch.QuadPart) - lastTimePreviewSwitch) >=
        (((FLOAT)ticksPerSecondPreviewSwitch.QuadPart) * 0.4)) {
            lastTimePreviewSwitch = (FLOAT)tickPreviewSwitch.QuadPart;
            return 1;
    }
    else {
        return 0;
    }
}

int AnimateROMBrowserLogoTimer() {
    QueryPerformanceCounter(&tickROMBrowserLogo);
    if(lastTimeROMBrowserLogo == 0) {
        lastTimeROMBrowserLogo = (FLOAT)tickROMBrowserLogo.QuadPart;
        return 0;
    }
    if((((FLOAT)tickROMBrowserLogo.QuadPart) - lastTimeROMBrowserLogo) >=
        (((FLOAT)ticksPerSecondROMBrowserLogo.QuadPart) / 60.0f) * 1) {
            lastTimeROMBrowserLogo = (FLOAT)tickROMBrowserLogo.QuadPart;
            return 1;
    }
    else {
        return 0;
    }
}

void SetDelay() {
    QueryPerformanceCounter(&tickDelay);
    lastTimeDelay = (FLOAT)tickDelay.QuadPart;
}

void SetDelayGame() {
    QueryPerformanceCounter(&tickDelay);
    lastTimeDelay = (FLOAT)tickDelay.QuadPart;
}

int DelayValidGame() {
    QueryPerformanceCounter(&tickDelay);
    if((((FLOAT)tickDelay.QuadPart) - lastTimeDelay) >=
        (((FLOAT)ticksPerSecondDelay.QuadPart) * 1)) {
            delay = false;
            return 1;
    }
    else {
        return 0;
    }
}

void GameDelay() {
    SetDelayGame();
    while(!DelayValidGame())
        DisplayMessage("Please wait...");
}

int DelayValid() {
    QueryPerformanceCounter(&tickDelay);
    if((((FLOAT)tickDelay.QuadPart) - lastTimeDelay) >=
        (((FLOAT)ticksPerSecondDelay.QuadPart) * 0.2)) {
            return 1;
    }
    else {
        return 0;
    }
}

int AnimateSplashScreen() {
    QueryPerformanceCounter(&tickSplashScreen);
    if((((FLOAT)tickSplashScreen.QuadPart) - lastTimeSplashScreen) >=
        (((FLOAT)ticksPerSecondSplashScreen.QuadPart) * 3.5)) {
            return 1;
    }
    else {
        return 0;
    }
}

void SplashScreen() {
    char fileName[2048];
    sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\splashscreen.png");
    D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
        D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
        D3DX_DEFAULT,0,NULL,NULL,&TexSplashScreen);
    Device->CreateVertexBuffer(sizeof(VertexListSplashScreen),0,
        D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferSplashScreen);	
    sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\splashscreen2.png");
    D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
        D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
        D3DX_DEFAULT,0,NULL,NULL,&TexPreview);

    m_mp3playerSplash.dsound_init() ;
    m_mp3playerSplash.m_fps = 60;
    sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\splash.mp3");
    m_mp3playerSplash.loadFile(fileName, 0, 0, 70*60*75 );
    m_mp3playerSplash.pause( FALSE );
    m_mp3playerSplash.adjust_volume(BackgroundMusicVolume);
    memset( m_mp3playerSplash.m_pSoundBufferData, 0, m_mp3playerSplash.stream_buffer_size);
    for(int i = 0; i < 90; i++) {
        Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
        Device->SetTexture(0,TexSplashScreen);
        DrawBackground();
        Present();
    } 
    SplashFinshed = false;
    QueryPerformanceFrequency(&ticksPerSecondSplashScreen);
    QueryPerformanceCounter(&tickSplashScreen);
    lastTimeSplashScreen = (FLOAT)tickSplashScreen.QuadPart;
    g_hSoundThreadSplash = CreateThread(NULL, 0, Mp3player_ThreadFuncSplash, NULL, 0, &g_dwSoundThreadIdSplash);
    fadeColor = 0;
    while(!AnimateSplashScreen()) {
        Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
        Device->SetTexture(0,TexSplashScreen);
        DrawBackground();
        Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
        fade = true;
        fadeColor +=2;
        if(fadeColor > 255) { fadeColor = 255; }
        Device->SetTexture(0,TexPreview);
        DrawBackground();
        fade = false;
        Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
        Present();
    }
    m_mp3playerSplash.stop();
    fadeColor = 255;
    fadeOption = 2;
    SplashFinshed = true;
}


void SaveGameList() {
   
}

bool LoadGameList() {
    return true;
}

void ScanDirectory(std::string PathToSearch){
    GameList.clear();
    GameListDirectory.clear();
    GameSelected = 0;
    std::string path1 = PathToSearch;
    std::string path2("*");
    std::string path = path1 + path2;
    HANDLE find=NULL;
    WIN32_FIND_DATA wfd;
    memset(&wfd,0,sizeof(wfd));
    find=FindFirstFile(path.c_str(),&wfd);

    if (find ==INVALID_HANDLE_VALUE){ //Empty directory
        ImageDBEntry t, t2;
        t.name = "No games were found";
        t.path = "";
        t.isADirectory = false;
        t.topLevel = false;
        t.isARoot = false;
        GameList.push_back(t);
        return;
    }

    do {
        if(!(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)) {
            //Not a folder		 
            std::string fileFound(wfd.cFileName);
            if((fileFound.find(".zip", 0) != string::npos) || 
                (fileFound.find(".ZIP", 0) != string::npos)) {
                    ImageDBEntry f;
                    f.name = fileFound;
                    f.path = PathToSearch + fileFound;
                    f.isADirectory = false;
                    GameList.push_back(f);	
            }
        }
        else {
            std::string folderName(wfd.cFileName);
            folderName = "<" + folderName + ">"; 

            ImageDBEntry d;
            d.name = folderName;
            std::string folderNameNoBrackets(wfd.cFileName);
            d.path = PathToSearch +  folderNameNoBrackets + "\\";
            d.isAGame = false;
            d.isARoot = false;
            d.isADirectory = true;
            d.topLevel = false;
            GameListDirectory.push_back(d);
        }
    } while (FindNextFile(find,&wfd) !=0);

	if(GameList.size() == 0 && GameListDirectory.size() == 0) {
		ImageDBEntry t, t2;
        t.name = "No games were found";
        t.path = "";
        t.isADirectory = false;
        t.topLevel = false;
        t.isARoot = false;
        GameList.push_back(t);
        return;
	}
    SortGameList();
}

void GenerateDat() {

}

void Scan() {
    char pathToSearch[2048];
    GameList.clear();
    GameListDirectories.clear();
    sprintf(pathToSearch,"%s%s", RomPath1.c_str(), "\\");
    ScanDirectory(pathToSearch);
    Directory n;
    n.currentDirectory = pathToSearch;
    n.selected = GameSelected;
    GameListDirectories.push_back(n);
    GameSelected = 0;
}

void AddToFavorites() {
    ImageDBEntry e;
    e.path = GameList[GameSelected].path;
    e.name =  GameList[GameSelected].name;

    if(FavoritesDatabase.size() == 1) {
        if (_tcscmp(FavoritesDatabase[0].name.c_str(), "No Favorites Found") == 0) {	
            FavoritesDatabase.clear();
        }
    }
    FavoritesDatabase.push_back(e);
    SortFavoritesList();
}

void UpdatePreview(string game) {
    game = game.substr(0, game.size() - 4); 

    if(!PreviewSwitch) {
        CurrentArtwork = 1;
        char fileName[2048];
        if(MovieEnabled) {
            stopMovie();
            sprintf(fileName,"%s%s%s%s", VideoPath.c_str(), "\\", game.c_str(), ".xmv");
            FILE* f = fopen(fileName, "r");
            if(f) {
                fclose(f);
                initMovie(fileName);
            }
            if(videoRender && EnableVideoAudio) {
                m_mp3player.pause(TRUE);
            }
            else {
                m_mp3player.pause(FALSE);
            }
        }

        if(TexPreview) {
            TexPreview->Release();
            TexPreview = NULL;
        }
        sprintf(fileName,"%s%s%s%s", ArtworkPath1.c_str(), "\\", game.c_str(), ".png");
        D3DXIMAGE_INFO ImageStats;
        D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
            D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
            D3DX_DEFAULT,0,&ImageStats,NULL,&TexPreview);
        if(TexPreview) {
            SourceWidth = ImageStats.Width;
            SourceHeight = ImageStats.Height;
        }
    }
    else {
        string e = ArtworkPath1;
        PreviewSwitch = false;
        if(CurrentArtwork == 1) e = ArtworkPath1;
        if(CurrentArtwork == 2) e = ArtworkPath2;
        if(CurrentArtwork == 3) e = ArtworkPath3;
        if(CurrentArtwork == 4) e = ArtworkPath4;
        if(CurrentArtwork == 5) e = ArtworkPath5;
        if(CurrentArtwork == 6) e = ArtworkPath6;
        if(CurrentArtwork == 7) e = ArtworkPath7;
        if(CurrentArtwork == 8) e = ArtworkPath8;
        if(TexPreview) {
            TexPreview->Release();
            TexPreview = NULL;
        }
        char fileName[2048];
        sprintf(fileName,"%s%s%s%s", e.c_str(), "\\", game.c_str(), ".png");
        D3DXIMAGE_INFO ImageStats;

        D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
            D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
            D3DX_DEFAULT,0,&ImageStats,NULL,&TexPreview);
        if(TexPreview) {
            SourceWidth = ImageStats.Width;
            SourceHeight = ImageStats.Height;
        }
	}
}

void SetRenderStates() {
    Device->SetRenderState(D3DRS_LIGHTING,0);
    Device->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
    Device->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
    Device->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
    Device->SetTextureStageState( 0, D3DTSS_ALPHAOP,   D3DTOP_MODULATE );
    Device->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
    Device->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
    Device->SetTextureStageState( 1, D3DTSS_COLOROP,   D3DTOP_DISABLE );
    Device->SetTextureStageState( 1, D3DTSS_ALPHAOP,   D3DTOP_DISABLE );
    Device->SetTextureStageState( 0, D3DTSS_ADDRESSU,  D3DTADDRESS_CLAMP );
    Device->SetTextureStageState( 0, D3DTSS_ADDRESSV,  D3DTADDRESS_CLAMP );
    Device->SetRenderState( D3DRS_ZENABLE,      FALSE );
    Device->SetRenderState( D3DRS_FOGENABLE,    FALSE );
    Device->SetRenderState( D3DRS_FOGTABLEMODE, D3DFOG_NONE );
    Device->SetRenderState( D3DRS_FILLMODE,     D3DFILL_SOLID );
    Device->SetRenderState( D3DRS_CULLMODE,     D3DCULL_CCW );
    Device->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
    Device->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
    Device->SetVertexShader( D3DFVF_XYZRHW|D3DFVF_DIFFUSE|D3DFVF_TEX1);
}

void DisplayFPS() {
    WCHAR fpsDisplay[80]={0};
    if(fps > framerate)
        fps = framerate;
    wsprintfW(fpsDisplay, L"FPS: %1f", fps);
    FontSetColour(0xffff00);
    FontText(fpsDisplay, DebugX, DebugY, 640);
}


void DisplayFreeMemory() {
    int xO = DebugX;
    int yO = DebugY + 20;
    MEMORYSTATUS stat;
    GlobalMemoryStatus( &stat );
    WCHAR text23456789_[80]={0};
    float t = (((float)stat.dwAvailPhys) / 1024000);
    wsprintfW(text23456789_, L"Free Memory: %4f MB", t);
    FontSetColour(0xffff00);
    FontText(text23456789_,xO,yO, 640);
    return;
}

void Debug() {
    DisplayFreeMemory();
}

extern "C" int dprintf(char *format, ...) {
    return 0;
    char *name=NULL;
    va_list val=NULL;
    name="D:\\GeneralError.txt";
    if (DebugFile==NULL) DebugFile=fopen(name,"wt");
    if (DebugFile==NULL) return 1;
    va_start(val,format);
    vfprintf(DebugFile,format,val);
    fflush(DebugFile);
    va_end(val);
    return 0;
}

void DisplayInstructions(char* text) {
    FontSetColour(0xffff00);
    FontGUI(ConvertCharStringToWCHAR(text), 320, 240, 640);
    FontGUI(ConvertCharStringToWCHAR("Press \"B\" to exit"), 320, 240 + vSpace, 640);
}

void ZeroTexture() {
    D3DSURFACE_DESC desc;
    TexScreen->GetLevelDesc( 0, &desc );
    DWORD dwTexWidth  = desc.Width;
    DWORD dwTexHeight = desc.Height;
    D3DLOCKED_RECT lock;
    TexScreen->LockRect( 0, &lock, 0, 0L );
    VOID* pBits = lock.pBits;
    for( DWORD y = 0; y < dwTexHeight; y++ ) {
        for( DWORD x = 0; x < dwTexWidth; x++ ) {
            ((unsigned short*)pBits)[y*dwTexWidth+x] = 0;
        }
    }
    TexScreen->UnlockRect( 0 );
}

void SetupDefaultPaths() {
    RomPath1 = "D:\\roms";
    ArtworkPath1="E:\\NestopiaX\\artwork\\Shots 1";
    ArtworkPath2="E:\\NestopiaX\\artwork\\Shots 2";
    ArtworkPath3="E:\\NestopiaX\\artwork\\Shots 3";
    ArtworkPath4="E:\\NestopiaX\\artwork\\Shots 4";
    ArtworkPath5="E:\\NestopiaX\\artwork\\Shots 5"; 
    ArtworkPath6="E:\\NestopiaX\\artwork\\Shots 6"; 
    ArtworkPath7="E:\\NestopiaX\\artwork\\Shots 7"; 
    ArtworkPath8="E:\\NestopiaX\\artwork\\Shots 8"; 
    SRAMPath="E:\\NestopiaX\\sram"; 
    IniPath="E:\\NestopiaX\\ini"; 
    SaveStatePath="E:\\NestopiaX\\savestates"; 
    MoviePath = "E:\\NestopiaX\\movies";
    mkdir("E:\\NestopiaX");
    mkdir("E:\\NestopiaX\\artwork");
    mkdir("E:\\NestopiaX\\artwork\\Shots 1");
    mkdir("E:\\NestopiaX\\artwork\\Shots 2");
    mkdir("E:\\NestopiaX\\artwork\\Shots 3");
    mkdir("E:\\NestopiaX\\artwork\\Shots 4");
    mkdir("E:\\NestopiaX\\artwork\\Shots 5");
    mkdir("E:\\NestopiaX\\artwork\\Shots 6");
    mkdir("E:\\NestopiaX\\artwork\\Shots 7");
    mkdir("E:\\NestopiaX\\artwork\\Shots 8");
    mkdir("E:\\NestopiaX\\sram");
    mkdir("E:\\NestopiaX\\ini");
    mkdir("E:\\NestopiaX\\ini\\controller");
    mkdir("E:\\NestopiaX\\ini\\emulation");
    mkdir("E:\\NestopiaX\\savestates");
    mkdir("E:\\NestopiaX\\movies");
}

void SetupPath() {
    FILE* f;
    f = fopen("D:\\Path.ini" , "r");
    if(!f) {
        SetupDefaultPaths();
        return;
    }
    UsePathINI = GetFileInteger(f);

    if(UsePathINI == 1) {
        RomPath1 = GetFileString(f);
        ArtworkPath1 = GetFileString(f);
        ArtworkPath2 = GetFileString(f);
        ArtworkPath3 = GetFileString(f);
        ArtworkPath4 = GetFileString(f);
        ArtworkPath5 = GetFileString(f);
        ArtworkPath6 = GetFileString(f);
        ArtworkPath7 = GetFileString(f);
        ArtworkPath8 = GetFileString(f);
        SRAMPath = GetFileString(f);
        IniPath = GetFileString(f);
        SaveStatePath = GetFileString(f);
        VideoPath = GetFileString(f);
        MoviePath = GetFileString(f);
        char fileName[2048];
        sprintf(fileName,"%s%s", IniPath.c_str(), "\\emulation");
        mkdir(fileName);
        sprintf(fileName,"%s%s", IniPath.c_str(), "\\controller");
        mkdir(fileName);
        fclose(f);
    }
    else {
        SetupDefaultPaths();
        fclose(f);
    }
}

HRESULT Mount(const char* szDrive, char* szDevice)
{
    char szSourceDevice[256];
    char szDestinationDrive[16];

    sprintf(szSourceDevice,"\\Device\\%s",szDevice);
    sprintf(szDestinationDrive,"\\??\\%s",szDrive);

    STRING DeviceName =
    {
        strlen(szSourceDevice),
        strlen(szSourceDevice) + 1,
        szSourceDevice
    };

    STRING LinkName =
    {
        strlen(szDestinationDrive),
        strlen(szDestinationDrive) + 1,
        szDestinationDrive
    };

    IoCreateSymbolicLink(&LinkName, &DeviceName);

    return S_OK;
}

HRESULT Unmount(const char* szDrive)
{
    char szDestinationDrive[16];
    sprintf(szDestinationDrive,"\\??\\%s",szDrive);

    STRING LinkName =
    {
        strlen(szDestinationDrive),
        strlen(szDestinationDrive) + 1,
        szDestinationDrive
    };

    IoDeleteSymbolicLink(&LinkName);

    return S_OK;
}
