#include "GlobalExtern.h"

void ROMSelectInput() {
    ReadInput();

    if(analogScroll && !g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER] && 
        !g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) {
            analogScroll = false;
            UpdatePreview(GameList[GameSelected].name);
            return;
    }

    if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
        if(GameListDirectories.size() == 1) {
            CancelSound();
            stopMovie();
            MenuSelected = 0;
            GUIState = MAIN_MENU;
            MenuBackground();
            fadeOption = 0;
            fadeColor = 255;
            m_mp3player.pause(FALSE);
            return;  
        }
        else {
            CancelSound();
            int temp = GameListDirectories[GameListDirectories.size() - 1].selected;
            GameListDirectories.erase(GameListDirectories.begin() + (GameListDirectories.size() - 1), GameListDirectories.begin() + (GameListDirectories.size() - 1) + 1);
            string q = GameListDirectories[GameListDirectories.size() - 1].currentDirectory;
            ScanDirectory(q);
            GameSelected = temp;
            if(TexPreview) {
                TexPreview->Release();
                TexPreview = NULL;
            }
            stopMovie();
            m_mp3player.pause(false);
        }
    }

    if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {  
        if(GameSelected == GameList.size() - 1)
            return;
        ClickSound();
        GameSelected++; 
        if(GameSelected >= GameList.size()) 
            GameSelected = GameList.size() - 1;
        UpdatePreview(GameList[GameSelected].name);
        return;
    }

    if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  { 
        if(GameSelected == 0)
            return;
        ClickSound();
        GameSelected--; 
        if(GameSelected < 0) 
            GameSelected = 0;
        UpdatePreview(GameList[GameSelected].name);
        return;
    }  

    if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_LEFT  &&
        g_Gamepads[DefaultController].fX2 == 0 && 
        !(g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) && 
        !(g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])) {  
            char c = GameList[GameSelected].name[0];	  
            c = tolower(c);
            for(int i = GameSelected; i > 0; i--) {
                char n = GameList[i].name[0];
                n = tolower(n);
                if(n <  c) {
                    GameSelected = i;
                    UpdatePreview(GameList[GameSelected].name);
                    break;	
                }
            }
            return;
    } 

    if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_RIGHT &&
        g_Gamepads[DefaultController].fX2 == 0 && 
        !(g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) && 
        !(g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])) { 
            char c = GameList[GameSelected].name[0];	  
            c = tolower(c);
            for(int i = GameSelected; i < GameList.size(); i++) {
                char n = GameList[i].name[0];
                n = tolower(n);
                if(n > c) {
                    GameSelected = i;
                    UpdatePreview(GameList[GameSelected].name);
                    break;
                }
            }
            return;
    } 		

    if (g_Gamepads[DefaultController].fX2 < 0)  {
        if(!PreviewSwitchValid())
            return;
        CyclePreview(-1);
        PreviewSwitch = true;
        UpdatePreview(GameList[GameSelected].name);
        if(!TexPreview) {
            for(int i = 0; i < 7; i++) {
                CyclePreview(-1);
                PreviewSwitch = true;
                UpdatePreview(GameList[GameSelected].name);
                if(TexPreview)
                    break;
            }
        }
        return;
    }

    if (g_Gamepads[DefaultController].fX2 > 0)  {
        if(!PreviewSwitchValid())
            return;
        CyclePreview(1);
        PreviewSwitch = true;
        UpdatePreview(GameList[GameSelected].name);
        if(!TexPreview) {
            for(int i = 0; i < 7; i++) {
                CyclePreview(1);
                PreviewSwitch = true;
                UpdatePreview(GameList[GameSelected].name);
                if(TexPreview)
                    break;
            }
        }
        return;
    }

    if(g_Gamepads[DefaultController].Event == XBGAMEPAD_Y) {
        GameSelected = 0;
        UpdatePreview(GameList[GameSelected].name);
        return;
    }

    if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
        ConfirmSound();
        if(GameList[GameSelected].isADirectory) {
            Directory n;
            n.currentDirectory = GameList[GameSelected].path;
            n.selected = GameSelected;
            GameListDirectories.push_back(n);
            ScanDirectory(GameList[GameSelected].path);
            UpdatePreview(GameList[GameSelected].name);
            return;
        }

        if(_tcscmp("No games were found", GameList[0].name.c_str()) == 0) {
            return;
        }
        m_mp3player.pause(true);
        stopMovie();
        SaveIni();
        std::string e = GameList[GameSelected].name;
        globalGameName = e.substr(0, e.size() - 4);
        CreateDirectories(globalGameName);
        oldGUIState = GUIState;
        GameDelay();
        StartGame((char*)GameList[GameSelected].path.c_str());
        m_mp3player.pause(false);
        GUIState = oldGUIState;
        SetDelay();
        g_Gamepads[DefaultController].Event = XBGAMEPAD_NONE;
        return;
    }
    if(g_Gamepads[DefaultController].Event == XBGAMEPAD_X) {
        ConfirmSound();
        m_mp3player.pause(FALSE);
        stopMovie();
        ImageSelectedMenu((char*)GameList[GameSelected].name.c_str());
        UpdatePreview(GameList[GameSelected].name);
    }
    if(g_Gamepads[DefaultController].wButtons & XINPUT_GAMEPAD_BACK) {
        ConfirmSound();
        char fileName[2048];
        sprintf(fileName,"%s%s%s", "D:\\info\\emulation\\", GameList[GameSelected].name.c_str(), ".ini");
        LoadGuide(fileName, (char*)GameList[GameSelected].name.c_str());
        DrawArcadeInfo();
    }

    if(g_Gamepads[DefaultController].Event == XBGAMEPAD_WHITE) {
        if((_tcscmp("No games were found", GameList[GameSelected].name.c_str()) == 0) ||
            GameList[GameSelected].isADirectory) {
                return;
        }

        AddToFavorites();
        SaveFavorites();
        while(1) {
            updateEffect();
            ReadInput();
            if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
                CancelSound();

                return;
            }

            Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
            Device->SetTexture(0,TexOption);
            DrawBackground();
            FontSetColour(0xffff00);
            FontGUI(ConvertCharStringToWCHAR("The following game has been added to the favorites list:"), MenuPosX, 240, 640); 
            FontGUI(ConvertCharStringToWCHAR((char*)GameList[GameSelected].name.c_str()), MenuPosX, 240 + 20, 640); 
            FontGUI(ConvertCharStringToWCHAR("Press \"B\" to return to the game list"), MenuPosX, 240 + 40, 640);
            Present();
        }
    }

    if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) {
        if(GameSelected == GameList.size() - 1)
            return;
        stopMovie();
        GameInfoDetail.clear();
        if(analogSpeed >= 1) { 
            analogSpeed = 0; 
        } 
        if(rightAnalog == 255)
            analogSpeed = scrollSpeed;
        else
            analogSpeed += ((float)rightAnalog/255.0f);
        GameSelected+=((int)analogSpeed); 
        if(GameSelected >= GameList.size()) 
            GameSelected = GameList.size() - 1;
        analogScroll = true;
        if(TexPreview) {
            TexPreview->Release();
            TexPreview = NULL;
        }
        return;
    }

    if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) {
        if(GameSelected == 0)
            return;
        stopMovie();
        GameInfoDetail.clear();
        if(analogSpeed >= 1)  { 
            analogSpeed = 0;
        }
        if(leftAnalog == 255)
            analogSpeed = scrollSpeed;
        else
            analogSpeed += ((float)leftAnalog/255.0f);
        GameSelected-=((int)analogSpeed); if(GameSelected < 0) GameSelected = 0;
        analogScroll = true;
        if(TexPreview) {
            TexPreview->Release();
            TexPreview = NULL;
        }
        return;
    }
}

void DrawGameList() {
    if(_tcscmp("No games were found", GameList[0].name.c_str()) == 0) {
        FontSetColour(0xffff00);
        FontText(ConvertCharStringToWCHAR("No games were found"),GameListX, GameListY, GameListWidth);
        FontCenteredText(ConvertCharStringToWCHAR("No games were found"),320, ROMPosY, 640);
		return;
    }
    FontSetColour(0xffff00);
    string temp = GameList[GameSelected].name;
    if(temp[0] != '<')
        temp = temp.substr(0, temp.size() - 4);

    if(EditName) {
        for(int i = 0; i < temp.size(); i++) {
            if((temp[i] == '(')) {
                temp[i] = '\0';
                break;
            }
        }
    }

    FontCenteredText(ConvertCharStringToWCHAR((char*)temp.c_str()),320, ROMPosY, 640);
    int y = GameListY;
    DWORD color;
    int start = 0;

    if(GameSelected > (GameListCount / 2) && (GameList.size() > GameListCount)) {
        start += (GameSelected  - (GameListCount / 2));
    }

    if((GameSelected > ((GameList.size()-1) - (GameListCount / 2))) && (GameList.size() > GameListCount)) {
        start = (GameList.size() - GameListCount);
    }

    for(int i = start; i <  start + GameListCount; i++) {
        if(i == GameList.size()) return;
        if(i ==GameSelected) {
            color = 0xffff00; 
        }
        else {
            color = 0xffffff;
        }
        WCHAR msg[1024]={0};

        std::string t = GameList[i].name;
        if(t[0] != '<')
            t = t.substr(0, t.size() - 4);
        if(EditName) {
            for(int n = 0; n < t.size(); n++) {
                if((t[n] == '(')) {
                    t[n] = '\0';
                    break;
                }
            }
        }
        for(int r = 0; r < t.size(); r++) {
            if((t.c_str())[r] == '\0') {
                msg[r] = '\0';
                break;
            }
            msg[r] = t[r];
        }
        FontSetColour(color);
        FontText(msg,GameListX, y, GameListWidth);
        y+=vSpace;
    }
}

void DrawROMList(int Mode) {
    Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
    Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
    Device->SetTexture(0,TexROMBrowser);
    DrawBackground();

    if(fadeColor > 0) {
        Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
        fade = true;
        fadeColor -=fadeSpeed;
        if(fadeColor < fadeSpeed) { fadeColor = 0; resumeGUI = false; }
        if(resumeGUI || CustomSet || CompanySet || YearSet || GenreSet) {
            Device->SetTexture(0,TexOption);
        }
        else {
            Device->SetTexture(0,TexMainMenu);
        }
        DrawBackground();
        fade = false;
        Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
        Present();
        if(setDisplay) {
            setDisplay = false;
            Device->SetFlickerFilter(FlickerFilter);
            Device->SetSoftDisplayFilter(Soften);
        }
        return;
    }
    else {	
        if(TexPreview) {
            if(videoRender && MovieEnabled) {
                Device->SetTexture(0,TexPreview);
                if(SourceWidth < SourceHeight) {
                    MakeVertexListPreviewVertical();
                }
                else {
                    MakeVertexListPreview();
                }
                Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
                Device->SetTexture(0,TexPreviewBorder);
                if(SourceWidth < SourceHeight) {
                    MakeVertexListPreviewBorderVertical();
                }
                else {
                    MakeVertexListPreviewBorder();
                }
                Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
                Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
                Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
            }
            else {
                Device->SetTexture(0,TexPreview);
                if(SourceWidth < SourceHeight) {
                    MakeVertexListAlternatePreviewVertical();
                }
                else {
                    MakeVertexListAlternatePreview();
                }
                Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
                Device->SetTexture(0,TexPreviewBorder);
                if(SourceWidth < SourceHeight) {
                    MakeVertexListAlternatePreviewBorderVertical();
                }
                else {
                    MakeVertexListAlternatePreviewBorder();
                }
                Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
                Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
                Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
            }
        }
        Device->SetTexture(0,TexROMBorder);
        MakeVertexListROMBorder();
        Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
        Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
        Device->SetTexture(0,TexSelectedBorder);
        MakeVertexListSelectedBorder();
        Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
        Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
        if(Mode == 1)
            DrawGameFavoriteList();
        else
            DrawGameList();
        if(videoRender && MovieEnabled) {
            drawMovie();
            Device->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
            Device->SetTexture(0,TexVideoBorder);
            if(!TexPreview) {
                MakeVertexListVideoBorder();
            }
            else {
                MakeVertexListDualVideoBorder();
            }
            Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
            Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
            Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
        }
        Device->SetTexture(0,TexAnimatedLogo);
        MakeVertexListAnimatedLogo(true);
        Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
        Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
        Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
    }
    Present();
    if(setDisplay) {
        setDisplay = false;
        Device->SetFlickerFilter(FlickerFilter);
        Device->SetSoftDisplayFilter(Soften);
    }
}

void DrawROMSelectMenu() {
    DrawROMList(0);
}

void ROMSelectMenu() {
    DrawROMSelectMenu();
    ROMSelectInput();
}
