#include "GlobalExtern.h"

void DrawOptionGUIImageItemPage2(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(OptionGUIImageSelectedPage2 == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawOptionGUIImageItemPage3(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(OptionGUIImageSelectedPage3 == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawOptionGUIImageItemsMenuPage2() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	for(int i = 0; i < OptionGUIImageItemsPage2.size(); i++) {
		DrawOptionGUIImageItemPage2(i, (char*)OptionGUIImageItemsPage2[i].c_str(), MenuDetailPosX, MenuDetailPosY + (i * vSpace));
		DrawOptionGUIImageItemPage2(i, (char*)OptionGUIImageValueItemsPage2[i].c_str(), MenuDetailPosX + MenuSpacing, MenuDetailPosY + (i * vSpace));
	}
	Present();
}

void DrawOptionGUIImageItemsMenuPage3() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	for(int i = 0; i < OptionGUIImageItemsPage3.size(); i++) {
		DrawOptionGUIImageItemPage3(i, (char*)OptionGUIImageItemsPage3[i].c_str(), MenuDetailPosX, MenuDetailPosY + (i * vSpace));
		DrawOptionGUIImageItemPage3(i, (char*)OptionGUIImageValueItemsPage3[i].c_str(), MenuDetailPosX + MenuSpacing, MenuDetailPosY + (i * vSpace));
	}
	Present();
}

void AnimatedLogoMainMenuAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		GUIState = 18;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) { zTopAnimatedLogoMainMenu+=0.01f;  zBottomAnimatedLogoMainMenu+=0.01f; }// Up
	if (g_Gamepads[DefaultController].fY1 < 0) { zTopAnimatedLogoMainMenu-=0.01f;  zBottomAnimatedLogoMainMenu-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX1 < 0) { zLeftAnimatedLogoMainMenu-=0.01f; zRightAnimatedLogoMainMenu-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeftAnimatedLogoMainMenu+=0.01f; zRightAnimatedLogoMainMenu+=0.01f; }// Right
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottomAnimatedLogoMainMenu+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) { zBottomAnimatedLogoMainMenu-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX2 < 0) { zRightAnimatedLogoMainMenu-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX2 > 0) { zRightAnimatedLogoMainMenu+=0.01f; } // Right

	cMoveLogoMainMenu = 0;
	zLeftAnimatedLogoMainMenuTemp = zLeftAnimatedLogoMainMenu;
	zRightAnimatedLogoMainMenuTemp = zRightAnimatedLogoMainMenu;
	zTopAnimatedLogoMainMenuTemp = zTopAnimatedLogoMainMenu;
	zBottomAnimatedLogoMainMenuTemp = zBottomAnimatedLogoMainMenu;

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	drawMovie();
	Device->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
	Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
	Device->SetTexture(0,TexMainMenu);
	SetAlpha = 1;
	DrawBackground();
	SetAlpha = 0;
	Device->SetTexture(0,TexAnimatedLogo);
	MakeVertexListAnimatedLogoMainMenu(false);
	Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
	Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void InfoBorderSimpleAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		ExitROMSelectEditMenu();
		GUIState = 18;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) { zTopInfoBorderSimple+=0.01f;  zBottomInfoBorderSimple+=0.01f; }// Up
	if (g_Gamepads[DefaultController].fY1 < 0) { zTopInfoBorderSimple-=0.01f;  zBottomInfoBorderSimple-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX1 < 0) { zLeftInfoBorderSimple-=0.01f; zRightInfoBorderSimple-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeftInfoBorderSimple+=0.01f; zRightInfoBorderSimple+=0.01f; }// Right
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottomInfoBorderSimple+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) { zBottomInfoBorderSimple-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX2 < 0) { zRightInfoBorderSimple-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX2 > 0) { zRightInfoBorderSimple+=0.01f; } // Right

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	DrawROMSelectEditMenu();
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void AlternatePreviewVerticalAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		ExitROMSelectEditMenu();
		AlternatePreviewVerticalResize = false;
		GUIState = 18;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) { zTopAlternatePreviewVertical+=0.01f;  zBottomAlternatePreviewVertical+=0.01f; }// Up
	if (g_Gamepads[DefaultController].fY1 < 0) { zTopAlternatePreviewVertical-=0.01f;  zBottomAlternatePreviewVertical-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX1 < 0) { zLeftAlternatePreviewVertical-=0.01f; zRightAlternatePreviewVertical-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeftAlternatePreviewVertical+=0.01f; zRightAlternatePreviewVertical+=0.01f; }// Right
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottomAlternatePreviewVertical+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) { zBottomAlternatePreviewVertical-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX2 < 0) { zRightAlternatePreviewVertical-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX2 > 0) { zRightAlternatePreviewVertical+=0.01f; } // Right

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	DrawROMSelectEditMenu();
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void AlternatePreviewBorderVerticalAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		ExitROMSelectEditMenu();
		AlternatePreviewBorderVerticalResize = false;
		GUIState = 18;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) { zTopAlternatePreviewBorderVertical+=0.01f;  zBottomAlternatePreviewBorderVertical+=0.01f; }// Up
	if (g_Gamepads[DefaultController].fY1 < 0) { zTopAlternatePreviewBorderVertical-=0.01f;  zBottomAlternatePreviewBorderVertical-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX1 < 0) { zLeftAlternatePreviewBorderVertical-=0.01f; zRightAlternatePreviewBorderVertical-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeftAlternatePreviewBorderVertical+=0.01f; zRightAlternatePreviewBorderVertical+=0.01f; }// Right
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottomAlternatePreviewBorderVertical+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) { zBottomAlternatePreviewBorderVertical-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX2 < 0) { zRightAlternatePreviewBorderVertical-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX2 > 0) { zRightAlternatePreviewBorderVertical+=0.01f; } // Right

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	DrawROMSelectEditMenu();
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void PreviewVerticalAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		ExitROMSelectEditMenu();
		PreviewVerticalResize = false;
		GUIState = 18;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) { zTopPreviewVertical+=0.01f;  zBottomPreviewVertical+=0.01f; }// Up
	if (g_Gamepads[DefaultController].fY1 < 0) { zTopPreviewVertical-=0.01f;  zBottomPreviewVertical-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX1 < 0) { zLeftPreviewVertical-=0.01f; zRightPreviewVertical-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeftPreviewVertical+=0.01f; zRightPreviewVertical+=0.01f; }// Right
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottomPreviewVertical+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) { zBottomPreviewVertical-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX2 < 0) { zRightPreviewVertical-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX2 > 0) { zRightPreviewVertical+=0.01f; } // Right

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	DrawROMSelectEditMenu();
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void PreviewBorderVerticalAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		ExitROMSelectEditMenu();
		PreviewBorderVerticalResize = false;
		GUIState = 18;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) { zTopPreviewBorderVertical+=0.01f;  zBottomPreviewBorderVertical+=0.01f; }// Up
	if (g_Gamepads[DefaultController].fY1 < 0) { zTopPreviewBorderVertical-=0.01f;  zBottomPreviewBorderVertical-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX1 < 0) { zLeftPreviewBorderVertical-=0.01f; zRightPreviewBorderVertical-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeftPreviewBorderVertical+=0.01f; zRightPreviewBorderVertical+=0.01f; }// Right
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottomPreviewBorderVertical+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) { zBottomPreviewBorderVertical-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX2 < 0) { zRightPreviewBorderVertical-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX2 > 0) { zRightPreviewBorderVertical+=0.01f; } // Right

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	DrawROMSelectEditMenu();
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}
void OptionGUIImageItemsInputPage2() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		GUIState = 10;
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
		ClickSound();
		OptionGUIImageSelectedPage2++;
		if(OptionGUIImageSelectedPage2 > OptionGUIImageItemsPage2.size() - 1)
			OptionGUIImageSelectedPage2 = 0;
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  { 
		ClickSound();
		OptionGUIImageSelectedPage2--;
		if(OptionGUIImageSelectedPage2 < 0)
			OptionGUIImageSelectedPage2 = OptionGUIImageItemsPage2.size() - 1;
		return;
	}

	if (g_Gamepads[DefaultController].fY2 > 0) {
		if(OptionGUIImageSelectedPage2 == 0) {
			speedROMBrowserLogo += 0.000001;
			std::ostringstream q0;
			q0 << speedROMBrowserLogo;
			std::string w0 = q0.str();
			OptionGUIImageValueItemsPage2[0] = (char*)w0.c_str();
			ResetAnimatedLogo();
			return;
		}

		if(OptionGUIImageSelectedPage2 == 1) {
			distanceROMBrowserLogo += 0.000001;
			std::ostringstream q0;
			q0 << distanceROMBrowserLogo;
			std::string w0 = q0.str();
			OptionGUIImageValueItemsPage2[1] = (char*)w0.c_str();
			ResetAnimatedLogo();
			return;
		}

		if(OptionGUIImageSelectedPage2 == 3) {
			speedLogoMainMenu += 0.000001;
			std::ostringstream q0;
			q0 << speedLogoMainMenu;
			std::string w0 = q0.str();
			OptionGUIImageValueItemsPage2[3] = (char*)w0.c_str();
			ResetAnimatedLogoMainMenu();
			return;
		}

		if(OptionGUIImageSelectedPage2 == 4) {
			distanceLogoMainMenu += 0.000001;
			std::ostringstream q0;
			q0 << distanceLogoMainMenu;
			std::string w0 = q0.str();
			OptionGUIImageValueItemsPage2[4] = (char*)w0.c_str();
			ResetAnimatedLogoMainMenu();
			return;
		}
	}

	if (g_Gamepads[DefaultController].fY2 < 0) {
		if(OptionGUIImageSelectedPage2 == 0) {
			speedROMBrowserLogo -= 0.000001;
			std::ostringstream q0;
			q0 << speedROMBrowserLogo;
			std::string w0 = q0.str();
			OptionGUIImageValueItemsPage2[0] = (char*)w0.c_str();
			ResetAnimatedLogo();
			return;
		}

		if(OptionGUIImageSelectedPage2 == 1) {
			distanceROMBrowserLogo -= 0.000001;
			std::ostringstream q0;
			q0 << distanceROMBrowserLogo;
			std::string w0 = q0.str();
			OptionGUIImageValueItemsPage2[1] = (char*)w0.c_str();
			ResetAnimatedLogo();
			return;
		}

		if(OptionGUIImageSelectedPage2 == 3) {
			speedLogoMainMenu -= 0.000001;
			std::ostringstream q0;
			q0 << speedLogoMainMenu;
			std::string w0 = q0.str();
			OptionGUIImageValueItemsPage2[3] = (char*)w0.c_str();
			ResetAnimatedLogoMainMenu();
			return;
		}

		if(OptionGUIImageSelectedPage2 == 4) {
			distanceLogoMainMenu -= 0.000001;
			std::ostringstream q0;
			q0 << distanceLogoMainMenu;
			std::string w0 = q0.str();
			OptionGUIImageValueItemsPage2[4] = (char*)w0.c_str();
			ResetAnimatedLogoMainMenu();
			return;
		}
	}

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_X) {
		ConfirmSound();
		if(OptionGUIImageSelectedPage2 == 0) {
			speedROMBrowserLogo -= 0.000001;
			std::ostringstream q0;
			q0 << speedROMBrowserLogo;
			std::string w0 = q0.str();
			OptionGUIImageValueItemsPage2[0] = (char*)w0.c_str();
			ResetAnimatedLogo();
			return;
		}

		if(OptionGUIImageSelectedPage2 == 1) {
			distanceROMBrowserLogo -= 0.000001;
			std::ostringstream q0;
			q0 << distanceROMBrowserLogo;
			std::string w0 = q0.str();
			OptionGUIImageValueItemsPage2[1] = (char*)w0.c_str();
			ResetAnimatedLogo();
			return;
		}

		if(OptionGUIImageSelectedPage2 == 3) {
			speedLogoMainMenu -= 0.000001;
			std::ostringstream q0;
			q0 << speedLogoMainMenu;
			std::string w0 = q0.str();
			OptionGUIImageValueItemsPage2[3] = (char*)w0.c_str();
			ResetAnimatedLogoMainMenu();
			return;
		}

		if(OptionGUIImageSelectedPage2 == 4) {
			distanceLogoMainMenu -= 0.000001;
			std::ostringstream q0;
			q0 << distanceLogoMainMenu;
			std::string w0 = q0.str();
			OptionGUIImageValueItemsPage2[4] = (char*)w0.c_str();
			ResetAnimatedLogoMainMenu();
			return;
		}
	}

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		ConfirmSound();
		if(OptionGUIImageSelectedPage2 == 0) {
			speedROMBrowserLogo += 0.000001;
			std::ostringstream q0;
			q0 << speedROMBrowserLogo;
			std::string w0 = q0.str();
			OptionGUIImageValueItemsPage2[0] = (char*)w0.c_str();
			ResetAnimatedLogo();
			return;
		}

		if(OptionGUIImageSelectedPage2 == 1) {
			distanceROMBrowserLogo += 0.000001;
			std::ostringstream q0;
			q0 << distanceROMBrowserLogo;
			std::string w0 = q0.str();
			OptionGUIImageValueItemsPage2[1] = (char*)w0.c_str();
			ResetAnimatedLogo();
			return;
		}

		if(OptionGUIImageSelectedPage2 == 2) {
			GUIState = 40;
		}

		if(OptionGUIImageSelectedPage2 == 3) {
			speedLogoMainMenu += 0.000001;
			std::ostringstream q0;
			q0 << speedLogoMainMenu;
			std::string w0 = q0.str();
			OptionGUIImageValueItemsPage2[3] = (char*)w0.c_str();
			ResetAnimatedLogoMainMenu();
			return;
		}

		if(OptionGUIImageSelectedPage2 == 4) {
			distanceLogoMainMenu += 0.000001;
			std::ostringstream q0;
			q0 << distanceLogoMainMenu;
			std::string w0 = q0.str();
			OptionGUIImageValueItemsPage2[4] = (char*)w0.c_str();
			ResetAnimatedLogoMainMenu();
			return;
		}

		if(OptionGUIImageSelectedPage2 == 5) {
			AlternatePreviewVerticalResize = true;
			GUIState = 42;
			InitROMSelectEditMenu();
		}

		if(OptionGUIImageSelectedPage2 == 6) {
			AlternatePreviewBorderVerticalResize = true;
			GUIState = 43;
			InitROMSelectEditMenu();
		}

		if(OptionGUIImageSelectedPage2 == 7) {
			PreviewVerticalResize = true;
			GUIState = 44;
			InitROMSelectEditMenu();
		}

		if(OptionGUIImageSelectedPage2 == 8) {
			PreviewBorderVerticalResize = true;
			GUIState = 45;
			InitROMSelectEditMenu();
		}
		if(OptionGUIImageSelectedPage2 == 9) {
			GUIState = 49;
		}
	}
	return;
}


void MainMenuOverlay1Adjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		GUIState = 49;
		return;
	}

	if (g_Gamepads[DefaultController].fX1 < 0) { zLeftMainMenuOverlay1-=0.01f; zRightMainMenuOverlay1-=0.01f; } //Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeftMainMenuOverlay1+=0.01f; zRightMainMenuOverlay1+=0.01f; } //Right
	if (g_Gamepads[DefaultController].fY1 < 0) { zTopMainMenuOverlay1-=0.01f;  zBottomMainMenuOverlay1-=0.01f; }// Down
	if (g_Gamepads[DefaultController].fY1 > 0) { zTopMainMenuOverlay1+=0.01f;  zBottomMainMenuOverlay1+=0.01f; } //Up
	if (g_Gamepads[DefaultController].fX2 > 0) { zRightMainMenuOverlay1+=0.01f; } // Right
	if (g_Gamepads[DefaultController].fX2 < 0) { zRightMainMenuOverlay1-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottomMainMenuOverlay1+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) {  zBottomMainMenuOverlay1-=0.01f; } // Down

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	drawMovie();
	Device->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
	Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
	Device->SetTexture(0,TexMainMenu);
	SetAlpha = 1;
	DrawBackground();
	Device->SetTexture(0,TexMainMenuOverlay);
	MakeVertexListMainMenuOverlay1();
	SetAlpha = 0;
	Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
	Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void MainMenuOverlay2Adjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		GUIState = 49;
		return;
	}

	if (g_Gamepads[DefaultController].fX1 < 0) { zLeftMainMenuOverlay2-=0.01f; zRightMainMenuOverlay2-=0.01f; } //Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeftMainMenuOverlay2+=0.01f; zRightMainMenuOverlay2+=0.01f; } //Right
	if (g_Gamepads[DefaultController].fY1 < 0) { zTopMainMenuOverlay2-=0.01f;  zBottomMainMenuOverlay2-=0.01f; }// Down
	if (g_Gamepads[DefaultController].fY1 > 0) { zTopMainMenuOverlay2+=0.01f;  zBottomMainMenuOverlay2+=0.01f; } //Up
	if (g_Gamepads[DefaultController].fX2 > 0) { zRightMainMenuOverlay2+=0.01f; } // Right
	if (g_Gamepads[DefaultController].fX2 < 0) { zRightMainMenuOverlay2-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottomMainMenuOverlay2+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) {  zBottomMainMenuOverlay2-=0.01f; } // Down

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	drawMovie();
	Device->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
	Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
	Device->SetTexture(0,TexMainMenu);
	SetAlpha = 1;
	DrawBackground();
	Device->SetTexture(0,TexMainMenuOverlay);
	MakeVertexListMainMenuOverlay2();
	SetAlpha = 0;
	Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
	Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void MainMenuOverlay3Adjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		GUIState = 49;
		return;
	}

	if (g_Gamepads[DefaultController].fX1 < 0) { zLeftMainMenuOverlay3-=0.01f; zRightMainMenuOverlay3-=0.01f; } //Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeftMainMenuOverlay3+=0.01f; zRightMainMenuOverlay3+=0.01f; } //Right
	if (g_Gamepads[DefaultController].fY1 < 0) { zTopMainMenuOverlay3-=0.01f;  zBottomMainMenuOverlay3-=0.01f; }// Down
	if (g_Gamepads[DefaultController].fY1 > 0) { zTopMainMenuOverlay3+=0.01f;  zBottomMainMenuOverlay3+=0.01f; } //Up
	if (g_Gamepads[DefaultController].fX2 > 0) { zRightMainMenuOverlay3+=0.01f; } // Right
	if (g_Gamepads[DefaultController].fX2 < 0) { zRightMainMenuOverlay3-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottomMainMenuOverlay3+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) {  zBottomMainMenuOverlay3-=0.01f; } // Down

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	drawMovie();
	Device->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
	Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
	Device->SetTexture(0,TexMainMenu);
	SetAlpha = 1;
	DrawBackground();
	Device->SetTexture(0,TexMainMenuOverlay);
	MakeVertexListMainMenuOverlay3();
	SetAlpha = 0;
	Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
	Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void MainMenuOverlay4Adjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		GUIState = 49;
		return;
	}

	if (g_Gamepads[DefaultController].fX1 < 0) { zLeftMainMenuOverlay4-=0.01f; zRightMainMenuOverlay4-=0.01f; } //Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeftMainMenuOverlay4+=0.01f; zRightMainMenuOverlay4+=0.01f; } //Right
	if (g_Gamepads[DefaultController].fY1 < 0) { zTopMainMenuOverlay4-=0.01f;  zBottomMainMenuOverlay4-=0.01f; }// Down
	if (g_Gamepads[DefaultController].fY1 > 0) { zTopMainMenuOverlay4+=0.01f;  zBottomMainMenuOverlay4+=0.01f; } //Up
	if (g_Gamepads[DefaultController].fX2 > 0) { zRightMainMenuOverlay4+=0.01f; } // Right
	if (g_Gamepads[DefaultController].fX2 < 0) { zRightMainMenuOverlay4-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottomMainMenuOverlay4+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) {  zBottomMainMenuOverlay4-=0.01f; } // Down

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	drawMovie();
	Device->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
	Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
	Device->SetTexture(0,TexMainMenu);
	SetAlpha = 1;
	DrawBackground();
	Device->SetTexture(0,TexMainMenuOverlay);
	MakeVertexListMainMenuOverlay4();
	SetAlpha = 0;
	Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
	Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void MainMenuOverlay5Adjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		GUIState = 49;
		return;
	}

	if (g_Gamepads[DefaultController].fX1 < 0) { zLeftMainMenuOverlay5-=0.01f; zRightMainMenuOverlay5-=0.01f; } //Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeftMainMenuOverlay5+=0.01f; zRightMainMenuOverlay5+=0.01f; } //Right
	if (g_Gamepads[DefaultController].fY1 < 0) { zTopMainMenuOverlay5-=0.01f;  zBottomMainMenuOverlay5-=0.01f; }// Down
	if (g_Gamepads[DefaultController].fY1 > 0) { zTopMainMenuOverlay5+=0.01f;  zBottomMainMenuOverlay5+=0.01f; } //Up
	if (g_Gamepads[DefaultController].fX2 > 0) { zRightMainMenuOverlay5+=0.01f; } // Right
	if (g_Gamepads[DefaultController].fX2 < 0) { zRightMainMenuOverlay5-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottomMainMenuOverlay5+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) {  zBottomMainMenuOverlay5-=0.01f; } // Down

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	drawMovie();
	Device->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
	Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
	Device->SetTexture(0,TexMainMenu);
	SetAlpha = 1;
	DrawBackground();
	Device->SetTexture(0,TexMainMenuOverlay);
	MakeVertexListMainMenuOverlay5();
	SetAlpha = 0;
	Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
	Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void MainMenuOverlay6Adjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		GUIState = 49;
		return;
	}

	if (g_Gamepads[DefaultController].fX1 < 0) { zLeftMainMenuOverlay6-=0.01f; zRightMainMenuOverlay6-=0.01f; } //Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeftMainMenuOverlay6+=0.01f; zRightMainMenuOverlay6+=0.01f; } //Right
	if (g_Gamepads[DefaultController].fY1 < 0) { zTopMainMenuOverlay6-=0.01f;  zBottomMainMenuOverlay6-=0.01f; }// Down
	if (g_Gamepads[DefaultController].fY1 > 0) { zTopMainMenuOverlay6+=0.01f;  zBottomMainMenuOverlay6+=0.01f; } //Up
	if (g_Gamepads[DefaultController].fX2 > 0) { zRightMainMenuOverlay6+=0.01f; } // Right
	if (g_Gamepads[DefaultController].fX2 < 0) { zRightMainMenuOverlay6-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottomMainMenuOverlay6+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) {  zBottomMainMenuOverlay6-=0.01f; } // Down

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	drawMovie();
	Device->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
	Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
	Device->SetTexture(0,TexMainMenu);
	SetAlpha = 1;
	DrawBackground();
	Device->SetTexture(0,TexMainMenuOverlay);
	MakeVertexListMainMenuOverlay6();
	SetAlpha = 0;
	Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
	Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void OptionGUIImageItemsInputPage3() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		GUIState = 18;
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
		ClickSound();
		OptionGUIImageSelectedPage3++;
		if(OptionGUIImageSelectedPage3 > OptionGUIImageItemsPage3.size() - 1)
			OptionGUIImageSelectedPage3 = 0;
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  { 
		ClickSound();
		OptionGUIImageSelectedPage3--;
		if(OptionGUIImageSelectedPage3 < 0)
			OptionGUIImageSelectedPage3 = OptionGUIImageItemsPage3.size() - 1;
		return;
	}

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_X) {
		if(OptionGUIImageSelectedPage3 == 9) {
			ConfirmSound();
			PauseGame--;
			if(PauseGame < 0)
				PauseGame = 4;
			if(PauseGame == 0)
				OptionGUIImageValueItemsPage3[9] = "Right Analog Click";
			if(PauseGame == 1)
				OptionGUIImageValueItemsPage3[9] = "Left Trigger + Right Trigger";
			if(PauseGame == 2)
				OptionGUIImageValueItemsPage3[9] = "Back + Start";
			if(PauseGame == 3)
				OptionGUIImageValueItemsPage3[9] = "Left Trigger + Back";
			if(PauseGame == 4)
				OptionGUIImageValueItemsPage3[9] = "Right Trigger + Back";
		}
	}

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		ConfirmSound();
		if(OptionGUIImageSelectedPage3 == 0) {
			GUIState = 50;
		}
		if(OptionGUIImageSelectedPage3 == 1) {
			GUIState = 51;
		}
		if(OptionGUIImageSelectedPage3 == 2) {
			GUIState = 52;
		}
		if(OptionGUIImageSelectedPage3 == 3) {
			GUIState = 53;
		}
		if(OptionGUIImageSelectedPage3 == 4) {
			GUIState = 54;
		}
		if(OptionGUIImageSelectedPage3 == 5) {
			GUIState = 55;
		}

		if(OptionGUIImageSelectedPage3 == 6) {
			DualVideoResize = true;
			InitROMSelectEditMenu();
			GUIState = 56;
		}

		if(OptionGUIImageSelectedPage3 == 7) {
			DualVideoBorderResize = true;
			InitROMSelectEditMenu();
			GUIState = 57;
		}

		if(OptionGUIImageSelectedPage3 == 8) {
			MovieEnabled ^= 1;
			if(MovieEnabled) {
				OptionGUIImageValueItemsPage3[8] = "Enabled";
			}
			else {
				OptionGUIImageValueItemsPage3[8] = "Disabled";
			}
		}

		if(OptionGUIImageSelectedPage3 == 9) {
			PauseGame++;
			if(PauseGame > 4)
				PauseGame = 0;
			if(PauseGame == 0)
				OptionGUIImageValueItemsPage3[9] = "Right Analog Click";
			if(PauseGame == 1)
				OptionGUIImageValueItemsPage3[9] = "Left Trigger + Right Trigger";
			if(PauseGame == 2)
				OptionGUIImageValueItemsPage3[9] = "Back + Start";
			if(PauseGame == 3)
				OptionGUIImageValueItemsPage3[9] = "Left Trigger + Back";
			if(PauseGame == 4)
				OptionGUIImageValueItemsPage3[9] = "Right Trigger + Back";
		}

		if(OptionGUIImageSelectedPage3 == 10) {
			MainMenuMovieSwitchEnabled ^= 1;
			if(MainMenuMovieSwitchEnabled) {
				OptionGUIImageValueItemsPage3[10] = "Enabled";
			}
			else {
				OptionGUIImageValueItemsPage3[10] = "Disabled";
			}
		}
		if(OptionGUIImageSelectedPage3 == 11) {
			EnableVideoAudio ^= 1;
			if(EnableVideoAudio) {
				OptionGUIImageValueItemsPage3[11] = "Enabled";
			}
			else {
				OptionGUIImageValueItemsPage3[11] = "Disabled";
			}
		}

	}
	return;
}


void BackgroundAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		ExitROMSelectEditMenu();
		GUIState = 10; 
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) { zTopMenu+=0.01f;  zBottomMenu+=0.01f; }// Up
	if (g_Gamepads[DefaultController].fY1 < 0) { zTopMenu-=0.01f;  zBottomMenu-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX1 < 0) { zLeftMenu-=0.01f; zRightMenu-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeftMenu+=0.01f; zRightMenu+=0.01f; }// Right
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottomMenu+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) { zBottomMenu-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX2 < 0) { zRightMenu-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX2 > 0) { zRightMenu+=0.01f; } // Right

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	DrawROMSelectEditMenu();
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void PreviewAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		ExitROMSelectEditMenu();
		PreviewResize = false;
		GUIState = 10; 
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) { zTopPreview+=0.01f;  zBottomPreview+=0.01f; }// Up
	if (g_Gamepads[DefaultController].fY1 < 0) { zTopPreview-=0.01f;  zBottomPreview-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX1 < 0) { zLeftPreview-=0.01f; zRightPreview-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeftPreview+=0.01f; zRightPreview+=0.01f; }// Right
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottomPreview+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) { zBottomPreview-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX2 < 0) { zRightPreview-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX2 > 0) { zRightPreview+=0.01f; } // Right

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	DrawROMSelectEditMenu();
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void ExitGameAdjust90() {
	if(!TexPreview) {
		D3DXCreateTextureFromFileEx(Device, "D:\\media\\preview.png", D3DX_DEFAULT,
			D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
			D3DX_DEFAULT,0,NULL,NULL,&TexPreview);
	}
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		GUIState = 18;
		SetupMatrices();
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) { zLeft90+=0.01f; zRight90+=0.01f; }// Up
	if (g_Gamepads[DefaultController].fY1 < 0) { zLeft90-=0.01f; zRight90-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX1 < 0) { zTop90+=0.01f;  zBottom90+=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zTop90-=0.01f;  zBottom90-=0.01f; }// Right
	if (g_Gamepads[DefaultController].fY2 > 0) { zRight90+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) { zRight90-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX2 < 0) { zBottom90+=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX2 > 0) {  zBottom90-=0.01f; } // Right

	zLeftExitGame = zLeft90;
	zRightExitGame = zRight90;
	zTopExitGame = zTop90;
	zBottomExitGame = zBottom90;

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	SetupMatrices();
	DrawBackground();
	Device->SetTexture(0,TexPreview);
	MakeVertexListExitGame();
	D3DXMATRIX q;
	D3DXMatrixRotationZ(&q, 90 * (3.14/180));
	Device->SetTransform(D3DTS_WORLD, &q);
	Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
	for(int i = 0; i < GameOptionItems.size(); i++) {
		DrawGameOptionItem(i, (char*)GameOptionItems[i].c_str(), GameOptionPosX, GameOptionPosY + (i * vSpace));
	}
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void ExitGameAdjust180() {
	if(!TexPreview) {
		D3DXCreateTextureFromFileEx(Device, "D:\\media\\preview.png", D3DX_DEFAULT,
			D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
			D3DX_DEFAULT,0,NULL,NULL,&TexPreview);
	}
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		GUIState = 18;
		SetupMatrices();
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) { zTop180-=0.01f;  zBottom180-=0.01f; }// Up
	if (g_Gamepads[DefaultController].fY1 < 0) { zTop180+=0.01f;  zBottom180+=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX1 < 0) { zLeft180+=0.01f; zRight180+=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeft180-=0.01f; zRight180-=0.01f; }// Right
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottom180-=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) { zBottom180+=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX2 < 0) { zRight180+=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX2 > 0) { zRight180-=0.01f; } // Right

	zLeftExitGame = zLeft180;
	zRightExitGame = zRight180;
	zTopExitGame = zTop180;
	zBottomExitGame = zBottom180;
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	SetupMatrices();
	DrawBackground();
	Device->SetTexture(0,TexPreview);
	MakeVertexListExitGame();
	D3DXMATRIX q;
	D3DXMatrixRotationZ(&q, 180 * (3.14/180));
	Device->SetTransform(D3DTS_WORLD, &q);
	Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
	for(int i = 0; i < GameOptionItems.size(); i++) {
		DrawGameOptionItem(i, (char*)GameOptionItems[i].c_str(), GameOptionPosX, GameOptionPosY + (i * vSpace));
	}
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void ExitGameAdjust270() {
	if(!TexPreview) {
		D3DXCreateTextureFromFileEx(Device, "D:\\media\\preview.png", D3DX_DEFAULT,
			D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
			D3DX_DEFAULT,0,NULL,NULL,&TexPreview);
	}
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		GUIState = 18;
		SetupMatrices();
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) { zLeft270-=0.01f; zRight270-=0.01f; }// Up
	if (g_Gamepads[DefaultController].fY1 < 0) { zLeft270+=0.01f; zRight270+=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX1 < 0) { zTop270-=0.01f;  zBottom270-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zTop270+=0.01f;  zBottom270+=0.01f; }// Right
	if (g_Gamepads[DefaultController].fY2 > 0) { zRight270-=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) { zRight270+=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX2 < 0) { zBottom270-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX2 > 0) { zBottom270+=0.01f; } // Right

	zLeftExitGame = zLeft270;
	zRightExitGame = zRight270;
	zTopExitGame = zTop270;
	zBottomExitGame = zBottom270;

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	SetupMatrices();
	DrawBackground();
	Device->SetTexture(0,TexPreview);
	MakeVertexListExitGame();
	D3DXMATRIX q;
	D3DXMatrixRotationZ(&q, 270 * (3.14/180));
	Device->SetTransform(D3DTS_WORLD, &q);
	Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
	for(int i = 0; i < GameOptionItems.size(); i++) {
		DrawGameOptionItem(i, (char*)GameOptionItems[i].c_str(), GameOptionPosX, GameOptionPosY + (i * vSpace));
	}
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void ExitGameAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		GUIState = 10;
		return;
	}
	
	if (g_Gamepads[DefaultController].fY1 > 0) { zTop0+=0.01f;  zBottom0+=0.01f; }// Up
	if (g_Gamepads[DefaultController].fY1 < 0) { zTop0-=0.01f;  zBottom0-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX1 < 0) { zLeft0-=0.01f; zRight0-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeft0+=0.01f; zRight0+=0.01f; }// Right
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottom0+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) { zBottom0-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX2 < 0) { zRight0-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX2 > 0) { zRight0+=0.01f; } // Right

	zLeftExitGame = zLeft0;
	zRightExitGame = zRight0;
	zTopExitGame = zTop0;
	zBottomExitGame = zBottom0;

	zLeftScale = zLeftExitGame;
	zRightScale = zRightExitGame;
	zTopScale = zTopExitGame;
	zBottomScale = zBottomExitGame;

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	Device->SetTexture(0,TexPreview);
	MakeVertexListExitGame();
	Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
	for(int i = 0; i < GameOptionItems.size(); i++) {
		DrawGameOptionItem(i, (char*)GameOptionItems[i].c_str(), GameOptionPosX, GameOptionPosY + (i * vSpace));
	}
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void MovieAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		stopMovie();
		SaveIni();
		ExitROMSelectEditMenu();
		VideoResize = false;
		GUIState = 10;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 < 0) {fTop+=1;  fBottom+=1; }// Up
	if (g_Gamepads[DefaultController].fY1 > 0) {fTop-=1;  fBottom-=1; } // Down
	if (g_Gamepads[DefaultController].fX1 < 0) {fLeft-=1; fRight-=1; } // Left
	if (g_Gamepads[DefaultController].fX1 > 0) {fLeft+=1; fRight+=1; }// Right

	if (g_Gamepads[DefaultController].fY2 < 0) fBottom+=1; // Up
	if (g_Gamepads[DefaultController].fY2 > 0) fBottom-=1; // Down
	if (g_Gamepads[DefaultController].fX2 < 0) fRight-=1; // Left
	if (g_Gamepads[DefaultController].fX2 > 0) fRight+=1; // Right

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	DrawROMSelectEditMenu();
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void DualMovieAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		stopMovie();
		SaveIni();
		ExitROMSelectEditMenu();
		DualVideoResize = false;
		GUIState = 49;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 < 0) {fDualTop+=1;  fDualBottom+=1; }// Up
	if (g_Gamepads[DefaultController].fY1 > 0) {fDualTop-=1;  fDualBottom-=1; } // Down
	if (g_Gamepads[DefaultController].fX1 < 0) {fDualLeft-=1; fDualRight-=1; } // Left
	if (g_Gamepads[DefaultController].fX1 > 0) {fDualLeft+=1; fDualRight+=1; }// Right

	if (g_Gamepads[DefaultController].fY2 < 0) fDualBottom+=1; // Up
	if (g_Gamepads[DefaultController].fY2 > 0) fDualBottom-=1; // Down
	if (g_Gamepads[DefaultController].fX2 < 0) fDualRight-=1; // Left
	if (g_Gamepads[DefaultController].fX2 > 0) fDualRight+=1; // Right

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	DrawROMSelectEditMenu();
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void MainMenuMovieAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		stopMovie();
		SaveIni();
		GUIState = 10;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 < 0) {fTopMenu+=1;  fBottomMenu+=1; }// Up
	if (g_Gamepads[DefaultController].fY1 > 0) {fTopMenu-=1;  fBottomMenu-=1; } // Down
	if (g_Gamepads[DefaultController].fX1 < 0) {fLeftMenu-=1; fRightMenu-=1; } // Left
	if (g_Gamepads[DefaultController].fX1 > 0) {fLeftMenu+=1; fRightMenu+=1; }// Right

	if (g_Gamepads[DefaultController].fY2 < 0) fBottomMenu+=1; // Up
	if (g_Gamepads[DefaultController].fY2 > 0) fBottomMenu-=1; // Down
	if (g_Gamepads[DefaultController].fX2 < 0) fRightMenu-=1; // Left
	if (g_Gamepads[DefaultController].fX2 > 0) fRightMenu+=1; // Right

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	drawMovie();
	Device->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
	Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
	Device->SetTexture(0,TexMainMenu);
	SetAlpha = 1;
	DrawBackground();
	SetAlpha = 0;
	Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void PreviewBorderAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		ExitROMSelectEditMenu();
		PreviewBorderResize = false;
		GUIState = 10;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) { zTopPreviewBorder+=0.01f;  zBottomPreviewBorder+=0.01f; }// Up
	if (g_Gamepads[DefaultController].fY1 < 0) { zTopPreviewBorder-=0.01f;  zBottomPreviewBorder-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX1 < 0) { zLeftPreviewBorder-=0.01f; zRightPreviewBorder-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeftPreviewBorder+=0.01f; zRightPreviewBorder+=0.01f; }// Right
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottomPreviewBorder+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) { zBottomPreviewBorder-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX2 < 0) { zRightPreviewBorder-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX2 > 0) { zRightPreviewBorder+=0.01f; } // Right

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	DrawROMSelectEditMenu();
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void InfoBorderAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		ExitROMSelectEditMenu();
		GUIState = 10;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) { zTopInfoBorder+=0.01f;  zBottomInfoBorder+=0.01f; }// Up
	if (g_Gamepads[DefaultController].fY1 < 0) { zTopInfoBorder-=0.01f;  zBottomInfoBorder-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX1 < 0) { zLeftInfoBorder-=0.01f; zRightInfoBorder-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeftInfoBorder+=0.01f; zRightInfoBorder+=0.01f; }// Right
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottomInfoBorder+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) { zBottomInfoBorder-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX2 < 0) { zRightInfoBorder-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX2 > 0) { zRightInfoBorder+=0.01f; } // Right

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	DrawROMSelectEditMenu();
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void VideoBorderAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		ExitROMSelectEditMenu();
		GUIState = 10;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) { zTopVideoBorder+=0.01f;  zBottomVideoBorder+=0.01f; }// Up
	if (g_Gamepads[DefaultController].fY1 < 0) { zTopVideoBorder-=0.01f;  zBottomVideoBorder-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX1 < 0) { zLeftVideoBorder-=0.01f; zRightVideoBorder-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeftVideoBorder+=0.01f; zRightVideoBorder+=0.01f; }// Right
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottomVideoBorder+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) { zBottomVideoBorder-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX2 < 0) { zRightVideoBorder-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX2 > 0) { zRightVideoBorder+=0.01f; } // Right

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	DrawROMSelectEditMenu();
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void DualVideoBorderAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		ExitROMSelectEditMenu();
		GUIState = 49;
		DualVideoBorderResize = false;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) { zTopDualVideoBorder+=0.01f;  zBottomDualVideoBorder+=0.01f; }// Up
	if (g_Gamepads[DefaultController].fY1 < 0) { zTopDualVideoBorder-=0.01f;  zBottomDualVideoBorder-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX1 < 0) { zLeftDualVideoBorder-=0.01f; zRightDualVideoBorder-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeftDualVideoBorder+=0.01f; zRightDualVideoBorder+=0.01f; }// Right
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottomDualVideoBorder+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) { zBottomDualVideoBorder-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX2 < 0) { zRightDualVideoBorder-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX2 > 0) { zRightDualVideoBorder+=0.01f; } // Right

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	DrawROMSelectEditMenu();
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void ROMBorderAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		ExitROMSelectEditMenu();
		GUIState = 10;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) { zTopROMBorder+=0.01f;  zBottomROMBorder+=0.01f; }// Up
	if (g_Gamepads[DefaultController].fY1 < 0) { zTopROMBorder-=0.01f;  zBottomROMBorder-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX1 < 0) { zLeftROMBorder-=0.01f; zRightROMBorder-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeftROMBorder+=0.01f; zRightROMBorder+=0.01f; }// Right
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottomROMBorder+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) { zBottomROMBorder-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX2 < 0) { zRightROMBorder-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX2 > 0) { zRightROMBorder+=0.01f; } // Right

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	DrawROMSelectEditMenu();
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();

}

void SelectBorderAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		ExitROMSelectEditMenu();
		GUIState = 10;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) { zTopSelectBorder+=0.01f;  zBottomSelectBorder+=0.01f; }// Up
	if (g_Gamepads[DefaultController].fY1 < 0) { zTopSelectBorder-=0.01f;  zBottomSelectBorder-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX1 < 0) { zLeftSelectBorder-=0.01f; zRightSelectBorder-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeftSelectBorder+=0.01f; zRightSelectBorder+=0.01f; }// Right
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottomSelectBorder+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) { zBottomSelectBorder-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX2 < 0) { zRightSelectBorder-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX2 > 0) { zRightSelectBorder+=0.01f; } // Right

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	DrawROMSelectEditMenu();
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();

}
void AlternatePreviewAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		ExitROMSelectEditMenu();
		AlternatePreviewResize = false;
		GUIState = 10;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) { zTopAlternatePreview+=0.01f;  zBottomAlternatePreview+=0.01f; }// Up
	if (g_Gamepads[DefaultController].fY1 < 0) { zTopAlternatePreview-=0.01f;  zBottomAlternatePreview-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX1 < 0) { zLeftAlternatePreview-=0.01f; zRightAlternatePreview-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeftAlternatePreview+=0.01f; zRightAlternatePreview+=0.01f; }// Right
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottomAlternatePreview+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) { zBottomAlternatePreview-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX2 < 0) { zRightAlternatePreview-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX2 > 0) { zRightAlternatePreview+=0.01f; } // Right

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	DrawROMSelectEditMenu();
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void AlternatePreviewBorderAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		ExitROMSelectEditMenu();
		AlternatePreviewBorderResize = false;
		GUIState = 10;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) { zTopAlternatePreviewBorder+=0.01f;  zBottomAlternatePreviewBorder+=0.01f; }// Up
	if (g_Gamepads[DefaultController].fY1 < 0) { zTopAlternatePreviewBorder-=0.01f;  zBottomAlternatePreviewBorder-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX1 < 0) { zLeftAlternatePreviewBorder-=0.01f; zRightAlternatePreviewBorder-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeftAlternatePreviewBorder+=0.01f; zRightAlternatePreviewBorder+=0.01f; }// Right
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottomAlternatePreviewBorder+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) { zBottomAlternatePreviewBorder-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX2 < 0) { zRightAlternatePreviewBorder-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX2 > 0) { zRightAlternatePreviewBorder+=0.01f; } // Right

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	DrawROMSelectEditMenu();
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void AnimatedLogoAdjust() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		ExitROMSelectEditMenu();
		GUIState = 10;
		return;
	}

	if (g_Gamepads[DefaultController].fY1 > 0) { zTopAnimatedLogo+=0.01f;  zBottomAnimatedLogo+=0.01f; }// Up
	if (g_Gamepads[DefaultController].fY1 < 0) { zTopAnimatedLogo-=0.01f;  zBottomAnimatedLogo-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX1 < 0) { zLeftAnimatedLogo-=0.01f; zRightAnimatedLogo-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX1 > 0) { zLeftAnimatedLogo+=0.01f; zRightAnimatedLogo+=0.01f; }// Right
	if (g_Gamepads[DefaultController].fY2 > 0) { zBottomAnimatedLogo+=0.01f; } // Up
	if (g_Gamepads[DefaultController].fY2 < 0) { zBottomAnimatedLogo-=0.01f; } // Down
	if (g_Gamepads[DefaultController].fX2 < 0) { zRightAnimatedLogo-=0.01f; } // Left
	if (g_Gamepads[DefaultController].fX2 > 0) { zRightAnimatedLogo+=0.01f; } // Right

	cMoveROMBrowserLogo = 0;
	zLeftAnimatedLogoTemp = zLeftAnimatedLogo;
	zRightAnimatedLogoTemp = zRightAnimatedLogo;
	zTopAnimatedLogoTemp = zTopAnimatedLogo;
	zBottomAnimatedLogoTemp = zBottomAnimatedLogo;

	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	DrawROMSelectEditMenu();
	DisplayInstructions("Use the left and right analog sticks to adjust the image.");
	Present();
}

void OptionGUIImageItemsInput() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		SaveIni();
		GUIState = 7;
		OptionGUIImageSelected = 0;
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
		ClickSound();
		OptionGUIImageSelected++;
		if(OptionGUIImageSelected > OptionGUIImageItems.size() - 1)
			OptionGUIImageSelected = 0;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  { 
		ClickSound();
		OptionGUIImageSelected--;
		if(OptionGUIImageSelected < 0)
			OptionGUIImageSelected = OptionGUIImageItems.size() - 1;
	}  

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_X) {
		ConfirmSound();
		if(OptionGUIImageSelected == 3) {
			zoomSpeed--;
			if(zoomSpeed < 1)
				zoomSpeed = 100;
			OptionGUIImageValueItems[3] = ConvertIntToString(zoomSpeed);
		}
		if(OptionGUIImageSelected == 4) {
			fadeSpeed--;
			if(fadeSpeed < 1)
				fadeSpeed = 100;
			OptionGUIImageValueItems[4] = ConvertIntToString(fadeSpeed);
		}
	}

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		ConfirmSound();
		if(OptionGUIImageSelected == 0) {
			InitROMSelectEditMenu();
			GUIState = 27;
		}

		if(OptionGUIImageSelected == 1) {
			PreviewResize = true;
			InitROMSelectEditMenu();
			GUIState = 28;
		}

		if(OptionGUIImageSelected == 2) {
			if(TexPreview) {
				TexPreview->Release();
				TexPreview = NULL;
			}
			D3DXCreateTextureFromFileEx(Device, "D:\\media\\preview.png", D3DX_DEFAULT,
				D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
				D3DX_DEFAULT,0,NULL,NULL,&TexPreview);
			GUIState = 29;
		}
		if(OptionGUIImageSelected == 3) {
			zoomSpeed++;
			if(zoomSpeed > 100)
				zoomSpeed = 1;
			OptionGUIImageValueItems[3] = ConvertIntToString(zoomSpeed);
		}
		if(OptionGUIImageSelected == 4) {
			fadeSpeed++;
			if(fadeSpeed > 100)
				fadeSpeed = 1;
			OptionGUIImageValueItems[4] = ConvertIntToString(fadeSpeed);
		}
		if(OptionGUIImageSelected == 5) {
			VideoResize = true;
			InitROMSelectEditMenu();
			GUIState = 30;
		}

		if(OptionGUIImageSelected == 6) {
			initMovie("D:\\media\\videopreview.xmv");
			GUIState = 31;
		}

		if(OptionGUIImageSelected == 7) {
			PreviewBorderResize = true;
			InitROMSelectEditMenu();
			GUIState = 32;
		}

		if(OptionGUIImageSelected == 8) {
			InitROMSelectEditMenu();
			GUIState = 34;
		}

		if(OptionGUIImageSelected == 9) {
			InitROMSelectEditMenu();
			GUIState = 35;
		}

		if(OptionGUIImageSelected == 10) {
			InitROMSelectEditMenu();
			GUIState = 36;
		}

		if(OptionGUIImageSelected == 11) {
			AlternatePreviewResize = true;
			InitROMSelectEditMenu();
			GUIState = 37;
		}

		if(OptionGUIImageSelected == 12) {
			AlternatePreviewBorderResize = true;
			InitROMSelectEditMenu();
			GUIState = 38;
		}

		if(OptionGUIImageSelected == 13) {
			InitROMSelectEditMenu();
			GUIState = 39;
		}

		if(OptionGUIImageSelected == 14) {
			GUIState = 18;
			return;
		}
	}
}

void OptionGUIImageItemsMenuPage2() {
	OptionGUIImageItemsInputPage2();
	DrawOptionGUIImageItemsMenuPage2();
}

void OptionGUIImageItemsMenuPage3() {
	OptionGUIImageItemsInputPage3();
	DrawOptionGUIImageItemsMenuPage3();
}

void DrawOptionGUIImageItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(OptionGUIImageSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawOptionGUIImageItemsMenu() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	for(int i = 0; i < OptionGUIImageItems.size(); i++) {
		DrawOptionGUIImageItem(i, (char*)OptionGUIImageItems[i].c_str(), MenuDetailPosX, MenuDetailPosY + (i * vSpace));
		DrawOptionGUIImageItem(i, (char*)OptionGUIImageValueItems[i].c_str(), MenuDetailPosX + MenuSpacing, MenuDetailPosY + (i * vSpace));
	}
	Present();
}

void OptionGUIImageItemsMenu() {
	OptionGUIImageItemsInput();
	DrawOptionGUIImageItemsMenu();
}

