#include "GlobalExtern.h"
extern void ImageMenu();

void MenuBackground() {
    if(MainMenuMovieSwitchEnabled) {		
        stopMovie();
        if(MenuSelected == 0) { 
            initMovie((char*)MainMenuVideoPath0.c_str());
        }
        if(MenuSelected == 1) {
            initMovie((char*)MainMenuVideoPath1.c_str());
        }
        if(MenuSelected == 2) {
            initMovie((char*)MainMenuVideoPath2.c_str());
        }
        if(MenuSelected == 3) {
            initMovie((char*)MainMenuVideoPath3.c_str());
        }
        if(MenuSelected == 4) {
            initMovie((char*)MainMenuVideoPath4.c_str());
        }
        if(MenuSelected == 5) {
            initMovie((char*)MainMenuVideoPath5.c_str());
        }
    }
    else {
        if(videoRender == false)
            initMovie((char*)MainMenuVideoPath0.c_str());
    }
}

void ResetAnimatedLogoMainMenu() {
    zLeftAnimatedLogoMainMenuTemp = zLeftAnimatedLogoMainMenu;
    zRightAnimatedLogoMainMenuTemp = zRightAnimatedLogoMainMenu;
    zTopAnimatedLogoMainMenuTemp = zTopAnimatedLogoMainMenu;
    zBottomAnimatedLogoMainMenuTemp = zBottomAnimatedLogoMainMenu;
    lMoveLogoMainMenu = -1 * distanceLogoMainMenu;
    rMoveLogoMainMenu = distanceLogoMainMenu;
    tMoveLogoMainMenu = distanceLogoMainMenu;
    bMoveLogoMainMenu = -1 * distanceLogoMainMenu;
    cMoveLogoMainMenu = 0;
    lastTimeLogoMainMenu = 0;
}

int AnimateLogoMainMenuTimer() {
    QueryPerformanceCounter(&tickLogoMainMenu);
    if(lastTimeLogoMainMenu == 0) {
        lastTimeLogoMainMenu = (FLOAT)tickLogoMainMenu.QuadPart;
        return 0;
    }
    if((((FLOAT)tickLogoMainMenu.QuadPart) - lastTimeLogoMainMenu) >= (((FLOAT)ticksPerSecondLogoMainMenu.QuadPart) / 60.0f) * 1) {
        lastTimeLogoMainMenu = (FLOAT)tickLogoMainMenu.QuadPart;
        return 1;
    }
    else {
        return 0;
    }
}

void MakeVertexListAnimatedLogoMainMenu(bool animate)
{
    struct CustomVertex *vert=NULL,*pv=NULL;
    float dist=0.0f;
    float scalex=0.0f,scaley=0.0f;
    unsigned int colour=0xffffffff;
    float right=0.0f,bottom=0.0f;
    if(animate) {
        if(AnimateLogoMainMenuTimer() == 1) {
            zLeftAnimatedLogoMainMenuTemp += lMoveLogoMainMenu;
            zRightAnimatedLogoMainMenuTemp += rMoveLogoMainMenu;
            zTopAnimatedLogoMainMenuTemp += tMoveLogoMainMenu;
            zBottomAnimatedLogoMainMenuTemp += bMoveLogoMainMenu;
            cMoveLogoMainMenu += speedLogoMainMenu;

            if(cMoveLogoMainMenu >= distanceLogoMainMenu) {
                cMoveLogoMainMenu = 0;
                lMoveLogoMainMenu = -lMoveLogoMainMenu;
                rMoveLogoMainMenu = -rMoveLogoMainMenu;
                tMoveLogoMainMenu = -tMoveLogoMainMenu;
                bMoveLogoMainMenu = -bMoveLogoMainMenu;
            }
        }
    }
    dist=10.0; scalex=dist; scaley=dist;
    vert=VertexListAnimatedLogoMainMenu;
    pv=vert;
    pv->z=dist;
    pv->x=-scalex + zLeftAnimatedLogoMainMenuTemp;
    pv->y=scaley + zTopAnimatedLogoMainMenuTemp;
    pv->colour=colour; pv++;
    *pv=vert[0]; pv->x= scalex  + zRightAnimatedLogoMainMenuTemp; pv->y= scaley + zTopAnimatedLogoMainMenuTemp; pv++;
    *pv=vert[0]; pv->x=-scalex  + zLeftAnimatedLogoMainMenuTemp; pv->y=-scaley  + zBottomAnimatedLogoMainMenuTemp; pv++;
    *pv=vert[0]; pv->x= scalex  + zRightAnimatedLogoMainMenuTemp; pv->y=-scaley +  zBottomAnimatedLogoMainMenuTemp; pv++;
    right = 1;bottom= 1; pv=vert;
    pv->u=0.0f; pv->v=0.00f; pv++;
    pv->u=right; pv->v=0.00f; pv++;
    pv->u=0.0f; pv->v=bottom; pv++;
    pv->u=right; pv->v=bottom; 
    unsigned char *lock=NULL;
    VertexBufferAnimatedLogoMainMenu->Lock(0,sizeof(VertexListAnimatedLogoMainMenu),&lock,0);
    memcpy(lock,VertexListAnimatedLogoMainMenu,sizeof(VertexListAnimatedLogoMainMenu));
    VertexBufferAnimatedLogoMainMenu->Unlock();
    Device->SetStreamSource(0,VertexBufferAnimatedLogoMainMenu,sizeof(CustomVertex));
    Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}

void UtilityMenu() {
    updateEffect();
    ReadInput();
    if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
        CancelSound();
        GUIState = MAIN_MENU;
        fadeOption = 1;
        fadeColor = 255;
        return;
    } 
    if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
        ClickSound();
        UtilityValue++; 
        if(UtilityValue > 2) 
            UtilityValue = 0;
    }
    if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
        ClickSound();
        UtilityValue--; 
        if(UtilityValue < 0) 
            UtilityValue = 2;
    }  
    if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
        ConfirmSound();				
        if(UtilityValue == 0) {
            ImageMenu();
        } 
        if(UtilityValue == 1) {
            SearchDirectoryText("D:\\guides\\");
            OptionGameGuide = true;
            while(OptionGameGuide == true) {
                GuideListMenu();
            }
        }
        if(UtilityValue == 2) {
            ResetFiles();
            GUIState = MAIN_MENU;
            fadeOption = 1;
            fadeColor = 255;
			return;
        }
    }
    Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
    Device->SetTexture(0,TexOption);
    DrawBackground();

    if(fadeColor > 0) {
        Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
        fade = true;
        fadeColor -=fadeSpeed;
        if(fadeColor < fadeSpeed) { fadeColor = 0; }
        Device->SetTexture(0,TexMainMenu);
        DrawBackground();
        fade = false;
        Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
    }
    else {
        int y = 110;
        DWORD color;
        if(UtilityValue == 0) color = 0xffff00; else color = 0xffffff;
        FontSetColour(color);
        FontCheatText(ConvertCharStringToWCHAR("Image Viewer"), 640/2, 110, sWidth);
        if(UtilityValue == 1) color = 0xffff00; else color = 0xffffff;
        FontSetColour(color);
        FontCheatText(ConvertCharStringToWCHAR("Text File Viewer"), 640/2, 130, sWidth);
		if(UtilityValue == 2) color = 0xffff00; else color = 0xffffff;
        FontSetColour(color);
        FontCheatText(ConvertCharStringToWCHAR("Reset Game Config Files"), 640/2, 150, sWidth);
    }
    Present();
}

void MainMenuInput() {
    ReadInput();
    if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
        ClickSound();
        MenuSelected++;
        if(MenuSelected > MainMenuItems.size() - 1)
            MenuSelected = 0;
        MenuBackground();
    }

    if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
        ClickSound();
        MenuSelected--;
        if(MenuSelected < 0)
            MenuSelected = MainMenuItems.size() - 1;
        MenuBackground();
    }  

    if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
        ConfirmSound();
        stopMovie();
        if(MenuSelected == 0) {
            Scan();
            UpdatePreview(GameList[GameSelected].name);
            GUIState = ROM_SELECT;
            fadeColor = 255;
            return;
        }

        if(MenuSelected == 1) {
            UpdatePreview(FavoritesDatabase[GameFavoriteSelected].name);
            GUIState = FAVORITE_SELECT;
            fadeColor = 255;
            return;
        }

        if(MenuSelected == 2) {
            GUIState = 3;
            fadeColor = 255;
            return;
        }

        if(MenuSelected == 3) {
            UtilityValue = 0;
            GUIState = 58;
            fadeColor = 255;
            guideGameSelected = 0;
            guideGameSelectedText = 0;
            return;
        }

        if(MenuSelected == 4) {
            SearchDirectoryText("D:\\docs\\");
            fadeColor = 255;
            GUIState = 11;
            guideGameSelected = 0;
            guideGameSelectedText = 0;
            return;
        }

        if(MenuSelected == 5) {
            fadeColor = 255;
            while(1) {
                updateEffect();
                ReadInput();
                if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
                    CancelSound();
                    fadeOption = 1;
                    fadeColor = 255;
                    MenuSelected = 5;
                    return;
                }

                if(g_Gamepads[DefaultController].Event == XBGAMEPAD_Y) {
                    SaveIni();
                    LD_LAUNCH_DASHBOARD launch;
                    memset(&launch,0,sizeof(launch));
                    launch.dwReason=XLD_LAUNCH_DASHBOARD_MAIN_MENU;
                    XLaunchNewImage(NULL,(LAUNCH_DATA *)&launch);
                }

                Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
                Device->SetTexture(0,TexOption);
                DrawBackground();
                if(fadeColor > 0) {
                    Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
                    fade = true;
                    fadeColor -=fadeSpeed;
                    if(fadeColor < fadeSpeed) { fadeColor = 0; }
                    Device->SetTexture(0,TexMainMenu);
                    DrawBackground();
                    fade = false;
                    Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
                }
                else {
                    DisplayCenteredMsg("Press \"Y\" to exit or \"B\" to cancel", 230);
                }
                Present();
            }
        }
    }
}

void DrawMenuItem(int MenuItemNumber, char* text, int x, int y) {
    unsigned int c;
    if(MenuSelected == MenuItemNumber) 
        c = 0xffff00; 
    else 
        c = 0xffffff;
    FontSetColour(c);
    FontCenteredText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawMainMenuItem(int MenuItemNumber, char* text, int x, int y) {
    SetFontHeight(MainMenuFontSize);
    unsigned int c;
    if(MenuSelected == MenuItemNumber) 
        c = 0xffff00; 
    else 
        c = 0xffffff;
    FontSetColour(c);
    if(MainMenuCentered) 
        FontCenteredText(ConvertCharStringToWCHAR(text), x, y, 640);
    else
        FontText(ConvertCharStringToWCHAR(text), x, y, 640);
    SetFontHeight(FontSize);
}

void DrawMainMenu() {
    if(fadeColor > 0) {
        Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
        Device->SetTexture(0,TexMainMenu);
        DrawBackground();
        Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
        fade = true;
        fadeColor -=fadeSpeed;
        if(fadeColor < fadeSpeed) { fadeColor = 0; }

        if(fadeOption == 0) {
            Device->SetTexture(0,TexROMBrowser);
            DrawBackground();
        }
        if(fadeOption == 1) {
            Device->SetTexture(0,TexOption);
            DrawBackground();
        }
        if(fadeOption == 2) {
            Device->SetTexture(0,TexSplashScreen);
            DrawBackground();
            Device->SetTexture(0,TexPreview);
            DrawBackground();
        }
        fade = false;
        Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
    }
    else {
        Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
        drawMovie();
        Device->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
        Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
        SetAlpha = 1;
        Device->SetTexture(0,TexMainMenu);
        DrawBackground();
        SetAlpha = 0;
        Device->SetTexture(0,TexAnimatedLogo);
        MakeVertexListAnimatedLogoMainMenu(true);
        Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);

        SetAlpha = 1;
        Device->SetTexture(0,TexMainMenuOverlay);
        if(MenuSelected == 0) {
            MakeVertexListMainMenuOverlay1();
            Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
        }
        if(MenuSelected == 1) {
            MakeVertexListMainMenuOverlay2();
            Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
        }
        if(MenuSelected == 2) {
            MakeVertexListMainMenuOverlay3();
            Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
        }
        if(MenuSelected == 3) {
            MakeVertexListMainMenuOverlay4();
            Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
        }
        if(MenuSelected == 4) {
            MakeVertexListMainMenuOverlay5();
            Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
        }
        if(MenuSelected == 5) {
            MakeVertexListMainMenuOverlay6();
            Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
        }
        Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
        SetAlpha = 0;
        for(int i = 0; i < MainMenuItems.size(); i++) {
            DrawMainMenuItem(i, (char*)MainMenuItems[i].c_str(), MainMenuPosX, MainMenuPosY + (i * MainMenuVSpace));
        }
    }
    Present();
}

void MainMenu() {
    DrawMainMenu();
    MainMenuInput();
}
