#include "GlobalExtern.h"

extern int nst_quit;

void DrawDipSwitchSettingItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(DipSwitchSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawDipSwitchMenu() {
	for(int i = 0; i < DipSwitchSettings.size(); i++) {
		DrawDipSwitchSettingItem(i, (char*)DipSwitchSettings[i].description.c_str(), MenuDetailPosX, MenuDetailPosY + (i * vSpace));
		DrawDipSwitchSettingItem(i, (char*)DipSwitchSettings[i].value.c_str(), MenuDetailPosX + MenuSpacing, MenuDetailPosY + (i * vSpace));
	}
}

void DrawGeneralOptionItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(GeneralOptionsSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawGeneralOptionsMenu() {
	for(int i = 0; i < GeneralOptionsSettings.size(); i++) {
		DrawGeneralOptionItem(i, (char*)GeneralOptionsSettings[i].c_str(), MenuDetailPosX, MenuDetailPosY + (i * vSpace));
		DrawGeneralOptionItem(i, (char*)GeneralOptionsValueSettings[i].c_str(), MenuDetailPosX + MenuSpacing, MenuDetailPosY + (i * vSpace));
	}
}

void DrawArcadeInfo() {
	while(true) {
		updateEffect();
		ReadInput();
		if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
			CancelSound();
			SetFontHeight(FontSize);
			guide.clear();
			return;          
		} 
		if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
			ClickSound();
			if(guideGameSelectedText < 7) guideGameSelectedText = 7;
			guideGameSelectedText++; if(guideGameSelectedText >=guide.size()) guideGameSelectedText = guide.size()- 1;
		}
		if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {  
			ClickSound();
			guideGameSelectedText--; if(guideGameSelectedText < 7) guideGameSelectedText = 7;
		}  
		if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_RIGHT)  {
			if(guideGameSelectedText < 7) guideGameSelectedText = 7;
			guideGameSelectedText+=GameGuideLines; if(guideGameSelectedText >=guide.size()) guideGameSelectedText = guide.size()- 1;
		}
		if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_LEFT)  {  
			guideGameSelectedText-=GameGuideLines; if(guideGameSelectedText < 7) guideGameSelectedText = 7;
		}  
		if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) {
			if(slowGuide >= 1) { 
				slowGuide = 0; 
			} 
			if(rightAnalog == 255)
				slowGuide = scrollSpeed;
			else
				slowGuide += ((float)rightAnalog/255.0f);
			guideGameSelectedText+=((int)slowGuide); 
			if(guideGameSelectedText >= guide.size()) 
				guideGameSelectedText = guide.size() - 1;
		}
		if (g_Gamepads[DefaultController].fX1 < 0) {guideLeft-=2;  } // Left
		if (g_Gamepads[DefaultController].fX1 > 0) {guideLeft+=2;  }// Right
		if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) {
			if(slowGuide >= 1)  { 
				slowGuide = 0;
			}
			if(leftAnalog == 255)
				slowGuide = scrollSpeed;
			else
				slowGuide += ((float)leftAnalog/255.0f);
			guideGameSelectedText-=((int)slowGuide); 
			if(guideGameSelectedText < 7)
				guideGameSelectedText = 7;
		}
		Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
		SetFontHeight(GameGuideFontSize);
		DrawGuide();
		SetFontHeight(FontSize);
		Present();
	}
}

extern void ResetSystem();
void GameOptionInput() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		//CancelSound();
		SaveGameIni(globalGameName.c_str());
		exitGameMenu = true;
		DxSoundPlay();
		SetDelay();
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
		ClickSound();
		GameOptionSelected++;
		if(GameOptionSelected > GameOptionItems.size() - 1)
			GameOptionSelected = 0;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
		ClickSound();
		GameOptionSelected--;
		if(GameOptionSelected < 0)
			GameOptionSelected = GameOptionItems.size() - 1;
	}  

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		if(GameOptionSelected == 0) {
			//ConfirmSound();
			SaveGameIni(globalGameName);
			exitGameMenu = true;
			DxSoundPlay();
			SetDelay();
			return;
		}
		if(GameOptionSelected == 1) {
			ConfirmSound();
			//resetGame = 10;
			SaveGameIni(globalGameName);
			exitGameMenu = true;
			DxSoundPlay();
			ResetSystem();
			SetDelay();
			return;
		}

		if(GameOptionSelected == 2) {
			ConfirmSound();
			SaveSlotSelected = 0;
			char fileName[2048];
			sprintf(fileName,"%s%s%s%s%s%s", SaveStatePath.c_str(), "\\", globalGameName.c_str(), "\\Slot0\\", globalGameName.c_str(), ".png");
			if(TexPreview) {
				TexPreview->Release();
				TexPreview = NULL;
			}
			D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
				D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
				D3DX_DEFAULT,0,NULL,NULL,&TexPreview);
			GUIState = 10;
			return;
		}

		if(GameOptionSelected == 3) {
			ConfirmSound();
			SaveSlotSelected = 0;
			char fileName[2048];
			sprintf(fileName,"%s%s%s%s%s%s", SaveStatePath.c_str(), "\\", globalGameName.c_str(), "\\Slot0\\", globalGameName.c_str(), ".png");
			if(TexPreview) {
				TexPreview->Release();
				TexPreview = NULL;
			}
			D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
				D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
				D3DX_DEFAULT,0,NULL,NULL,&TexPreview);
			GUIState = 11;
			return;
		}

		if(GameOptionSelected == 4) {
			ConfirmSound();
			std::string e;
			if(CurrentArtwork == 1) e = ArtworkPath1;
			if(CurrentArtwork == 2) e = ArtworkPath2;
			if(CurrentArtwork == 3) e = ArtworkPath3;
			if(CurrentArtwork == 4) e = ArtworkPath4;
			if(CurrentArtwork == 5) e = ArtworkPath5;
			if(CurrentArtwork == 6) e = ArtworkPath6;
			if(CurrentArtwork == 7) e = ArtworkPath7;
			if(CurrentArtwork == 8) e = ArtworkPath8;
			char fileName[2048];
			sprintf(fileName,"%s%s%s%s", e.c_str(), "\\", globalGameName.c_str(), ".png");
			MakeScreenShot(fileName);
			SaveGameIni(globalGameName.c_str());
			exitGameMenu = true;
			DxSoundPlay();
			SetDelay();			
			return;
		}

		if(GameOptionSelected == 5) {
			ConfirmSound();
			GUIState = 4;
			return;
		}
		if(GameOptionSelected == 6) {
			ConfirmSound();
            std::ostringstream temp;
			temp << nDSoundVol;
			std::string temp2 = temp.str();
			OptionEmulationSoundValueItems[1] = temp2.c_str();
			GUIState = 5;
			return;
		}

		if(GameOptionSelected == 7) {
			ConfirmSound();
			while(1) {
				updateEffect();
				ReadInput();
				if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
					CancelSound();
					SaveGameIni(globalGameName.c_str());
					SaveControllerIni();
					return;
				}

				if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
					ClickSound();
					OptionGUIControllerItemsSelected++;
					if(OptionGUIControllerItemsSelected > OptionGUIControllerItems.size() - 1)
						OptionGUIControllerItemsSelected = 0;
				}

				if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
					ClickSound();
					OptionGUIControllerItemsSelected--;
					if(OptionGUIControllerItemsSelected < 0)
						OptionGUIControllerItemsSelected = OptionGUIControllerItems.size() - 1;
				}  

				if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
					ConfirmSound();
					if(OptionGUIControllerItemsSelected == 0) {
						OptionControllerItems.clear();
						if(OptionControllerButtonItems[0].size() != 0)
							OptionControllerItems.push_back("Controller 1 Configuration");
						if(OptionControllerButtonItems[1].size() != 0)
							OptionControllerItems.push_back("Controller 2 Configuration");
						if(OptionControllerButtonItems[2].size() != 0)
							OptionControllerItems.push_back("Controller 3 Configuration");
						if(OptionControllerButtonItems[3].size() != 0)
							OptionControllerItems.push_back("Controller 4 Configuration");
						while(1) {
							updateEffect();
							if(!OptionControllerInput())
								break;
							DrawOptionControllerMenu();
						}
					}
					if(OptionGUIControllerItemsSelected == 1) {
						while(1) {
							updateEffect();
							ReadInput();
							if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
								CancelSound();
								SaveControllerIni();
								break;  
							}
							if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
								ClickSound();
								OptionControllerTurboSelected++;
								if(OptionControllerTurboSelected > OptionControllerTurboItems.size() - 1)
									OptionControllerTurboSelected = 0;
							}

							if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
								ClickSound();
								OptionControllerTurboSelected--;
								if(OptionControllerTurboSelected < 0)
									OptionControllerTurboSelected = OptionControllerTurboItems.size() - 1;
							}  

							if(g_Gamepads[DefaultController].Event == XBGAMEPAD_X) {
								ConfirmSound();
								if(OptionControllerTurboSelected == 5) {
									turboSpeed--; 
									if(turboSpeed < 1) 
										turboSpeed = 100; 
								}
								UpdateTurboDescriptions();	
							} 

							if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
								ConfirmSound();
								if(OptionControllerTurboSelected == 0) {
									turboControllerSelected++;
									if(turboControllerSelected > 3) 
										turboControllerSelected = 0;
								}
								if(OptionControllerTurboSelected == 1) {
									tButtons[turboControllerSelected].turboA++; 
									tButtons[turboControllerSelected].turboA &= 1; 
								}
								if(OptionControllerTurboSelected == 2) {
									tButtons[turboControllerSelected].turboB++; 
									tButtons[turboControllerSelected].turboB &= 1; 
								}
								if(OptionControllerTurboSelected == 3) {
									tButtons[turboControllerSelected].turboSelect++; 
									tButtons[turboControllerSelected].turboSelect &= 1; 
								}
								if(OptionControllerTurboSelected == 4) {
									tButtons[turboControllerSelected].turboStart++; 
									tButtons[turboControllerSelected].turboStart &= 1; 
								}
								if(OptionControllerTurboSelected == 5) {
									turboSpeed++; 
									if(turboSpeed > 100) 
										turboSpeed = 1; 
								}
								UpdateTurboDescriptions();
							} 

							DrawOptionControllerTurboMenu();
						}
					}
					if(OptionGUIControllerItemsSelected == 2) {
						ControllerEdit = true;
						while(ControllerEdit) {
							updateEffect();
							OptionControllerGeneralMenu();
						}
					}
					//Controller1Type
				}

				Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
				Device->SetTexture(0,TexOption);
				DrawBackground();
				for(int i = 0; i < OptionGUIControllerItems.size(); i++) {
					unsigned int c;
					if(OptionGUIControllerItemsSelected == i) 
						c = 0xffff00; 
					else 
						c = 0xffffff;
					FontSetColour(c);
					FontCenteredText(ConvertCharStringToWCHAR((char*)OptionGUIControllerItems[i].c_str()), MenuPosX, MenuPosY + (i * vSpace), 640);
				}
				Present();
			}
		}

		if(GameOptionSelected == 8) {
			ConfirmSound();
			GeneralOptionsSelected = 0;
			while(1) {
				updateEffect();
				ReadInput();
				if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
					CancelSound();
					SaveGameIni(globalGameName.c_str());
					break;          
				} 
				if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
					if(GeneralOptionsSettings.size() != 0) {	
						ClickSound();
						GeneralOptionsSelected++; 
						if(GeneralOptionsSelected >= GeneralOptionsSettings.size()) 
							GeneralOptionsSelected = GeneralOptionsSettings.size() - 1;
					}
				}
				if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
					if(GeneralOptionsSettings.size() != 0) {	
						ClickSound();
						GeneralOptionsSelected--; 
						if(GeneralOptionsSelected < 0) 
							GeneralOptionsSelected = 0;
					}
				}  
				if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
					if(GeneralOptionsSettings.size() != 0) {		
						ConfirmSound();

						if(GeneralOptionsSelected == 0) {
							FlipFDSDisk();
							exitGameMenu = true;
							DxSoundPlay();
							SetDelay();
							return;
						}
						if(GeneralOptionsSelected == 1) {
							Disk++;
							if(Disk > 3)
								Disk = 0;
							if(Disk == 0) {
								GeneralOptionsValueSettings[1] = "Disk 1, Side A";
								SetDisk(0, 0);
							}
							if(Disk == 1) {
								GeneralOptionsValueSettings[1] = "Disk 1, Side B";
								SetDisk(0, 1);
							}
							if(Disk == 2) {
								GeneralOptionsValueSettings[1] = "Disk 2, Side A";
								SetDisk(1, 0);
							}
							if(Disk == 3) {
								GeneralOptionsValueSettings[1] = "Disk 2, Side B";
								SetDisk(1, 1);
							}
						}
						if(GeneralOptionsSelected == 2) {
							Region++;
							if(Region > 2)
								Region = 0;
							if(Region == 0)
								GeneralOptionsValueSettings[2] = "Auto";
							if(Region == 1)
								GeneralOptionsValueSettings[2] = "NTSC";
							if(Region == 2)
								GeneralOptionsValueSettings[2] = "PAL";
						}
						if(GeneralOptionsSelected == 3) {
							UnlimitedSprites++;
							if(UnlimitedSprites > 1)
								UnlimitedSprites = 0;
							if(UnlimitedSprites == 1)
								GeneralOptionsValueSettings[3] = "Enabled";
							else
								GeneralOptionsValueSettings[3] = "Disabled";
							SetSprites();
						}
						if(GeneralOptionsSelected == 4) {
							ResetType++;
							if(ResetType > 1)
								ResetType = 0;
							if(ResetType == 1)
								GeneralOptionsValueSettings[4] = "Soft";
							else
								GeneralOptionsValueSettings[4] = "Hard";
						}
                        if(GeneralOptionsSelected == 5) {
                            MovieStop();
							exitGameMenu = true;
							DxSoundPlay();
							SetDelay();
							return;
                        }
                        if(GeneralOptionsSelected == 6) {
                            MovieStop();
                            MovieLoad();
							exitGameMenu = true;
							DxSoundPlay();
							SetDelay();
							return;
                        }
					}
				}
				Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
				Device->SetTexture(0,TexOption);
				DrawBackground();
				DrawGeneralOptionsMenu();
				Present();
			}
		}

		if(GameOptionSelected == 9) {
			ConfirmSound();
			if(CheatGameList.size() == 0) {
				while(1) {
					updateEffect();
					ReadInput();
					if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
						CancelSound();
						return;          
					} 
					Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
					Device->SetTexture(0,TexOption);
					DrawBackground();
					DisplayCenteredMsg("No cheats found", 190); 
					Present();
				}
			}
			else {
				while(1) {
					updateEffect();
					ReadInput();
					if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
						CancelSound();
						EnableCheats();
						return;          
					} 
					if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
						ClickSound();
						CheatGameListSelected++; 
						if(CheatGameListSelected >= CheatGameList.size()) 
							CheatGameListSelected = CheatGameList.size() - 1;
					}
					if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
						ClickSound();
						CheatGameListSelected--; 
						if(CheatGameListSelected < 0) 
							CheatGameListSelected = 0;
					}  
					if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
						ConfirmSound();
						CheatSelected = 0;
						while(1) {
							updateEffect();
							ReadInput();
							if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
								CancelSound();
								break;          
							} 
							if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
								ClickSound();
								CheatSelected++; 
								if(CheatSelected >= CheatGameList[CheatGameListSelected].cheatlist.size()) 
									CheatSelected = CheatGameList[CheatGameListSelected].cheatlist.size() - 1;
							}
							if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
								ClickSound();
								CheatSelected--; 
								if(CheatSelected < 0) 
									CheatSelected = 0;
							}  
							if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
								ConfirmSound();
								int CheatValue = 0;
								while(1) {
									updateEffect();
									ReadInput();
									if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
										CancelSound();
										break;          
									} 
									if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
										ClickSound();
										CheatValue++; 
										if(CheatValue > 1) 
											CheatValue = 0;
									}
									if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
										ClickSound();
										CheatValue--; 
										if(CheatValue < 0) 
											CheatValue = 1;
									}  
									if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
										ConfirmSound();
										if(CheatValue == 0)
											CheatGameList[CheatGameListSelected].cheatlist[CheatSelected].enabled = true;
										else
											CheatGameList[CheatGameListSelected].cheatlist[CheatSelected].enabled = false;

										CheatGameList[CheatGameListSelected].enabled = false;
										for(int j = 0; j < CheatGameList[CheatGameListSelected].cheatlist.size(); j++) {								
											if (CheatGameList[CheatGameListSelected].cheatlist[j].enabled) {
												CheatGameList[CheatGameListSelected].enabled = true;
												break;
											}
										}										
										break;
									}
									Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
									Device->SetTexture(0,TexOption);
									DrawBackground();
									int y = 110;
									DWORD color;
									if(CheatValue == 0) color = 0xffff00; else color = 0xffffff;
									FontSetColour(color);
									FontCheatText(ConvertCharStringToWCHAR("Enabled"), 640/2, 110, sWidth);
									if(CheatValue == 1) color = 0xffff00; else color = 0xffffff;
									FontSetColour(color);
									FontCheatText(ConvertCharStringToWCHAR("Disabled"), 640/2, 130, sWidth);									
									Present();
								}
							}
							if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) {
								if(analogSpeed >= 1) { 
									analogSpeed = 0; 
								} 
								if(rightAnalog == 255)
									analogSpeed = scrollSpeed;
								else
									analogSpeed += ((float)rightAnalog/255.0f);
								CheatSelected+=((int)analogSpeed); 
								if(CheatSelected >= CheatGameList[CheatGameListSelected].cheatlist.size()) 
									CheatSelected = CheatGameList[CheatGameListSelected].cheatlist.size() - 1;
							}
							if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) {
								if(analogSpeed >= 1)  { 
									analogSpeed = 0;
								}
								if(leftAnalog == 255)
									analogSpeed = scrollSpeed;
								else
									analogSpeed += ((float)leftAnalog/255.0f);
								CheatSelected-=((int)analogSpeed); if(CheatSelected < 0) CheatSelected = 0;
							}
							Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
							Device->SetTexture(0,TexOption);
							DrawBackground();
							DrawCheatGameListDetailMenu();
							Present();
						}
					}

					if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) {
						if(analogSpeed >= 1) { 
							analogSpeed = 0; 
						} 
						if(rightAnalog == 255)
							analogSpeed = scrollSpeed;
						else
							analogSpeed += ((float)rightAnalog/255.0f);
						CheatGameListSelected+=((int)analogSpeed); 
						if(CheatGameListSelected >= CheatGameList.size()) 
							CheatGameListSelected = CheatGameList.size() - 1;
					}
					if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) {
						if(analogSpeed >= 1)  { 
							analogSpeed = 0;
						}
						if(leftAnalog == 255)
							analogSpeed = scrollSpeed;
						else
							analogSpeed += ((float)leftAnalog/255.0f);
						CheatGameListSelected-=((int)analogSpeed); if(CheatGameListSelected < 0) CheatGameListSelected = 0;
					}
					Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
					Device->SetTexture(0,TexOption);
					DrawBackground();
					DrawCheatGameListMenu();
					Present();
				}
			}
		}

		if(GameOptionSelected == 10) {
			ConfirmSound();
			FontSetColour(0xffff00);
			Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
			SetupMatrices();
			MakeVertexListMenu();
			FontGUI(ConvertCharStringToWCHAR((char*)"Please wait..."), 320, 240, 640);
			Present();
			LoadGameInfo(GlobalCRC);
			if(guide.size() >= 11) 
				guideGameSelectedText = 10;
			while(true) {
				updateEffect();
				ReadInput();
				if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
					CancelSound();
					SetFontHeight(FontSize);
					guide.clear();
					guideGameSelectedText = 0;
					return;          
				} 
				if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
					ClickSound();
					if(guideGameSelectedText < 10) guideGameSelectedText = 10;
					guideGameSelectedText++; if(guideGameSelectedText >=guide.size()) guideGameSelectedText = guide.size()- 1;
				}
				if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {  
					ClickSound();
					guideGameSelectedText--; if(guideGameSelectedText < 10) guideGameSelectedText = 10;
				}  
				if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_RIGHT)  {
					if(guideGameSelectedText < 10) guideGameSelectedText = 10;
					guideGameSelectedText+=GameGuideLines; if(guideGameSelectedText >=guide.size()) guideGameSelectedText = guide.size()- 1;
				}
				if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_LEFT)  {  
					guideGameSelectedText-=GameGuideLines; if(guideGameSelectedText < 10) guideGameSelectedText = 10;
				}  
				if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) {
					if(slowGuide >= 1) { 
						slowGuide = 0; 
					} 
					if(rightAnalog == 255)
						slowGuide = scrollSpeed;
					else
						slowGuide += ((float)rightAnalog/255.0f);
					guideGameSelectedText+=((int)slowGuide); 
					if(guideGameSelectedText >= guide.size()) 
						guideGameSelectedText = guide.size() - 1;
				}
				if (g_Gamepads[DefaultController].fX1 < 0) {guideLeft-=2;  } // Left
				if (g_Gamepads[DefaultController].fX1 > 0) {guideLeft+=2;  }// Right
				if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) {
					if(slowGuide >= 1)  { 
						slowGuide = 0;
					}
					if(leftAnalog == 255)
						slowGuide = scrollSpeed;
					else
						slowGuide += ((float)leftAnalog/255.0f);
					guideGameSelectedText-=((int)slowGuide); 
					if(guideGameSelectedText < 10)
						guideGameSelectedText = 10;
				}
				Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
				SetFontHeight(GameGuideFontSize);
				DrawGuide();
				SetFontHeight(FontSize);
				Present();
			}
			return;
		}

		if(GameOptionSelected == 11) {
			ConfirmSound();
			SearchDirectoryText("D:\\guides\\");
			GUIState = 12;
			return;
		}

		if(GameOptionSelected == 12) {
			ConfirmSound();
			ImageMenu();
		}

		if(GameOptionSelected == 13) {
			SaveGameIni(globalGameName.c_str());
			exitGameMenu = true;
			nst_quit = 1;
			return;
		}
	}
}

void DrawGameOptionItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(GameOptionSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawGameOptionMenu() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	SetupMatrices();
	DrawBackground();
	Device->SetTexture(0,TexScreen);
	exitEmulation = true;
	MakeVertexListExitGame();
	exitEmulation = false;
	Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
	if(zoomOver >= 4) {
		for(int i = 0; i < GameOptionItems.size(); i++) {
			DrawGameOptionItem(i, (char*)GameOptionItems[i].c_str(), GameOptionPosX, GameOptionPosY + (i * vSpace));
		}
	}
	Present();
}

void GameOptionMenu() {
	ResetScreenSaver();
	zLeftExitGame = zLeft0;
	zRightExitGame = zRight0;
	zTopExitGame = zTop0;
	zBottomExitGame = zBottom0;
	zLeftScale = zBaseLeft + zLeft;
	zRightScale = zBaseRight + zRight;
	zTopScale = zBaseTop + zTop;
	zBottomScale = zBaseBottom + zBottom;
	leftMove = ((zLeftExitGame - (zLeftScale)) / zoomSpeed);
	rightMove = (((zRightScale) - zRightExitGame) / zoomSpeed);
	topMove = (((zTopScale) - zTopExitGame) / zoomSpeed); 
	bottomMove = ((zBottomExitGame - (zBottomScale)) / zoomSpeed);
	zoomOver = 0;

	GameOptionSelected = 0;
	while(!exitGameMenu) {
		SetupMatrices();
		if(GUIState == 1 || GUIState == 2) {
			GameOptionInput();
			DrawGameOptionMenu();
		}
		if(GUIState == 4) {
			OptionVideoMenu();
		}
		if(GUIState == 5) {
			OptionSoundMenu();
		}
		if(GUIState == 8) {
			OptionVideoScaleMenu();
		}
		if(GUIState == 10) {
			OptionSaveStateMenu();
		}
		if(GUIState == 11) {
			OptionLoadStateMenu();
		}
		if(GUIState == 12) {
			GuideListMenu();
		}
		if(GUIState == 60) {
			OptionVideoMenu2();
		}
		updateEffect();
	}
	SetupMatricesEmulation();
	MakeVertexList();
	Device->SetTexture(0,TexScreen);
	g_Gamepads[DefaultController].Event = XBGAMEPAD_NONE;
	SetDelay();
}