#include <xtl.h>
#include <iostream>
#include <fstream>
#include <strstream>
#include <sstream>
#include <iomanip>
#include <string.h>
#include <cassert>
#include <sys/stat.h>
#include <sys/types.h>
#include <errno.h>
#include <vector>
#include <cstdlib>
#include <cwchar>
#include <cerrno>
#include <cstring>
#include <algorithm>
#include "GlobalExtern.h"
#include "..\core\api\NstApiEmulator.hpp"
#include "..\core\api\NstApiCheats.hpp"
#include "..\core\NstStream.hpp"
#include "..\core\NstXml.hpp"

using namespace std;

extern Emulator emulator;
extern char rootname[512];

bool operator<(const GameCheats &l, const GameCheats &r) {
	std::string a = l.game;
	std::string b = r.game;
	transform(a.begin(), a.end(), a.begin(), tolower);
	transform(b.begin(), b.end(), b.begin(), tolower);
	if(a < b) return true; else return false;
}

void PrintCheatAllGameList() {
	int count = 1;
	for(int i = 0; i < CheatGameList.size(); i++) {
		for(int j = 0; j < CheatGameList[i].cheatlist.size(); j++) {
			count++;
		}
	}
}

void PrintCheatGameList() {
	for(int i = 0; i < CheatGameList.size(); i++) {
		cout << CheatGameList[i].game.c_str() << endl;
	}
}

void EnableCheats(void) {
	Cheats cheats(emulator);

	cheats.ClearCodes();	

	for(int i = 0; i < CheatGameList.size(); i++) {
		if (CheatGameList[i].enabled) {
			for(int j = 0; j < CheatGameList[i].cheatlist.size(); j++) {
				if (CheatGameList[i].cheatlist[j].enabled) {
					cheats.SetCode(CheatGameList[i].cheatlist[j].code);
				}
			}
		}
	}
}

void DeleteCheats(void) {
	cheatlist.clear();
	CheatGameList.clear();
}

void AddCode(Cheats::Code &code, bool useenable, bool enable, char *description) {
	Cheats cheats(emulator);
	int clidx = cheatlist.size();
	NstCheatEntry newentry;

	newentry.code = code;
	newentry.crc = 0;
	newentry.description = description;

	if (useenable) {
		newentry.enabled = enable;
	}
	else {
		newentry.enabled = true;
	}

	if (cheats.GameGenieEncode(code, newentry.gg) != Nes::RESULT_OK)
	{
		strcpy(newentry.gg, "---");
	}

	// not all GG codes can be represented in PAR
	if (cheats.ProActionRockyEncode(code, newentry.par) != Nes::RESULT_OK)
	{
		strcpy(newentry.par, "---");
	}

	sprintf(newentry.raw, "%04x - %02x - %02x", code.address, code.value, code.compare);
	cheatlist.push_back(newentry);
}							    

bool SetupCheat(char* cheat) {
	Xml xml;
	Cheats cheats(emulator);
	char *filename = cheat;
	std::ifstream stream( filename, std::ifstream::in|std::ifstream::binary );

	if (stream.is_open()) {
		xml.Read( stream );

		if (xml.GetRoot().IsType( L"cheats" )) {
			for (Xml::Node node(xml.GetRoot().GetFirstChild()); node; node=node.GetNextSibling()) {
				if (!node.IsType( L"cheat" ))
					continue;
				Cheats::Code code;
				code.useCompare = false;

				if (const Xml::Node address=node.GetChild( L"address" )) {
					unsigned int v;

					if (0xFFFF < (v=address.GetUnsignedValue()))
						continue;
					code.address = v;

					if (const Xml::Node value=node.GetChild( L"value" )) {
						if (0xFF < (v=value.GetUnsignedValue()))
							continue;
						code.value = v;
					}

					if (const Xml::Node compare=node.GetChild( L"compare" )) {
						if (0xFF < (v=compare.GetUnsignedValue()))
							continue;
						code.compare = v;
						code.useCompare = true;
					}
				}
				else {
					char codestr[512];

					if (const Xml::Node genie=node.GetChild( L"genie" )) {
						wcstombs(codestr, genie.GetValue(), 511);
						if (cheats.GameGenieDecode(codestr, code) != Nes::RESULT_OK)
						{
							continue;
						}
					}
					else if (const Xml::Node rocky=node.GetChild( L"rocky" )) {
						wcstombs(codestr, rocky.GetValue(), 511);
						if (cheats.ProActionRockyDecode(codestr, code) != Nes::RESULT_OK)
						{
							continue;
						}
					}
					else {
						continue;
					}
				}

				if (node.GetChild( L"description" )) {
					char desc[1024];
					wcstombs(desc, node.GetChild( L"description" ).GetValue(), 1024);
					AddCode(code, true, node.GetAttribute( L"enabled" ).IsValue( L"0" ) ? false : true, desc);
				}
				else {
					AddCode(code, true, node.GetAttribute( L"enabled" ).IsValue( L"0" ) ? false : true, "No description found");
				}

				cheatlist[cheatlist.size()-1].crc = node.GetAttribute( L"game" ).GetUnsignedValue();
			}
			stream.close();
			return true;
		}
		else {
			stream.close();
			return false;
		}        
	}
	return true;
}

void BuildCheatGameList(std::string PathToSearch) {
	CheatGameListSelected = 0;
	CheatSelected = 0;
	CheatGameList.clear();
	std::string path1 = PathToSearch;
	std::string path2("*");
	std::string path = path1 + path2;
	HANDLE find=NULL;
	WIN32_FIND_DATA wfd;
	memset(&wfd,0,sizeof(wfd));
	find=FindFirstFile(path.c_str(),&wfd);
	int count = 1;
	if (find ==INVALID_HANDLE_VALUE){
		return;
	}

	do {
		if(!(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)) {
			std::string fileFound(wfd.cFileName);
			string file = path1 + fileFound;
			cheatlist.clear();
			if(SetupCheat((char*)file.c_str())) {
				GameCheats cheat;
				cheat.game = fileFound.substr(0, fileFound.size() - 4);               
				cheat.cheatlist = cheatlist;
				cheat.enabled = false;
				CheatGameList.push_back(cheat);
			}
		}
	} while (FindNextFile(find,&wfd) !=0);
	sort(CheatGameList.begin(), CheatGameList.end());
	for(int i = 0; i < CheatGameList.size(); i++) {
		CheatGameList[i].enabled = false;
		for(int j = 0; j < CheatGameList[i].cheatlist.size(); j++) {								
			CheatGameList[i].enabled = false;	
		}
	}
	CheatGameListSelected = 0;
	if(globalGameName.size() < 3) return;

	for(int i = 0; i < CheatGameList.size(); i++) {
		if((CheatGameList[i].game[0] == globalGameName[0]) && 
			CheatGameList[i].game[1] == globalGameName[1] &&
			CheatGameList[i].game[2] == globalGameName[2]) {
				CheatGameListSelected = i;
				break;
			}
	}
	if(CheatGameListSelected == 0) {
		for(int i = 0; i < CheatGameList.size(); i++) {
			if(CheatGameList[i].game[0] == globalGameName[0]) {
				CheatGameListSelected = i;
				break;
			}
		}
	}
}

extern int FontCheatText(WCHAR *text,int dx,int dy, int maxWidth);

void DrawCheatGameListMenu() {
	int y = 110;
	DWORD color;
	int start = 0;
	if(CheatGameListSelected > 7 && (CheatGameList.size() > 15)) {
		start += (CheatGameListSelected  - 7);
	}
	if((CheatGameListSelected > ((CheatGameList.size()-1) - 7)) && (CheatGameList.size() > 15)) {
		start = (CheatGameList.size() - 15);
	}

	for(int i = start; i <  start +15; i++) {
		if(i == CheatGameList.size()) return;
		if(CheatGameList[i].enabled) color = 0x00ff00; else color = 0xffffff; 
		if(i ==CheatGameListSelected) color = 0xffff00; 
		FontSetColour(color);
		FontCheatText(ConvertCharStringToWCHAR((char*)CheatGameList[i].game.c_str()), 640/2, y, sWidth);

		//FontCenteredText(ConvertCharStringToWCHAR((char*)CheatGameList[i].game.c_str()), sWidth/2, y, 600);
		y+=20;
	}
}

void DrawCheatGameListDetailMenu() {
	int y = 110;
	DWORD color;
	int start = 0;
	if(CheatSelected > 7 && (CheatGameList[CheatGameListSelected].cheatlist.size() > 15)) {
		start += (CheatSelected  - 7);
	}
	if((CheatSelected > ((CheatGameList[CheatGameListSelected].cheatlist.size()-1) - 7)) && (CheatGameList[CheatGameListSelected].cheatlist.size() > 15)) {
		start = (CheatGameList[CheatGameListSelected].cheatlist.size() - 15);
	}
	for(int i = start; i <  start +15; i++) {
		if(i == CheatGameList[CheatGameListSelected].cheatlist.size()) return;
		if(CheatGameList[CheatGameListSelected].cheatlist[i].enabled) color = 0x00ff00; else color = 0xffffff; 
		if(i ==CheatSelected) color = 0xffff00;

		FontSetColour(color);
		FontCheatText(ConvertCharStringToWCHAR((char*)CheatGameList[CheatGameListSelected].cheatlist[i].description.c_str()), 640/2, y, sWidth);
		y+=20;
	}
}