// DirectSound modul
#include <xtl.h>
#include <math.h>

// Sound is split into a series of 'segs', one seg for each frame
// The Loop buffer is a multiple of this seg length.
IDirectSound* pDS = NULL;			// DirectSound interface
static IDirectSoundBuffer* pdsbPrim = NULL;	// Primary buffer
static IDirectSoundBuffer* pdsbLoop = NULL;	// (Secondary) Loop buffer
static int cbLoopLen = 0;					// Loop length (in bytes) calculated
//int (*DSoundGetNextSound)(int);				// Callback used to request more sound
static int nDSoundFps;						// Application fps * 100
long nDSoundVol = 0;
int bAlwaysDrawFrames = 0;
int nAppVirtualFps = 6000;
int nAudSampleRate = 44100;			// sample rate
int nAudVolume = 10000;				// Sound volume (% * 100)
int nAudSegCount = 6;				// Segs in the pdsbLoop buffer
int nAudSegLen = 0;					// Seg length in samples (calculated from Rate/Fps)
unsigned char bAudOkay = 0;			// True if DSound was initted okay
unsigned char bAudPlaying = 0;		// True if the Loop buffer is playing
int nAudDSPModule = 0;				// DSP module to use: 0 = none, 1 = low-pass filter
short* nAudNextSound = NULL;		// The next sound seg we will add to the sample loop
unsigned int nAudSelect = 0;		// Which audio plugin is selected
int nBurnSoundRate = 0;				// sample rate of sound or zero for no sound
int nBurnSoundLen = 0;				// length in samples per frame
short* pBurnSoundOut = NULL;		// pointer to output buffer
static int nDSoundNextSeg = 0;										// We have filled the sound in the loop up to the beginning of 'nNextSeg'
extern int framerate;
extern int SurroundSound;
extern void* osd_malloc(int n);
//extern HWND g_main_window;

#define RELEASE(p)      { if(p) { (p)->Release(); (p)=NULL; } }
#define WRAP_INC(x) { x++; if (x >= nAudSegCount) x = 0; }

static int DSoundGetNextSoundFiller(int)							// int bDraw
{
	if (nAudNextSound == NULL) {
		return 1;
	}
	memset(nAudNextSound, 0, nAudSegLen << 2);						// Write silence into the buffer

	return 0;
}

static int DxSetCallback(int (*pCallback)(int))
{
	/*if (pCallback == NULL) {
		DSoundGetNextSound = DSoundGetNextSoundFiller;
	} else {
		DSoundGetNextSound = pCallback;
	}*/

	return 0;
}

static int DxBlankSound()
{
	void *pData = NULL, *pData2 = NULL;
	DWORD cbLen = 0, cbLen2 = 0;

	// Lock the Loop buffer
	if (FAILED(pdsbLoop->Lock(0, cbLoopLen, &pData, &cbLen, &pData2, &cbLen2, 0))) {
		return 1;
	}
	memset(pData, 0, cbLen);

	// Unlock (2nd 0 is because we wrote nothing to second part)
	pdsbLoop->Unlock(pData, cbLen, pData2, 0);

	// Also blank the nAudNextSound buffer
	if (nAudNextSound) {
		memset(nAudNextSound, 0, nAudSegLen << 2);
	}

	return 0;
}

extern void NesRun(bool sound);
extern short soundBuffer[0x8000];

void GetNextSound(int bDraw)  {
	
}

void DirectSoundInit() {
	DirectSoundCreate(NULL, &pDS, NULL);
}

// This function checks the DSound loop, and if necessary does a callback to update the emulation
int DxSoundCheck()
{
	int nPlaySeg = 0, nFollowingSeg = 0;
	DWORD nPlay = 0, nWrite = 0;

	if (pdsbLoop == NULL) {
		return 1;
	}

	// We should do nothing until nPlay has left nDSoundNextSeg
	pdsbLoop->GetCurrentPosition(&nPlay, &nWrite);

	nPlaySeg = nPlay / (nAudSegLen << 2);

	if (nPlaySeg > nAudSegCount -1 ) {
		nPlaySeg = nAudSegCount - 1;
	}
	if (nPlaySeg < 0) {												// important to ensure nPlaySeg clipped for below
		nPlaySeg = 0;
	}

	if (nDSoundNextSeg == nPlaySeg) {
		//Sleep(2);													// Don't need to do anything for a bit
		return 0;
	}

	// work out which seg we will fill next
	nFollowingSeg = nDSoundNextSeg;
	WRAP_INC(nFollowingSeg);

	while (nDSoundNextSeg != nPlaySeg) {
		void *pData = NULL, *pData2 = NULL;
		DWORD cbLen = 0, cbLen2 = 0;
		int bDraw;

		// fill nNextSeg

		nAudNextSound = &soundBuffer[0];

		// Lock the relevant seg of the loop buffer
		if (SUCCEEDED(pdsbLoop->Lock(nDSoundNextSeg * (nAudSegLen << 2), nAudSegLen << 2, &pData, &cbLen, &pData2, &cbLen2, 0))) {
			// Locked the segment, so write the sound we calculated last time
			memcpy(pData, nAudNextSound, nAudSegLen << 2);

			// Unlock (2nd 0 is because we wrote nothing to second part)
			pdsbLoop->Unlock(pData, cbLen, pData2, 0);
		}

		bDraw = (nFollowingSeg == nPlaySeg)	|| bAlwaysDrawFrames;	// If this is the last seg of sound, flag bDraw (to draw the graphics)

		//NesRun(bDraw);
		NesRun(bDraw);									// get more sound into nAudNextSound

		/*if (nAudDSPModule)	{
			DspDo(nAudNextSound, nAudSegLen);
		}*/

		nDSoundNextSeg = nFollowingSeg;
		WRAP_INC(nFollowingSeg);
	}

	return 0;
}

int DxSoundPlay()
{
	DxBlankSound();
	pdsbLoop->SetVolume(nDSoundVol);

	if (FAILED(pdsbLoop->Play(0, 0, DSBPLAY_LOOPING))) {
		return 1;
	}
	bAudPlaying = 1;

	return 0;
}

int DxSoundNESExit()
{
	/*if(nAudNextSound) {
		free(nAudNextSound);
		nAudNextSound = NULL;
	}*/

	//// Release the (Secondary) Loop Sound Buffer
	RELEASE(pdsbLoop);
	////// Release the Primary Sound Buffer
	RELEASE(pdsbPrim);
	return 0;
}

int DxSoundInit()
{
	int nRet = 0;
	DSBUFFERDESC dsbd;
	WAVEFORMATEX wfx;

	//if(!pDS) {
	//	if( FAILED( DirectSoundCreate( NULL, &pDS, NULL ) ) )
	//		return false;
	//}

	//dsound_caps.dwSize = sizeof(dsound_caps);
	//IDirectSound_GetCaps(m_pDSound, &dsound_caps);
	//pDS->SetCooperativeLevel(g_main_window, DSSCL_PRIORITY);
	//pDS->Initialize(NULL);


	if(framerate == 50)
		nAppVirtualFps = 5000;
	else 
		nAppVirtualFps = 6000;

	nDSoundFps = nAppVirtualFps;

	// Calculate the Seg Length and Loop length (round to nearest sample)
	nAudSegLen = (nAudSampleRate * 100 + (nDSoundFps >> 1)) / nDSoundFps;
	cbLoopLen = (nAudSegLen * nAudSegCount) << 2;
	//cbLoopLen *= 2;
	// Make the format of the sound
	memset(&wfx, 0, sizeof(wfx));
	wfx.cbSize = 0;
	wfx.wFormatTag = WAVE_FORMAT_PCM;
	wfx.nChannels = 2;										  // stereo
	wfx.nSamplesPerSec = nAudSampleRate;					  // sample rate
	wfx.wBitsPerSample = 16;								  // 16-bit
	wfx.nBlockAlign = 4;									  // bytes per sample
	wfx.nAvgBytesPerSec = wfx.nSamplesPerSec * wfx.nBlockAlign;

	// Make the primary sound buffer
	memset(&dsbd, 0, sizeof(DSBUFFERDESC));
	dsbd.dwSize = sizeof(DSBUFFERDESC);
	dsbd.dwBufferBytes = 1024*8;
	dsbd.lpwfxFormat = &wfx;

	//dsbd.dwFlags = DSBCAPS_PRIMARYBUFFER;
	if (FAILED(pDS->CreateSoundBuffer(&dsbd, &pdsbPrim, NULL))) {
		DxSoundNESExit();
		return 1;
	}

	// Make the loop sound buffer
	memset(&dsbd, 0, sizeof(DSBUFFERDESC));
	dsbd.dwSize = sizeof(DSBUFFERDESC);
	dsbd.dwBufferBytes = cbLoopLen;
	dsbd.lpwfxFormat = &wfx;								// Same format as the primary buffer
	if (FAILED(pDS->CreateSoundBuffer(&dsbd, &pdsbLoop, NULL))) {
		return 1;
	}
	
	if(SurroundSound) {
		DSMIXBINVOLUMEPAIR dsmbvp[8] = {
			{DSMIXBIN_FRONT_LEFT, DSBVOLUME_MAX},   // left channel
			{DSMIXBIN_FRONT_RIGHT, DSBVOLUME_MAX},  // right channel
			{DSMIXBIN_FRONT_CENTER, DSBVOLUME_MAX}, // left channel
			{DSMIXBIN_FRONT_CENTER, DSBVOLUME_MAX}, // right channel
			{DSMIXBIN_BACK_LEFT, DSBVOLUME_MAX},    // left channel
			{DSMIXBIN_BACK_RIGHT, DSBVOLUME_MAX},   // right channel
			{DSMIXBIN_LOW_FREQUENCY, DSBVOLUME_MAX},    // left channel
			{DSMIXBIN_LOW_FREQUENCY, DSBVOLUME_MAX}};   // right channel
			DSMIXBINS dsmb;
			dsmb.dwMixBinCount = 8;
			dsmb.lpMixBinVolumePairs = dsmbvp;
			pdsbLoop->SetMixBins(&dsmb);
	}
	DxSoundPlay();

		nAudNextSound = (short*)osd_malloc(nAudSegLen << 2);		// The next sound block to put in the stream
		if (nAudNextSound == NULL) {
			DxSoundNESExit();
			return 1;
		}

		DxSetCallback(NULL);

		return 0;
}

int DxSoundStop()
{
	/*bAudPlaying = 0;

	if (bAudOkay == 0) {
		return 1;
	}*/

	// Stop the looping buffer
	if(pdsbLoop)
		pdsbLoop->Stop();

	return 0;
}

void ResetSound() {
	DSBUFFERDESC dsbd;
	WAVEFORMATEX wfx;
	bAudPlaying = 0;
	if (pdsbLoop)
	{
		pdsbLoop->Stop();
		pdsbLoop->Release();
		pdsbLoop = NULL;
	}

	nAudSegLen = (nAudSampleRate * 100 + (nDSoundFps >> 1)) / nDSoundFps;
	cbLoopLen = (nAudSegLen * nAudSegCount) << 2;

	memset(&dsbd, 0, sizeof(DSBUFFERDESC));
	dsbd.dwSize = sizeof(DSBUFFERDESC);

	memset(&wfx, 0, sizeof(wfx));
	wfx.cbSize = 0;
	wfx.wFormatTag = WAVE_FORMAT_PCM;
	wfx.nChannels = 2;										  // stereo

	wfx.nSamplesPerSec = nAudSampleRate;
	wfx.wBitsPerSample = 16;								  // 16-bit
	wfx.nBlockAlign = 4;									  // bytes per sample
	wfx.nAvgBytesPerSec = wfx.nSamplesPerSec * wfx.nBlockAlign;

	dsbd.lpwfxFormat = &wfx;
	dsbd.dwBufferBytes = cbLoopLen;
	pDS->CreateSoundBuffer(&dsbd, &pdsbLoop, NULL);
	//free(nAudNextSound);
	nAudNextSound = (short*)realloc(nAudNextSound, nAudSegLen << 2);		// The next sound block to put in the stream
	DxSoundPlay();
	nBurnSoundRate = nAudSampleRate;
	nBurnSoundLen = nAudSegLen;
}

void DxSoundSetVolume()
{
	if (nDSoundVol < DSBVOLUME_MIN) {
		nDSoundVol = DSBVOLUME_MIN;
	}

	if (nDSoundVol > DSBVOLUME_MAX) {
		nDSoundVol = DSBVOLUME_MAX;
	}

	if (FAILED(pdsbLoop->SetVolume(nDSoundVol))) {
		return;
	}
}
