// Z80 (Zed Eight-Ty) Interface
#define EMU_DOZE // Use my 'Doze' Assembler Z80 emulator

#ifdef EMU_DOZE
#include "doze.h"
#endif

extern unsigned char (*ZetRead)(unsigned short a);         // Mem read
extern void (*ZetWrite)(unsigned short a,unsigned char d); // Mem Write
extern unsigned char (*ZetIn)(unsigned short a);           // Port read
extern void (*ZetOut)(unsigned short a,unsigned char d);   // Port Write

int ZetInit();
int ZetMemCallback(int nStart,int nEnd,int nMode);
int ZetMemEnd();
int ZetExit();
int ZetMapArea(int nStart, int nEnd, int nMode, unsigned char *Mem);
int ZetMapArea(int nStart, int nEnd, int nMode, unsigned char *Mem01, unsigned char *Mem02);
int ZetReset();
int ZetPc();
int ZetScan(int nAction);

#ifdef EMU_DOZE
extern int nDozeRunTotal; // While inside ZetRun(), the total cycles we should be doing
#endif

inline static int ZetMidCycles() // Cycles executed so far (valid during ZetRun only)
{
#ifdef EMU_DOZE
  return nDozeRunTotal-nDozeCycles;
#endif
}

inline static void ZetRaiseIrq(int nVal)
{
#ifdef EMU_DOZE
  nDozeInterrupt=nVal;
#endif
}

inline static void ZetLowerIrq()
{
#ifdef EMU_DOZE
  nDozeInterrupt=-1;
#endif
}

inline static void ZetNmi()
{
#ifdef EMU_DOZE
  DozeNmi();
#endif
}

inline static int ZetRun(int nCycles)
{
#ifdef EMU_DOZE
  int nDid=0;
  nDozeRunTotal=nCycles;
  nDozeCycles=nCycles;

  DozeRun(); nDid=ZetMidCycles();

  nDozeCycles=0;
  nDozeRunTotal=0;
  return nDid;
#endif
}
