// X-Men vs Street Fighter

#include "cps.h"

STDINPUTINFOSPEC(Drv, CpsFsi);

static int DrvInit()
{
  int nRet=0; int i=0; unsigned char *pqs=NULL;

  Cps=2;
  nCpsRomLen=  7*0x080000;
  nCpsCodeLen= 2*0x080000;
  nCpsGfxLen=  8*0x400000;
  nCpsZRomLen= 2*0x020000;
  nCpsQSamLen= 2*0x200000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  // Load program roms (as they are on the roms) for CpsRom
  for (i=0;i<7;i++)
  { nRet=BurnLoadRom(CpsRom+0x080000*i,2+i,1); if (nRet!=0) return 1; }

  // Make decrypted rom
  memcpy(CpsCode,CpsRom,nCpsCodeLen);
  nRet=BurnXorRom(CpsCode         ,0,1); if (nRet!=0) return 1;
  nRet=BurnXorRom(CpsCode+0x080000,1,1); if (nRet!=0) return 1;

  // Load graphics roms
  nRet=Cps2LoadTiles(CpsGfx           , 9);
  nRet=Cps2LoadTiles(CpsGfx+4*0x400000,13);

  // Load Z80 Roms
  nRet=BurnLoadRom(CpsZRom         ,17,1);
  nRet=BurnLoadRom(CpsZRom+ 0x20000,18,1);

  // Load Q Sample Roms
  pqs=(unsigned char *)CpsQSam;
  nRet=BurnLoadRom(pqs         ,19,1);
  nRet=BurnLoadRom(pqs+0x200000,20,1);
  BurnByteswap(pqs,nCpsQSamLen);

  nRet=CpsRunInit();

  if (nRet!=0) return 1;
  // Ready to go
  return 0;
}

static int DrvExit()
{


  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0;
  return 0;
}

//===============================
//X-Men Vs. Street Fighter (Euro)
//===============================


static struct BurnRomInfo XmvsfRomDesc[]=
{
  {"xvsex.03d",0x80000,0x3b3e7836, 0x10}, // xor decryption tables
  {"xvsex.04d",0x80000,0x108863ce, 0x10},

  {"xvse.03d" ,0x80000,0x5ae5bd3b, 0x10}, // 68000 code (encrypted)
  {"xvse.04d" ,0x80000,0x5eb9c02e, 0x10},
  {"xvs.05a"  ,0x80000,0x7db6025d, 0x10},
  {"xvs.06a"  ,0x80000,0xe8e2c75c, 0x10},
  {"xvs.07"   ,0x80000,0x08f0abed, 0x10},
  {"xvs.08"   ,0x80000,0x81929675, 0x10},
  {"xvs.09"   ,0x80000,0x9641f36b, 0x10},

  // graphics:
  {"xvs.13"  ,0x400000,0xf6684efd,    1}, //  9
  {"xvs.15"  ,0x400000,0x29109221,    1},
  {"xvs.17"  ,0x400000,0x92db3474,    1},
  {"xvs.19"  ,0x400000,0x3733473c,    1},
  {"xvs.14"  ,0x400000,0xbcac2e41,    1},
  {"xvs.16"  ,0x400000,0xea04a272,    1},
  {"xvs.18"  ,0x400000,0xb0def86a,    1},
  {"xvs.20"  ,0x400000,0x4b40ff9f,    1},

  // sound - z80 roms
  {"xvs.01"  ,0x020000,0x3999e93a,    2}, // 17
  {"xvs.02"  ,0x020000,0x101bdee9,    2},
  // sound - samples
  {"xvs.11"  ,0x200000,0x9cadcdbc,    2},
  {"xvs.12"  ,0x200000,0x7b11e460,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Xmvsf) STD_ROM_FN(Xmvsf)

struct BurnDriver BurnDrvCpsXmvsf=
{
  {"xmvsf" ,"X-Men Vs. Street Fighter (Euro 960910)","","Capcom","CPS2","1996",NULL, NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, XmvsfRomInfo, XmvsfRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//==============================
//X-Men Vs. Street Fighter (USA)
//==============================


static struct BurnRomInfo XmvsfuRomDesc[]=
{
  {"xvsux.03h",0x80000,0x1539c639, 0x10}, // xor decryption tables
  {"xvsux.04h",0x80000,0x68916b3f, 0x10},

  {"xvsu.03h" ,0x80000,0x5481155a, 0x10}, // 68000 code (encrypted)
  {"xvsu.04h" ,0x80000,0x1e236388, 0x10},
  {"xvs.05a"  ,0x80000,0x7db6025d, 0x10},
  {"xvs.06a"  ,0x80000,0xe8e2c75c, 0x10},
  {"xvs.07"   ,0x80000,0x08f0abed, 0x10},
  {"xvs.08"   ,0x80000,0x81929675, 0x10},
  {"xvs.09"   ,0x80000,0x9641f36b, 0x10},

  // graphics:
  {"xvs.13"  ,0x400000,0xf6684efd,    1}, //  9
  {"xvs.15"  ,0x400000,0x29109221,    1},
  {"xvs.17"  ,0x400000,0x92db3474,    1},
  {"xvs.19"  ,0x400000,0x3733473c,    1},
  {"xvs.14"  ,0x400000,0xbcac2e41,    1},
  {"xvs.16"  ,0x400000,0xea04a272,    1},
  {"xvs.18"  ,0x400000,0xb0def86a,    1},
  {"xvs.20"  ,0x400000,0x4b40ff9f,    1},

  // sound - z80 roms
  {"xvs.01"  ,0x020000,0x3999e93a,    2}, // 17
  {"xvs.02"  ,0x020000,0x101bdee9,    2},
  // sound - samples
  {"xvs.11"  ,0x200000,0x9cadcdbc,    2},
  {"xvs.12"  ,0x200000,0x7b11e460,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Xmvsfu) STD_ROM_FN(Xmvsfu)

struct BurnDriver BurnDrvCpsXmvsfu=
{
  {"xmvsfu" ,"X-Men Vs. Street Fighter (US 961004)","","Capcom","CPS2","1996","xmvsf", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, XmvsfuRomInfo, XmvsfuRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//================================
//X-Men Vs. Street Fighter (Japan)
//================================


static struct BurnRomInfo XmvsfjRomDesc[]=
{
  {"xvsjx.03d",0x80000,0x00000000, 0x10}, // xor decryption tables
  {"xvsjx.04d",0x80000,0x00000000, 0x10},

  {"xvsj.03d" ,0x80000,0xbeb81de9, 0x10}, // 68000 code (encrypted)
  {"xvsj.04d" ,0x80000,0x23d11271, 0x10},
  {"xvs.05a"  ,0x80000,0x7db6025d, 0x10},
  {"xvs.06a"  ,0x80000,0xe8e2c75c, 0x10},
  {"xvs.07"   ,0x80000,0x08f0abed, 0x10},
  {"xvs.08"   ,0x80000,0x81929675, 0x10},
  {"xvs.09"   ,0x80000,0x9641f36b, 0x10},

  // graphics:
  {"xvs.13"  ,0x400000,0xf6684efd,    1}, //  9
  {"xvs.15"  ,0x400000,0x29109221,    1},
  {"xvs.17"  ,0x400000,0x92db3474,    1},
  {"xvs.19"  ,0x400000,0x3733473c,    1},
  {"xvs.14"  ,0x400000,0xbcac2e41,    1},
  {"xvs.16"  ,0x400000,0xea04a272,    1},
  {"xvs.18"  ,0x400000,0xb0def86a,    1},
  {"xvs.20"  ,0x400000,0x4b40ff9f,    1},

  // sound - z80 roms
  {"xvs.01"  ,0x020000,0x3999e93a,    2}, // 17
  {"xvs.02"  ,0x020000,0x101bdee9,    2},
  // sound - samples
  {"xvs.11"  ,0x200000,0x9cadcdbc,    2},
  {"xvs.12"  ,0x200000,0x7b11e460,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Xmvsfj) STD_ROM_FN(Xmvsfj)

struct BurnDriverX BurnDrvCpsXmvsfj=
{
  {"xmvsfj" ,"X-Men Vs. Street Fighter (Japan 960910)","Encrypted","Capcom","CPS2","1996","xmvsf", NULL},
  0,2,HARDWARE_CAPCOM_CPS2,
  NULL, XmvsfjRomInfo, XmvsfjRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//===============================
//X-Men Vs. Street Fighter (Asia)
//===============================


static struct BurnRomInfo XmvsfaRomDesc[]=
{
  {"xvsax.03" ,0x80000,0x00000000, 0x10}, // xor decryption tables
  {"xvsax.04" ,0x80000,0x00000000, 0x10},

  {"xvsa.03"  ,0x80000,0xd0cca7a8, 0x10}, // 68000 code (encrypted)
  {"xvsa.04"  ,0x80000,0x8c8e76fd, 0x10},
  {"xvs.05a"  ,0x80000,0x7db6025d, 0x10},
  {"xvs.06a"  ,0x80000,0xe8e2c75c, 0x10},
  {"xvs.07"   ,0x80000,0x08f0abed, 0x10},
  {"xvs.08"   ,0x80000,0x81929675, 0x10},
  {"xvs.09"   ,0x80000,0x9641f36b, 0x10},

  // graphics:
  {"xvs.13"  ,0x400000,0xf6684efd,    1}, //  9
  {"xvs.15"  ,0x400000,0x29109221,    1},
  {"xvs.17"  ,0x400000,0x92db3474,    1},
  {"xvs.19"  ,0x400000,0x3733473c,    1},
  {"xvs.14"  ,0x400000,0xbcac2e41,    1},
  {"xvs.16"  ,0x400000,0xea04a272,    1},
  {"xvs.18"  ,0x400000,0xb0def86a,    1},
  {"xvs.20"  ,0x400000,0x4b40ff9f,    1},

  // sound - z80 roms
  {"xvs.01"  ,0x020000,0x3999e93a,    2}, // 17
  {"xvs.02"  ,0x020000,0x101bdee9,    2},
  // sound - samples
  {"xvs.11"  ,0x200000,0x9cadcdbc,    2},
  {"xvs.12"  ,0x200000,0x7b11e460,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Xmvsfa) STD_ROM_FN(Xmvsfa)

struct BurnDriverX BurnDrvCpsXmvsfa=
{
  {"xmvsfa" ,"X-Men Vs. Street Fighter (Asia 961023)","Encrypted","Capcom","CPS2","1996","xmvsf", NULL},
  0,2,HARDWARE_CAPCOM_CPS2,
  NULL, XmvsfaRomInfo, XmvsfaRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//===================================
//X-Men Vs. Street Fighter (Hispanic)
//===================================


static struct BurnRomInfo XmvsfhRomDesc[]=
{
  {"xvshx.03a",0x80000,0x00000000, 0x10}, // xor decryption tables
  {"xvshx.04a",0x80000,0x00000000, 0x10},

  {"xvsh.03a" ,0x80000,0xd4fffb04, 0x10}, // 68000 code (encrypted)
  {"xvsh.04a" ,0x80000,0x1b4ea638, 0x10},
  {"xvs.05a"  ,0x80000,0x7db6025d, 0x10},
  {"xvs.06a"  ,0x80000,0xe8e2c75c, 0x10},
  {"xvs.07"   ,0x80000,0x08f0abed, 0x10},
  {"xvs.08"   ,0x80000,0x81929675, 0x10},
  {"xvs.09"   ,0x80000,0x9641f36b, 0x10},

  // graphics:
  {"xvs.13"  ,0x400000,0xf6684efd,    1}, //  9
  {"xvs.15"  ,0x400000,0x29109221,    1},
  {"xvs.17"  ,0x400000,0x92db3474,    1},
  {"xvs.19"  ,0x400000,0x3733473c,    1},
  {"xvs.14"  ,0x400000,0xbcac2e41,    1},
  {"xvs.16"  ,0x400000,0xea04a272,    1},
  {"xvs.18"  ,0x400000,0xb0def86a,    1},
  {"xvs.20"  ,0x400000,0x4b40ff9f,    1},

  // sound - z80 roms
  {"xvs.01"  ,0x020000,0x3999e93a,    2}, // 17
  {"xvs.02"  ,0x020000,0x101bdee9,    2},
  // sound - samples
  {"xvs.11"  ,0x200000,0x9cadcdbc,    2},
  {"xvs.12"  ,0x200000,0x7b11e460,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Xmvsfh) STD_ROM_FN(Xmvsfh)

struct BurnDriverX BurnDrvCpsXmvsfh=
{
  {"xmvsfh" ,"X-Men Vs. Street Fighter (Hispanic 961004)","Encrypted","Capcom","CPS2","1996","xmvsf", NULL},
  0,2,HARDWARE_CAPCOM_CPS2,
  NULL, XmvsfhRomInfo, XmvsfhRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
