// X-Men: Children of the Atom

#include "cps.h"

STDINPUTINFOSPEC(Drv, CpsFsi);


static int DrvInit()
{
  int nRet=0; int i=0; unsigned char *pqs=NULL;

  Cps=2; Xmcota=1;
  nCpsRomLen=  8*0x080000;
  nCpsCodeLen= 2*0x080000;
  nCpsGfxLen=  8*0x400000;
  nCpsZRomLen= 2*0x020000;
  nCpsQSamLen= 2*0x200000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  // Load program roms (as they are on the roms) for CpsRom
  for (i=0;i<8;i++)
  { nRet=BurnLoadRom(CpsRom+0x080000*i,2+i,1); if (nRet!=0) return 1; }

  // Make decrypted rom
  memcpy(CpsCode,CpsRom,nCpsCodeLen);
  nRet=BurnXorRom(CpsCode         ,0,1); if (nRet!=0) return 1;
  nRet=BurnXorRom(CpsCode+0x080000,1,1); if (nRet!=0) return 1;

  // Load graphics roms
  nRet=Cps2LoadTiles(CpsGfx           ,10);
  nRet=Cps2LoadTiles(CpsGfx+4*0x400000,14);

  // Load Z80 Roms
  nRet=BurnLoadRom(CpsZRom         ,18,1);
  nRet=BurnLoadRom(CpsZRom+ 0x20000,19,1);

  // Load Q Sample Roms
  pqs=(unsigned char *)CpsQSam;
  nRet=BurnLoadRom(pqs         ,20,1);
  nRet=BurnLoadRom(pqs+0x200000,21,1);
  BurnByteswap(pqs,nCpsQSamLen);


  nRet=CpsRunInit(); if (nRet!=0) return 1;
  // Ready to go
  return 0;
}

static int DrvExit()
{

  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0; Xmcota=0;
  return 0;
}

//========================================
//X-Men: Children of the Atom (Euro v3.00)
//========================================


static struct BurnRomInfo XmcotaRomDesc[]=
{
  {"xmnex.03e",0x80000,0x2f5daa9f, 0x10}, // xor decryption table
  {"xmnex.04e",0x80000,0xf0e24605, 0x10}, // xor decryption table

  {"xmne.03e" ,0x80000,0xa9a09b09, 0x10}, // 68000 code (encrypted)
  {"xmne.04e" ,0x80000,0x52fa2106, 0x10},
  {"xmn.05a"  ,0x80000,0xac0d7759, 0x10},
  {"xmn.06a"  ,0x80000,0x1b86a328, 0x10},
  {"xmn.07a"  ,0x80000,0x2c142a44, 0x10},
  {"xmn.08a"  ,0x80000,0xf712d44f, 0x10},
  {"xmn.09a"  ,0x80000,0x9241cae8, 0x10},
  {"xmn.10a"  ,0x80000,0x53c0eab9, 0x10},
// 10
  {"xmn.13"  ,0x400000,0xbf4df073,    1},
  {"xmn.15"  ,0x400000,0x4d7e4cef,    1},
  {"xmn.17"  ,0x400000,0x513eea17,    1},
  {"xmn.19"  ,0x400000,0xd23897fc,    1},
  {"xmn.14"  ,0x400000,0x778237b7,    1},
  {"xmn.16"  ,0x400000,0x67b36948,    1},
  {"xmn.18"  ,0x400000,0x015a7c4c,    1},
  {"xmn.20"  ,0x400000,0x9dde2758,    1},
// 18
  {"xmn.01a" ,0x020000,0x40f479ea,    2},
  {"xmn.02a" ,0x020000,0x39d9b5ad,    2},
  // sound - samples
  {"xmn.11"  ,0x200000,0xc848a6bc,    2},
  {"xmn.12"  ,0x200000,0x729c188f,    2},
};

STD_ROM_PICK(Xmcota) STD_ROM_FN(Xmcota)

struct BurnDriver BurnDrvCpsXmcota=
{
  {"xmcota" ,"X-Men: Children of the Atom (Euro 950105)","","Capcom","CPS2","1995",NULL, NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, XmcotaRomInfo, XmcotaRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//=======================================
//X-Men: Children of the Atom (USA v3.00)
//=======================================


static struct BurnRomInfo XmcotauRomDesc[]=
{
  {"xmnux.03e",0x80000,0x27636ac7, 0x10}, // xor decryption table
  {"xmnux.04e",0x80000,0x0aed300c, 0x10}, // xor decryption table

  {"xmnu.03e" ,0x80000,0x0bafeb0e, 0x10}, // 68000 code (encrypted)
  {"xmnu.04e" ,0x80000,0xc29bdae3, 0x10},
  {"xmn.05a"  ,0x80000,0xac0d7759, 0x10},
  {"xmn.06a"  ,0x80000,0x1b86a328, 0x10},
  {"xmn.07a"  ,0x80000,0x2c142a44, 0x10},
  {"xmn.08a"  ,0x80000,0xf712d44f, 0x10},
  {"xmn.09a"  ,0x80000,0x9241cae8, 0x10},
  {"xmn.10a"  ,0x80000,0x53c0eab9, 0x10},
// 10
  {"xmn.13"  ,0x400000,0xbf4df073,    1},
  {"xmn.15"  ,0x400000,0x4d7e4cef,    1},
  {"xmn.17"  ,0x400000,0x513eea17,    1},
  {"xmn.19"  ,0x400000,0xd23897fc,    1},
  {"xmn.14"  ,0x400000,0x778237b7,    1},
  {"xmn.16"  ,0x400000,0x67b36948,    1},
  {"xmn.18"  ,0x400000,0x015a7c4c,    1},
  {"xmn.20"  ,0x400000,0x9dde2758,    1},
// 18
  {"xmn.01a" ,0x020000,0x40f479ea,    2},
  {"xmn.02a" ,0x020000,0x39d9b5ad,    2},
  // sound - samples
  {"xmn.11"  ,0x200000,0xc848a6bc,    2},
  {"xmn.12"  ,0x200000,0x729c188f,    2},
};

STD_ROM_PICK(Xmcotau) STD_ROM_FN(Xmcotau)

struct BurnDriver BurnDrvCpsXmcotau=
{
  {"xmcotau" ,"X-Men: Children of the Atom (US 950105)","","Capcom","CPS2","1995","xmcota", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, XmcotauRomInfo, XmcotauRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//=========================================
//X-Men: Children of the Atom (Japan v2.10)
//=========================================


static struct BurnRomInfo XmcotajRomDesc[]=
{
  {"xmnjx.03b",0x80000,0x523c9589, 0x10},
  {"xmnjx.04b",0x80000,0x673765ba, 0x10},

  {"xmnj.03b" ,0x80000,0xc8175fb3, 0x10},
  {"xmnj.04b" ,0x80000,0x54b3fba3, 0x10},
  {"xmn.05"   ,0x80000,0xc3ed62a2, 0x10},
  {"xmn.06"   ,0x80000,0xf03c52e1, 0x10},
  {"xmn.07"   ,0x80000,0x325626b1, 0x10},
  {"xmn.08"   ,0x80000,0x7194ea10, 0x10},
  {"xmn.09"   ,0x80000,0xae946df3, 0x10},
  {"xmn.10"   ,0x80000,0x32a6be1d, 0x10},

  {"xmn.13"  ,0x400000,0xbf4df073,    1},
  {"xmn.15"  ,0x400000,0x4d7e4cef,    1},
  {"xmn.17"  ,0x400000,0x513eea17,    1},
  {"xmn.19"  ,0x400000,0xd23897fc,    1},
  {"xmn.14"  ,0x400000,0x778237b7,    1},
  {"xmn.16"  ,0x400000,0x67b36948,    1},
  {"xmn.18"  ,0x400000,0x015a7c4c,    1},
  {"xmn.20"  ,0x400000,0x9dde2758,    1},

  {"xmn.01a" ,0x020000,0x40f479ea,    2},
  {"xmn.02a" ,0x020000,0x39d9b5ad,    2},

  {"xmn.11"  ,0x200000,0xc848a6bc,    2},
  {"xmn.12"  ,0x200000,0x729c188f,    2},
};

STD_ROM_PICK(Xmcotaj) STD_ROM_FN(Xmcotaj)

struct BurnDriver BurnDrvCpsXmcotaj=
{
  {"xmcotaj" ,"X-Men: Children of the Atom (Japan 941219)","","Capcom","CPS2","1994","xmcota", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, XmcotajRomInfo, XmcotajRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//============================================
//X-Men: Children of the Atom (Japan r1 v2.00)
//============================================


static struct BurnRomInfo Xmcotaj1RomDesc[]=
{
  {"xmnjx.03a",0x80000,0x515b9bf9, 0x10},
  {"xmnjx.04a",0x80000,0x5419572b, 0x10},

  {"xmnj.03a" ,0x80000,0x00761611, 0x10},
  {"xmnj.04a" ,0x80000,0x614d3f60, 0x10},
  {"xmn.05"   ,0x80000,0xc3ed62a2, 0x10},
  {"xmn.06"   ,0x80000,0xf03c52e1, 0x10},
  {"xmn.07"   ,0x80000,0x325626b1, 0x10},
  {"xmn.08"   ,0x80000,0x7194ea10, 0x10},
  {"xmn.09"   ,0x80000,0xae946df3, 0x10},
  {"xmn.10"   ,0x80000,0x32a6be1d, 0x10},

// 10
  // graphics:
  {"xmn.13"  ,0x400000,0xbf4df073,    1},
  {"xmn.15"  ,0x400000,0x4d7e4cef,    1},
  {"xmn.17"  ,0x400000,0x513eea17,    1},
  {"xmn.19"  ,0x400000,0xd23897fc,    1},
  {"xmn.14"  ,0x400000,0x778237b7,    1},
  {"xmn.16"  ,0x400000,0x67b36948,    1},
  {"xmn.18"  ,0x400000,0x015a7c4c,    1},
  {"xmn.20"  ,0x400000,0x9dde2758,    1},

// 18
  // sound - z80 roms
  {"xmn.01a" ,0x020000,0x40f479ea,    2},
  {"xmn.02a" ,0x020000,0x39d9b5ad,    2},
  // sound - samples
  {"xmn.11"  ,0x200000,0xc848a6bc,    2},
  {"xmn.12"  ,0x200000,0x729c188f,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Xmcotaj1) STD_ROM_FN(Xmcotaj1)

struct BurnDriver BurnDrvCpsXmcotaj1=
{
  {"xmcotaj1" ,"X-Men: Children of the Atom (Japan 941217)","","Capcom","CPS2","1994","xmcota", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Xmcotaj1RomInfo, Xmcotaj1RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//==============================================
//X-Men: Children of the Atom (Japan rent v1.00)
//==============================================


static struct BurnRomInfo XmcotajrRomDesc[]=
{
  {"xmnox.03a",0x80000,0xc2d26e40, 0x10},
  {"xmnox.04a",0x80000,0x9fb6b396, 0x10},

  {"xmno.03a"  ,0x80000,0x7ab19acf, 0x10},
  {"xmno.04a"  ,0x80000,0x7615dd21, 0x10},
  {"xmno.05a"  ,0x80000,0x0303d672, 0x10},
  {"xmno.06a"  ,0x80000,0x332839a5, 0x10},
  {"xmno.07"   ,0x80000,0x6255e8d5, 0x10},
  {"xmno.08"   ,0x80000,0xb8ebe77c, 0x10},
  {"xmno.09"   ,0x80000,0x5440d950, 0x10},
  {"xmno.10a"  ,0x80000,0xb8296966, 0x10},

// 10
  // graphics:
  {"xmn.13"  ,0x400000,0xbf4df073,    1},
  {"xmn.15"  ,0x400000,0x4d7e4cef,    1},
  {"xmn.17"  ,0x400000,0x513eea17,    1},
  {"xmn.19"  ,0x400000,0xd23897fc,    1},
  {"xmn.14"  ,0x400000,0x778237b7,    1},
  {"xmn.16"  ,0x400000,0x67b36948,    1},
  {"xmn.18"  ,0x400000,0x015a7c4c,    1},
  {"xmn.20"  ,0x400000,0x9dde2758,    1},

// 18
  // sound - z80 roms
  {"xmn.01" ,0x020000,0x7178336e,    2},
  {"xmn.02" ,0x020000,0x0ec58501,    2},
  // sound - samples
  {"xmn.11"  ,0x200000,0xc848a6bc,    2},
  {"xmn.12"  ,0x200000,0x729c188f,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Xmcotajr) STD_ROM_FN(Xmcotajr)

struct BurnDriver BurnDrvCpsXmcotajr=
{
  {"xmcotajr" ,"X-Men: Children of the Atom (Japan 941208 rent version)","","Capcom","CPS2","1994","xmcota", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, XmcotajrRomInfo, XmcotajrRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//===========================================
//X-Men: Children of the Atom (Hispanic v???)
//===========================================


static struct BurnRomInfo XmcotahRomDesc[]=
{
  {"xmnhx.03" ,0x80000,0x00000000, 0x10}, // xor decryption table
  {"xmnhx.04" ,0x80000,0x00000000, 0x10}, // xor decryption table

  {"xmnh.03"  ,0x80000,0xe4b85a90, 0x10}, // 68000 code (encrypted)
  {"xmnh.04"  ,0x80000,0x7dfe1406, 0x10},
  {"xmnh.05"  ,0x80000,0x87b0ed0f, 0x10},
  {"xmn.06a"  ,0x80000,0x1b86a328, 0x10},
  {"xmn.07a"  ,0x80000,0x2c142a44, 0x10},
  {"xmn.08a"  ,0x80000,0xf712d44f, 0x10},
  {"xmn.09a"  ,0x80000,0x9241cae8, 0x10},
  {"xmnh.10"  ,0x80000,0xcb36b0a4, 0x10},
// 10
  {"xmn.13"  ,0x400000,0xbf4df073,    1},
  {"xmn.15"  ,0x400000,0x4d7e4cef,    1},
  {"xmn.17"  ,0x400000,0x513eea17,    1},
  {"xmn.19"  ,0x400000,0xd23897fc,    1},
  {"xmn.14"  ,0x400000,0x778237b7,    1},
  {"xmn.16"  ,0x400000,0x67b36948,    1},
  {"xmn.18"  ,0x400000,0x015a7c4c,    1},
  {"xmn.20"  ,0x400000,0x9dde2758,    1},
// 18
  {"xmn.01a" ,0x020000,0x40f479ea,    2},
  {"xmn.02a" ,0x020000,0x39d9b5ad,    2},
  // sound - samples
  {"xmn.11"  ,0x200000,0xc848a6bc,    2},
  {"xmn.12"  ,0x200000,0x729c188f,    2},
};

STD_ROM_PICK(Xmcotah) STD_ROM_FN(Xmcotah)

struct BurnDriverX BurnDrvCpsXmcotah=
{
  {"xmcotah" ,"X-Men: Children of the Atom (Hispanic 950331)","Encrypted","Capcom","CPS2","1995","xmcota", NULL},
  0,2,HARDWARE_CAPCOM_CPS2,
  NULL, XmcotahRomInfo, XmcotahRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//=======================================
//X-Men: Children of the Atom (Asia v???)
//=======================================


static struct BurnRomInfo XmcotaaRomDesc[]=
{
  {"xmnax.03a",0x80000,0x978a0de4, 0x10}, // xor decryption table
  {"xmnax.04a",0x80000,0x07cb0839, 0x10}, // xor decryption table

  {"xmna.03a" ,0x80000,0x7df8b27e, 0x10}, // 68000 code (encrypted)
  {"xmna.04a" ,0x80000,0xb44e30a7, 0x10},
  {"xmn.05"   ,0x80000,0xc3ed62a2, 0x10},
  {"xmn.06"   ,0x80000,0xf03c52e1, 0x10},
  {"xmn.07"   ,0x80000,0x325626b1, 0x10},
  {"xmn.08"   ,0x80000,0x7194ea10, 0x10},
  {"xmn.09"   ,0x80000,0xae946df3, 0x10},
  {"xmn.10"   ,0x80000,0x32a6be1d, 0x10},
// 10
  {"xmn.13"  ,0x400000,0xbf4df073,    1},
  {"xmn.15"  ,0x400000,0x4d7e4cef,    1},
  {"xmn.17"  ,0x400000,0x513eea17,    1},
  {"xmn.19"  ,0x400000,0xd23897fc,    1},
  {"xmn.14"  ,0x400000,0x778237b7,    1},
  {"xmn.16"  ,0x400000,0x67b36948,    1},
  {"xmn.18"  ,0x400000,0x015a7c4c,    1},
  {"xmn.20"  ,0x400000,0x9dde2758,    1},
// 18
  {"xmn.01a" ,0x020000,0x40f479ea,    2},
  {"xmn.02a" ,0x020000,0x39d9b5ad,    2},
  // sound - samples
  {"xmn.11"  ,0x200000,0xc848a6bc,    2},
  {"xmn.12"  ,0x200000,0x729c188f,    2},
};

STD_ROM_PICK(Xmcotaa) STD_ROM_FN(Xmcotaa)

struct BurnDriver BurnDrvCpsXmcotaa=
{
  {"xmcotaa" ,"X-Men: Children of the Atom (Asia 941217)","","Capcom","CPS2","1995","xmcota", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, XmcotaaRomInfo, XmcotaaRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
