// Super Street Fighter 2 Turbo

#include "cps.h"

STDINPUTINFOSPEC(Drv, CpsFsi);

static int DrvInit()
{
  int nRet=0; int i=0; unsigned char *pqs=NULL;

  Cps=2; Ssf2t=1;
  nCpsRomLen=  7*0x080000;
  nCpsCodeLen= 6*0x080000;
  nCpsGfxLen=   0x1000000;
  nCpsZRomLen= 2*0x020000;
  nCpsQSamLen= 2*0x200000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  // Load program roms (as they are on the roms) for CpsRom
  for (i=0;i<7;i++)
  { nRet=BurnLoadRom(CpsRom+0x080000*i,6+i,1); if (nRet!=0) return 1; }

  // Make decrypted rom
  memcpy(CpsCode,CpsRom,nCpsCodeLen);
  for (i=0;i<6;i++)
  { nRet=BurnXorRom(CpsCode+i*0x080000,i,1); if (nRet!=0) return 1; }

  // Load graphics roms
  nRet=Cps2LoadTiles(CpsGfx         ,13);
  nRet=Cps2LoadTiles(CpsGfx+0x800000,17);
  nRet=Cps2LoadTiles(CpsGfx+0xc00000,21);

  nCpsGfxScroll[3]=0;

  // Load Z80 Roms
  nRet=BurnLoadRom(CpsZRom         ,25,1);
  nRet=BurnLoadRom(CpsZRom+ 0x20000,26,1);

  // Load Q Sample Roms
  pqs=(unsigned char *)CpsQSam;
  nRet=BurnLoadRom(pqs         ,27,1);
  nRet=BurnLoadRom(pqs+0x200000,28,1);
  BurnByteswap(pqs,nCpsQSamLen);

  nRet=CpsRunInit();

  if (nRet!=0) return 1;
  // Ready to go
  return 0;
}

static int DrvExit()
{

  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0; Ssf2t=0;
  return 0;
}

//====================================
//Super Street Fighter 2 Turbo (World)
//====================================


static struct BurnRomInfo Ssf2tRomDesc[]=
{
  {"sfxex.03c",0x80000,0xa181b207, 0x10}, // 0, xor decryption table
  {"sfxex.04a",0x80000,0xdf28bd00, 0x10},
  {"sfxex.05" ,0x80000,0x29b7bda4, 0x10},
  {"sfxex.06a",0x80000,0x6c8719b3, 0x10},
  {"sfxex.07" ,0x80000,0xdfc3b3cd, 0x10},
  {"sfxex.08" ,0x80000,0xd7436ae9, 0x10},

  {"sfxe.03c" ,0x80000,0x2fa1f396, 0x10}, // 6, 68000 code (encrypted)
  {"sfxe.04a" ,0x80000,0xd0bc29c6, 0x10},
  {"sfxe.05"  ,0x80000,0x65222964, 0x10},
  {"sfxe.06a" ,0x80000,0x8fe9f531, 0x10},
  {"sfxe.07"  ,0x80000,0x8a7d0cb6, 0x10},
  {"sfxe.08"  ,0x80000,0x74c24062, 0x10},
  {"sfx.09"   ,0x80000,0x642fae3f, 0x10},

  // graphics:
  {"ssf.13"  ,0x200000,0xcf94d275,    1}, // 13
  {"ssf.15"  ,0x200000,0x5eb703af,    1},
  {"ssf.17"  ,0x200000,0xffa60e0f,    1},
  {"ssf.19"  ,0x200000,0x34e825c5,    1},
  {"ssf.14"  ,0x100000,0xb7cc32e7,    1},
  {"ssf.16"  ,0x100000,0x8376ad18,    1},
  {"ssf.18"  ,0x100000,0xf5b1b336,    1},
  {"ssf.20"  ,0x100000,0x459d5c6b,    1},
  {"sfx.21"  ,0x100000,0xe32854af,    1},
  {"sfx.23"  ,0x100000,0x760f2927,    1},
  {"sfx.25"  ,0x100000,0x1ee90208,    1},
  {"sfx.27"  ,0x100000,0xf814400f,    1},

  // sound - z80 roms
  {"sfx.01"  ,0x020000,0xb47b8835,    2}, // 25
  {"sfx.02"  ,0x020000,0x0022633f,    2},
  // sound - samples
  {"sfx.11"  ,0x200000,0x9bdbd476,    2},
  {"sfx.12"  ,0x200000,0xa05e3aab,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Ssf2t) STD_ROM_FN(Ssf2t)

struct BurnDriver BurnDrvCpsSsf2t=
{
  {"ssf2t" ,"Super Street Fighter 2 Turbo (World 940223)","","Capcom","CPS2","1994","ssf2", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Ssf2tRomInfo, Ssf2tRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//===================================
//Super Street Fighter 2 Turbo (Asia)
//===================================


static struct BurnRomInfo Ssf2taRomDesc[]=
{
  {"sfxax.03c",0x80000,0xc8a664fa, 0x10}, // 0, xor decryption table
  {"sfxax.04a",0x80000,0x149d6352, 0x10},
  {"sfxax.05" ,0x80000,0xac169aa9, 0x10},
  {"sfxax.06a",0x80000,0xbb60394c, 0x10},
  {"sfxax.07" ,0x80000,0xe62b1b69, 0x10},
  {"sfxax.08" ,0x80000,0x7c5fd202, 0x10},

  {"sfxa.03c" ,0x80000,0x04b9ff34, 0x10}, // 6, 68000 code (encrypted)
  {"sfxa.04a" ,0x80000,0x16ea5f7a, 0x10},
  {"sfxa.05"  ,0x80000,0x53d61f0c, 0x10},
  {"sfxa.06a" ,0x80000,0x066d09b5, 0x10},
  {"sfxa.07"  ,0x80000,0xa428257b, 0x10},
  {"sfxa.08"  ,0x80000,0x39be596c, 0x10},
  {"sfx.09"   ,0x80000,0x642fae3f, 0x10},

  // graphics:
  {"ssf.13"  ,0x200000,0xcf94d275,    1}, // 13
  {"ssf.15"  ,0x200000,0x5eb703af,    1},
  {"ssf.17"  ,0x200000,0xffa60e0f,    1},
  {"ssf.19"  ,0x200000,0x34e825c5,    1},
  {"ssf.14"  ,0x100000,0xb7cc32e7,    1},
  {"ssf.16"  ,0x100000,0x8376ad18,    1},
  {"ssf.18"  ,0x100000,0xf5b1b336,    1},
  {"ssf.20"  ,0x100000,0x459d5c6b,    1},
  {"sfx.21"  ,0x100000,0xe32854af,    1},
  {"sfx.23"  ,0x100000,0x760f2927,    1},
  {"sfx.25"  ,0x100000,0x1ee90208,    1},
  {"sfx.27"  ,0x100000,0xf814400f,    1},

  // sound - z80 roms
  {"sfx.01"  ,0x020000,0xb47b8835,    2}, // 25
  {"sfx.02"  ,0x020000,0x0022633f,    2},
  // sound - samples
  {"sfx.11"  ,0x200000,0x9bdbd476,    2},
  {"sfx.12"  ,0x200000,0xa05e3aab,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Ssf2ta) STD_ROM_FN(Ssf2ta)

struct BurnDriver BurnDrvCpsSsf2ta=
{
  {"ssf2ta" ,"Super Street Fighter 2 Turbo (Asia 940223)","","Capcom","CPS2","1994","ssf2", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Ssf2taRomInfo, Ssf2taRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//==================================
//Super Street Fighter 2 Turbo (USA)
//==================================


static struct BurnRomInfo Ssf2tuRomDesc[]=
{
  {"sfxux.03c",0x80000,0x441df197, 0x10}, // 0, xor decryption table
  {"sfxux.04a",0x80000,0x7390df1b, 0x10},
  {"sfxux.05" ,0x80000,0x1d3310a0, 0x10},
  {"sfxux.06a",0x80000,0x6fc5efa6, 0x10},
  {"sfxux.07" ,0x80000,0x88455606, 0x10},
  {"sfxux.08" ,0x80000,0xfa2396a6, 0x10},

  {"sfxu.03c" ,0x80000,0x86e4a335, 0x10}, // 6, 68000 code (encrypted)
  {"sfxu.04a" ,0x80000,0x532b5ffd, 0x10},
  {"sfxu.05"  ,0x80000,0xffa3c6de, 0x10},
  {"sfxu.06a" ,0x80000,0xe4c04c99, 0x10},
  {"sfxu.07"  ,0x80000,0xd8199e41, 0x10},
  {"sfxu.08"  ,0x80000,0xb3c71810, 0x10},
  {"sfx.09"   ,0x80000,0x642fae3f, 0x10},

  // graphics:
  {"ssf.13"  ,0x200000,0xcf94d275,    1}, // 13
  {"ssf.15"  ,0x200000,0x5eb703af,    1},
  {"ssf.17"  ,0x200000,0xffa60e0f,    1},
  {"ssf.19"  ,0x200000,0x34e825c5,    1},
  {"ssf.14"  ,0x100000,0xb7cc32e7,    1},
  {"ssf.16"  ,0x100000,0x8376ad18,    1},
  {"ssf.18"  ,0x100000,0xf5b1b336,    1},
  {"ssf.20"  ,0x100000,0x459d5c6b,    1},
  {"sfx.21"  ,0x100000,0xe32854af,    1},
  {"sfx.23"  ,0x100000,0x760f2927,    1},
  {"sfx.25"  ,0x100000,0x1ee90208,    1},
  {"sfx.27"  ,0x100000,0xf814400f,    1},

  // sound - z80 roms
  {"sfx.01"  ,0x020000,0xb47b8835,    2}, // 25
  {"sfx.02"  ,0x020000,0x0022633f,    2},
  // sound - samples
  {"sfx.11"  ,0x200000,0x9bdbd476,    2},
  {"sfx.12"  ,0x200000,0xa05e3aab,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Ssf2tu) STD_ROM_FN(Ssf2tu)

struct BurnDriver BurnDrvCpsSsf2tu=
{
  {"ssf2tu" ,"Super Street Fighter 2 Turbo (US 940223)","","Capcom","CPS2","1994","ssf2", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Ssf2tuRomInfo, Ssf2tuRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//================================
//Super Street Fighter 2 X (Japan)
//================================


static struct BurnRomInfo Ssf2xjRomDesc[]=
{
  {"sfxjx.03c",0x80000,0x084e929f, 0x10}, // 0, xor decryption table
  {"sfxjx.04a",0x80000,0x9ea7a7c0, 0x10},
  {"sfxjx.05" ,0x80000,0x46184b32, 0x10},
  {"sfxjx.06a",0x80000,0x9877b7a4, 0x10},
  {"sfxjx.07" ,0x80000,0xeb8c5317, 0x10},
  {"sfxjx.08" ,0x80000,0x656a9858, 0x10},

  {"sfxj.03c" ,0x80000,0xa7417b79, 0x10}, // 6, 68000 code (encrypted)
  {"sfxj.04a" ,0x80000,0xaf7767b4, 0x10},
  {"sfxj.05"  ,0x80000,0xf4ff18f5, 0x10},
  {"sfxj.06a" ,0x80000,0x260d0370, 0x10},
  {"sfxj.07"  ,0x80000,0x1324d02a, 0x10},
  {"sfxj.08"  ,0x80000,0x2de76f10, 0x10},
  {"sfx.09"   ,0x80000,0x642fae3f, 0x10},

  // graphics:
  {"ssf.13"  ,0x200000,0xcf94d275,    1}, // 13
  {"ssf.15"  ,0x200000,0x5eb703af,    1},
  {"ssf.17"  ,0x200000,0xffa60e0f,    1},
  {"ssf.19"  ,0x200000,0x34e825c5,    1},
  {"ssf.14"  ,0x100000,0xb7cc32e7,    1},
  {"ssf.16"  ,0x100000,0x8376ad18,    1},
  {"ssf.18"  ,0x100000,0xf5b1b336,    1},
  {"ssf.20"  ,0x100000,0x459d5c6b,    1},
  {"sfx.21"  ,0x100000,0xe32854af,    1},
  {"sfx.23"  ,0x100000,0x760f2927,    1},
  {"sfx.25"  ,0x100000,0x1ee90208,    1},
  {"sfx.27"  ,0x100000,0xf814400f,    1},

  // sound - z80 roms
  {"sfx.01"  ,0x020000,0xb47b8835,    2}, // 25
  {"sfx.02"  ,0x020000,0x0022633f,    2},
  // sound - samples
  {"sfx.11"  ,0x200000,0x9bdbd476,    2},
  {"sfx.12"  ,0x200000,0xa05e3aab,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Ssf2xj) STD_ROM_FN(Ssf2xj)

struct BurnDriver BurnDrvCpsSsf2xj=
{
  {"ssf2xj" ,"Super Street Fighter 2 X: Grand Master Challenge (Japan 940223)","","Capcom","CPS2","1994","ssf2", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Ssf2xjRomInfo, Ssf2xjRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
