// Super Street Fighter 2

#include "cps.h"

STDINPUTINFOSPEC(Drv, CpsFsi);

static int DrvInit()
{
  int nRet=0; int i=0; unsigned char *pqs=NULL;

  Cps=2;
  nCpsRomLen=  5*0x080000;
  nCpsCodeLen= 5*0x080000;
  nCpsGfxLen=    0xc00000;
  nCpsZRomLen= 1*0x020000;
  nCpsQSamLen= 8*0x080000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  // Load program roms (as they are on the roms) for CpsRom
  for (i=0;i<5;i++)
  { nRet=BurnLoadRom(CpsRom+i*0x080000,5+i,1); if (nRet!=0) return 1; }

  // Make decrypted rom
  memcpy(CpsCode,CpsRom,nCpsCodeLen);
  for (i=0;i<5;i++)
  { nRet=BurnXorRom(CpsCode+i*0x080000,0+i,1); if (nRet!=0) return 1; }

  // Load graphics roms
  nRet=Cps2LoadTiles(CpsGfx           ,10);
  nRet=Cps2LoadTiles(CpsGfx+  0x800000,14);

  nCpsGfxScroll[3]=0;

  // Load Z80 Roms
  nRet=BurnLoadRom(CpsZRom,18,1);

  // Load Q Sample Roms
  pqs=(unsigned char *)CpsQSam;
  for (i=0;i<8;i++)
  {
    nRet=BurnLoadRom(pqs+i*0x080000,19+i,1);
  }

  nRet=CpsRunInit();

  if (nRet!=0) return 1;
  // Ready to go
  return 0;
}

static int DrvExit()
{

  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0;
  return 0;
}

//============================
//Super Street Fighter 2 (USA)
//============================


static struct BurnRomInfo Ssf2RomDesc[]=
{
// 0
  {"ssfux.03a",0x80000,0xec278279, 0x10}, // xor decryption tables
  {"ssfux.04a",0x80000,0x6194d896, 0x10},
  {"ssfux.05" ,0x80000,0xaa846b9f, 0x10},
  {"ssfux.06" ,0x80000,0x235268c4, 0x10},
  {"ssfux.07" ,0x80000,0xe46e033c, 0x10},
// 5
  {"ssfu.03a" ,0x80000,0x72f29c33, 0x10}, // 68000 code (encrypted)
  {"ssfu.04a" ,0x80000,0x935cea44, 0x10},
  {"ssfu.05"  ,0x80000,0xa0acb28a, 0x10},
  {"ssfu.06"  ,0x80000,0x47413dcf, 0x10},
  {"ssfu.07"  ,0x80000,0xe6066077, 0x10},
// 10
  {"ssf.13"  ,0x200000,0xcf94d275,    1},
  {"ssf.15"  ,0x200000,0x5eb703af,    1},
  {"ssf.17"  ,0x200000,0xffa60e0f,    1},
  {"ssf.19"  ,0x200000,0x34e825c5,    1},
  {"ssf.14"  ,0x100000,0xb7cc32e7,    1},
  {"ssf.16"  ,0x100000,0x8376ad18,    1},
  {"ssf.18"  ,0x100000,0xf5b1b336,    1},
  {"ssf.20"  ,0x100000,0x459d5c6b,    1},
// 18
  {"ssf.01"  ,0x020000,0xeb247e8c,    2},
// 19
  {"ssf.q01" ,0x080000,0xa6f9da5c,    2},
  {"ssf.q02" ,0x080000,0x8c66ae26,    2},
  {"ssf.q03" ,0x080000,0x695cc2ca,    2},
  {"ssf.q04" ,0x080000,0x9d9ebe32,    2},
  {"ssf.q05" ,0x080000,0x4770e7b7,    2},
  {"ssf.q06" ,0x080000,0x4e79c951,    2},
  {"ssf.q07" ,0x080000,0xcdd14313,    2},
  {"ssf.q08" ,0x080000,0x6f5a088c,    2},
};

STD_ROM_PICK(Ssf2) STD_ROM_FN(Ssf2)

struct BurnDriver BurnDrvCpsSsf2=
{
  {"ssf2", "Super Street Fighter 2: The New Challengers (US 930911)","","Capcom","CPS2","1993",NULL, NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Ssf2RomInfo, Ssf2RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//==============================
//Super Street Fighter 2 (Japan)
//==============================


static struct BurnRomInfo Ssf2jRomDesc[]=
{
  {"ssfjx.03b" ,0x80000,0x693985dd, 0x10},
  {"ssfjx.04a" ,0x80000,0xf866d34a, 0x10},
  {"ssfjx.05"  ,0x80000,0x7282bb56, 0x10},
  {"ssfjx.06b" ,0x80000,0xc597bc4a, 0x10},
  {"ssfjx.07"  ,0x80000,0x2af7cab2, 0x10},

  {"ssfj.03b" ,0x80000,0x5c2e356d, 0x10},
  {"ssfj.04a" ,0x80000,0x013bd55c, 0x10},
  {"ssfj.05"  ,0x80000,0x0918d19a, 0x10},
  {"ssfj.06b" ,0x80000,0x014e0c6d, 0x10},
  {"ssfj.07"  ,0x80000,0xeb6a9b1b, 0x10},

  {"ssf.13"  ,0x200000,0xcf94d275,    1},
  {"ssf.15"  ,0x200000,0x5eb703af,    1},
  {"ssf.17"  ,0x200000,0xffa60e0f,    1},
  {"ssf.19"  ,0x200000,0x34e825c5,    1},
  {"ssf.14"  ,0x100000,0xb7cc32e7,    1},
  {"ssf.16"  ,0x100000,0x8376ad18,    1},
  {"ssf.18"  ,0x100000,0xf5b1b336,    1},
  {"ssf.20"  ,0x100000,0x459d5c6b,    1},

  {"ssf.01"  ,0x020000,0xeb247e8c,    2},

  {"ssf.q01" ,0x080000,0xa6f9da5c,    2},
  {"ssf.q02" ,0x080000,0x8c66ae26,    2},
  {"ssf.q03" ,0x080000,0x695cc2ca,    2},
  {"ssf.q04" ,0x080000,0x9d9ebe32,    2},
  {"ssf.q05" ,0x080000,0x4770e7b7,    2},
  {"ssf.q06" ,0x080000,0x4e79c951,    2},
  {"ssf.q07" ,0x080000,0xcdd14313,    2},
  {"ssf.q08" ,0x080000,0x6f5a088c,    2},
};

STD_ROM_PICK(Ssf2j) STD_ROM_FN(Ssf2j)

struct BurnDriver BurnDrvCpsSsf2j=
{
  {"ssf2j", "Super Street Fighter 2: The New Challengers (Japan 931005)","","Capcom","CPS2","1993","ssf2", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Ssf2jRomInfo, Ssf2jRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//=================================
//Super Street Fighter 2 (Japan r1)
//=================================


static struct BurnRomInfo Ssf2jr1RomDesc[]=
{
  {"ssfjx.03a" ,0x80000,0xc1b1d0c1, 0x10},
  {"ssfjx.04a" ,0x80000,0xf866d34a, 0x10},
  {"ssfjx.05"  ,0x80000,0x7282bb56, 0x10},
  {"ssfjx.06"  ,0x80000,0xcc027506, 0x10},
  {"ssfjx.07"  ,0x80000,0x2af7cab2, 0x10},

  {"ssfj.03a" ,0x80000,0x0bbf1304, 0x10},
  {"ssfj.04a" ,0x80000,0x013bd55c, 0x10},
  {"ssfj.05"  ,0x80000,0x0918d19a, 0x10},
  {"ssfj.06"  ,0x80000,0xd808a6cd, 0x10},
  {"ssfj.07"  ,0x80000,0xeb6a9b1b, 0x10},

  {"ssf.13"  ,0x200000,0xcf94d275,    1},
  {"ssf.15"  ,0x200000,0x5eb703af,    1},
  {"ssf.17"  ,0x200000,0xffa60e0f,    1},
  {"ssf.19"  ,0x200000,0x34e825c5,    1},
  {"ssf.14"  ,0x100000,0xb7cc32e7,    1},
  {"ssf.16"  ,0x100000,0x8376ad18,    1},
  {"ssf.18"  ,0x100000,0xf5b1b336,    1},
  {"ssf.20"  ,0x100000,0x459d5c6b,    1},

  {"ssf.01"  ,0x020000,0xeb247e8c,    2},

  {"ssf.q01" ,0x080000,0xa6f9da5c,    2},
  {"ssf.q02" ,0x080000,0x8c66ae26,    2},
  {"ssf.q03" ,0x080000,0x695cc2ca,    2},
  {"ssf.q04" ,0x080000,0x9d9ebe32,    2},
  {"ssf.q05" ,0x080000,0x4770e7b7,    2},
  {"ssf.q06" ,0x080000,0x4e79c951,    2},
  {"ssf.q07" ,0x080000,0xcdd14313,    2},
  {"ssf.q08" ,0x080000,0x6f5a088c,    2},
};

STD_ROM_PICK(Ssf2jr1) STD_ROM_FN(Ssf2jr1)

struct BurnDriver BurnDrvCpsSsf2jr1=
{
  {"ssf2jr1", "Super Street Fighter 2: The New Challengers (Japan 930911)","","Capcom","CPS2","1993","ssf2", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Ssf2jr1RomInfo, Ssf2jr1RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//=================================
//Super Street Fighter 2 (Japan r2)
//=================================


static struct BurnRomInfo Ssf2jr2RomDesc[]=
{
  {"ssfjx.03"  ,0x80000,0xc3eca34c, 0x10},
  {"ssfjx.04"  ,0x80000,0x4e1080c2, 0x10},
  {"ssfjx.05"  ,0x80000,0x7282bb56, 0x10},
  {"ssfjx.06"  ,0x80000,0xcc027506, 0x10},
  {"ssfjx.07"  ,0x80000,0x2af7cab2, 0x10},

  {"ssfj.03"  ,0x80000,0x7eb0efed, 0x10},
  {"ssfj.04"  ,0x80000,0xd7322164, 0x10},
  {"ssfj.05"  ,0x80000,0x0918d19a, 0x10},
  {"ssfj.06"  ,0x80000,0xd808a6cd, 0x10},
  {"ssfj.07"  ,0x80000,0xeb6a9b1b, 0x10},

  {"ssf.13"  ,0x200000,0xcf94d275,    1},
  {"ssf.15"  ,0x200000,0x5eb703af,    1},
  {"ssf.17"  ,0x200000,0xffa60e0f,    1},
  {"ssf.19"  ,0x200000,0x34e825c5,    1},
  {"ssf.14"  ,0x100000,0xb7cc32e7,    1},
  {"ssf.16"  ,0x100000,0x8376ad18,    1},
  {"ssf.18"  ,0x100000,0xf5b1b336,    1},
  {"ssf.20"  ,0x100000,0x459d5c6b,    1},

  {"ssf.01"  ,0x020000,0xeb247e8c,    2},

  {"ssf.q01" ,0x080000,0xa6f9da5c,    2},
  {"ssf.q02" ,0x080000,0x8c66ae26,    2},
  {"ssf.q03" ,0x080000,0x695cc2ca,    2},
  {"ssf.q04" ,0x080000,0x9d9ebe32,    2},
  {"ssf.q05" ,0x080000,0x4770e7b7,    2},
  {"ssf.q06" ,0x080000,0x4e79c951,    2},
  {"ssf.q07" ,0x080000,0xcdd14313,    2},
  {"ssf.q08" ,0x080000,0x6f5a088c,    2},
};

STD_ROM_PICK(Ssf2jr2) STD_ROM_FN(Ssf2jr2)

struct BurnDriver BurnDrvCpsSsf2jr2=
{
  {"ssf2jr2", "Super Street Fighter 2: The New Challengers (Japan 930910)","","Capcom","CPS2","1993","ssf2", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Ssf2jr2RomInfo, Ssf2jr2RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//====================================
//Super Street Fighter 2: T.B. (World)
//====================================


static struct BurnRomInfo Ssf2tbRomDesc[]=
{
  {"ssfex.3tc"  ,0x80000,0x9b2cda8c, 0x10},
  {"ssfex.4tc"  ,0x80000,0x62d26dc2, 0x10},
  {"ssfex.5t"   ,0x80000,0x3ae42ff3, 0x10},
  {"ssfex.6tb"  ,0x80000,0xf12e7228, 0x10},
  {"ssfex.7t"   ,0x80000,0x4d51f760, 0x10},

  {"ssfe.3tc"  ,0x80000,0x496a8409, 0x10},
  {"ssfe.4tc"  ,0x80000,0x4b45c18b, 0x10},
  {"ssfe.5t"   ,0x80000,0x6a9c6444, 0x10},
  {"ssfe.6tb"  ,0x80000,0xe4944fc3, 0x10},
  {"ssfe.7t"   ,0x80000,0x2c9f4782, 0x10},

  {"ssf.13"  ,0x200000,0xcf94d275,    1},
  {"ssf.15"  ,0x200000,0x5eb703af,    1},
  {"ssf.17"  ,0x200000,0xffa60e0f,    1},
  {"ssf.19"  ,0x200000,0x34e825c5,    1},
  {"ssf.14"  ,0x100000,0xb7cc32e7,    1},
  {"ssf.16"  ,0x100000,0x8376ad18,    1},
  {"ssf.18"  ,0x100000,0xf5b1b336,    1},
  {"ssf.20"  ,0x100000,0x459d5c6b,    1},

  {"ssf.01"  ,0x020000,0xeb247e8c,    2},

  {"ssf.q01" ,0x080000,0xa6f9da5c,    2},
  {"ssf.q02" ,0x080000,0x8c66ae26,    2},
  {"ssf.q03" ,0x080000,0x695cc2ca,    2},
  {"ssf.q04" ,0x080000,0x9d9ebe32,    2},
  {"ssf.q05" ,0x080000,0x4770e7b7,    2},
  {"ssf.q06" ,0x080000,0x4e79c951,    2},
  {"ssf.q07" ,0x080000,0xcdd14313,    2},
  {"ssf.q08" ,0x080000,0x6f5a088c,    2},
};

STD_ROM_PICK(Ssf2tb) STD_ROM_FN(Ssf2tb)

struct BurnDriver BurnDrvCpsSsf2tb=
{
  {"ssf2tb", "Super Street Fighter 2: The Tournament Battle (World 931119)","","Capcom","CPS2","1993","ssf2", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Ssf2tbRomInfo, Ssf2tbRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//================================
//Super Street Fighter 2 (Asia r1)
//================================


static struct BurnRomInfo Ssf2ar1RomDesc[]=
{
  {"ssfax.03a",0x80000,0xd628422c, 0x10},
  {"ssfax.04a",0x80000,0x99d5e67f, 0x10},
  {"ssfax.05" ,0x80000,0xd104f415, 0x10},
  {"ssfax.06" ,0x80000,0x210e787c, 0x10},
  {"ssfax.07" ,0x80000,0xca49b7f6, 0x10},

  {"ssfa.03a" ,0x80000,0xd2a3c520, 0x10},
  {"ssfa.04a" ,0x80000,0x5d873642, 0x10},
  {"ssfa.05"  ,0x80000,0xf8fb4de2, 0x10},
  {"ssfa.06"  ,0x80000,0xaa8acee7, 0x10},
  {"ssfa.07"  ,0x80000,0x36e29217, 0x10},

  {"ssf.13"   ,0x200000,0xcf94d275,    1},
  {"ssf.15"   ,0x200000,0x5eb703af,    1},
  {"ssf.17"   ,0x200000,0xffa60e0f,    1},
  {"ssf.19"   ,0x200000,0x34e825c5,    1},
  {"ssf.14"   ,0x100000,0xb7cc32e7,    1},
  {"ssf.16"   ,0x100000,0x8376ad18,    1},
  {"ssf.18"   ,0x100000,0xf5b1b336,    1},
  {"ssf.20"   ,0x100000,0x459d5c6b,    1},

  {"ssf.01"   ,0x020000,0xeb247e8c,    2},

  {"ssf.q01"  ,0x080000,0xa6f9da5c,    2},
  {"ssf.q02"  ,0x080000,0x8c66ae26,    2},
  {"ssf.q03"  ,0x080000,0x695cc2ca,    2},
  {"ssf.q04"  ,0x080000,0x9d9ebe32,    2},
  {"ssf.q05"  ,0x080000,0x4770e7b7,    2},
  {"ssf.q06"  ,0x080000,0x4e79c951,    2},
  {"ssf.q07"  ,0x080000,0xcdd14313,    2},
  {"ssf.q08"  ,0x080000,0x6f5a088c,    2},
};

STD_ROM_PICK(Ssf2ar1) STD_ROM_FN(Ssf2ar1)

struct BurnDriver BurnDrvCpsSsf2ar1=
{
  {"ssf2ar1", "Super Street Fighter 2: The New Challengers (Asia 930914)","","Capcom","CPS2","1993","ssf2", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Ssf2ar1RomInfo, Ssf2ar1RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//=============================
//Super Street Fighter 2 (Asia)
//=============================


static struct BurnRomInfo Ssf2aRomDesc[]=
{
  {"ssfax.03b",0x80000,0x903b997e, 0x10},
  {"ssfax.04a",0x80000,0x99d5e67f, 0x10},
  {"ssfax.05" ,0x80000,0xd104f415, 0x10},
  {"ssfax.06b",0x80000,0x16516200, 0x10},
  {"ssfax.07" ,0x80000,0xca49b7f6, 0x10},

  {"ssfa.03b" ,0x80000,0x83a059bf, 0x10},
  {"ssfa.04a" ,0x80000,0x5d873642, 0x10},
  {"ssfa.05"  ,0x80000,0xf8fb4de2, 0x10},
  {"ssfa.06b" ,0x80000,0x3185d19d, 0x10},
  {"ssfa.07"  ,0x80000,0x36e29217, 0x10},

  {"ssf.13"   ,0x200000,0xcf94d275,    1},
  {"ssf.15"   ,0x200000,0x5eb703af,    1},
  {"ssf.17"   ,0x200000,0xffa60e0f,    1},
  {"ssf.19"   ,0x200000,0x34e825c5,    1},
  {"ssf.14"   ,0x100000,0xb7cc32e7,    1},
  {"ssf.16"   ,0x100000,0x8376ad18,    1},
  {"ssf.18"   ,0x100000,0xf5b1b336,    1},
  {"ssf.20"   ,0x100000,0x459d5c6b,    1},

  {"ssf.01"   ,0x020000,0xeb247e8c,    2},

  {"ssf.q01"  ,0x080000,0xa6f9da5c,    2},
  {"ssf.q02"  ,0x080000,0x8c66ae26,    2},
  {"ssf.q03"  ,0x080000,0x695cc2ca,    2},
  {"ssf.q04"  ,0x080000,0x9d9ebe32,    2},
  {"ssf.q05"  ,0x080000,0x4770e7b7,    2},
  {"ssf.q06"  ,0x080000,0x4e79c951,    2},
  {"ssf.q07"  ,0x080000,0xcdd14313,    2},
  {"ssf.q08"  ,0x080000,0x6f5a088c,    2},
};

STD_ROM_PICK(Ssf2a) STD_ROM_FN(Ssf2a)

struct BurnDriver BurnDrvCpsSsf2a=
{
  {"ssf2a", "Super Street Fighter 2: The New Challengers (Asia 931005)","","Capcom","CPS2","1993","ssf2", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Ssf2aRomInfo, Ssf2aRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//====================================
//Super Street Fighter 2: T.B. (Japan)
//====================================


static struct BurnRomInfo Ssf2tbjRomDesc[]=
{
  {"ssfjx.3t"  ,0x80000,0x00000000, 0x10},
  {"ssfjx.4t"  ,0x80000,0x00000000, 0x10},
  {"ssfjx.5t"  ,0x80000,0x00000000, 0x10},
  {"ssfjx.6t"  ,0x80000,0x00000000, 0x10},
  {"ssfjx.7t"  ,0x80000,0x00000000, 0x10},

  {"ssfj.3t"   ,0x80000,0x980d4450, 0x10},
  {"ssfj.4t"   ,0x80000,0xb4dc1906, 0x10},
  {"ssfj.5t"   ,0x80000,0xa7e35fbc, 0x10},
  {"ssfj.6t"   ,0x80000,0xcb592b30, 0x10},
  {"ssfj.7t"   ,0x80000,0x1f239515, 0x10},

  {"ssf.13"    ,0x200000,0xcf94d275,    1},
  {"ssf.15"    ,0x200000,0x5eb703af,    1},
  {"ssf.17"    ,0x200000,0xffa60e0f,    1},
  {"ssf.19"    ,0x200000,0x34e825c5,    1},
  {"ssf.14"    ,0x100000,0xb7cc32e7,    1},
  {"ssf.16"    ,0x100000,0x8376ad18,    1},
  {"ssf.18"    ,0x100000,0xf5b1b336,    1},
  {"ssf.20"    ,0x100000,0x459d5c6b,    1},

  {"ssf.01"    ,0x020000,0xeb247e8c,    2},

  {"ssf.q01"   ,0x080000,0xa6f9da5c,    2},
  {"ssf.q02"   ,0x080000,0x8c66ae26,    2},
  {"ssf.q03"   ,0x080000,0x695cc2ca,    2},
  {"ssf.q04"   ,0x080000,0x9d9ebe32,    2},
  {"ssf.q05"   ,0x080000,0x4770e7b7,    2},
  {"ssf.q06"   ,0x080000,0x4e79c951,    2},
  {"ssf.q07"   ,0x080000,0xcdd14313,    2},
  {"ssf.q08"   ,0x080000,0x6f5a088c,    2},
};

STD_ROM_PICK(Ssf2tbj) STD_ROM_FN(Ssf2tbj)

struct BurnDriverX BurnDrvCpsSsf2tbj=
{
  {"ssf2tbj", "Super Street Fighter 2: The Tournament Battle (Japan 930910)","Encrypted","Capcom","CPS2","1993","ssf2", NULL},
  0,2,HARDWARE_CAPCOM_CPS2,
  NULL, Ssf2tbjRomInfo, Ssf2tbjRomName, DrvInputInfo,	NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
