#include "cps.h"

/*===================
Night Warriors Driver
===================*/

STDINPUTINFOSPEC(Drv, CpsFsi);


static int DrvInit()
{
 int nRet=0; int i=0; unsigned char *pqs=NULL;

 Cps=2;
 nCpsRomLen=  8*0x080000;
 nCpsCodeLen= 3*0x080000;
 nCpsGfxLen=  8*0x400000;
 nCpsZRomLen= 2*0x020000;
 nCpsQSamLen= 2*0x200000;
 nRet=CpsInit(); if (nRet!=0) return 1;

 // Load program roms (as they are on the roms) for CpsRom
 for (i=0;i<8;i++)
 { nRet=BurnLoadRom(CpsRom+0x080000*i,3+i,1); if (nRet!=0) return 1; }

 // Make decrypted rom
 memcpy(CpsCode,CpsRom,nCpsCodeLen);
 nRet=BurnXorRom(CpsCode         ,0,1); if (nRet!=0) return 1;
 nRet=BurnXorRom(CpsCode+0x080000,1,1); if (nRet!=0) return 1;
 nRet=BurnXorRom(CpsCode+0x100000,2,1); if (nRet!=0) return 1;

 // Load graphics roms
 nRet=Cps2LoadTiles(CpsGfx           ,11);
 nRet=Cps2LoadTiles(CpsGfx+4*0x400000,15);

 // Load Z80 Roms
 nRet=BurnLoadRom(CpsZRom         ,19,1);
 nRet=BurnLoadRom(CpsZRom+ 0x20000,20,1);

 // Load Q Sample Roms
 pqs=(unsigned char *)CpsQSam;
 nRet=BurnLoadRom(pqs         ,21,1);
 nRet=BurnLoadRom(pqs+0x200000,22,1);
 BurnByteswap(pqs,nCpsQSamLen);


 nRet=CpsRunInit();

 if (nRet!=0) return 1;
 // Ready to go
 return 0;
}

static int DrvExit()
{

  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0;
  return 0;
}

/*==================
Night Warriors (USA)
==================*/


static struct BurnRomInfo NwarrRomDesc[]=
{
  {"vphux.03f",0x080000,0xd1c35094, 0x10},
  {"vphux.04c",0x080000,0x48b01f4e, 0x10},
  {"vphux.05e",0x080000,0x0147c2a5, 0x10},

  {"vphu.03f" ,0x080000,0x85d6a359, 0x10},
  {"vphu.04c" ,0x080000,0xcb7fce77, 0x10},
  {"vphu.05e" ,0x080000,0xe08f2bba, 0x10},
  {"vphu.06c" ,0x080000,0x08c04cdb, 0x10},
  {"vphu.07b" ,0x080000,0xb5a5ab19, 0x10},
  {"vphu.08b" ,0x080000,0x51bb20fb, 0x10},
  {"vphu.09b" ,0x080000,0x41a64205, 0x10},
  {"vphu.10b" ,0x080000,0x2b1d43ae, 0x10},

  {"vph.13"   ,0x400000,0xc51baf99,    1},
  {"vph.15"   ,0x400000,0x3ce83c77,    1},
  {"vph.17"   ,0x400000,0x4f2408e0,    1},
  {"vph.19"   ,0x400000,0x9ff60250,    1},
  {"vph.14"   ,0x400000,0x7a0e1add,    1},
  {"vph.16"   ,0x400000,0x2f41ca75,    1},
  {"vph.18"   ,0x400000,0x64498eed,    1},
  {"vph.20"   ,0x400000,0x17f2433f,    1},

  {"vph.01"   ,0x020000,0x5045dcac,    2},
  {"vph.02"   ,0x020000,0x86b60e59,    2},

  {"vph.11"   ,0x200000,0xe1837d33,    2},
  {"vph.12"   ,0x200000,0xfbd3cd90,    2},
};

STD_ROM_PICK(Nwarr) STD_ROM_FN(Nwarr)

struct BurnDriver BurnDrvCpsNwarr=
{
  {"nwarr" ,"Night Warriors: Darkstalkers Revenge (US 950406)",NULL,"Capcom","CPS2","1995",NULL, NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, NwarrRomInfo, NwarrRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*=======================
Night Warriors (Hispanic)
=======================*/


static struct BurnRomInfo NwarrhRomDesc[]=
{
  {"vphhx.03d",0x080000,0x00000000, 0x10},
  {"vphhx.04a",0x080000,0x00000000, 0x10},
  {"vphhx.05c",0x080000,0x00000000, 0x10},

  {"vphh.03d" ,0x080000,0x6029c7be, 0x10},
  {"vphh.04a" ,0x080000,0xd26625ee, 0x10},
  {"vphh.05c" ,0x080000,0x73ee0b8a, 0x10},
  {"vphh.06a" ,0x080000,0xa5b3a50a, 0x10},
  {"vphh.07"  ,0x080000,0x5fc2bdc1, 0x10},
  {"vphh.08"  ,0x080000,0xe65588d9, 0x10},
  {"vphh.09"  ,0x080000,0xa2ce6d63, 0x10},
  {"vphh.10"  ,0x080000,0xe2f4f4b9, 0x10},

  {"vph.13"   ,0x400000,0xc51baf99,    1},
  {"vph.15"   ,0x400000,0x3ce83c77,    1},
  {"vph.17"   ,0x400000,0x4f2408e0,    1},
  {"vph.19"   ,0x400000,0x9ff60250,    1},
  {"vph.14"   ,0x400000,0x7a0e1add,    1},
  {"vph.16"   ,0x400000,0x2f41ca75,    1},
  {"vph.18"   ,0x400000,0x64498eed,    1},
  {"vph.20"   ,0x400000,0x17f2433f,    1},

  {"vph.01"   ,0x020000,0x5045dcac,    2},
  {"vph.02"   ,0x020000,0x86b60e59,    2},

  {"vph.11"   ,0x200000,0xe1837d33,    2},
  {"vph.12"   ,0x200000,0xfbd3cd90,    2},
};

STD_ROM_PICK(Nwarrh) STD_ROM_FN(Nwarrh)

struct BurnDriverX BurnDrvCpsNwarrh=
{
  {"nwarrh" ,"Night Warriors: Darkstalkers Revenge (Hispanic 950403)","Encrypted","Capcom","CPS2","1995","nwarr", NULL},
  0,2,HARDWARE_CAPCOM_CPS2,
  NULL, NwarrhRomInfo, NwarrhRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*====================
Vampire Hunter (Japan)
====================*/


static struct BurnRomInfo VhuntjRomDesc[]=
{
  {"vphjx.03f",0x080000,0xdde66666, 0x10},
  {"vphjx.04c",0x080000,0x2dfed55f, 0x10},
  {"vphjx.05d",0x080000,0x56c18710, 0x10},

  {"vphj.03f" ,0x080000,0x3de2e333, 0x10},
  {"vphj.04c" ,0x080000,0xc95cf304, 0x10},
  {"vphj.05d" ,0x080000,0x50de5ddd, 0x10},
  {"vphj.06c" ,0x080000,0xac3bd3d5, 0x10},
  {"vphj.07b" ,0x080000,0x0761309f, 0x10},
  {"vphj.08b" ,0x080000,0x5a5c2bf5, 0x10},
  {"vphj.09b" ,0x080000,0x823d6d99, 0x10},
  {"vphj.10b" ,0x080000,0x32c7d8f0, 0x10},

  {"vph.13"   ,0x400000,0xc51baf99,    1},
  {"vph.15"   ,0x400000,0x3ce83c77,    1},
  {"vph.17"   ,0x400000,0x4f2408e0,    1},
  {"vph.19"   ,0x400000,0x9ff60250,    1},
  {"vph.14"   ,0x400000,0x7a0e1add,    1},
  {"vph.16"   ,0x400000,0x2f41ca75,    1},
  {"vph.18"   ,0x400000,0x64498eed,    1},
  {"vph.20"   ,0x400000,0x17f2433f,    1},

  {"vph.01"   ,0x020000,0x5045dcac,    2},
  {"vph.02"   ,0x020000,0x86b60e59,    2},

  {"vph.11"   ,0x200000,0xe1837d33,    2},
  {"vph.12"   ,0x200000,0xfbd3cd90,    2},
};

STD_ROM_PICK(Vhuntj) STD_ROM_FN(Vhuntj)

struct BurnDriver BurnDrvCpsVhuntj=
{
  {"vhuntj" ,"Vampire Hunter: Darkstalkers Revenge (Japan 950316)",NULL,"Capcom","CPS2","1995","nwarr", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, VhuntjRomInfo, VhuntjRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*=======================
Vampire Hunter (Japan R1)
=======================*/


static struct BurnRomInfo Vhuntjr1RomDesc[]=
{
  {"vphjx.03b",0x080000,0xb3c43690, 0x10},
  {"vphjx.04a",0x080000,0x22ff1003, 0x10},
  {"vphjx.05a",0x080000,0xc35b50cb, 0x10},

  {"vphj.03b" ,0x080000,0x679c3fa9, 0x10},
  {"vphj.04a" ,0x080000,0xeb6e71e4, 0x10},
  {"vphj.05a" ,0x080000,0xeaf634ea, 0x10},
  {"vphj.06a" ,0x080000,0xb70cc6be, 0x10},
  {"vphj.07a" ,0x080000,0x46ab907d, 0x10},
  {"vphj.08a" ,0x080000,0x1c00355e, 0x10},
  {"vphj.09a" ,0x080000,0x026e6f82, 0x10},
  {"vphj.10a" ,0x080000,0xaadfb3ea, 0x10},

  {"vph.13"   ,0x400000,0xc51baf99,    1},
  {"vph.15"   ,0x400000,0x3ce83c77,    1},
  {"vph.17"   ,0x400000,0x4f2408e0,    1},
  {"vph.19"   ,0x400000,0x9ff60250,    1},
  {"vph.14"   ,0x400000,0x7a0e1add,    1},
  {"vph.16"   ,0x400000,0x2f41ca75,    1},
  {"vph.18"   ,0x400000,0x64498eed,    1},
  {"vph.20"   ,0x400000,0x17f2433f,    1},

  {"vph.01"   ,0x020000,0x5045dcac,    2},
  {"vph.02"   ,0x020000,0x86b60e59,    2},

  {"vph.11"   ,0x200000,0xe1837d33,    2},
  {"vph.12"   ,0x200000,0xfbd3cd90,    2},
};

STD_ROM_PICK(Vhuntjr1) STD_ROM_FN(Vhuntjr1)

struct BurnDriver BurnDrvCpsVhuntjr1=
{
  {"vhuntjr1" ,"Vampire Hunter: Darkstalkers Revenge (Japan 950302)",NULL,"Capcom","CPS2","1995","nwarr", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Vhuntjr1RomInfo, Vhuntjr1RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
