#ifndef _XBOXCONFIG
#define _XBOXCONFIG

#ifdef _XBOX
#pragma warning(disable:4244)		// "possible loss of data"
#endif

#include <io.h>
#include <iostream>
#include <string>
#include <map>

#define DPAD	0
#define	ANALOG	1
#define XARCADE	2
#define MAXGAMEPADS	4
#define MAXFIREBUTTONS 6
#define MAXBUTTONS 8


using namespace std;
typedef map<int, int>CONFIGMAP;
typedef map<DWORD, int>BUTTONMAP;
typedef map<int, DWORD>LOOKUPMAP;


struct GamepadMappings
{
	DWORD dwCoin;
	DWORD dwStart;
	DWORD dwFire[6];
};


 
class CConfiguration
{
public:

	CConfiguration();
 
	void ShowPlayerGamepadType(void);
	void ShowPlayerMappings(int nPlayer);
	
	DWORD GetFireMapping(int nPlayer, int nFireNum);
	void SetFireMapping(int nPlayer, int nFireNum, DWORD nButton);
	
	int GetFireType(int nPlayer, int nFireNum);
	void SetFireType(int nPlayer, int nType, DWORD nButton);

	int GetJoyType(int nPlayer);
	void SetJoyType(int nPlayer, int nType);


	int m_nPlayerNumPos;				// player we are currently on
	int m_nButtonPos;
	
	CONFIGMAP m_ConfigMap;
	BUTTONMAP m_ButtonMap;
	LOOKUPMAP m_LookupMap;

	GamepadMappings m_PlayerMappings[4];

};

#endif