#include "toaplan.h"

unsigned char ToaYM2151Registers[0x0100];
unsigned int ToaCurrentYM2151Register;

static short* pBuffer;
short* pYM2151Buffer[2];

static void AllocateBuffers()
{
	pBuffer = (short*)malloc(nBurnSoundLen * 2 * sizeof(short));

	pYM2151Buffer[0] = pBuffer;
	pYM2151Buffer[1] = pBuffer + nBurnSoundLen;
}

static void FreeBuffers()
{
	free(pBuffer);
}

int ToaYM2151Init(int nClockFrequency)
{
	YM2151Init(1, nClockFrequency, nBurnSoundRate);

	AllocateBuffers();
	return 0;
}

void ToaYM2151Exit()
{
	YM2151Shutdown();

	FreeBuffers();
}

void ToaYM2151Scan(int nAction)
{
	SCAN_VAR(ToaCurrentYM2151Register);
	SCAN_VAR(ToaYM2151Registers);

	if (nAction & 2) {
		for (int i = 0; i < 0x0100; i++) {
			YM2151WriteReg(0, i, ToaYM2151Registers[i]);
		}
	}
}
