#include "cps.h"

/*=====================
Vampire Hunter 2 Driver
=====================*/

STDINPUTINFOSPEC(Drv, CpsFsi);


static int DrvInit()
{
 int nRet=0; int i=0; unsigned char *pqs=NULL;

 Cps=2;
 nCpsRomLen=  8*0x080000;
 nCpsCodeLen= 2*0x080000;
 nCpsGfxLen=  8*0x400000;
 nCpsZRomLen= 2*0x020000;
 nCpsQSamLen= 2*0x400000;
 nRet=CpsInit(); if (nRet!=0) return 1;

 // Load program roms (as they are on the roms) for CpsRom
 for (i=0;i<8;i++)
 { nRet=BurnLoadRom(CpsRom+0x080000*i,2+i,1); if (nRet!=0) return 1; }

 // Make decrypted rom
 memcpy(CpsCode,CpsRom,nCpsCodeLen);
 nRet=BurnXorRom(CpsCode         ,0,1); if (nRet!=0) return 1;
 nRet=BurnXorRom(CpsCode+0x080000,1,1); if (nRet!=0) return 1;

 // Load graphics roms
 nRet=Cps2LoadTiles(CpsGfx           ,10);
 nRet=Cps2LoadTiles(CpsGfx+4*0x400000,14);

 // Load Z80 Roms
 nRet=BurnLoadRom(CpsZRom         ,18,1);
 nRet=BurnLoadRom(CpsZRom+ 0x20000,19,1);

 // Load Q Sample Roms
 pqs=(unsigned char *)CpsQSam;
 nRet=BurnLoadRom(pqs         ,20,1);
 nRet=BurnLoadRom(pqs+0x400000,21,1);
 BurnByteswap(pqs,nCpsQSamLen);


 nRet=CpsRunInit();

 if (nRet!=0) return 1;
 // Ready to go
 return 0;
}

static int DrvExit()
{

  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0;
  return 0;
}

/*======================
Vampire Hunter 2 (Japan)
======================*/


static struct BurnRomInfo Vhunt2RomDesc[]=
{
  {"vh2jx.03" ,0x080000,0x7D5D7AAE, 0x10},
  {"vh2jx.04" ,0x080000,0xc66E9AEA, 0x10},

  {"vh2j.03"  ,0x080000,0x1a5feb13, 0x10},
  {"vh2j.04"  ,0x080000,0x434611a5, 0x10},
  {"vh2j.05"  ,0x080000,0xde34f624, 0x10},
  {"vh2j.06"  ,0x080000,0x6a3b9897, 0x10},
  {"vh2j.07"  ,0x080000,0xb021c029, 0x10},
  {"vh2j.08"  ,0x080000,0xac873dff, 0x10},
  {"vh2j.09"  ,0x080000,0xeaefce9c, 0x10},
  {"vh2j.10"  ,0x080000,0x11730952, 0x10},

  {"vh2.13"   ,0x400000,0x3b02ddaa,    1},
  {"vh2.15"   ,0x400000,0x4e40de66,    1},
  {"vh2.17"   ,0x400000,0xb31d00c9,    1},
  {"vh2.19"   ,0x400000,0x149be3ab,    1},
  {"vh2.14"   ,0x400000,0xcd09bd63,    1},
  {"vh2.16"   ,0x400000,0xe0182c15,    1},
  {"vh2.18"   ,0x400000,0x778dc4f6,    1},
  {"vh2.20"   ,0x400000,0x605d9d1d,    1},

  {"vh2.01"   ,0x020000,0x67b9f779,    2},
  {"vh2.02"   ,0x020000,0xaaf15fcb,    2},

  {"vh2.11"   ,0x400000,0x38922efd,    2},
  {"vh2.12"   ,0x400000,0x6e2430af,    2},
};

STD_ROM_PICK(Vhunt2) STD_ROM_FN(Vhunt2)

struct BurnDriver BurnDrvCpsVhunt2=
{
  {"vhunt2" ,"Vampire Hunter 2: Darkstalkers Revenge (Japan 970913)",NULL,"Capcom","CPS2","1997",NULL, NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Vhunt2RomInfo, Vhunt2RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
