// Street Fighter Alpha 3

#include "cps.h"

STDINPUTINFOSPEC(Drv, CpsFsi);

// announcer codes are between 100 and 13a if anyone wants to disable them

static int DrvInit()
{
  int nRet=0; int i=0; unsigned char *pqs=NULL;

  Cps=2;
  nCpsRomLen=  8*0x080000;
  nCpsCodeLen= 2*0x080000;
  nCpsGfxLen=  8*0x400000;
  nCpsZRomLen= 2*0x020000;
  nCpsQSamLen= 2*0x400000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  for (i=0;i<8;i++)
  { nRet=BurnLoadRom(CpsRom+0x080000*i,2+i,1); if (nRet!=0) return 1; }

  memcpy(CpsCode,CpsRom,nCpsCodeLen);
  nRet=BurnXorRom(CpsCode         ,0,1); if (nRet!=0) return 1;
  nRet=BurnXorRom(CpsCode+0x080000,1,1); if (nRet!=0) return 1;

  nRet=Cps2LoadTiles(CpsGfx           ,10);
  nRet=Cps2LoadTiles(CpsGfx+4*0x400000,14);

  nRet=BurnLoadRom(CpsZRom         ,18,1);
  nRet=BurnLoadRom(CpsZRom+ 0x20000,19,1);

  pqs=(unsigned char *)CpsQSam;
  nRet=BurnLoadRom(pqs         ,20,1);
  nRet=BurnLoadRom(pqs+0x400000,21,1);
  BurnByteswap(pqs,nCpsQSamLen);

  nRet=CpsRunInit(); if (nRet!=0) return 1;

  return 0;
}

static int DrvExit()
{


  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0;
  return 0;
}

//============================
//Street Fighter Alpha 3 (USA)
//============================


static struct BurnRomInfo Sfa3RomDesc[]=
{
  {"sz3ux.03c"    ,0x80000,0x7091276b, 0x10},
  {"sz3ux.04c"    ,0x80000,0x83b213b1, 0x10},

  {"sz3u.03c"     ,0x80000,0xe007da2e, 0x10},
  {"sz3u.04c"     ,0x80000,0x5f78f0e7, 0x10},
  {"sz3.05c"      ,0x80000,0x57fd0a40, 0x10},
  {"sz3.06c"      ,0x80000,0xf6305f8b, 0x10},
  {"sz3.07c"      ,0x80000,0x6eab0f6f, 0x10},
  {"sz3.08c"      ,0x80000,0x910c4a3b, 0x10},
  {"sz3.09c"      ,0x80000,0xb29e5199, 0x10},
  {"sz3.10b"      ,0x80000,0xdeb2ff52, 0x10},

  {"sz3.13"     ,0x400000,0x0f7a60d9,    1},
  {"sz3.15"     ,0x400000,0x8e933741,    1},
  {"sz3.17"     ,0x400000,0xd6e98147,    1},
  {"sz3.19"     ,0x400000,0xf31a728a,    1},
  {"sz3.14"     ,0x400000,0x5ff98297,    1},
  {"sz3.16"     ,0x400000,0x52b5bdee,    1},
  {"sz3.18"     ,0x400000,0x40631ed5,    1},
  {"sz3.20"     ,0x400000,0x763409b4,    1},

  {"sz3.01"     ,0x020000,0xde810084,    1},
  {"sz3.02"     ,0x020000,0x72445dc4,    1},

  {"sz3.11"     ,0x400000,0x1c89eed1,    2},
  {"sz3.12"     ,0x400000,0xf392b13a,    2},
};

STD_ROM_PICK(Sfa3) STD_ROM_FN(Sfa3)

struct BurnDriver BurnDrvCpsSfa3=
{
  {"sfa3" ,"Street Fighter Alpha 3 (US 980904)","","Capcom","CPS2","1998",NULL, NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Sfa3RomInfo, Sfa3RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame, CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//===============================
//Street Fighter Alpha 3 (USA r1)
//===============================


static struct BurnRomInfo Sfa3r1RomDesc[]=
{
  {"sz3ux.03"    ,0x80000,0x42994875, 0x10},
  {"sz3ux.04"    ,0x80000,0x86ee79e3, 0x10},

  {"sz3u.03"     ,0x80000,0xb5984a19, 0x10},
  {"sz3u.04"     ,0x80000,0x7e8158ba, 0x10},
  {"sz3.05"      ,0x80000,0x9b21518a, 0x10},
  {"sz3.06"      ,0x80000,0xe7a6c3a7, 0x10},
  {"sz3.07"      ,0x80000,0xec4c0cfd, 0x10},
  {"sz3.08"      ,0x80000,0x5c7e7240, 0x10},
  {"sz3.09"      ,0x80000,0xc5589553, 0x10},
  {"sz3.10"      ,0x80000,0xa9717252, 0x10},

  {"sz3.13"     ,0x400000,0x0f7a60d9,    1},
  {"sz3.15"     ,0x400000,0x8e933741,    1},
  {"sz3.17"     ,0x400000,0xd6e98147,    1},
  {"sz3.19"     ,0x400000,0xf31a728a,    1},
  {"sz3.14"     ,0x400000,0x5ff98297,    1},
  {"sz3.16"     ,0x400000,0x52b5bdee,    1},
  {"sz3.18"     ,0x400000,0x40631ed5,    1},
  {"sz3.20"     ,0x400000,0x763409b4,    1},

  {"sz3.01"     ,0x020000,0xde810084,    1},
  {"sz3.02"     ,0x020000,0x72445dc4,    1},

  {"sz3.11"     ,0x400000,0x1c89eed1,    2},
  {"sz3.12"     ,0x400000,0xf392b13a,    2},
};

STD_ROM_PICK(Sfa3r1) STD_ROM_FN(Sfa3r1)

struct BurnDriver BurnDrvCpsSfa3r1=
{
  {"sfa3r1" ,"Street Fighter Alpha 3 (US 980629)","","Capcom","CPS2","1998","sfa3", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Sfa3r1RomInfo, Sfa3r1RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame, CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//=============================
//Street Fighter Zero 3 (Japan)
//=============================


static struct BurnRomInfo Sfz3jRomDesc[]=
{
  {"sz3jx.03a"    ,0x80000,0xb2f4046d, 0x10},
  {"sz3jx.04a"    ,0x80000,0x85c38642, 0x10},

  {"sz3j.03a"     ,0x80000,0x6ee0beae, 0x10},
  {"sz3j.04a"     ,0x80000,0xa6e2978d, 0x10},
  {"sz3.05a"      ,0x80000,0x05964b7d, 0x10},
  {"sz3.06a"      ,0x80000,0x78ce2179, 0x10},
  {"sz3.07a"      ,0x80000,0x398bf52f, 0x10},
  {"sz3.08a"      ,0x80000,0x866d0588, 0x10},
  {"sz3.09a"      ,0x80000,0x2180892c, 0x10},
  {"sz3.10"      ,0x80000,0xa9717252, 0x10},

  {"sz3.13"     ,0x400000,0x0f7a60d9,    1},
  {"sz3.15"     ,0x400000,0x8e933741,    1},
  {"sz3.17"     ,0x400000,0xd6e98147,    1},
  {"sz3.19"     ,0x400000,0xf31a728a,    1},
  {"sz3.14"     ,0x400000,0x5ff98297,    1},
  {"sz3.16"     ,0x400000,0x52b5bdee,    1},
  {"sz3.18"     ,0x400000,0x40631ed5,    1},
  {"sz3.20"     ,0x400000,0x763409b4,    1},

  {"sz3.01"     ,0x020000,0xde810084,    1},
  {"sz3.02"     ,0x020000,0x72445dc4,    1},

  {"sz3.11"     ,0x400000,0x1c89eed1,    2},
  {"sz3.12"     ,0x400000,0xf392b13a,    2},
};

STD_ROM_PICK(Sfz3j) STD_ROM_FN(Sfz3j)

struct BurnDriver BurnDrvCpsSfz3j=
{
  {"sfz3j" ,"Street Fighter Zero 3 (Japan 980727)","","Capcom","CPS2","1998","sfa3", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Sfz3jRomInfo, Sfz3jRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame, CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//================================
//Street Fighter Zero 3 (Japan r1)
//================================


static struct BurnRomInfo Sfz3jr1RomDesc[]=
{
  {"sz3jx.03"    ,0x80000,0xacd88307, 0x10},
  {"sz3jx.04"    ,0x80000,0x2c15655b, 0x10},

  {"sz3j.03"     ,0x80000,0xf7cb4b13, 0x10},
  {"sz3j.04"     ,0x80000,0x0846c29d, 0x10},
  {"sz3.05"      ,0x80000,0x9b21518a, 0x10},
  {"sz3.06"      ,0x80000,0xe7a6c3a7, 0x10},
  {"sz3.07"      ,0x80000,0xec4c0cfd, 0x10},
  {"sz3.08"      ,0x80000,0x5c7e7240, 0x10},
  {"sz3.09"      ,0x80000,0xc5589553, 0x10},
  {"sz3.10"      ,0x80000,0xa9717252, 0x10},

  {"sz3.13"     ,0x400000,0x0f7a60d9,    1},
  {"sz3.15"     ,0x400000,0x8e933741,    1},
  {"sz3.17"     ,0x400000,0xd6e98147,    1},
  {"sz3.19"     ,0x400000,0xf31a728a,    1},
  {"sz3.14"     ,0x400000,0x5ff98297,    1},
  {"sz3.16"     ,0x400000,0x52b5bdee,    1},
  {"sz3.18"     ,0x400000,0x40631ed5,    1},
  {"sz3.20"     ,0x400000,0x763409b4,    1},

  {"sz3.01"     ,0x020000,0xde810084,    1},
  {"sz3.02"     ,0x020000,0x72445dc4,    1},

  {"sz3.11"     ,0x400000,0x1c89eed1,    2},
  {"sz3.12"     ,0x400000,0xf392b13a,    2},
};

STD_ROM_PICK(Sfz3jr1) STD_ROM_FN(Sfz3jr1)

struct BurnDriver BurnDrvCpsSfz3jr1=
{
  {"sfz3jr1" ,"Street Fighter Zero 3 (Japan 980629)","","Capcom","CPS2","1998","sfa3", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Sfz3jr1RomInfo, Sfz3jr1RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame, CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//================================
//Street Fighter Zero 3 (Asia)
//================================


static struct BurnRomInfo Sfz3aRomDesc[]=
{
  {"sz3ax.03a"   ,0x80000,0xf3ad39ac, 0x10},
  {"sz3ax.04"    ,0x80000,0x792527ca, 0x10},

  {"sz3a.03a"    ,0x80000,0x29c681fd, 0x10},
  {"sz3a.04"     ,0x80000,0x9ddd1484, 0x10},
  {"sz3.05"      ,0x80000,0x9b21518a, 0x10},
  {"sz3.06"      ,0x80000,0xe7a6c3a7, 0x10},
  {"sz3.07"      ,0x80000,0xec4c0cfd, 0x10},
  {"sz3.08"      ,0x80000,0x5c7e7240, 0x10},
  {"sz3.09"      ,0x80000,0xc5589553, 0x10},
  {"sz3.10"      ,0x80000,0xa9717252, 0x10},

  {"sz3.13"     ,0x400000,0x0f7a60d9,    1},
  {"sz3.15"     ,0x400000,0x8e933741,    1},
  {"sz3.17"     ,0x400000,0xd6e98147,    1},
  {"sz3.19"     ,0x400000,0xf31a728a,    1},
  {"sz3.14"     ,0x400000,0x5ff98297,    1},
  {"sz3.16"     ,0x400000,0x52b5bdee,    1},
  {"sz3.18"     ,0x400000,0x40631ed5,    1},
  {"sz3.20"     ,0x400000,0x763409b4,    1},

  {"sz3.01"     ,0x020000,0xde810084,    1},
  {"sz3.02"     ,0x020000,0x72445dc4,    1},

  {"sz3.11"     ,0x400000,0x1c89eed1,    2},
  {"sz3.12"     ,0x400000,0xf392b13a,    2},
};

STD_ROM_PICK(Sfz3a) STD_ROM_FN(Sfz3a)

struct BurnDriver BurnDrvCpsSfz3a=
{
  {"sfz3a" ,"Street Fighter Zero 3 (Asia 980701)","","Capcom","CPS2","1998","sfa3", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Sfz3aRomInfo, Sfz3aRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame, CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
