// Saturday Night Slammasters II

#include "cps.h"

static struct BurnInputInfo DrvInputList[] =
{
  {"P1 Coin"       , 0, CpsInp020+4, "p1 coin"},
  {"P1 Start"      , 0, CpsInp020+0, "p1 start"},
  {"P1 Up"         , 0, CpsInp001+3, "p1 up"},
  {"P1 Down"       , 0, CpsInp001+2, "p1 down"},
  {"P1 Left"       , 0, CpsInp001+1, "p1 left"},
  {"P1 Right"      , 0, CpsInp001+0, "p1 right"},
  {"P1 Fire 1"     , 0, CpsInp001+4, "p1 fire 1"},
  {"P1 Low Kick"   , 0, CpsInp001+5, "p1 fire 2"},
  {"P1 High Kick"  , 0, CpsInp001+6, "p1 fire 3"},
  {"P1 Hold"       , 0, CpsInp011+0, "p1 fire 4"},
  {"P1 Low Punch"  , 0, CpsInp011+1, "p1 fire 5"},
  {"P1 High Punch" , 0, CpsInp011+2, "p1 fire 6"},

  {"P2 Coin"       , 0, CpsInp020+5, "p2 coin"},
  {"P2 Start"      , 0, CpsInp020+1, "p2 start"},
  {"P2 Up"         , 0, CpsInp000+3, "p2 up"},
  {"P2 Down"       , 0, CpsInp000+2, "p2 down"},
  {"P2 Left"       , 0, CpsInp000+1, "p2 left"},
  {"P2 Right"      , 0, CpsInp000+0, "p2 right"},
  {"P2 Fire 1"     , 0, CpsInp000+4, "p2 fire 1"},
  {"P2 Low Kick"   , 0, CpsInp000+5, "p2 fire 2"},
  {"P2 High Kick"  , 0, CpsInp000+6, "p2 fire 3"},
  {"P2 Hold"       , 0, CpsInp011+4, "p2 fire 4"},
  {"P2 Low Punch"  , 0, CpsInp011+5, "p2 fire 5"},
  {"P2 High Punch" , 0, CpsInp020+6, "p2 fire 6"},

  {"Reset"         , 0, &CpsReset   , "reset"},
  {"Diagnostic"    , 0, CpsInp021+1, "diag"},
  {"Service"       , 0, CpsInp021+2, "service"},
};

STDINPUTINFO(Drv);


static int DrvInit()
{
  int nRet=0; int i=0; unsigned char *pqs=NULL;

  Cps=2;
  nCpsRomLen=  6*0x080000;
  nCpsCodeLen= 3*0x080000;
  nCpsGfxLen=   0x1200000;
  nCpsZRomLen= 2*0x020000;
  nCpsQSamLen= 2*0x200000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  // Load program roms (as they are on the roms) for CpsRom
  for (i=0;i<6;i++)
  { nRet=BurnLoadRom(CpsRom+0x080000*i,3+i,1); if (nRet!=0) return 1; }

  // Make decrypted rom
  memcpy(CpsCode,CpsRom,nCpsCodeLen);
  for (i=0;i<3;i++)
  { nRet=BurnXorRom(CpsCode+i*0x080000,i,1); if (nRet!=0) return 1; }

  // Load graphics roms
  nRet=Cps2LoadTiles(CpsGfx           , 9);
  nRet=Cps2LoadTiles(CpsGfx+ 0x0800000,13);
  nRet=Cps2LoadTiles(CpsGfx+ 0x1000000,17);

  // Load Z80 Roms
  nRet=BurnLoadRom(CpsZRom         ,21,1);
  nRet=BurnLoadRom(CpsZRom+0x020000,22,1);

  // Load Q Sample Roms
  pqs=(unsigned char *)CpsQSam;
  nRet=BurnLoadRom(pqs         ,23,1);
  nRet=BurnLoadRom(pqs+0x200000,24,1);
  BurnByteswap(pqs,nCpsQSamLen);


  nRet=CpsRunInit(); if (nRet!=0) return 1;
  // Ready to go
  return 0;
}

static int DrvExit()
{


  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0;
  return 0;
}

//===========================================
//Slammasters II - Ring Of Destruction (Euro)
//===========================================


static struct BurnRomInfo RingdestRomDesc[]=
{
  {"smbex.03b",0x80000,0x3b1457bd, 0x10}, // xor decryption tables
  {"smbex.04b",0x80000,0x6299eb4e, 0x10},
  {"smbex.05b",0x80000,0xbe4a84d1, 0x10},

  {"smbe.03b" ,0x80000,0xb8016278, 0x10}, // 68000 code (encrypted)
  {"smbe.04b" ,0x80000,0x18c4c447, 0x10},
  {"smbe.05b" ,0x80000,0x18ebda7f, 0x10},
  {"smbe.06b" ,0x80000,0x89c80007, 0x10},
  {"smb.07"  ,0x80000,0xb9a11577, 0x10},
  {"smb.08"  ,0x80000,0xf931b76b, 0x10},

  // graphics:
  {"smb.13"  ,0x200000,0xd9b2d1de,    1}, // 9
  {"smb.15"  ,0x200000,0x9a766d92,    1},
  {"smb.17"  ,0x200000,0x51800f0f,    1},
  {"smb.19"  ,0x200000,0x35757e96,    1},
  {"smb.14"  ,0x200000,0xe5bfd0e7,    1},
  {"smb.16"  ,0x200000,0xc56c0866,    1},
  {"smb.18"  ,0x200000,0x4ded3910,    1},
  {"smb.20"  ,0x200000,0x26ea1ec5,    1},
  {"smb.21"  ,0x080000,0x0a08c5fc,    1},
  {"smb.23"  ,0x080000,0x0911b6c4,    1},
  {"smb.25"  ,0x080000,0x82d6c4ec,    1},
  {"smb.27"  ,0x080000,0x9b48678b,    1},

  // sound - z80 roms
  {"smb.01"  ,0x020000,0x0abc229a,    2}, // 21
  {"smb.02"  ,0x020000,0xd051679a,    2},
  // sound - samples
  {"smb.11"  ,0x200000,0xc56935f9,    2},
  {"smb.12"  ,0x200000,0x955b0782,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Ringdest) STD_ROM_FN(Ringdest)

struct BurnDriver BurnDrvCpsRingdest=
{
  {"ringdest" ,"Ring of Destruction: Slammasters II (Euro 940902)","","Capcom","CPS2","1994",NULL, NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, RingdestRomInfo, RingdestRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//===========================
//Super Muscle Bomber (Japan)
//===========================


static struct BurnRomInfo SmbombRomDesc[]=
{
  {"smbjx.03a",0x80000,0x3600f8d8, 0x10}, // xor decryption tables
  {"smbjx.04a",0x80000,0x6d0f1b81, 0x10},
  {"smbjx.05a",0x80000,0x97f5b4af, 0x10},

  {"smbj.03a" ,0x80000,0x1c5613de, 0x10}, // 68000 code (encrypted)
  {"smbj.04a" ,0x80000,0x29071ed7, 0x10},
  {"smbj.05a" ,0x80000,0xeb20bce4, 0x10},
  {"smbj.06a" ,0x80000,0x94b420cd, 0x10},
  {"smb.07"  ,0x80000,0xb9a11577, 0x10},
  {"smb.08"  ,0x80000,0xf931b76b, 0x10},

  // graphics:
  {"smb.13"  ,0x200000,0xd9b2d1de,    1}, // 9
  {"smb.15"  ,0x200000,0x9a766d92,    1},
  {"smb.17"  ,0x200000,0x51800f0f,    1},
  {"smb.19"  ,0x200000,0x35757e96,    1},
  {"smb.14"  ,0x200000,0xe5bfd0e7,    1},
  {"smb.16"  ,0x200000,0xc56c0866,    1},
  {"smb.18"  ,0x200000,0x4ded3910,    1},
  {"smb.20"  ,0x200000,0x26ea1ec5,    1},
  {"smb.21"  ,0x080000,0x0a08c5fc,    1},
  {"smb.23"  ,0x080000,0x0911b6c4,    1},
  {"smb.25"  ,0x080000,0x82d6c4ec,    1},
  {"smb.27"  ,0x080000,0x9b48678b,    1},

  // sound - z80 roms
  {"smb.01"  ,0x020000,0x0abc229a,    2}, // 21
  {"smb.02"  ,0x020000,0xd051679a,    2},
  // sound - samples
  {"smb.11"  ,0x200000,0xc56935f9,    2},
  {"smb.12"  ,0x200000,0x955b0782,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Smbomb) STD_ROM_FN(Smbomb)

struct BurnDriver BurnDrvCpsSmbomb=
{
  {"smbomb" ,"Super Muscle Bomber: The International Blowout (Japan 940831)","","Capcom","CPS2","1994","ringdest", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, SmbombRomInfo, SmbombRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//==============================
//Super Muscle Bomber (Japan r1)
//==============================


static struct BurnRomInfo Smbombr1RomDesc[]=
{
  {"smbjx.03",0x80000,0xb0b67439, 0x10},
  {"smbjx.04",0x80000,0xa012f690, 0x10},
  {"smbjx.05",0x80000,0xf6e886d0, 0x10},

  {"smbj.03" ,0x80000,0x52eafb10, 0x10},
  {"smbj.04" ,0x80000,0xaa6e8078, 0x10},
  {"smbj.05" ,0x80000,0xb69e7d5f, 0x10},
  {"smbj.06" ,0x80000,0x8d857b56, 0x10},
  {"smb.07"  ,0x80000,0xb9a11577, 0x10},
  {"smb.08"  ,0x80000,0xf931b76b, 0x10},

  {"smb.13"  ,0x200000,0xd9b2d1de,    1},
  {"smb.15"  ,0x200000,0x9a766d92,    1},
  {"smb.17"  ,0x200000,0x51800f0f,    1},
  {"smb.19"  ,0x200000,0x35757e96,    1},
  {"smb.14"  ,0x200000,0xe5bfd0e7,    1},
  {"smb.16"  ,0x200000,0xc56c0866,    1},
  {"smb.18"  ,0x200000,0x4ded3910,    1},
  {"smb.20"  ,0x200000,0x26ea1ec5,    1},
  {"smb.21"  ,0x080000,0x0a08c5fc,    1},
  {"smb.23"  ,0x080000,0x0911b6c4,    1},
  {"smb.25"  ,0x080000,0x82d6c4ec,    1},
  {"smb.27"  ,0x080000,0x9b48678b,    1},

  {"smb.01"  ,0x020000,0x0abc229a,    2},
  {"smb.02"  ,0x020000,0xd051679a,    2},

  {"smb.11"  ,0x200000,0xc56935f9,    2},
  {"smb.12"  ,0x200000,0x955b0782,    2},
};

STD_ROM_PICK(Smbombr1) STD_ROM_FN(Smbombr1)

struct BurnDriver BurnDrvCpsSmbombr1=
{
  {"smbombr1" ,"Super Muscle Bomber: The International Blowout (Japan 940808)","","Capcom","CPS2","1994","ringdest", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Smbombr1RomInfo, Smbombr1RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
