#include "cps.h"
// Quiz Nanairo Dreams

static struct BurnInputInfo DrvInputList[] =
{
  {"P1 Coin"       , 0, CpsInp020+4, "p1 coin"},
  {"P1 Start"      , 0, CpsInp020+0, "p1 start"},
  {"P1 Answer 1"   , 0, CpsInp001+4, "p1 fire 1"},
  {"P1 Answer 2"   , 0, CpsInp001+5, "p1 fire 2"},
  {"P1 Answer 3"   , 0, CpsInp001+6, "p1 fire 3"},
  {"P1 Answer 4"   , 0, CpsInp001+7, "p1 fire 4"},

  {"P2 Coin"       , 0, CpsInp020+5, "p2 coin"},
  {"P2 Start"      , 0, CpsInp020+1, "p2 start"},
  {"P2 Answer 1"   , 0, CpsInp000+4, "p2 fire 1"},
  {"P2 Answer 2"   , 0, CpsInp000+5, "p2 fire 2"},
  {"P2 Answer 3"   , 0, CpsInp000+6, "p2 fire 3"},
  {"P2 Answer 4"   , 0, CpsInp000+7, "p2 fire 4"},

  {"Reset"         , 0, &CpsReset,   "reset"},
  {"Diagnostic"    , 0, CpsInp021+1, "diag"},
  {"Service"       , 0, CpsInp021+2, "service"},
};

STDINPUTINFO(Drv);


static int DrvInit()
{
  int nRet=0; int i=0; unsigned char *pqs=NULL;
  Cps=2;
  nCpsRomLen=  4*0x080000;
  nCpsCodeLen= 1*0x080000;
  nCpsGfxLen=    0x800000;
  nCpsZRomLen= 1*0x020000;
  nCpsQSamLen= 2*0x200000; // Length in samples
  nRet=CpsInit(); if (nRet!=0) return 1;

  // Load program roms (as they are on the roms) for CpsRom
  for (i=0;i<4;i++)
  { nRet=BurnLoadRom(CpsRom+0x080000*i,1+i,1); if (nRet!=0) return 1; }

  // Make decrypted rom
  memcpy(CpsCode,CpsRom,nCpsCodeLen);
  nRet=BurnXorRom(CpsCode,0,1); if (nRet!=0) return 1;

  // Load graphics roms
  Cps2LoadTiles(CpsGfx,5);

  // Load Z80 Roms
  nRet=BurnLoadRom(CpsZRom         , 9,1);

  // Load Q Sample Roms
  pqs=(unsigned char *)CpsQSam;
  nRet=BurnLoadRom(pqs         ,10,1);
  nRet=BurnLoadRom(pqs+0x200000,11,1);
  BurnByteswap(pqs,nCpsQSamLen);


  nRet=CpsRunInit(); if (nRet!=0) return 1;
  // Ready to go
  return 0;
}

static int DrvExit()
{

  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0;
  return 0;
}


static struct BurnRomInfo DrvRomDesc[]=
{
  {"tqzjx.03a" ,0x80000,0x5804a8f8, 0x10}, // xor decryption table
  {"tqzj.03a"  ,0x80000,0x7acf3e30, 0x10}, // 68000 code (encrypted)
  {"tqzj.04"  ,0x80000,0xf1044a87, 0x10},
  {"tqzj.05"  ,0x80000,0x4105ba0e, 0x10},
  {"tqzj.06"  ,0x80000,0xc371e8a5, 0x10},

  // graphics:
  {"tqz.14"  ,0x200000,0x98af88a2,    1}, //  5
  {"tqz.16"  ,0x200000,0xdf82d491,    1},
  {"tqz.18"  ,0x200000,0x42f132ff,    1},
  {"tqz.20"  ,0x200000,0xb2e128a3,    1},

  // sound - z80 roms
  {"tqz.01"  ,0x020000,0xe9ce9d0a,    2}, //  9
  // sound - samples
  {"tqz.11"  ,0x200000,0x78e7884f,    2}, // 10
  {"tqz.12"  ,0x200000,0x2e049b13,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Drv) STD_ROM_FN(Drv)

struct BurnDriver BurnDrvCpsQndream=
{
  {"qndream","Quiz Nanairo Dreams: Nijiirotyou no Kiseki (Japan 960826)","","Capcom","CPS2","1996",NULL, NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, DrvRomInfo, DrvRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
// -------------------------------------------------------
