#include "cps.h"

/*=====================================
 Marvel Super Heroes Vs. Street Fighter
 All-in-One Driver 1.30 by LoopMaster
=====================================*/

STDINPUTINFOSPEC(Drv, CpsFsi);


static int DrvInit()
{
 int nRet=0; int i=0; unsigned char *pqs=NULL;

 Cps=2;
 nCpsRomLen=  8*0x080000;
 nCpsCodeLen= 2*0x080000;
 nCpsGfxLen=  8*0x400000;
 nCpsZRomLen= 2*0x020000;
 nCpsQSamLen= 2*0x400000;
 nRet=CpsInit(); if (nRet!=0) return 1;

 // Load program roms (as they are on the roms) for CpsRom
 for (i=0;i<8;i++)
 { nRet=BurnLoadRom(CpsRom+0x080000*i,2+i,1); if (nRet!=0) return 1; }

 // Make decrypted rom
 memcpy(CpsCode,CpsRom,nCpsCodeLen);
 nRet=BurnXorRom(CpsCode         ,0,1); if (nRet!=0) return 1;
 nRet=BurnXorRom(CpsCode+0x080000,1,1); if (nRet!=0) return 1;

 // Load graphics roms
 nRet=Cps2LoadTiles(CpsGfx           ,10);
 nRet=Cps2LoadTiles(CpsGfx+4*0x400000,14);

 // Load Z80 Roms
 nRet=BurnLoadRom(CpsZRom         ,18,1);
 nRet=BurnLoadRom(CpsZRom+ 0x20000,19,1);

 // Load Q Sample Roms
 pqs=(unsigned char *)CpsQSam;
 nRet=BurnLoadRom(pqs         ,20,1);
 nRet=BurnLoadRom(pqs+0x400000,21,1);
 BurnByteswap(pqs,nCpsQSamLen);

 nRet=CpsRunInit();

 if (nRet!=0) return 1;
 // Ready to go
 return 0;
}

static int DrvExit()
{

  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0;
  return 0;
}


/*============================================
Marvel Super Heroes  Vs. Street Fighter (USA)
============================================*/


static struct BurnRomInfo MshvsfRomDesc[]=
{
  {"mvsux.03g",0x80000,0x17b12a95, 0x10},
  {"mvsux.04g",0x80000,0xf98200cf, 0x10},

  {"mvsu.03g" ,0x80000,0x0664ab15, 0x10},
  {"mvsu.04g" ,0x80000,0x97e060ee, 0x10},
  {"mvs.05d"  ,0x80000,0x921fc542, 0x10},
  {"mvs.06a"  ,0x80000,0x959f3030, 0x10},
  {"mvs.07b"  ,0x80000,0x7f915bdb, 0x10},
  {"mvs.08a"  ,0x80000,0xc2813884, 0x10},
  {"mvs.09b"  ,0x80000,0x3ba08818, 0x10},
  {"mvs.10b"  ,0x80000,0xcf0dba98, 0x10},

  {"mvs.13"  ,0x400000,0x29b05fd9,    1},
  {"mvs.15"  ,0x400000,0xfaddccf1,    1},
  {"mvs.17"  ,0x400000,0x97aaf4c7,    1},
  {"mvs.19"  ,0x400000,0xcb70e915,    1},
  {"mvs.14"  ,0x400000,0xb3b1972d,    1},
  {"mvs.16"  ,0x400000,0x08aadb5d,    1},
  {"mvs.18"  ,0x400000,0xc1228b35,    1},
  {"mvs.20"  ,0x400000,0x366cc6c2,    1},

  {"mvs.01"  ,0x020000,0x68252324,    2},
  {"mvs.02"  ,0x020000,0xb34e773d,    2},

  {"mvs.11"  ,0x400000,0x86219770,    2},
  {"mvs.12"  ,0x400000,0xf2fd7f68,    2},
};

STD_ROM_PICK(Mshvsf) STD_ROM_FN(Mshvsf)

struct BurnDriver BurnDrvCpsMshvsf=
{
  {"mshvsf" ,"Marvel Super Heroes Vs. Street Fighter (US 970827)","","Capcom","CPS2","1997",NULL, NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, MshvsfRomInfo, MshvsfRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*============================================
Marvel Super Heroes  Vs. Street Fighter (USA r1)
============================================*/


static struct BurnRomInfo Mshvsfu1RomDesc[]=
{
  {"mvsux.03d",0x80000,0x281bcb48, 0x10},
  {"mvsux.04d",0x80000,0xa2d68628, 0x10},

  {"mvsu.03d" ,0x80000,0xae60a66a, 0x10},
  {"mvsu.04d" ,0x80000,0x91f67d8a, 0x10},
  {"mvs.05a"  ,0x80000,0x1a5de0cb, 0x10},
  {"mvs.06a"  ,0x80000,0x959f3030, 0x10},
  {"mvs.07b"  ,0x80000,0x7f915bdb, 0x10},
  {"mvs.08a"  ,0x80000,0xc2813884, 0x10},
  {"mvs.09b"  ,0x80000,0x3ba08818, 0x10},
  {"mvs.10b"  ,0x80000,0xcf0dba98, 0x10},

  {"mvs.13"  ,0x400000,0x29b05fd9,    1},
  {"mvs.15"  ,0x400000,0xfaddccf1,    1},
  {"mvs.17"  ,0x400000,0x97aaf4c7,    1},
  {"mvs.19"  ,0x400000,0xcb70e915,    1},
  {"mvs.14"  ,0x400000,0xb3b1972d,    1},
  {"mvs.16"  ,0x400000,0x08aadb5d,    1},
  {"mvs.18"  ,0x400000,0xc1228b35,    1},
  {"mvs.20"  ,0x400000,0x366cc6c2,    1},

  {"mvs.01"  ,0x020000,0x68252324,    2},
  {"mvs.02"  ,0x020000,0xb34e773d,    2},

  {"mvs.11"  ,0x400000,0x86219770,    2},
  {"mvs.12"  ,0x400000,0xf2fd7f68,    2},
};

STD_ROM_PICK(Mshvsfu1) STD_ROM_FN(Mshvsfu1)

struct BurnDriver BurnDrvCpsMshvsfu1=
{
  {"mshvsfu1" ,"Marvel Super Heroes Vs. Street Fighter (US 970625)","","Capcom","CPS2","1997","mshvsf", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Mshvsfu1RomInfo, Mshvsfu1RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*==============================================
Marvel Super Heroes  Vs. Street Fighter (Japan)
==============================================*/


static struct BurnRomInfo MshvsfjRomDesc[]=
{
  {"mvsjx.03i",0x80000,0x55170c4c, 0x10},
  {"mvsjx.04i",0x80000,0xe7883768, 0x10},

  {"mvsj.03i" ,0x80000,0xd8cbb691, 0x10},
  {"mvsj.04i" ,0x80000,0x32741ace, 0x10},
  {"mvs.05h"  ,0x80000,0x77870dc3, 0x10},
  {"mvs.06a"  ,0x80000,0x959f3030, 0x10},
  {"mvs.07b"  ,0x80000,0x7f915bdb, 0x10},
  {"mvs.08a"  ,0x80000,0xc2813884, 0x10},
  {"mvs.09b"  ,0x80000,0x3ba08818, 0x10},
  {"mvs.10b"  ,0x80000,0xcf0dba98, 0x10},

  {"mvs.13"  ,0x400000,0x29b05fd9,    1},
  {"mvs.15"  ,0x400000,0xfaddccf1,    1},
  {"mvs.17"  ,0x400000,0x97aaf4c7,    1},
  {"mvs.19"  ,0x400000,0xcb70e915,    1},
  {"mvs.14"  ,0x400000,0xb3b1972d,    1},
  {"mvs.16"  ,0x400000,0x08aadb5d,    1},
  {"mvs.18"  ,0x400000,0xc1228b35,    1},
  {"mvs.20"  ,0x400000,0x366cc6c2,    1},

  {"mvs.01"  ,0x020000,0x68252324,    2},
  {"mvs.02"  ,0x020000,0xb34e773d,    2},

  {"mvs.11"  ,0x400000,0x86219770,    2},
  {"mvs.12"  ,0x400000,0xf2fd7f68,    2},
};

STD_ROM_PICK(Mshvsfj) STD_ROM_FN(Mshvsfj)

struct BurnDriver BurnDrvCpsMshvsfj=
{
  {"mshvsfj" ,"Marvel Super Heroes Vs. Street Fighter (Japan 970707)","","Capcom","CPS2","1997","mshvsf", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, MshvsfjRomInfo, MshvsfjRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*=================================================
Marvel Super Heroes  Vs. Street Fighter (Japan r1)
=================================================*/


static struct BurnRomInfo Mshvsfj1RomDesc[]=
{
  {"mvsjx.03h",0x80000,0x6b4201c1, 0x10},
  {"mvsjx.04h",0x80000,0xab1b04cc, 0x10},

  {"mvsj.03h" ,0x80000,0xfbe2115f, 0x10},
  {"mvsj.04h" ,0x80000,0xb528a367, 0x10},
  {"mvs.05g"  ,0x80000,0x9515a245, 0x10},
  {"mvs.06a"  ,0x80000,0x959f3030, 0x10},
  {"mvs.07b"  ,0x80000,0x7f915bdb, 0x10},
  {"mvs.08a"  ,0x80000,0xc2813884, 0x10},
  {"mvs.09b"  ,0x80000,0x3ba08818, 0x10},
  {"mvs.10b"  ,0x80000,0xcf0dba98, 0x10},

  {"mvs.13"  ,0x400000,0x29b05fd9,    1},
  {"mvs.15"  ,0x400000,0xfaddccf1,    1},
  {"mvs.17"  ,0x400000,0x97aaf4c7,    1},
  {"mvs.19"  ,0x400000,0xcb70e915,    1},
  {"mvs.14"  ,0x400000,0xb3b1972d,    1},
  {"mvs.16"  ,0x400000,0x08aadb5d,    1},
  {"mvs.18"  ,0x400000,0xc1228b35,    1},
  {"mvs.20"  ,0x400000,0x366cc6c2,    1},

  {"mvs.01"  ,0x020000,0x68252324,    2},
  {"mvs.02"  ,0x020000,0xb34e773d,    2},

  {"mvs.11"  ,0x400000,0x86219770,    2},
  {"mvs.12"  ,0x400000,0xf2fd7f68,    2},
};

STD_ROM_PICK(Mshvsfj1) STD_ROM_FN(Mshvsfj1)

struct BurnDriver BurnDrvCpsMshvsfj1=
{
  {"mshvsfj1" ,"Marvel Super Heroes Vs. Street Fighter (Japan 970702)","","Capcom","CPS2","1997","mshvsf", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Mshvsfj1RomInfo, Mshvsfj1RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*===========================================================
Marvel Super Heroes  Vs. Street Fighter (Hispanic) Encrypted
===========================================================*/


static struct BurnRomInfo MshvsfhRomDesc[]=
{
  {"mvshx.03f",0x80000,0x00000000, 0x10},
  {"mvshx.04f",0x80000,0x00000000, 0x10},

  {"mvsh.03f" ,0x80000,0x4f60f41e, 0x10},
  {"mvsh.04f" ,0x80000,0xdc08ec12, 0x10},
  {"mvs.05a"  ,0x80000,0x1a5de0cb, 0x10},
  {"mvs.06a"  ,0x80000,0x959f3030, 0x10},
  {"mvs.07b"  ,0x80000,0x7f915bdb, 0x10},
  {"mvs.08a"  ,0x80000,0xc2813884, 0x10},
  {"mvs.09b"  ,0x80000,0x3ba08818, 0x10},
  {"mvs.10b"  ,0x80000,0xcf0dba98, 0x10},

  {"mvs.13"  ,0x400000,0x29b05fd9,    1},
  {"mvs.15"  ,0x400000,0xfaddccf1,    1},
  {"mvs.17"  ,0x400000,0x97aaf4c7,    1},
  {"mvs.19"  ,0x400000,0xcb70e915,    1},
  {"mvs.14"  ,0x400000,0xb3b1972d,    1},
  {"mvs.16"  ,0x400000,0x08aadb5d,    1},
  {"mvs.18"  ,0x400000,0xc1228b35,    1},
  {"mvs.20"  ,0x400000,0x366cc6c2,    1},

  {"mvs.01"  ,0x020000,0x68252324,    2},
  {"mvs.02"  ,0x020000,0xb34e773d,    2},

  {"mvs.11"  ,0x400000,0x86219770,    2},
  {"mvs.12"  ,0x400000,0xf2fd7f68,    2},
};

STD_ROM_PICK(Mshvsfh) STD_ROM_FN(Mshvsfh)

struct BurnDriverX BurnDrvCpsMshvsfh=
{
  {"mshvsfh" ,"Marvel Super Heroes Vs. Street Fighter (Hispanic 970625)","Encrypted","Capcom","CPS2","1997","mshvsf", NULL},
  0,2,HARDWARE_CAPCOM_CPS2,
  NULL, MshvsfhRomInfo, MshvsfhRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*=======================================================
Marvel Super Heroes  Vs. Street Fighter (Asia) Encrypted
=======================================================*/


static struct BurnRomInfo MshvsfaRomDesc[]=
{
  {"mvsax.03d",0x80000,0x00000000, 0x10},
  {"mvsax.04d",0x80000,0x00000000, 0x10},

  {"mvsa.03d" ,0x80000,0x5b863716, 0x10},
  {"mvsa.04d" ,0x80000,0x4886e65f, 0x10},
  {"mvs.05a"  ,0x80000,0x1a5de0cb, 0x10},
  {"mvs.06a"  ,0x80000,0x959f3030, 0x10},
  {"mvs.07b"  ,0x80000,0x7f915bdb, 0x10},
  {"mvs.08a"  ,0x80000,0xc2813884, 0x10},
  {"mvs.09b"  ,0x80000,0x3ba08818, 0x10},
  {"mvs.10b"  ,0x80000,0xcf0dba98, 0x10},

  {"mvs.13"  ,0x400000,0x29b05fd9,    1},
  {"mvs.15"  ,0x400000,0xfaddccf1,    1},
  {"mvs.17"  ,0x400000,0x97aaf4c7,    1},
  {"mvs.19"  ,0x400000,0xcb70e915,    1},
  {"mvs.14"  ,0x400000,0xb3b1972d,    1},
  {"mvs.16"  ,0x400000,0x08aadb5d,    1},
  {"mvs.18"  ,0x400000,0xc1228b35,    1},
  {"mvs.20"  ,0x400000,0x366cc6c2,    1},

  {"mvs.01"  ,0x020000,0x68252324,    2},
  {"mvs.02"  ,0x020000,0xb34e773d,    2},

  {"mvs.11"  ,0x400000,0x86219770,    2},
  {"mvs.12"  ,0x400000,0xf2fd7f68,    2},
};

STD_ROM_PICK(Mshvsfa) STD_ROM_FN(Mshvsfa)

struct BurnDriverX BurnDrvCpsMshvsfa=
{
  {"mshvsfa" ,"Marvel Super Heroes Vs. Street Fighter (Asia 970625)","Encrypted","Capcom","CPS2","1997","mshvsf", NULL},
  0,2,HARDWARE_CAPCOM_CPS2,
  NULL, MshvsfaRomInfo, MshvsfaRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*==========================================================
Marvel Super Heroes  Vs. Street Fighter (Asia r1) Encrypted
==========================================================*/


static struct BurnRomInfo Mshvsfa1RomDesc[]=
{
  {"mvsax.03d",0x80000,0x00000000, 0x10},
  {"mvsax.04d",0x80000,0x00000000, 0x10},

  {"mvsa.03"  ,0x80000,0x92ef1933, 0x10},
  {"mvsa.04"  ,0x80000,0x4b24373c, 0x10},
  {"mvs.05"   ,0x80000,0xac180c1c, 0x10},
  {"mvs.06a"  ,0x80000,0x959f3030, 0x10},
  {"mvs.07b"  ,0x80000,0x7f915bdb, 0x10},
  {"mvs.08a"  ,0x80000,0xc2813884, 0x10},
  {"mvs.09b"  ,0x80000,0x3ba08818, 0x10},
  {"mvs.10b"  ,0x80000,0xcf0dba98, 0x10},

  {"mvs.13"  ,0x400000,0x29b05fd9,    1},
  {"mvs.15"  ,0x400000,0xfaddccf1,    1},
  {"mvs.17"  ,0x400000,0x97aaf4c7,    1},
  {"mvs.19"  ,0x400000,0xcb70e915,    1},
  {"mvs.14"  ,0x400000,0xb3b1972d,    1},
  {"mvs.16"  ,0x400000,0x08aadb5d,    1},
  {"mvs.18"  ,0x400000,0xc1228b35,    1},
  {"mvs.20"  ,0x400000,0x366cc6c2,    1},

  {"mvs.01"  ,0x020000,0x68252324,    2},
  {"mvs.02"  ,0x020000,0xb34e773d,    2},

  {"mvs.11"  ,0x400000,0x86219770,    2},
  {"mvs.12"  ,0x400000,0xf2fd7f68,    2},
};

STD_ROM_PICK(Mshvsfa1) STD_ROM_FN(Mshvsfa1)

struct BurnDriverX BurnDrvCpsMshvsfa1=
{
  {"mshvsfa1" ,"Marvel Super Heroes Vs. Street Fighter (Asia 970620)","Encrypted","Capcom","CPS2","1997","mshvsf", NULL},
  0,2,HARDWARE_CAPCOM_CPS2,
  NULL, Mshvsfa1RomInfo, Mshvsfa1RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
