#include "cps.h"

/*==============================================
 19XX
==============================================*/

static struct BurnInputInfo DrvInputList[] =
{
  {"P1 Coin"       , 0, CpsInp020+4, "p1 coin"  },
  {"P1 Start"      , 0, CpsInp020+0, "p1 start" },
  {"P1 Up"         , 0, CpsInp001+3, "p1 up"    },
  {"P1 Down"       , 0, CpsInp001+2, "p1 down"  },
  {"P1 Left"       , 0, CpsInp001+1, "p1 left"  },
  {"P1 Right"      , 0, CpsInp001+0, "p1 right" },
  {"P1 Shot"       , 0, CpsInp001+4, "p1 fire 1"},
  {"P1 Bomb"       , 0, CpsInp001+5, "p1 fire 2"},

  {"P2 Coin"       , 0, CpsInp020+5, "p2 coin"  },
  {"P2 Start"      , 0, CpsInp020+1, "p2 start" },
  {"P2 Up"         , 0, CpsInp000+3, "p2 up"    },
  {"P2 Down"       , 0, CpsInp000+2, "p2 down"  },
  {"P2 Left"       , 0, CpsInp000+1, "p2 left"  },
  {"P2 Right"      , 0, CpsInp000+0, "p2 right" },
  {"P2 Shot"       , 0, CpsInp000+4, "p2 fire 1"},
  {"P2 Bomb"       , 0, CpsInp000+5, "p2 fire 2"},

  {"Reset"         , 0, &CpsReset  , "reset"    },
  {"Diagnostic"    , 0, CpsInp021+1, "diag"     },
  {"Service"       , 0, CpsInp021+2, "service"  },
};

STDINPUTINFO(Drv);


static int DrvInit()
{
  int nRet=0; int i=0; unsigned char *pqs=NULL;

  Cps=2;
  nCpsRomLen=  5*0x080000;
  nCpsCodeLen= 4*0x080000;
  nCpsGfxLen=   0x1000000;
  nCpsZRomLen= 1*0x020000;
  nCpsQSamLen= 2*0x200000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  for (i=0;i<5;i++)
  { nRet=BurnLoadRom(CpsRom+0x080000*i,4+i,1); if (nRet!=0) return 1; }

  memcpy(CpsCode,CpsRom,nCpsCodeLen);
  for (i=0;i<4;i++)
  { nRet=BurnXorRom(CpsCode+0x080000*i,0+i,1); if (nRet!=0) return 1; }

  nRet=Cps2LoadTiles(CpsGfx          , 9);
  nRet=Cps2LoadTiles(CpsGfx+0x0800000,13);

  nRet=BurnLoadRom(CpsZRom,17,1);

  pqs=(unsigned char *)CpsQSam;
  nRet=BurnLoadRom(pqs         ,18,1);
  nRet=BurnLoadRom(pqs+0x200000,19,1);
  BurnByteswap(pqs,nCpsQSamLen);




  nRet=CpsRunInit(); if (nRet!=0) return 1;
  return 0;
}

static int DrvExit()
{


  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0;

  return 0;
}


/*==========
 19XX (USA)
==========*/


static struct BurnRomInfo NinexxRomDesc[]=
{

  {"19xux.03" ,0x80000,0x239a08ae, 0x10},
  {"19xux.04" ,0x80000,0xc13a1072, 0x10},
  {"19xux.05" ,0x80000,0x8c066ec3, 0x10},
  {"19xux.06" ,0x80000,0x4b1caeb9, 0x10},

  {"19xu.03"  ,0x80000,0x05955268, 0x10},
  {"19xu.04"  ,0x80000,0x3111ab7f, 0x10},
  {"19xu.05"  ,0x80000,0x38df4a63, 0x10},
  {"19xu.06"  ,0x80000,0x5c7e60d3, 0x10},
  {"19x.07"   ,0x80000,0x61c0296c, 0x10},

  {"19x.13"  ,0x080000,0x427aeb18,    1},
  {"19x.15"  ,0x080000,0x63bdbf54,    1},
  {"19x.17"  ,0x080000,0x2dfe18b5,    1},
  {"19x.19"  ,0x080000,0xcbef9579,    1},
  {"19x.14"  ,0x200000,0xe916967c,    1},
  {"19x.16"  ,0x200000,0x6e75f3db,    1},
  {"19x.18"  ,0x200000,0x2213e798,    1},
  {"19x.20"  ,0x200000,0xab9d5b96,    1},

  {"19x.01"  ,0x020000,0xef55195e,    2},

  {"19x.11"  ,0x200000,0xd38beef3,    2},
  {"19x.12"  ,0x200000,0xd47c96e2,    2},
};

STD_ROM_PICK(Ninexx) STD_ROM_FN(Ninexx)

struct BurnDriver BurnDrvCps19xx=
{
  {"19xx" ,"19XX: The War Against Destiny (US 951207)","","Capcom","CPS2","1995",NULL, NULL},
  BDF_GAME_WORKING | BDF_ROTATE_GRAPHICS_CCW, 2, HARDWARE_CAPCOM_CPS2,
  NULL, NinexxRomInfo, NinexxRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,224,384,3,4
};

/*===============
 19XX (Hispanic)
===============*/


static struct BurnRomInfo NinexxhRomDesc[]=
{

  {"19xhx.03a" ,0x80000,0x374ce871, 0x10},
  {"19xhx.04a" ,0x80000,0xebd16e33, 0x10},
  {"19xhx.05a" ,0x80000,0x0bb5ad27, 0x10},
  {"19xhx.06a" ,0x80000,0x3663c8d2, 0x10},

  {"19xh.03a"  ,0x80000,0x357be2ac, 0x10},
  {"19xh.04a"  ,0x80000,0xbb13ea3b, 0x10},
  {"19xh.05a"  ,0x80000,0xcbd76601, 0x10},
  {"19xh.06a"  ,0x80000,0xb362de8b, 0x10},
  {"19x.07"    ,0x80000,0x61c0296c, 0x10},

  {"19x.13"  ,0x080000,0x427aeb18,     1},
  {"19x.15"  ,0x080000,0x63bdbf54,     1},
  {"19x.17"  ,0x080000,0x2dfe18b5,     1},
  {"19x.19"  ,0x080000,0xcbef9579,     1},
  {"19x.14"  ,0x200000,0xe916967c,     1},
  {"19x.16"  ,0x200000,0x6e75f3db,     1},
  {"19x.18"  ,0x200000,0x2213e798,     1},
  {"19x.20"  ,0x200000,0xab9d5b96,     1},

  {"19x.01"  ,0x020000,0xef55195e,     2},

  {"19x.11"  ,0x200000,0xd38beef3,     2},
  {"19x.12"  ,0x200000,0xd47c96e2,     2},
};

STD_ROM_PICK(Ninexxh) STD_ROM_FN(Ninexxh)

struct BurnDriver BurnDrvCps19xxh=
{
  {"19xxh" ,"19XX: The War Against Destiny (Hispanic 951218)","","Capcom","CPS2","1995","19xx", NULL},
  BDF_GAME_WORKING | BDF_ROTATE_GRAPHICS_CCW, 2, HARDWARE_CAPCOM_CPS2,
  NULL, NinexxhRomInfo, NinexxhRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,224,384,3,4
};


/*======================
 19XX (Japan) Encrypted
======================*/


static struct BurnRomInfo NinexxjRomDesc[]=
{

  {"19xjx.03a" ,0x80000,0x00000000, 0x10},
  {"19xjx.04a" ,0x80000,0x00000000, 0x10},
  {"19xjx.05a" ,0x80000,0x00000000, 0x10},
  {"19xjx.06a" ,0x80000,0x00000000, 0x10},

  {"19xj.03a"  ,0x80000,0xed08bdd1, 0x10},
  {"19xj.04a"  ,0x80000,0x5254caab, 0x10},
  {"19xj.05a"  ,0x80000,0xaa508ac4, 0x10},
  {"19xj.06a"  ,0x80000,0xff2d785b, 0x10},
  {"19x.07"    ,0x80000,0x61c0296c, 0x10},

  {"19x.13"  ,0x080000,0x427aeb18,     1},
  {"19x.15"  ,0x080000,0x63bdbf54,     1},
  {"19x.17"  ,0x080000,0x2dfe18b5,     1},
  {"19x.19"  ,0x080000,0xcbef9579,     1},
  {"19x.14"  ,0x200000,0xe916967c,     1},
  {"19x.16"  ,0x200000,0x6e75f3db,     1},
  {"19x.18"  ,0x200000,0x2213e798,     1},
  {"19x.20"  ,0x200000,0xab9d5b96,     1},

  {"19x.01"  ,0x020000,0xef55195e,     2},

  {"19x.11"  ,0x200000,0xd38beef3,     2},
  {"19x.12"  ,0x200000,0xd47c96e2,     2},
};

STD_ROM_PICK(Ninexxj) STD_ROM_FN(Ninexxj)

struct BurnDriverX BurnDrvCps19xxj=
{
  {"19xxj" ,"19XX: The War Against Destiny (Japan 951225)","Encrypted","Capcom","CPS2","1995","19xx", NULL},
  BDF_ROTATE_GRAPHICS_CCW, 2, HARDWARE_CAPCOM_CPS2,
  NULL, NinexxjRomInfo, NinexxjRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,224,384,3,4
};

/*=========================
 19XX (Japan r1) Encrypted
=========================*/


static struct BurnRomInfo Ninexxjr1RomDesc[]=
{

  {"19xjx.03"  ,0x80000,0x00000000, 0x10},
  {"19xjx.04"  ,0x80000,0x00000000, 0x10},
  {"19xjx.05"  ,0x80000,0x00000000, 0x10},
  {"19xjx.06"  ,0x80000,0x00000000, 0x10},

  {"19xj.03"   ,0x80000,0x26a381ed, 0x10},
  {"19xj.04"   ,0x80000,0x30100cca, 0x10},
  {"19xj.05"   ,0x80000,0xde67e938, 0x10},
  {"19xj.06"   ,0x80000,0x39f9a409, 0x10},
  {"19x.07"    ,0x80000,0x61c0296c, 0x10},

  {"19x.13"  ,0x080000,0x427aeb18,     1},
  {"19x.15"  ,0x080000,0x63bdbf54,     1},
  {"19x.17"  ,0x080000,0x2dfe18b5,     1},
  {"19x.19"  ,0x080000,0xcbef9579,     1},
  {"19x.14"  ,0x200000,0xe916967c,     1},
  {"19x.16"  ,0x200000,0x6e75f3db,     1},
  {"19x.18"  ,0x200000,0x2213e798,     1},
  {"19x.20"  ,0x200000,0xab9d5b96,     1},

  {"19x.01"  ,0x020000,0xef55195e,     2},

  {"19x.11"  ,0x200000,0xd38beef3,     2},
  {"19x.12"  ,0x200000,0xd47c96e2,     2},
};

STD_ROM_PICK(Ninexxjr1) STD_ROM_FN(Ninexxjr1)

struct BurnDriverX BurnDrvCps19xxjr1=
{
  {"19xxjr1" ,"19XX: The War Against Destiny (Japan 951207)","Encrypted","Capcom","CPS2","1995","19xx", NULL},
  BDF_ROTATE_GRAPHICS_CCW, 2, HARDWARE_CAPCOM_CPS2,
  NULL, Ninexxjr1RomInfo, Ninexxjr1RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,224,384,3,4
};
