// Burn - Arcade emulator library - internal code

// Standard headers
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "burn.h"

#ifdef _MSC_VER
 #undef for
 #define for if (0) {} else for

 #pragma warning (disable:4514) // Disable "unreferenced inline function removed" warning message
 #pragma warning(disable:4201)
 #pragma warning(disable:4127)
 #pragma warning(disable:4800)
 #pragma warning(disable:4244)

 #include <conio.h>
 #define printf 
#endif

#ifndef MAX_PATH
 #define MAX_PATH 260
#endif

// Compensate for Windows' need to be different from the rest of the world.
#ifdef _MSC_VER

 #undef strcasecmp
 #define strcasecmp _stricmp

 #undef strncasecmp
 #define strncasecmp _strnicmp

#endif

#ifdef __GNUC__

 #undef _strncmpi
 #define _strncmpi strncasecmp

 #undef _strnicmp
 #define _strnicmp strncasecmp

#endif

typedef char INT8;
typedef unsigned char UINT8;
typedef short INT16;
typedef unsigned short UINT16;
typedef int INT32;
typedef unsigned int UINT32;

// Chip emulators ------------------------------------------------

// sek.cpp
#include "sek.h"

// zet.cpp
#include "zet.h"

// --------------------------------------

struct BurnDriver {
	char *szText[8];	// [0] = Short name for the driver
						// [1] = Full name of the game the driver is for
						// [2] = Notes
						// [3] = Manufacturer
						// [4] = System
						// [5] = Date
						// [6] = Parent ROM (set to NULL if no parent)
						// [7] = BIOS/board ROMs (set to NULL if not used)
	int flags;			// See burn.h
	int players;		// Max number of players a game supports (so we can remove single player games from netplay)
	int hardware;		// Which type of hardware the game runs on
	int (*GetZipName)(char** pszName, unsigned int i);				// Function to get possible zip names
	int (*GetRomInfo)(struct BurnRomInfo* pri,unsigned int i);		// Function to get the length and crc of each rom
	int (*GetRomName)(char** pszName, unsigned int i, int nAka);	// Function to get the possible names for each rom
	int (*GetInputInfo)(struct BurnInputInfo* pii, unsigned int i);	// Function to get the input info for the game
	int (*GetDIPInfo)(struct BurnDIPInfo* pdi, unsigned int i);		// Function to get the input info for the game
	int (*Init)(); int (*Exit)(); int (*Frame)(); int (*Redraw)(); int (*AreaScan)(int nAction, int* pnMin);
	unsigned char* pRecalcPal;										// Set to 1 if the palette needs to be fully re-calculated
	int nWidth, nHeight; int nXAspect, nYAspect;					// Screen width, height, x/y aspect
};

#define BurnDriverD BurnDriver		// Debug status
#define BurnDriverX BurnDriver		// Exclude from build

// Standard functions
#include "stdfunc.h"

// burn.cpp
// Scan a small variable or structure
inline static void ScanVar(void *pv, int nSize, char *szName)
{
	struct BurnArea ba;
	memset(&ba, 0, sizeof(ba));
	ba.Data = pv;
	ba.nLen = nSize;
	ba.szName = szName;
	BurnAcb(&ba);
}

#define SCAN_VAR(x) ScanVar(&x,sizeof(x),#x);

int BurnClearScreen();

inline static void PutPix(unsigned char *pPix,unsigned int c)
{
       if (nBurnBpp>=4) *((unsigned int *)pPix)=c;
  else if (nBurnBpp>=3)
  {
    pPix[0]=(unsigned char) c;
    pPix[1]=(unsigned char)(c>>8);
    pPix[2]=(unsigned char)(c>>16);
  }
  else if (nBurnBpp>=2) *((unsigned short *)pPix)=(unsigned short)c;
  else *pPix=(unsigned char)c;
}

int BurnByteswap(unsigned char *pm,int nLen);

// load.cpp
int BurnLoadRom(unsigned char *Dest,int i,int nGap);
int BurnXorRom(unsigned char *Dest,int i,int nGap);
int BurnLoadBitField(unsigned char *pDest,unsigned char *pSrc,int nField,int nSrcLen);

