// Warriors of Fate

#include "cps.h"

static struct BurnInputInfo DrvInputList[] =
{
  {"P1 Coin"       , 0, CpsInp018+0, "p1 coin"},
  {"P1 Start"      , 0, CpsInp018+4, "p1 start"},
  {"P1 Up"         , 0, CpsInp001+3, "p1 up"},
  {"P1 Down"       , 0, CpsInp001+2, "p1 down"},
  {"P1 Left"       , 0, CpsInp001+1, "p1 left"},
  {"P1 Right"      , 0, CpsInp001+0, "p1 right"},
  {"P1 Attack"     , 0, CpsInp001+4, "p1 fire 1"},
  {"P1 Jump"       , 0, CpsInp001+5, "p1 fire 2"},

  {"P2 Coin"       , 0, CpsInp018+1, "p2 coin"},
  {"P2 Start"      , 0, CpsInp018+5, "p2 start"},
  {"P2 Up"         , 0, CpsInp000+3, "p2 up"},
  {"P2 Down"       , 0, CpsInp000+2, "p2 down"},
  {"P2 Left"       , 0, CpsInp000+1, "p2 left"},
  {"P2 Right"      , 0, CpsInp000+0, "p2 right"},
  {"P2 Attack"     , 0, CpsInp000+4, "p2 fire 1"},
  {"P2 Jump"       , 0, CpsInp000+5, "p2 fire 2"},

  {"P3 Coin"       , 0, CpsInpc001+6, "p3 coin"  },
  {"P3 Start"      , 0, CpsInpc001+7, "p3 start" },
  {"P3 Up"         , 0, CpsInpc001+3, "p3 up"    },
  {"P3 Down"       , 0, CpsInpc001+2, "p3 down"  },
  {"P3 Left"       , 0, CpsInpc001+1, "p3 left"  },
  {"P3 Right"      , 0, CpsInpc001+0, "p3 right" },
  {"P3 Attack"     , 0, CpsInpc001+4, "p3 fire 1"},
  {"P3 Jump"       , 0, CpsInpc001+5, "p3 fire 2"},

  {"Reset"         , 0, &CpsReset,   "reset"},
  {"Diagnostic"    , 0, CpsInp018+6, "diag"},
  {"Service"       , 0, CpsInp018+2, "service"},
  {"Dip C"         , 2, &Cpi01E    , "dip"},
};

STDINPUTINFO(Drv);

static struct BurnDIPInfo wofDIPList[]=
{
	// Defaults
	{0x1b, 0xff, 0xff, 0x00, NULL                },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x1b, 0x01, 0x08, 0x08, "Off"                    },
	{0x1b, 0x01, 0x08, 0x00, "On"                     },
};

STDDIPINFO(wof);


static int DrvExit()
{

  CpsRunExit();

  CpsExit();
  nCpsQSamLen=0; nCpsZRomLen=0; nCpsGfxLen=0; nCpsRomLen=0;
  Cps=0; Cps1Qs=0;
  return 0;
}

//==============================
//Warriors of Fate Init CPS_B_01
//==============================

static int Drvb1Init()
{
  int nRet=0; unsigned char *pqs=NULL;
  Cps=1; Cps1Qs=1;
  nCpsRomLen= 2*0x080000;
  nCpsCodeLen=0; // not encrypted
  nCpsGfxLen= 8*0x080000;
  nCpsZRomLen= 2*0x020000;
  nCpsQSamLen= 4*0x080000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  // Load program roms
  nRet=BurnLoadRom(CpsRom+0x000000,0,1); if (nRet!=0) return 1;
  nRet=BurnLoadRom(CpsRom+0x080000,1,1); if (nRet!=0) return 1;

  // Set dip switches
//  SETUP_DIPSW_3(Cpi01A,Cpi01C,Cpi01E,0x00,0x00,0x00);

  // Load graphics roms
  CpsLoadTiles(CpsGfx         , 2);
  CpsLoadTiles(CpsGfx+0x200000, 6);

  nCpsLcReg=0x66; // Layer control register is at 0x66
  CpsLayEn[1]=0x02;
  CpsLayEn[2]=0x04;
  CpsLayEn[3]=0x08;

  // Start of Board ID improvments by KEV. 0x00,0x0000
  CpsBID[0]=0x00;
  CpsBID[1]=0x00;
  CpsBID[2]=0x00;
  //end

  MaskAddr[0]=0x68;
  MaskAddr[1]=0x6a;
  MaskAddr[2]=0x6c;
  MaskAddr[3]=0x6e;

  nRet=BurnLoadRom(CpsZRom,10,1);
  wof_decode();

  pqs=(unsigned char *)CpsQSam;
  nRet=BurnLoadRom(pqs         ,11,1);
  nRet=BurnLoadRom(pqs+0x080000,12,1);
  nRet=BurnLoadRom(pqs+0x100000,13,1);
  nRet=BurnLoadRom(pqs+0x180000,14,1);


  nRet=CpsRunInit(); if (nRet!=0) return 1;
  // Ready to go
  return 0;
}

//==============================
//Warriors of Fate Init QSOUND_1
//==============================

static int Drvq1Init()
{
  int nRet=0; unsigned char *pqs=NULL;
  Cps=1; Cps1Qs=1;
  nCpsRomLen= 2*0x080000;
  nCpsCodeLen=0; // not encrypted
  nCpsGfxLen= 8*0x080000;
  nCpsZRomLen= 2*0x020000;
  nCpsQSamLen= 4*0x080000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  // Load program roms
  nRet=BurnLoadRom(CpsRom+0x000000,0,1); if (nRet!=0) return 1;
  nRet=BurnLoadRom(CpsRom+0x080000,1,1); if (nRet!=0) return 1;

  // Load graphics roms
  CpsLoadTiles(CpsGfx         , 2);
  CpsLoadTiles(CpsGfx+0x200000, 6);

  nCpsLcReg=0x62; // Layer control register is at 0x62
  CpsLayEn[1]=0x10;
  CpsLayEn[2]=0x08;
  CpsLayEn[3]=0x04;

  // Protection enable code by KEV
  CpsMProt[0]=0x00;
  CpsMProt[1]=0x00;
  CpsMProt[2]=0x00;
  CpsMProt[3]=0x00;

  // Start of Board ID improvments by KEV. 0x00,0x0000
  CpsBID[0]=0x00;
  CpsBID[1]=0x00;
  CpsBID[2]=0x00;
  //end

  MaskAddr[0]=0x64;
  MaskAddr[1]=0x66;
  MaskAddr[2]=0x68;
  MaskAddr[3]=0x6a;

  nRet=BurnLoadRom(CpsZRom,10,1);
  wof_decode();

  pqs=(unsigned char *)CpsQSam;
  nRet=BurnLoadRom(pqs         ,11,1);
  nRet=BurnLoadRom(pqs+0x080000,12,1);
  nRet=BurnLoadRom(pqs+0x100000,13,1);
  nRet=BurnLoadRom(pqs+0x180000,14,1);


  nRet=CpsRunInit(); if (nRet!=0) return 1;
  // Ready to go
  return 0;
}

//========================
//Warriors of Fate (World)
//========================

// Count possible zip names and (if pszName!=NULL) return them

// Rom information
static struct BurnRomInfo WofRomDesc[]=
{
  {"tk2e_23b.rom" ,0x80000,0x11fb2ed1,0x10}, // 0 swapped 68000 code
  {"tk2e_22b.rom" ,0x80000,0x479b3f24,0x10}, // 1 swapped

  // graphics:
  {"tk2_gfx1.rom",0x80000,0x0d9cb9bf,   1}, // 2
  {"tk2_gfx3.rom",0x80000,0x45227027,   1},
  {"tk2_gfx2.rom",0x80000,0xc5ca2460,   1},
  {"tk2_gfx4.rom",0x80000,0xe349551c,   1},
  {"tk2_gfx5.rom",0x80000,0x291f0f0b,   1}, // 6
  {"tk2_gfx7.rom",0x80000,0x3edeb949,   1},
  {"tk2_gfx6.rom",0x80000,0x1abd14d6,   1},
  {"tk2_gfx8.rom",0x80000,0xb27948e3,   1},

  // z80 rom
  {"tk2_qa.rom" ,0x20000,0xc9183a0d,   2}, // 10
  // samples
  {"tk2_q1.rom" ,0x80000,0x611268cf,   2},
  {"tk2_q2.rom" ,0x80000,0x20f55ca9,   2},
  {"tk2_q3.rom" ,0x80000,0xbfcf6f52,   2},
  {"tk2_q4.rom" ,0x80000,0x36642e88,   2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Wof) STD_ROM_FN(Wof)


struct BurnDriver BurnDrvCpsWof=
{
  {"wof","Warriors of Fate (World)","","Capcom","CPS1","1992",NULL, NULL},
  1,3,HARDWARE_CAPCOM_CPS1_QSOUND,
  NULL,WofRomInfo,WofRomName,DrvInputInfo, wofDIPInfo,
  Drvb1Init,DrvExit,Cps1Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//====================
//Sangokushi II (Asia)
//====================

// Count possible zip names and (if pszName!=NULL) return them

// Rom information
static struct BurnRomInfo WofaRomDesc[]=
{
  {"tk2a_23b.rom" ,0x80000,0x2e024628,0x10}, // 0 swapped 68000 code
  {"tk2a_22b.rom" ,0x80000,0x900ad4cd,0x10}, // 1 swapped

  // graphics:
  {"tk2_gfx1.rom",0x80000,0x0d9cb9bf,   1}, // 2
  {"tk2_gfx3.rom",0x80000,0x45227027,   1},
  {"tk2_gfx2.rom",0x80000,0xc5ca2460,   1},
  {"tk2_gfx4.rom",0x80000,0xe349551c,   1},
  {"tk2_gfx5.rom",0x80000,0x291f0f0b,   1}, // 6
  {"tk2_gfx7.rom",0x80000,0x3edeb949,   1},
  {"tk2_gfx6.rom",0x80000,0x1abd14d6,   1},
  {"tk2_gfx8.rom",0x80000,0xb27948e3,   1},

  // z80 rom
  {"tk2_qa.rom" ,0x20000,0xc9183a0d,   2}, // 10
  // samples
  {"tk2_q1.rom" ,0x80000,0x611268cf,   2},
  {"tk2_q2.rom" ,0x80000,0x20f55ca9,   2},
  {"tk2_q3.rom" ,0x80000,0xbfcf6f52,   2},
  {"tk2_q4.rom" ,0x80000,0x36642e88,   2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Wofa) STD_ROM_FN(Wofa)


struct BurnDriver BurnDrvCpsWofa=
{
  {"wofa","Sangokushi II (Asia)","","Capcom","CPS1","1992","wof", NULL},
  1,3,HARDWARE_CAPCOM_CPS1_QSOUND,
  NULL,WofaRomInfo,WofaRomName,DrvInputInfo, wofDIPInfo,
  Drvb1Init,DrvExit,Cps1Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//======================
//Warriors of Fate (USA)
//======================

// Count possible zip names and (if pszName!=NULL) return them

// Rom information
static struct BurnRomInfo WofuRomDesc[]=
{
  {"tk2u.23c" ,0x80000,0x29b89c12,0x10}, // 0 swapped 68000 code
  {"tk2u.22c" ,0x80000,0xf5af4774,0x10}, // 1 swapped

  // graphics:
  {"tk2_gfx1.rom",0x80000,0x0d9cb9bf,   1}, // 2
  {"tk2_gfx3.rom",0x80000,0x45227027,   1},
  {"tk2_gfx2.rom",0x80000,0xc5ca2460,   1},
  {"tk2_gfx4.rom",0x80000,0xe349551c,   1},
  {"tk2_gfx5.rom",0x80000,0x291f0f0b,   1}, // 6
  {"tk2_gfx7.rom",0x80000,0x3edeb949,   1},
  {"tk2_gfx6.rom",0x80000,0x1abd14d6,   1},
  {"tk2_gfx8.rom",0x80000,0xb27948e3,   1},

  // z80 rom
  {"tk2_qa.rom" ,0x20000,0xc9183a0d,   2}, // 10
  // samples
  {"tk2_q1.rom" ,0x80000,0x611268cf,   2},
  {"tk2_q2.rom" ,0x80000,0x20f55ca9,   2},
  {"tk2_q3.rom" ,0x80000,0xbfcf6f52,   2},
  {"tk2_q4.rom" ,0x80000,0x36642e88,   2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Wofu) STD_ROM_FN(Wofu)


struct BurnDriver BurnDrvCpsWofu=
{
  {"wofu","Warriors of Fate (US)","","Capcom","CPS1","1992","wof", NULL},
  1,3,HARDWARE_CAPCOM_CPS1_QSOUND,
  NULL,WofuRomInfo,WofuRomName,DrvInputInfo, wofDIPInfo,
  Drvq1Init,DrvExit,Cps1Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//================================================
//Tenchi wo Kurau II - Sekiheki no Tatakai (Japan)
//================================================

// Count possible zip names and (if pszName!=NULL) return them

// Rom information
static struct BurnRomInfo WofjRomDesc[]=
{
  {"tk2j23c.bin" ,0x80000,0x9b215a68,0x10}, // 0 swapped 68000 code
  {"tk2j22c.bin" ,0x80000,0xb74b09ac,0x10}, // 1 swapped

  // graphics:
  {"tk2_gfx1.rom",0x80000,0x0d9cb9bf,   1}, // 2
  {"tk2_gfx3.rom",0x80000,0x45227027,   1},
  {"tk2_gfx2.rom",0x80000,0xc5ca2460,   1},
  {"tk2_gfx4.rom",0x80000,0xe349551c,   1},
  {"tk205.bin",0x80000,0xe4a44d53,   1}, // 6
  {"tk206.bin",0x80000,0x58066ba8,   1},
  {"tk207.bin",0x80000,0xd706568e,   1},
  {"tk208.bin",0x80000,0xd4a19a02,   1},

  // z80 rom
  {"tk2_qa.rom" ,0x20000,0xc9183a0d,   2}, // 10
  // samples
  {"tk2_q1.rom" ,0x80000,0x611268cf,   2},
  {"tk2_q2.rom" ,0x80000,0x20f55ca9,   2},
  {"tk2_q3.rom" ,0x80000,0xbfcf6f52,   2},
  {"tk2_q4.rom" ,0x80000,0x36642e88,   2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Wofj) STD_ROM_FN(Wofj)


struct BurnDriver BurnDrvCpsWofj=
{
  {"wofj","Tenchi wo Kurau II - Sekiheki no Tatakai (Japan)","","Capcom","CPS1","1992","wof", NULL},
  1,3,HARDWARE_CAPCOM_CPS1_QSOUND,
  NULL,WofjRomInfo,WofjRomName,DrvInputInfo, wofDIPInfo,
  Drvq1Init,DrvExit,Cps1Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
