#include "cps.h"

/*=======================================================
Marvel vs. Capcom All-in-One Driver 1.50 by Treble Winner
=======================================================*/

STDINPUTINFOSPEC(Drv, CpsFsi);


static int DrvInit()
{
 int nRet=0; int i=0; unsigned char *pqs=NULL;

 Cps=2;
 nCpsRomLen=  8*0x080000;
 nCpsCodeLen= 2*0x080000;
 nCpsGfxLen=  8*0x400000;
 nCpsZRomLen= 2*0x020000;
 nCpsQSamLen= 2*0x400000;
 nRet=CpsInit(); if (nRet!=0) return 1;

 // Load program roms (as they are on the roms) for CpsRom
 for (i=0;i<8;i++)
 { nRet=BurnLoadRom(CpsRom+0x080000*i,2+i,1); if (nRet!=0) return 1; }

 // Make decrypted rom
 memcpy(CpsCode,CpsRom,nCpsCodeLen);
 nRet=BurnXorRom(CpsCode         ,0,1); if (nRet!=0) return 1;
 nRet=BurnXorRom(CpsCode+0x080000,1,1); if (nRet!=0) return 1;

 // Load graphics roms
 nRet=Cps2LoadTiles(CpsGfx           ,10);
 nRet=Cps2LoadTiles(CpsGfx+4*0x400000,14);

 // Load Z80 Roms
 nRet=BurnLoadRom(CpsZRom         ,18,1);
 nRet=BurnLoadRom(CpsZRom+ 0x20000,19,1);

 // Load Q Sample Roms
 pqs=(unsigned char *)CpsQSam;
 nRet=BurnLoadRom(pqs         ,20,1);
 nRet=BurnLoadRom(pqs+0x400000,21,1);
 BurnByteswap(pqs,nCpsQSamLen);

 nRet=CpsRunInit();

 if (nRet!=0) return 1;
 // Ready to go
 return 0;
}

static int DrvExit()
{

  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0;
  return 0;
}

/*=====================
Marvel Vs. Capcom (USA)
=====================*/


static struct BurnRomInfo MvscRomDesc[]=
{
  {"mvcux.03d",0x80000,0x86685cbf, 0x10},
  {"mvcux.04d",0x80000,0x438ba92b, 0x10},

  {"mvcu.03d" ,0x80000,0xc6007557, 0x10},
  {"mvcu.04d" ,0x80000,0x724b2b20, 0x10},
  {"mvc.05a"  ,0x80000,0x2d8c8e86, 0x10},
  {"mvc.06a"  ,0x80000,0x8528e1f5, 0x10},
  {"mvc.07"   ,0x80000,0xc3baa32b, 0x10},
  {"mvc.08"   ,0x80000,0xbc002fcd, 0x10},
  {"mvc.09"   ,0x80000,0xc67b26df, 0x10},
  {"mvc.10"   ,0x80000,0x0fdd1e26, 0x10},

  {"mvc.13"  ,0x400000,0xfa5f74bc,    1},
  {"mvc.15"  ,0x400000,0x71938a8f,    1},
  {"mvc.17"  ,0x400000,0x92741d07,    1},
  {"mvc.19"  ,0x400000,0xbcb72fc6,    1},
  {"mvc.14"  ,0x400000,0x7f1df4e4,    1},
  {"mvc.16"  ,0x400000,0x90bd3203,    1},
  {"mvc.18"  ,0x400000,0x67aaf727,    1},
  {"mvc.20"  ,0x400000,0x8b0bade8,    1},

  {"mvc.01"  ,0x020000,0x41629e95,    2},
  {"mvc.02"  ,0x020000,0x963abf6b,    2},

  {"mvc.11"  ,0x400000,0x850fe663,    2},
  {"mvc.12"  ,0x400000,0x7ccb1896,    2},
};

STD_ROM_PICK(Mvsc) STD_ROM_FN(Mvsc)

struct BurnDriver BurnDrvCpsMvsc=
{
  {"mvsc" ,"Marvel Vs. Capcom: Clash of Super Heroes (US 980123)","","Capcom","CPS2","1998",NULL, NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, MvscRomInfo, MvscRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*=======================
Marvel Vs. Capcom (Japan)
=======================*/


static struct BurnRomInfo MvscjRomDesc[]=
{
  {"mvcjx.03a",0x80000,0xe696a098, 0x10},
  {"mvcjx.04a",0x80000,0x7faeee82, 0x10},

  {"mvcj.03a" ,0x80000,0x3df18879, 0x10},
  {"mvcj.04a" ,0x80000,0x07d212e8, 0x10},
  {"mvc.05a"  ,0x80000,0x2d8c8e86, 0x10},
  {"mvc.06a"  ,0x80000,0x8528e1f5, 0x10},
  {"mvc.07"   ,0x80000,0xc3baa32b, 0x10},
  {"mvc.08"   ,0x80000,0xbc002fcd, 0x10},
  {"mvc.09"   ,0x80000,0xc67b26df, 0x10},
  {"mvc.10"   ,0x80000,0x0fdd1e26, 0x10},

  {"mvc.13"  ,0x400000,0xfa5f74bc,    1},
  {"mvc.15"  ,0x400000,0x71938a8f,    1},
  {"mvc.17"  ,0x400000,0x92741d07,    1},
  {"mvc.19"  ,0x400000,0xbcb72fc6,    1},
  {"mvc.14"  ,0x400000,0x7f1df4e4,    1},
  {"mvc.16"  ,0x400000,0x90bd3203,    1},
  {"mvc.18"  ,0x400000,0x67aaf727,    1},
  {"mvc.20"  ,0x400000,0x8b0bade8,    1},

  {"mvc.01"  ,0x020000,0x41629e95,    2},
  {"mvc.02"  ,0x020000,0x963abf6b,    2},

  {"mvc.11"  ,0x400000,0x850fe663,    2},
  {"mvc.12"  ,0x400000,0x7ccb1896,    2},
};

STD_ROM_PICK(Mvscj) STD_ROM_FN(Mvscj)

struct BurnDriver BurnDrvCpsMvscj=
{
  {"mvscj" ,"Marvel Vs. Capcom: Clash of Super Heroes (Japan 980123)","","Capcom","CPS2","1998","mvsc", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, MvscjRomInfo, MvscjRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*==========================
Marvel Vs. Capcom (Japan r1)
==========================*/


static struct BurnRomInfo Mvscjr1RomDesc[]=
{
  {"mvcjx.03" ,0x80000,0xcc94ab89, 0x10},
  {"mvcjx.04" ,0x80000,0xc5a83202, 0x10},

  {"mvcj.03"  ,0x80000,0x2164213f, 0x10},
  {"mvcj.04"  ,0x80000,0xc905c86f, 0x10},
  {"mvc.05"   ,0x80000,0x7db71ce9, 0x10},
  {"mvc.06"   ,0x80000,0x4b0b6d3e, 0x10},
  {"mvc.07"   ,0x80000,0xc3baa32b, 0x10},
  {"mvc.08"   ,0x80000,0xbc002fcd, 0x10},
  {"mvc.09"   ,0x80000,0xc67b26df, 0x10},
  {"mvc.10"   ,0x80000,0x0fdd1e26, 0x10},

  {"mvc.13"  ,0x400000,0xfa5f74bc,    1},
  {"mvc.15"  ,0x400000,0x71938a8f,    1},
  {"mvc.17"  ,0x400000,0x92741d07,    1},
  {"mvc.19"  ,0x400000,0xbcb72fc6,    1},
  {"mvc.14"  ,0x400000,0x7f1df4e4,    1},
  {"mvc.16"  ,0x400000,0x90bd3203,    1},
  {"mvc.18"  ,0x400000,0x67aaf727,    1},
  {"mvc.20"  ,0x400000,0x8b0bade8,    1},

  {"mvc.01"  ,0x020000,0x41629e95,    2},
  {"mvc.02"  ,0x020000,0x963abf6b,    2},

  {"mvc.11"  ,0x400000,0x850fe663,    2},
  {"mvc.12"  ,0x400000,0x7ccb1896,    2},
};

STD_ROM_PICK(Mvscjr1) STD_ROM_FN(Mvscjr1)

struct BurnDriver BurnDrvCpsMvscjr1=
{
  {"mvscjr1" ,"Marvel Vs. Capcom: Clash of Super Heroes (Japan 980112)","","Capcom","CPS2","1998","mvsc", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Mvscjr1RomInfo, Mvscjr1RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*======================
Marvel Vs. Capcom (Asia)
======================*/


static struct BurnRomInfo MvscaRomDesc[]=
{
  {"mvcax.03" ,0x80000,0x4512a6af, 0x10},
  {"mvcax.04" ,0x80000,0xe6f537d2, 0x10},

  {"mvca.03"  ,0x80000,0xfe5fa7b9, 0x10},
  {"mvca.04"  ,0x80000,0x082b701c, 0x10},
  {"mvc.05"   ,0x80000,0x7db71ce9, 0x10},
  {"mvc.06"   ,0x80000,0x4b0b6d3e, 0x10},
  {"mvc.07"   ,0x80000,0xc3baa32b, 0x10},
  {"mvc.08"   ,0x80000,0xbc002fcd, 0x10},
  {"mvc.09"   ,0x80000,0xc67b26df, 0x10},
  {"mvc.10"   ,0x80000,0x0fdd1e26, 0x10},

  {"mvc.13"  ,0x400000,0xfa5f74bc,    1},
  {"mvc.15"  ,0x400000,0x71938a8f,    1},
  {"mvc.17"  ,0x400000,0x92741d07,    1},
  {"mvc.19"  ,0x400000,0xbcb72fc6,    1},
  {"mvc.14"  ,0x400000,0x7f1df4e4,    1},
  {"mvc.16"  ,0x400000,0x90bd3203,    1},
  {"mvc.18"  ,0x400000,0x67aaf727,    1},
  {"mvc.20"  ,0x400000,0x8b0bade8,    1},

  {"mvc.01"  ,0x020000,0x41629e95,    2},
  {"mvc.02"  ,0x020000,0x963abf6b,    2},

  {"mvc.11"  ,0x400000,0x850fe663,    2},
  {"mvc.12"  ,0x400000,0x7ccb1896,    2},
};

STD_ROM_PICK(Mvsca) STD_ROM_FN(Mvsca)

struct BurnDriver BurnDrvCpsMvsca=
{
  {"mvsca" ,"Marvel Vs. Capcom: Clash of Super Heroes (Asia 980112)","","Capcom","CPS2","1998","mvsc", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, MvscaRomInfo, MvscaRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*==========================
Marvel Vs. Capcom (Hispanic)
==========================*/


static struct BurnRomInfo MvschRomDesc[]=
{
  {"mvchx.03" ,0x80000,0x00000000, 0x10},
  {"mvchx.04" ,0x80000,0x00000000, 0x10},

  {"mvch.03"  ,0x80000,0x6a0ec9f7, 0x10},
  {"mvch.04"  ,0x80000,0x00f03fa4, 0x10},
  {"mvc.05a"  ,0x80000,0x2d8c8e86, 0x10},
  {"mvc.06a"  ,0x80000,0x8528e1f5, 0x10},
  {"mvc.07"   ,0x80000,0xc3baa32b, 0x10},
  {"mvc.08"   ,0x80000,0xbc002fcd, 0x10},
  {"mvc.09"   ,0x80000,0xc67b26df, 0x10},
  {"mvc.10"   ,0x80000,0x0fdd1e26, 0x10},

  {"mvc.13"  ,0x400000,0xfa5f74bc,    1},
  {"mvc.15"  ,0x400000,0x71938a8f,    1},
  {"mvc.17"  ,0x400000,0x92741d07,    1},
  {"mvc.19"  ,0x400000,0xbcb72fc6,    1},
  {"mvc.14"  ,0x400000,0x7f1df4e4,    1},
  {"mvc.16"  ,0x400000,0x90bd3203,    1},
  {"mvc.18"  ,0x400000,0x67aaf727,    1},
  {"mvc.20"  ,0x400000,0x8b0bade8,    1},

  {"mvc.01"  ,0x020000,0x41629e95,    2},
  {"mvc.02"  ,0x020000,0x963abf6b,    2},

  {"mvc.11"  ,0x400000,0x850fe663,    2},
  {"mvc.12"  ,0x400000,0x7ccb1896,    2},
};

STD_ROM_PICK(Mvsch) STD_ROM_FN(Mvsch)

struct BurnDriverX BurnDrvCpsMvsch=
{
  {"mvsch" ,"Marvel Vs. Capcom: Clash of Super Heroes (Hispanic 980123)","Encrypted","Capcom","CPS2","1998","mvsc", NULL},
  0,2,HARDWARE_CAPCOM_CPS2,
  NULL, MvschRomInfo, MvschRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

