// Eco Fighers

#include "cps.h"

static struct BurnInputInfo DrvInputList[] =
{
  {"P1 Coin"       , 0, CpsInp020+4, "p1 coin"  },
  {"P1 Start"      , 0, CpsInp020+0, "p1 start" },
  {"P1 Up"         , 0, CpsInp001+3, "p1 up"    },
  {"P1 Down"       , 0, CpsInp001+2, "p1 down"  },
  {"P1 Left"       , 0, CpsInp001+1, "p1 left"  },
  {"P1 Right"      , 0, CpsInp001+0, "p1 right" },
  {"P1 Turn 1"     , 0, CpsInp001+4, "p1 fire 1"},
  {"P1 Attack"     , 0, CpsInp001+5, "p1 fire 2"},
  {"P1 Turn 2"     , 0, CpsInp001+6, "p1 fire 3"},

  {"P2 Coin"       , 0, CpsInp020+5, "p2 coin"  },
  {"P2 Start"      , 0, CpsInp020+1, "p2 start" },
  {"P2 Up"         , 0, CpsInp000+3, "p2 up"    },
  {"P2 Down"       , 0, CpsInp000+2, "p2 down"  },
  {"P2 Left"       , 0, CpsInp000+1, "p2 left"  },
  {"P2 Right"      , 0, CpsInp000+0, "p2 right" },
  {"P2 Turn 1"     , 0, CpsInp000+4, "p2 fire 1"},
  {"P2 Attack"     , 0, CpsInp000+5, "p2 fire 2"},
  {"P2 Turn 2"     , 0, CpsInp000+6, "p2 fire 3"},

  {"Reset"         , 0, &CpsReset  , "reset"    },
  {"Diagnostic"    , 0, CpsInp021+1, "diag"     },
  {"Service"       , 0, CpsInp021+2, "service"  },
};

STDINPUTINFO(Drv);


static int DrvInit()
{
  int nRet=0; int i=0; unsigned char *pqs=NULL;

  Cps=2;
  nCpsRomLen=  4*0x080000;
  nCpsCodeLen= 4*0x080000;
  nCpsGfxLen=  6*0x200000;
  nCpsZRomLen= 1*0x020000;
  nCpsQSamLen= 2*0x200000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  for (i=0;i<4;i++)
  { nRet=BurnLoadRom(CpsRom+0x080000*i,4+i,1); if (nRet!=0) return 1; }

  memcpy(CpsCode,CpsRom,nCpsCodeLen);
  for (i=0;i<4;i++)
  { nRet=BurnXorRom(CpsCode+0x080000*i,0+i,1); if (nRet!=0) return 1; }

  nRet=Cps2LoadTiles(CpsGfx,8);
  nRet=Cps2LoadTiles(CpsGfx+0x0800000,12);

  nRet=BurnLoadRom(CpsZRom         ,16,1);
  pqs=(unsigned char *)CpsQSam;
  nRet=BurnLoadRom(pqs         ,17,1);
  nRet=BurnLoadRom(pqs+0x200000,18,1);
  BurnByteswap(pqs,nCpsQSamLen);


  nRet=CpsRunInit(); if (nRet!=0) return 1;
  return 0;
}

static int DrvExit()
{

  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0;
  return 0;
}


/*==================
Eco Fighters (World)
==================*/


static struct BurnRomInfo EcofghtrRomDesc[]=
{
  {"uecex.03" ,0x80000,0xe0ff3d51, 0x10},
  {"uecex.04" ,0x80000,0xb9f998e8, 0x10},
  {"uecex.05" ,0x80000,0x12410260, 0x10},
  {"uecex.06" ,0x80000,0xd5b4b1a2, 0x10},

  {"uece.03"  ,0x80000,0xec2c1137, 0x10},
  {"uece.04"  ,0x80000,0xb35f99db, 0x10},
  {"uece.05"  ,0x80000,0xd9d42d31, 0x10},
  {"uece.06"  ,0x80000,0x9d9771cf, 0x10},

  {"uec.13"  ,0x200000,0xdcaf1436,    1},
  {"uec.15"  ,0x200000,0x2807df41,    1},
  {"uec.17"  ,0x200000,0x8a708d02,    1},
  {"uec.19"  ,0x200000,0xde7be0ef,    1},
  {"uec.14"  ,0x100000,0x1a003558,    1},
  {"uec.16"  ,0x100000,0x4ff8a6f9,    1},
  {"uec.18"  ,0x100000,0xb167ae12,    1},
  {"uec.20"  ,0x100000,0x1064bdc2,    1},

  {"uec.01"  ,0x020000,0xc235bd15,    2},

  {"uec.11"  ,0x200000,0x81b25d39,    2},
  {"uec.12"  ,0x200000,0x27729e52,    2},
};

STD_ROM_PICK(Ecofghtr) STD_ROM_FN(Ecofghtr)

struct BurnDriver BurnDrvCpsEcofghtr=
{
  {"ecofghtr" ,"Eco Fighters (World 931203)","","Capcom","CPS2","1993",NULL, NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, EcofghtrRomInfo, EcofghtrRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*======================
Ultimate Ecology (Japan)
======================*/


static struct BurnRomInfo UecologyRomDesc[]=
{
  {"uecjx.03" ,0x80000,0x00000000, 0x10},
  {"uecjx.04" ,0x80000,0x00000000, 0x10},
  {"uecjx.05" ,0x80000,0x00000000, 0x10},
  {"uecjx.06" ,0x80000,0x00000000, 0x10},

  {"uecj.03"  ,0x80000,0x94c40a4c, 0x10},
  {"uecj.04"  ,0x80000,0x8d6e3a09, 0x10},
  {"uecj.05"  ,0x80000,0x8604ecd7, 0x10},
  {"uecj.06"  ,0x80000,0xb7e1d31f, 0x10},

  {"uec.13"  ,0x200000,0xdcaf1436,    1},
  {"uec.15"  ,0x200000,0x2807df41,    1},
  {"uec.17"  ,0x200000,0x8a708d02,    1},
  {"uec.19"  ,0x200000,0xde7be0ef,    1},
  {"uec.14"  ,0x100000,0x1a003558,    1},
  {"uec.16"  ,0x100000,0x4ff8a6f9,    1},
  {"uec.18"  ,0x100000,0xb167ae12,    1},
  {"uec.20"  ,0x100000,0x1064bdc2,    1},

  {"uec.01"  ,0x020000,0xc235bd15,    2},

  {"uec.11"  ,0x200000,0x81b25d39,    2},
  {"uec.12"  ,0x200000,0x27729e52,    2},
};

STD_ROM_PICK(Uecology) STD_ROM_FN(Uecology)

struct BurnDriverX BurnDrvCpsUecology=
{
  {"uecology" ,"Ultimate Ecology (Japan 931203)","Encrypted","Capcom","CPS2","1993","ecofghtr", NULL},
  0,2,HARDWARE_CAPCOM_CPS2,
  NULL, UecologyRomInfo, UecologyRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
