// Burner Config file module
#include "fba.h"

static char szConfig[255 + 16];

static void CreateConfigName()
{
	memcpy(szConfig, "t:\\fbax.ini", 11);
	return;
}

// Read in the config file for the whole application
int ConfigAppLoad()
{
	char szLine[256];
	FILE *h;

	CreateConfigName();

	if ((h = fopen(szConfig,"rt")) == NULL) {
		return 1;
	}

	// Go through each line of the config file
	while (1) {
		int nLen;
		if (fgets(szLine, sizeof(szLine), h) == NULL) {				// End of config file
			break;
		}

		nLen = strlen(szLine);
		
		// Get rid of the linefeed at the end
		if (szLine[nLen - 1] == 10) {
			szLine[nLen - 1] = 0;
			nLen--;
		}

#define VAR(x) { char *szValue = LabelCheck(szLine,#x);		\
  if (szValue) x = strtol(szValue, NULL, 0); }
#define FLT(x) { char *szValue = LabelCheck(szLine,#x);		\
  if (szValue) x = atof(szValue); }
#define STR(x) { char *szValue = LabelCheck(szLine,#x " ");	\
  if (szValue) strcpy(x,szValue); }

		// controller mappings
		VAR(m_Config.m_ConfigMap[0]);
		VAR(m_Config.m_ConfigMap[1]);
		VAR(m_Config.m_ConfigMap[2]);
		VAR(m_Config.m_ConfigMap[3]);
		VAR(m_Config.m_PlayerMappings[0].dwFire[0]);
		VAR(m_Config.m_PlayerMappings[0].dwFire[1]);
		VAR(m_Config.m_PlayerMappings[0].dwFire[2]);
		VAR(m_Config.m_PlayerMappings[0].dwFire[3]);
		VAR(m_Config.m_PlayerMappings[0].dwFire[4]);
		VAR(m_Config.m_PlayerMappings[0].dwFire[5]);
		VAR(m_Config.m_PlayerMappings[1].dwFire[0]);
		VAR(m_Config.m_PlayerMappings[1].dwFire[1]);
		VAR(m_Config.m_PlayerMappings[1].dwFire[2]);
		VAR(m_Config.m_PlayerMappings[1].dwFire[3]);
		VAR(m_Config.m_PlayerMappings[1].dwFire[4]);
		VAR(m_Config.m_PlayerMappings[1].dwFire[5]);
		VAR(m_Config.m_PlayerMappings[2].dwFire[0]);
		VAR(m_Config.m_PlayerMappings[2].dwFire[1]);
		VAR(m_Config.m_PlayerMappings[2].dwFire[2]);
		VAR(m_Config.m_PlayerMappings[2].dwFire[3]);
		VAR(m_Config.m_PlayerMappings[2].dwFire[4]);
		VAR(m_Config.m_PlayerMappings[2].dwFire[5]);
		VAR(m_Config.m_PlayerMappings[3].dwFire[0]);
		VAR(m_Config.m_PlayerMappings[3].dwFire[1]);
		VAR(m_Config.m_PlayerMappings[3].dwFire[2]);
		VAR(m_Config.m_PlayerMappings[3].dwFire[3]);
		VAR(m_Config.m_PlayerMappings[3].dwFire[4]);
		VAR(m_Config.m_PlayerMappings[3].dwFire[5]);

		// Video

//		VAR(controlmode);
		// Other
		STR(szAppRomPaths[0]);
		STR(szAppRomPaths[1]);
		STR(szAppRomPaths[2]);
		STR(szAppRomPaths[3]);

#undef STR
#undef FLT
#undef VAR
	}

	fclose(h);
	return 0;
}

// Write out the config file for the whole application
int ConfigAppSave()
{
	FILE *h;

	CreateConfigName();

	if ((h = fopen(szConfig, "wt")) == NULL) {
		return 1;
	}

	// Write title
	fprintf(h,"// FBA Config File\n\n");
	fprintf(h,"// Don't edit this file manually unless you know what you're doing\n");
	fprintf(h,"// FBA will restore default settings when this file is deleted\n");

#define VAR(x) fprintf(h, #x " %d\n", x)
#define FLT(x) fprintf(h, #x " %f\n", x)
#define STR(x) fprintf(h, #x " %s\n", x)
	
	fprintf(h,"\n\n\n");
	fprintf(h, "\n// Player controls\n");
	VAR(m_Config.m_ConfigMap[0]);
	VAR(m_Config.m_ConfigMap[1]);
	VAR(m_Config.m_ConfigMap[2]);
	VAR(m_Config.m_ConfigMap[3]);
	VAR(m_Config.m_PlayerMappings[0].dwFire[0]);
	VAR(m_Config.m_PlayerMappings[0].dwFire[1]);
	VAR(m_Config.m_PlayerMappings[0].dwFire[2]);
	VAR(m_Config.m_PlayerMappings[0].dwFire[3]);
	VAR(m_Config.m_PlayerMappings[0].dwFire[4]);
	VAR(m_Config.m_PlayerMappings[0].dwFire[5]);
	VAR(m_Config.m_PlayerMappings[1].dwFire[0]);
	VAR(m_Config.m_PlayerMappings[1].dwFire[1]);
	VAR(m_Config.m_PlayerMappings[1].dwFire[2]);
	VAR(m_Config.m_PlayerMappings[1].dwFire[3]);
	VAR(m_Config.m_PlayerMappings[1].dwFire[4]);
	VAR(m_Config.m_PlayerMappings[1].dwFire[5]);
	VAR(m_Config.m_PlayerMappings[2].dwFire[0]);
	VAR(m_Config.m_PlayerMappings[2].dwFire[1]);
	VAR(m_Config.m_PlayerMappings[2].dwFire[2]);
	VAR(m_Config.m_PlayerMappings[2].dwFire[3]);
	VAR(m_Config.m_PlayerMappings[2].dwFire[4]);
	VAR(m_Config.m_PlayerMappings[2].dwFire[5]);
	VAR(m_Config.m_PlayerMappings[3].dwFire[0]);
	VAR(m_Config.m_PlayerMappings[3].dwFire[1]);
	VAR(m_Config.m_PlayerMappings[3].dwFire[2]);
	VAR(m_Config.m_PlayerMappings[3].dwFire[3]);
	VAR(m_Config.m_PlayerMappings[3].dwFire[4]);
	VAR(m_Config.m_PlayerMappings[3].dwFire[5]);

	fprintf(h,"\n\n\n");
	fprintf(h,"\n// The paths to search for rom zips. (include trailing backslash)\n");
	STR(szAppRomPaths[0]);
	STR(szAppRomPaths[1]);
	STR(szAppRomPaths[2]);
	STR(szAppRomPaths[3]);

	fprintf(h,"\n\n\n");

#undef STR
#undef FLT
#undef VAR

	fclose(h);
	return 0;
}

char* LabelCheck(char *s,char *szLabel)
{
	int nLen;
	if (s == NULL) {
		return NULL;
	}
	if (szLabel == NULL) {
		return NULL;
	}
	nLen = strlen(szLabel);
	
	SKIP_WS(s);													// Skip whitespace

	if (strncmp(s, szLabel, nLen)){								// Doesn't match
		return NULL;
	}
	return s + nLen;
}

int QuoteRead(char** pszQuote, char** pszEnd, char* szSrc)		// Read a quoted string from szSrc and point to the end
{
	static char szQuote[QUOTE_MAX];
	char *s = szSrc;
	int i;
	
	SKIP_WS(s);													// Skip whitespace

	if (*s != '\"')	{											// Didn't start with a quote
		return 1;
	}
	s++;

	// Copy the characters into szQuote
	for (i = 0; i < QUOTE_MAX - 1; i++, s++) {
		if (*s == '\"') {
			s++;
			break;
		}
		if (*s == 0) {											// Stop copying if end of line or end of string
			break;
		}
		szQuote[i] = *s;										// Copy character to szQuote
	}
	szQuote[i] = 0;												// Zero-terminate szQuote

	if (pszQuote) {
		*pszQuote = szQuote;
	}
	if (pszEnd)	{
		*pszEnd = s;
	}
	
	return 0;
}

