#include "toaplan.h"
// Toaplan -- palette functions

unsigned char* ToaPalSrc;			// Pointer to input palette
unsigned int* ToaPalette;
int nToaPalLen;

unsigned char ToaRecalcPalette;		// Set to 1 to force recalculation of the entire palette (not needed now)

int ToaPalInit()
{
	return 0;
}

int ToaPalExit()
{
	return 0;
}

inline static unsigned int CalcCol(unsigned short nColour, int i)
{
	int r, g, b;

	r = (nColour & 0x001F) << 3;	// Red
	r |= r >> 5;
	g = (nColour & 0x03E0) >> 2;  	// Green
	g |= g >> 5;
	b = (nColour & 0x7C00) >> 7;	// Blue
	b |= b >> 5;

	return BurnHighCol(r, g, b, i);
}

int ToaPalUpdate()
{
	int i;
	unsigned short* ps;
	unsigned int* pd;

	for (i = 0, ps = (unsigned short*)ToaPalSrc, pd = ToaPalette; i < nToaPalLen; i++, ps += 1, pd++) {
		*pd = CalcCol(*ps, i);
	}
	return 0;
}

/*

// Update the PC copy of the palette on writes to the palette memory
void ToaPalWriteByte(unsigned int nAddress, unsigned char byteValue)
{
	nAddress ^= 1;
	nAddress &= (nToaPalLen << 1) - 1;							// Clip to palette length
	ToaPalSrc[nAddress] = byteValue;							// write byte

	ToaPalette[nAddress >> 1] = CalcCol(*(unsigned short*)(ToaPalSrc + (nAddress & ~0x01)), 0);
}

void ToaPalWriteWord(unsigned int nAddress, unsigned short wordValue)
{
	nAddress &= (nToaPalLen << 1) - 1;							// Clip to palette length
	*((unsigned short*)(ToaPalSrc + nAddress)) = wordValue;		// write byte
	ToaPalette[nAddress >> 1] = CalcCol(wordValue, 0);
}

*/

