// OKIM6295 module header

#define MAX_OKIM6295 2

int OKIM6295Init(int nChip, int nSamplerate, float fMaxVolume);
void OKIM6295Exit(int nChip);
int OKIM6295Render(int nChip, short* pSoundBuf, int nSegmenLength);
void OKIM6295Command(int nChip, unsigned char nCommand);
int OKIM6295Scan(int nChip);

extern unsigned char* OKIM6295ROM;
extern unsigned char* OKIM6295SampleInfo[MAX_OKIM6295][4];
extern unsigned char* OKIM6295SampleData[MAX_OKIM6295][4];

inline unsigned int OKIM6295ReadStatus(const int nChip)
{
	extern unsigned int nOKIM6295Status[MAX_OKIM6295];
	
	return nOKIM6295Status[nChip];
}

